/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.dynamic.data.mapping.internal.io;

import com.liferay.dynamic.data.mapping.form.field.type.DDMFormFieldTypeServicesTracker;
import com.liferay.dynamic.data.mapping.internal.io.DDMFormRuleJSONSerializer;
import com.liferay.dynamic.data.mapping.internal.io.util.DDMFormFieldSerializerUtil;
import com.liferay.dynamic.data.mapping.io.DDMFormSerializer;
import com.liferay.dynamic.data.mapping.io.DDMFormSerializerSerializeRequest;
import com.liferay.dynamic.data.mapping.io.DDMFormSerializerSerializeResponse;
import com.liferay.dynamic.data.mapping.model.DDMForm;
import com.liferay.dynamic.data.mapping.model.DDMFormRule;
import com.liferay.dynamic.data.mapping.model.DDMFormSuccessPageSettings;
import com.liferay.dynamic.data.mapping.model.LocalizedValue;
import com.liferay.portal.kernel.json.JSONArray;
import com.liferay.portal.kernel.json.JSONFactory;
import com.liferay.portal.kernel.json.JSONObject;
import com.liferay.portal.kernel.util.LocaleUtil;
import com.liferay.portal.kernel.util.Validator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component(immediate=true, property={"ddm.form.serializer.type=json"}, service={DDMFormSerializer.class})
public class DDMFormJSONSerializer
implements DDMFormSerializer {
    private DDMFormFieldTypeServicesTracker _ddmFormFieldTypeServicesTracker;
    private JSONFactory _jsonFactory;

    public DDMFormSerializerSerializeResponse serialize(DDMFormSerializerSerializeRequest ddmFormSerializerSerializeRequest) {
        DDMForm ddmForm = ddmFormSerializerSerializeRequest.getDDMForm();
        JSONObject jsonObject = this._jsonFactory.createJSONObject();
        this.addAvailableLanguageIds(jsonObject, ddmForm.getAvailableLocales());
        this.addDefaultLanguageId(jsonObject, ddmForm.getDefaultLocale());
        this.addRules(jsonObject, ddmForm.getDDMFormRules());
        this.addSuccessPageSettings(jsonObject, ddmForm.getDDMFormSuccessPageSettings());
        if (Validator.isNotNull((String)ddmForm.getDefinitionSchemaVersion())) {
            jsonObject.put("definitionSchemaVersion", ddmForm.getDefinitionSchemaVersion());
        }
        DDMFormFieldSerializerUtil.serialize(ddmForm.getDDMFormFields(), this._ddmFormFieldTypeServicesTracker, this._jsonFactory, jsonObject);
        DDMFormSerializerSerializeResponse.Builder builder = DDMFormSerializerSerializeResponse.Builder.newBuilder((String)jsonObject.toString());
        return builder.build();
    }

    protected void addAvailableLanguageIds(JSONObject jsonObject, Set<Locale> availableLocales) {
        JSONArray jsonArray = this._jsonFactory.createJSONArray();
        for (Locale availableLocale : availableLocales) {
            jsonArray.put(LocaleUtil.toLanguageId((Locale)availableLocale));
        }
        jsonObject.put("availableLanguageIds", jsonArray);
    }

    protected void addDefaultLanguageId(JSONObject jsonObject, Locale defaultLocale) {
        jsonObject.put("defaultLanguageId", LocaleUtil.toLanguageId((Locale)defaultLocale));
    }

    protected void addRules(JSONObject jsonObject, List<DDMFormRule> ddmFormRules) {
        if (ddmFormRules.isEmpty()) {
            return;
        }
        jsonObject.put("rules", DDMFormRuleJSONSerializer.serialize(ddmFormRules));
    }

    protected void addSuccessPageSettings(JSONObject jsonObject, DDMFormSuccessPageSettings ddmFormSuccessPageSettings) {
        jsonObject.put("successPage", this.toJSONObject(ddmFormSuccessPageSettings));
    }

    @Reference(unbind="-")
    protected void setDDMFormFieldTypeServicesTracker(DDMFormFieldTypeServicesTracker ddmFormFieldTypeServicesTracker) {
        this._ddmFormFieldTypeServicesTracker = ddmFormFieldTypeServicesTracker;
    }

    @Reference(unbind="-")
    protected void setJSONFactory(JSONFactory jsonFactory) {
        this._jsonFactory = jsonFactory;
    }

    protected JSONObject toJSONObject(DDMFormSuccessPageSettings ddmFormSuccessPageSettings) {
        JSONObject jsonObject = this._jsonFactory.createJSONObject();
        jsonObject.put("body", this.toJSONObject(ddmFormSuccessPageSettings.getBody())).put("enabled", ddmFormSuccessPageSettings.isEnabled()).put("title", this.toJSONObject(ddmFormSuccessPageSettings.getTitle()));
        return jsonObject;
    }

    protected JSONObject toJSONObject(LocalizedValue localizedValue) {
        if (localizedValue == null) {
            return this._jsonFactory.createJSONObject();
        }
        JSONObject jsonObject = this._jsonFactory.createJSONObject();
        Map values = localizedValue.getValues();
        if (values.isEmpty()) {
            return jsonObject;
        }
        for (Locale availableLocale : localizedValue.getAvailableLocales()) {
            jsonObject.put(LocaleUtil.toLanguageId((Locale)availableLocale), localizedValue.getString(availableLocale));
        }
        return jsonObject;
    }
}

