/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.dynamic.data.mapping.internal.info.item.provider;

import com.liferay.document.library.kernel.service.DLAppService;
import com.liferay.document.library.util.DLURLHelper;
import com.liferay.dynamic.data.mapping.info.field.converter.DDMFormFieldInfoFieldConverter;
import com.liferay.dynamic.data.mapping.info.item.provider.DDMFormValuesInfoFieldValuesProvider;
import com.liferay.dynamic.data.mapping.kernel.DDMFormField;
import com.liferay.dynamic.data.mapping.kernel.DDMFormFieldValue;
import com.liferay.dynamic.data.mapping.kernel.DDMFormValues;
import com.liferay.dynamic.data.mapping.kernel.Value;
import com.liferay.dynamic.data.mapping.util.DDMBeanTranslator;
import com.liferay.info.field.InfoFieldValue;
import com.liferay.info.item.ClassPKInfoItemIdentifier;
import com.liferay.info.item.InfoItemIdentifier;
import com.liferay.info.item.InfoItemReference;
import com.liferay.info.localized.InfoLocalizedValue;
import com.liferay.info.type.WebImage;
import com.liferay.portal.kernel.json.JSONFactoryUtil;
import com.liferay.portal.kernel.json.JSONObject;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.model.GroupedModel;
import com.liferay.portal.kernel.repository.model.FileEntry;
import com.liferay.portal.kernel.sanitizer.SanitizerUtil;
import com.liferay.portal.kernel.util.DateUtil;
import com.liferay.portal.kernel.util.Validator;
import java.text.DateFormat;
import java.text.NumberFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component(service={DDMFormValuesInfoFieldValuesProvider.class})
public class DDMFormValuesInfoFieldValuesProviderImpl
implements DDMFormValuesInfoFieldValuesProvider<GroupedModel> {
    private static final Log _log = LogFactoryUtil.getLog(DDMFormValuesInfoFieldValuesProviderImpl.class);
    @Reference
    private DDMBeanTranslator _ddmBeanTranslator;
    @Reference
    private DDMFormFieldInfoFieldConverter _ddmFormFieldInfoFieldConverter;
    @Reference
    private DLAppService _dlAppService;
    @Reference
    private DLURLHelper _dlURLHelper;

    public List<InfoFieldValue<InfoLocalizedValue<Object>>> getInfoFieldValues(GroupedModel groupedModel, DDMFormValues ddmFormValues) {
        List ddmFormFieldValues = ddmFormValues.getDDMFormFieldValues();
        Stream stream = ddmFormFieldValues.stream();
        return stream.flatMap(ddmFormFieldValue -> {
            List<InfoFieldValue<InfoLocalizedValue<Object>>> infoFieldValues = this._getInfoFieldValues(groupedModel, (DDMFormFieldValue)ddmFormFieldValue);
            return infoFieldValues.stream();
        }).collect(Collectors.toList());
    }

    private void _addDDMFormFieldValue(GroupedModel groupedModel, DDMFormFieldValue ddmFormFieldValue, List<InfoFieldValue<InfoLocalizedValue<Object>>> infoFieldValues) {
        this._addNestedFields(groupedModel, ddmFormFieldValue, infoFieldValues);
        this._getInfoFieldValue(groupedModel, ddmFormFieldValue).map(infoFieldValues::add);
    }

    private void _addNestedFields(GroupedModel groupedModel, DDMFormFieldValue ddmFormFieldValue, List<InfoFieldValue<InfoLocalizedValue<Object>>> infoFieldValues) {
        Map nestedDDMFormFieldValuesMap = ddmFormFieldValue.getNestedDDMFormFieldValuesMap();
        for (Map.Entry entry : nestedDDMFormFieldValuesMap.entrySet()) {
            List ddmFormFieldValues = (List)entry.getValue();
            ddmFormFieldValues.forEach(nestedDDMFormFieldValue -> this._addDDMFormFieldValue(groupedModel, (DDMFormFieldValue)nestedDDMFormFieldValue, infoFieldValues));
        }
    }

    private Optional<InfoFieldValue<InfoLocalizedValue<Object>>> _getInfoFieldValue(GroupedModel groupedModel, DDMFormFieldValue ddmFormFieldValue) {
        Value value = ddmFormFieldValue.getValue();
        if (value == null) {
            return Optional.empty();
        }
        return Optional.of(new InfoFieldValue(this._ddmFormFieldInfoFieldConverter.convert(this._ddmBeanTranslator.translate(ddmFormFieldValue.getDDMFormField())), (Object)InfoLocalizedValue.builder().defaultLocale(value.getDefaultLocale()).value(consumer -> {
            for (Locale locale : value.getAvailableLocales()) {
                consumer.accept((Object)locale, this._sanitizeDDMFormFieldValue(groupedModel, ddmFormFieldValue, locale));
            }
        }).build()));
    }

    private List<InfoFieldValue<InfoLocalizedValue<Object>>> _getInfoFieldValues(GroupedModel groupedModel, DDMFormFieldValue ddmFormFieldValue) {
        ArrayList<InfoFieldValue<InfoLocalizedValue<Object>>> infoFieldValues = new ArrayList<InfoFieldValue<InfoLocalizedValue<Object>>>();
        this._addDDMFormFieldValue(groupedModel, ddmFormFieldValue, infoFieldValues);
        return infoFieldValues;
    }

    private WebImage _getWebImage(JSONObject jsonObject) {
        try {
            String uuid = jsonObject.getString("uuid");
            long groupId = jsonObject.getLong("groupId");
            if (Validator.isNull((String)uuid) && groupId == 0L) {
                return null;
            }
            FileEntry fileEntry = this._dlAppService.getFileEntryByUuidAndGroupId(uuid, groupId);
            WebImage webImage = new WebImage(this._dlURLHelper.getDownloadURL(fileEntry, fileEntry.getFileVersion(), null, ""), new InfoItemReference(FileEntry.class.getName(), (InfoItemIdentifier)new ClassPKInfoItemIdentifier(fileEntry.getFileEntryId())));
            webImage.setAlt(jsonObject.getString("alt"));
            return webImage;
        }
        catch (Exception exception) {
            if (_log.isDebugEnabled()) {
                _log.debug((Object)exception, (Throwable)exception);
            }
            return null;
        }
    }

    private Object _sanitizeDDMFormFieldValue(GroupedModel groupedModel, DDMFormFieldValue ddmFormFieldValue, Locale locale) {
        Value value = ddmFormFieldValue.getValue();
        String valueString = value.getString(locale);
        try {
            if (Objects.equals(ddmFormFieldValue.getType(), "ddm-date") || Objects.equals(ddmFormFieldValue.getType(), "date")) {
                if (Validator.isNull((String)valueString)) {
                    return null;
                }
                DateFormat dateFormat = DateFormat.getDateInstance(3, locale);
                Date date = DateUtil.parseDate((String)"yyyy-MM-dd", (String)valueString, (Locale)locale);
                return dateFormat.format(date);
            }
            if (Objects.equals(ddmFormFieldValue.getType(), "ddm-decimal") || Objects.equals(ddmFormFieldValue.getType(), "numeric")) {
                if (Validator.isNull((String)valueString)) {
                    return null;
                }
                NumberFormat numberFormat = NumberFormat.getNumberInstance(locale);
                DDMFormField ddmFormField = ddmFormFieldValue.getDDMFormField();
                String dataType = ddmFormField.getDataType();
                if (dataType.equals("double") || dataType.equals("float")) {
                    numberFormat.setMinimumFractionDigits(1);
                }
                return numberFormat.format(numberFormat.parse(valueString));
            }
            if (Objects.equals(ddmFormFieldValue.getType(), "ddm-image") || Objects.equals(ddmFormFieldValue.getType(), "image")) {
                return this._getWebImage(JSONFactoryUtil.createJSONObject((String)valueString));
            }
            return SanitizerUtil.sanitize((long)groupedModel.getCompanyId(), (long)groupedModel.getGroupId(), (long)groupedModel.getUserId(), (String)groupedModel.getModelClassName(), (long)((Long)groupedModel.getPrimaryKeyObj()), (String)"text/html", (String)"ALL", (String)valueString, null);
        }
        catch (Exception exception) {
            _log.error((Object)("Unable to sanitize field " + ddmFormFieldValue.getName()), (Throwable)exception);
            return valueString;
        }
    }
}

