/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.dynamic.data.mapping.service.persistence.impl;

import com.liferay.dynamic.data.mapping.exception.NoSuchTemplateVersionException;
import com.liferay.dynamic.data.mapping.model.DDMTemplateVersion;
import com.liferay.dynamic.data.mapping.model.DDMTemplateVersionTable;
import com.liferay.dynamic.data.mapping.model.impl.DDMTemplateVersionImpl;
import com.liferay.dynamic.data.mapping.model.impl.DDMTemplateVersionModelImpl;
import com.liferay.dynamic.data.mapping.service.persistence.DDMTemplateVersionPersistence;
import com.liferay.petra.sql.dsl.Table;
import com.liferay.petra.string.StringBundler;
import com.liferay.portal.kernel.change.tracking.CTColumnResolutionType;
import com.liferay.portal.kernel.configuration.Configuration;
import com.liferay.portal.kernel.dao.orm.ArgumentsResolver;
import com.liferay.portal.kernel.dao.orm.Dialect;
import com.liferay.portal.kernel.dao.orm.EntityCache;
import com.liferay.portal.kernel.dao.orm.FinderCache;
import com.liferay.portal.kernel.dao.orm.FinderPath;
import com.liferay.portal.kernel.dao.orm.Query;
import com.liferay.portal.kernel.dao.orm.QueryPos;
import com.liferay.portal.kernel.dao.orm.QueryUtil;
import com.liferay.portal.kernel.dao.orm.Session;
import com.liferay.portal.kernel.dao.orm.SessionFactory;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.model.BaseModel;
import com.liferay.portal.kernel.model.change.tracking.CTModel;
import com.liferay.portal.kernel.security.auth.CompanyThreadLocal;
import com.liferay.portal.kernel.service.ServiceContext;
import com.liferay.portal.kernel.service.ServiceContextThreadLocal;
import com.liferay.portal.kernel.service.persistence.BasePersistence;
import com.liferay.portal.kernel.service.persistence.change.tracking.helper.CTPersistenceHelper;
import com.liferay.portal.kernel.service.persistence.impl.BasePersistenceImpl;
import com.liferay.portal.kernel.util.HashMapDictionary;
import com.liferay.portal.kernel.util.OrderByComparator;
import com.liferay.portal.kernel.util.ProxyUtil;
import java.io.Serializable;
import java.lang.reflect.InvocationHandler;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.Dictionary;
import java.util.EnumMap;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import javax.sql.DataSource;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceRegistration;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Deactivate;
import org.osgi.service.component.annotations.Reference;

@Component(service={DDMTemplateVersionPersistence.class, BasePersistence.class})
public class DDMTemplateVersionPersistenceImpl
extends BasePersistenceImpl<DDMTemplateVersion>
implements DDMTemplateVersionPersistence {
    public static final String FINDER_CLASS_NAME_ENTITY = DDMTemplateVersionImpl.class.getName();
    public static final String FINDER_CLASS_NAME_LIST_WITH_PAGINATION = FINDER_CLASS_NAME_ENTITY + ".List1";
    public static final String FINDER_CLASS_NAME_LIST_WITHOUT_PAGINATION = FINDER_CLASS_NAME_ENTITY + ".List2";
    private FinderPath _finderPathWithPaginationFindAll;
    private FinderPath _finderPathWithoutPaginationFindAll;
    private FinderPath _finderPathCountAll;
    private FinderPath _finderPathWithPaginationFindByTemplateId;
    private FinderPath _finderPathWithoutPaginationFindByTemplateId;
    private FinderPath _finderPathCountByTemplateId;
    private static final String _FINDER_COLUMN_TEMPLATEID_TEMPLATEID_2 = "ddmTemplateVersion.templateId = ?";
    private FinderPath _finderPathFetchByT_V;
    private FinderPath _finderPathCountByT_V;
    private static final String _FINDER_COLUMN_T_V_TEMPLATEID_2 = "ddmTemplateVersion.templateId = ? AND ";
    private static final String _FINDER_COLUMN_T_V_VERSION_2 = "ddmTemplateVersion.version = ?";
    private static final String _FINDER_COLUMN_T_V_VERSION_3 = "(ddmTemplateVersion.version IS NULL OR ddmTemplateVersion.version = '')";
    private FinderPath _finderPathWithPaginationFindByT_S;
    private FinderPath _finderPathWithoutPaginationFindByT_S;
    private FinderPath _finderPathCountByT_S;
    private static final String _FINDER_COLUMN_T_S_TEMPLATEID_2 = "ddmTemplateVersion.templateId = ? AND ";
    private static final String _FINDER_COLUMN_T_S_STATUS_2 = "ddmTemplateVersion.status = ?";
    private static final Map<CTColumnResolutionType, Set<String>> _ctColumnNamesMap = new EnumMap<CTColumnResolutionType, Set<String>>(CTColumnResolutionType.class);
    private static final List<String> _mappingTableNames = new ArrayList<String>();
    private static final List<String[]> _uniqueIndexColumnNames = new ArrayList<String[]>();
    private BundleContext _bundleContext;
    @Reference
    protected CTPersistenceHelper ctPersistenceHelper;
    @Reference
    protected EntityCache entityCache;
    @Reference
    protected FinderCache finderCache;
    private static final String _SQL_SELECT_DDMTEMPLATEVERSION = "SELECT ddmTemplateVersion FROM DDMTemplateVersion ddmTemplateVersion";
    private static final String _SQL_SELECT_DDMTEMPLATEVERSION_WHERE = "SELECT ddmTemplateVersion FROM DDMTemplateVersion ddmTemplateVersion WHERE ";
    private static final String _SQL_COUNT_DDMTEMPLATEVERSION = "SELECT COUNT(ddmTemplateVersion) FROM DDMTemplateVersion ddmTemplateVersion";
    private static final String _SQL_COUNT_DDMTEMPLATEVERSION_WHERE = "SELECT COUNT(ddmTemplateVersion) FROM DDMTemplateVersion ddmTemplateVersion WHERE ";
    private static final String _ORDER_BY_ENTITY_ALIAS = "ddmTemplateVersion.";
    private static final String _NO_SUCH_ENTITY_WITH_PRIMARY_KEY = "No DDMTemplateVersion exists with the primary key ";
    private static final String _NO_SUCH_ENTITY_WITH_KEY = "No DDMTemplateVersion exists with the key {";
    private static final Log _log;
    private ServiceRegistration<ArgumentsResolver> _argumentsResolverServiceRegistration;

    public List<DDMTemplateVersion> findByTemplateId(long templateId) {
        return this.findByTemplateId(templateId, -1, -1, null);
    }

    public List<DDMTemplateVersion> findByTemplateId(long templateId, int start, int end) {
        return this.findByTemplateId(templateId, start, end, null);
    }

    public List<DDMTemplateVersion> findByTemplateId(long templateId, int start, int end, OrderByComparator<DDMTemplateVersion> orderByComparator) {
        return this.findByTemplateId(templateId, start, end, orderByComparator, true);
    }

    public List<DDMTemplateVersion> findByTemplateId(long templateId, int start, int end, OrderByComparator<DDMTemplateVersion> orderByComparator, boolean useFinderCache) {
        boolean productionMode = this.ctPersistenceHelper.isProductionMode(DDMTemplateVersion.class);
        FinderPath finderPath = null;
        Object[] finderArgs = null;
        if (start == -1 && end == -1 && orderByComparator == null) {
            if (useFinderCache && productionMode) {
                finderPath = this._finderPathWithoutPaginationFindByTemplateId;
                finderArgs = new Object[]{templateId};
            }
        } else if (useFinderCache && productionMode) {
            finderPath = this._finderPathWithPaginationFindByTemplateId;
            finderArgs = new Object[]{templateId, start, end, orderByComparator};
        }
        List list = null;
        if (useFinderCache && productionMode && (list = (List)this.finderCache.getResult(finderPath, finderArgs)) != null && !list.isEmpty()) {
            for (DDMTemplateVersion ddmTemplateVersion : list) {
                if (templateId == ddmTemplateVersion.getTemplateId()) continue;
                list = null;
                break;
            }
        }
        if (list == null) {
            StringBundler sb = null;
            sb = orderByComparator != null ? new StringBundler(3 + orderByComparator.getOrderByFields().length * 2) : new StringBundler(3);
            sb.append(_SQL_SELECT_DDMTEMPLATEVERSION_WHERE);
            sb.append(_FINDER_COLUMN_TEMPLATEID_TEMPLATEID_2);
            if (orderByComparator != null) {
                this.appendOrderByComparator(sb, _ORDER_BY_ENTITY_ALIAS, orderByComparator);
            } else {
                sb.append(" ORDER BY ddmTemplateVersion.templateVersionId ASC");
            }
            String sql = sb.toString();
            Session session = null;
            try {
                session = this.openSession();
                Query query = session.createQuery(sql);
                QueryPos queryPos = QueryPos.getInstance((Query)query);
                queryPos.add(templateId);
                list = QueryUtil.list((Query)query, (Dialect)this.getDialect(), (int)start, (int)end);
                this.cacheResult(list);
                if (useFinderCache && productionMode) {
                    this.finderCache.putResult(finderPath, finderArgs, (Object)list);
                }
            }
            catch (Exception exception) {
                throw this.processException(exception);
            }
            finally {
                this.closeSession(session);
            }
        }
        return list;
    }

    public DDMTemplateVersion findByTemplateId_First(long templateId, OrderByComparator<DDMTemplateVersion> orderByComparator) throws NoSuchTemplateVersionException {
        DDMTemplateVersion ddmTemplateVersion = this.fetchByTemplateId_First(templateId, orderByComparator);
        if (ddmTemplateVersion != null) {
            return ddmTemplateVersion;
        }
        StringBundler sb = new StringBundler(4);
        sb.append(_NO_SUCH_ENTITY_WITH_KEY);
        sb.append("templateId=");
        sb.append(templateId);
        sb.append("}");
        throw new NoSuchTemplateVersionException(sb.toString());
    }

    public DDMTemplateVersion fetchByTemplateId_First(long templateId, OrderByComparator<DDMTemplateVersion> orderByComparator) {
        List<DDMTemplateVersion> list = this.findByTemplateId(templateId, 0, 1, orderByComparator);
        if (!list.isEmpty()) {
            return list.get(0);
        }
        return null;
    }

    public DDMTemplateVersion findByTemplateId_Last(long templateId, OrderByComparator<DDMTemplateVersion> orderByComparator) throws NoSuchTemplateVersionException {
        DDMTemplateVersion ddmTemplateVersion = this.fetchByTemplateId_Last(templateId, orderByComparator);
        if (ddmTemplateVersion != null) {
            return ddmTemplateVersion;
        }
        StringBundler sb = new StringBundler(4);
        sb.append(_NO_SUCH_ENTITY_WITH_KEY);
        sb.append("templateId=");
        sb.append(templateId);
        sb.append("}");
        throw new NoSuchTemplateVersionException(sb.toString());
    }

    public DDMTemplateVersion fetchByTemplateId_Last(long templateId, OrderByComparator<DDMTemplateVersion> orderByComparator) {
        int count = this.countByTemplateId(templateId);
        if (count == 0) {
            return null;
        }
        List<DDMTemplateVersion> list = this.findByTemplateId(templateId, count - 1, count, orderByComparator);
        if (!list.isEmpty()) {
            return list.get(0);
        }
        return null;
    }

    public DDMTemplateVersion[] findByTemplateId_PrevAndNext(long templateVersionId, long templateId, OrderByComparator<DDMTemplateVersion> orderByComparator) throws NoSuchTemplateVersionException {
        DDMTemplateVersion ddmTemplateVersion = this.findByPrimaryKey(templateVersionId);
        Session session = null;
        try {
            session = this.openSession();
            DDMTemplateVersion[] array = new DDMTemplateVersionImpl[]{this.getByTemplateId_PrevAndNext(session, ddmTemplateVersion, templateId, orderByComparator, true), ddmTemplateVersion, this.getByTemplateId_PrevAndNext(session, ddmTemplateVersion, templateId, orderByComparator, false)};
            DDMTemplateVersion[] dDMTemplateVersionArray = array;
            return dDMTemplateVersionArray;
        }
        catch (Exception exception) {
            throw this.processException(exception);
        }
        finally {
            this.closeSession(session);
        }
    }

    protected DDMTemplateVersion getByTemplateId_PrevAndNext(Session session, DDMTemplateVersion ddmTemplateVersion, long templateId, OrderByComparator<DDMTemplateVersion> orderByComparator, boolean previous) {
        List list;
        StringBundler sb = null;
        sb = orderByComparator != null ? new StringBundler(4 + orderByComparator.getOrderByConditionFields().length * 3 + orderByComparator.getOrderByFields().length * 3) : new StringBundler(3);
        sb.append(_SQL_SELECT_DDMTEMPLATEVERSION_WHERE);
        sb.append(_FINDER_COLUMN_TEMPLATEID_TEMPLATEID_2);
        if (orderByComparator != null) {
            String[] orderByConditionFields = orderByComparator.getOrderByConditionFields();
            if (orderByConditionFields.length > 0) {
                sb.append(" AND ");
            }
            for (int i = 0; i < orderByConditionFields.length; ++i) {
                sb.append(_ORDER_BY_ENTITY_ALIAS);
                sb.append(orderByConditionFields[i]);
                if (i + 1 < orderByConditionFields.length) {
                    if (orderByComparator.isAscending() ^ previous) {
                        sb.append(" >= ? AND ");
                        continue;
                    }
                    sb.append(" <= ? AND ");
                    continue;
                }
                if (orderByComparator.isAscending() ^ previous) {
                    sb.append(" >= ? ");
                    continue;
                }
                sb.append(" <= ? ");
            }
            sb.append(" ORDER BY ");
            String[] orderByFields = orderByComparator.getOrderByFields();
            for (int i = 0; i < orderByFields.length; ++i) {
                sb.append(_ORDER_BY_ENTITY_ALIAS);
                sb.append(orderByFields[i]);
                if (i + 1 < orderByFields.length) {
                    if (orderByComparator.isAscending() ^ previous) {
                        sb.append(" ASC, ");
                        continue;
                    }
                    sb.append(" DESC, ");
                    continue;
                }
                if (orderByComparator.isAscending() ^ previous) {
                    sb.append(" ASC");
                    continue;
                }
                sb.append(" DESC");
            }
        } else {
            sb.append(" ORDER BY ddmTemplateVersion.templateVersionId ASC");
        }
        String sql = sb.toString();
        Query query = session.createQuery(sql);
        query.setFirstResult(0);
        query.setMaxResults(2);
        QueryPos queryPos = QueryPos.getInstance((Query)query);
        queryPos.add(templateId);
        if (orderByComparator != null) {
            for (Object orderByConditionValue : orderByComparator.getOrderByConditionValues((Object)ddmTemplateVersion)) {
                queryPos.add(orderByConditionValue);
            }
        }
        if ((list = query.list()).size() == 2) {
            return (DDMTemplateVersion)list.get(1);
        }
        return null;
    }

    public void removeByTemplateId(long templateId) {
        for (DDMTemplateVersion ddmTemplateVersion : this.findByTemplateId(templateId, -1, -1, null)) {
            this.remove((BaseModel)ddmTemplateVersion);
        }
    }

    public int countByTemplateId(long templateId) {
        boolean productionMode = this.ctPersistenceHelper.isProductionMode(DDMTemplateVersion.class);
        FinderPath finderPath = null;
        Object[] finderArgs = null;
        Long count = null;
        if (productionMode) {
            finderPath = this._finderPathCountByTemplateId;
            finderArgs = new Object[]{templateId};
            count = (Long)this.finderCache.getResult(finderPath, finderArgs);
        }
        if (count == null) {
            StringBundler sb = new StringBundler(2);
            sb.append(_SQL_COUNT_DDMTEMPLATEVERSION_WHERE);
            sb.append(_FINDER_COLUMN_TEMPLATEID_TEMPLATEID_2);
            String sql = sb.toString();
            Session session = null;
            try {
                session = this.openSession();
                Query query = session.createQuery(sql);
                QueryPos queryPos = QueryPos.getInstance((Query)query);
                queryPos.add(templateId);
                count = (Long)query.uniqueResult();
                if (productionMode) {
                    this.finderCache.putResult(finderPath, finderArgs, (Object)count);
                }
            }
            catch (Exception exception) {
                throw this.processException(exception);
            }
            finally {
                this.closeSession(session);
            }
        }
        return count.intValue();
    }

    public DDMTemplateVersion findByT_V(long templateId, String version) throws NoSuchTemplateVersionException {
        DDMTemplateVersion ddmTemplateVersion = this.fetchByT_V(templateId, version);
        if (ddmTemplateVersion == null) {
            StringBundler sb = new StringBundler(6);
            sb.append(_NO_SUCH_ENTITY_WITH_KEY);
            sb.append("templateId=");
            sb.append(templateId);
            sb.append(", version=");
            sb.append(version);
            sb.append("}");
            if (_log.isDebugEnabled()) {
                _log.debug((Object)sb.toString());
            }
            throw new NoSuchTemplateVersionException(sb.toString());
        }
        return ddmTemplateVersion;
    }

    public DDMTemplateVersion fetchByT_V(long templateId, String version) {
        return this.fetchByT_V(templateId, version, true);
    }

    public DDMTemplateVersion fetchByT_V(long templateId, String version, boolean useFinderCache) {
        DDMTemplateVersion ddmTemplateVersion;
        version = Objects.toString(version, "");
        boolean productionMode = this.ctPersistenceHelper.isProductionMode(DDMTemplateVersion.class);
        Object[] finderArgs = null;
        if (useFinderCache && productionMode) {
            finderArgs = new Object[]{templateId, version};
        }
        Object result = null;
        if (useFinderCache && productionMode) {
            result = this.finderCache.getResult(this._finderPathFetchByT_V, finderArgs);
        }
        if (result instanceof DDMTemplateVersion && (templateId != (ddmTemplateVersion = (DDMTemplateVersion)result).getTemplateId() || !Objects.equals(version, ddmTemplateVersion.getVersion()))) {
            result = null;
        }
        if (result == null) {
            StringBundler sb = new StringBundler(4);
            sb.append(_SQL_SELECT_DDMTEMPLATEVERSION_WHERE);
            sb.append("ddmTemplateVersion.templateId = ? AND ");
            boolean bindVersion = false;
            if (version.isEmpty()) {
                sb.append(_FINDER_COLUMN_T_V_VERSION_3);
            } else {
                bindVersion = true;
                sb.append(_FINDER_COLUMN_T_V_VERSION_2);
            }
            String sql = sb.toString();
            Session session = null;
            try {
                List list;
                session = this.openSession();
                Query query = session.createQuery(sql);
                QueryPos queryPos = QueryPos.getInstance((Query)query);
                queryPos.add(templateId);
                if (bindVersion) {
                    queryPos.add(version);
                }
                if ((list = query.list()).isEmpty()) {
                    if (useFinderCache && productionMode) {
                        this.finderCache.putResult(this._finderPathFetchByT_V, finderArgs, (Object)list);
                    }
                } else {
                    DDMTemplateVersion ddmTemplateVersion2 = (DDMTemplateVersion)list.get(0);
                    result = ddmTemplateVersion2;
                    this.cacheResult(ddmTemplateVersion2);
                }
            }
            catch (Exception exception) {
                throw this.processException(exception);
            }
            finally {
                this.closeSession(session);
            }
        }
        if (result instanceof List) {
            return null;
        }
        return (DDMTemplateVersion)result;
    }

    public DDMTemplateVersion removeByT_V(long templateId, String version) throws NoSuchTemplateVersionException {
        DDMTemplateVersion ddmTemplateVersion = this.findByT_V(templateId, version);
        return (DDMTemplateVersion)this.remove((BaseModel)ddmTemplateVersion);
    }

    public int countByT_V(long templateId, String version) {
        version = Objects.toString(version, "");
        boolean productionMode = this.ctPersistenceHelper.isProductionMode(DDMTemplateVersion.class);
        FinderPath finderPath = null;
        Object[] finderArgs = null;
        Long count = null;
        if (productionMode) {
            finderPath = this._finderPathCountByT_V;
            finderArgs = new Object[]{templateId, version};
            count = (Long)this.finderCache.getResult(finderPath, finderArgs);
        }
        if (count == null) {
            StringBundler sb = new StringBundler(3);
            sb.append(_SQL_COUNT_DDMTEMPLATEVERSION_WHERE);
            sb.append("ddmTemplateVersion.templateId = ? AND ");
            boolean bindVersion = false;
            if (version.isEmpty()) {
                sb.append(_FINDER_COLUMN_T_V_VERSION_3);
            } else {
                bindVersion = true;
                sb.append(_FINDER_COLUMN_T_V_VERSION_2);
            }
            String sql = sb.toString();
            Session session = null;
            try {
                session = this.openSession();
                Query query = session.createQuery(sql);
                QueryPos queryPos = QueryPos.getInstance((Query)query);
                queryPos.add(templateId);
                if (bindVersion) {
                    queryPos.add(version);
                }
                count = (Long)query.uniqueResult();
                if (productionMode) {
                    this.finderCache.putResult(finderPath, finderArgs, (Object)count);
                }
            }
            catch (Exception exception) {
                throw this.processException(exception);
            }
            finally {
                this.closeSession(session);
            }
        }
        return count.intValue();
    }

    public List<DDMTemplateVersion> findByT_S(long templateId, int status) {
        return this.findByT_S(templateId, status, -1, -1, null);
    }

    public List<DDMTemplateVersion> findByT_S(long templateId, int status, int start, int end) {
        return this.findByT_S(templateId, status, start, end, null);
    }

    public List<DDMTemplateVersion> findByT_S(long templateId, int status, int start, int end, OrderByComparator<DDMTemplateVersion> orderByComparator) {
        return this.findByT_S(templateId, status, start, end, orderByComparator, true);
    }

    public List<DDMTemplateVersion> findByT_S(long templateId, int status, int start, int end, OrderByComparator<DDMTemplateVersion> orderByComparator, boolean useFinderCache) {
        boolean productionMode = this.ctPersistenceHelper.isProductionMode(DDMTemplateVersion.class);
        FinderPath finderPath = null;
        Object[] finderArgs = null;
        if (start == -1 && end == -1 && orderByComparator == null) {
            if (useFinderCache && productionMode) {
                finderPath = this._finderPathWithoutPaginationFindByT_S;
                finderArgs = new Object[]{templateId, status};
            }
        } else if (useFinderCache && productionMode) {
            finderPath = this._finderPathWithPaginationFindByT_S;
            finderArgs = new Object[]{templateId, status, start, end, orderByComparator};
        }
        List list = null;
        if (useFinderCache && productionMode && (list = (List)this.finderCache.getResult(finderPath, finderArgs)) != null && !list.isEmpty()) {
            for (DDMTemplateVersion ddmTemplateVersion : list) {
                if (templateId == ddmTemplateVersion.getTemplateId() && status == ddmTemplateVersion.getStatus()) continue;
                list = null;
                break;
            }
        }
        if (list == null) {
            StringBundler sb = null;
            sb = orderByComparator != null ? new StringBundler(4 + orderByComparator.getOrderByFields().length * 2) : new StringBundler(4);
            sb.append(_SQL_SELECT_DDMTEMPLATEVERSION_WHERE);
            sb.append("ddmTemplateVersion.templateId = ? AND ");
            sb.append(_FINDER_COLUMN_T_S_STATUS_2);
            if (orderByComparator != null) {
                this.appendOrderByComparator(sb, _ORDER_BY_ENTITY_ALIAS, orderByComparator);
            } else {
                sb.append(" ORDER BY ddmTemplateVersion.templateVersionId ASC");
            }
            String sql = sb.toString();
            Session session = null;
            try {
                session = this.openSession();
                Query query = session.createQuery(sql);
                QueryPos queryPos = QueryPos.getInstance((Query)query);
                queryPos.add(templateId);
                queryPos.add(status);
                list = QueryUtil.list((Query)query, (Dialect)this.getDialect(), (int)start, (int)end);
                this.cacheResult(list);
                if (useFinderCache && productionMode) {
                    this.finderCache.putResult(finderPath, finderArgs, (Object)list);
                }
            }
            catch (Exception exception) {
                throw this.processException(exception);
            }
            finally {
                this.closeSession(session);
            }
        }
        return list;
    }

    public DDMTemplateVersion findByT_S_First(long templateId, int status, OrderByComparator<DDMTemplateVersion> orderByComparator) throws NoSuchTemplateVersionException {
        DDMTemplateVersion ddmTemplateVersion = this.fetchByT_S_First(templateId, status, orderByComparator);
        if (ddmTemplateVersion != null) {
            return ddmTemplateVersion;
        }
        StringBundler sb = new StringBundler(6);
        sb.append(_NO_SUCH_ENTITY_WITH_KEY);
        sb.append("templateId=");
        sb.append(templateId);
        sb.append(", status=");
        sb.append(status);
        sb.append("}");
        throw new NoSuchTemplateVersionException(sb.toString());
    }

    public DDMTemplateVersion fetchByT_S_First(long templateId, int status, OrderByComparator<DDMTemplateVersion> orderByComparator) {
        List<DDMTemplateVersion> list = this.findByT_S(templateId, status, 0, 1, orderByComparator);
        if (!list.isEmpty()) {
            return list.get(0);
        }
        return null;
    }

    public DDMTemplateVersion findByT_S_Last(long templateId, int status, OrderByComparator<DDMTemplateVersion> orderByComparator) throws NoSuchTemplateVersionException {
        DDMTemplateVersion ddmTemplateVersion = this.fetchByT_S_Last(templateId, status, orderByComparator);
        if (ddmTemplateVersion != null) {
            return ddmTemplateVersion;
        }
        StringBundler sb = new StringBundler(6);
        sb.append(_NO_SUCH_ENTITY_WITH_KEY);
        sb.append("templateId=");
        sb.append(templateId);
        sb.append(", status=");
        sb.append(status);
        sb.append("}");
        throw new NoSuchTemplateVersionException(sb.toString());
    }

    public DDMTemplateVersion fetchByT_S_Last(long templateId, int status, OrderByComparator<DDMTemplateVersion> orderByComparator) {
        int count = this.countByT_S(templateId, status);
        if (count == 0) {
            return null;
        }
        List<DDMTemplateVersion> list = this.findByT_S(templateId, status, count - 1, count, orderByComparator);
        if (!list.isEmpty()) {
            return list.get(0);
        }
        return null;
    }

    public DDMTemplateVersion[] findByT_S_PrevAndNext(long templateVersionId, long templateId, int status, OrderByComparator<DDMTemplateVersion> orderByComparator) throws NoSuchTemplateVersionException {
        DDMTemplateVersion ddmTemplateVersion = this.findByPrimaryKey(templateVersionId);
        Session session = null;
        try {
            session = this.openSession();
            DDMTemplateVersion[] array = new DDMTemplateVersionImpl[]{this.getByT_S_PrevAndNext(session, ddmTemplateVersion, templateId, status, orderByComparator, true), ddmTemplateVersion, this.getByT_S_PrevAndNext(session, ddmTemplateVersion, templateId, status, orderByComparator, false)};
            DDMTemplateVersion[] dDMTemplateVersionArray = array;
            return dDMTemplateVersionArray;
        }
        catch (Exception exception) {
            throw this.processException(exception);
        }
        finally {
            this.closeSession(session);
        }
    }

    protected DDMTemplateVersion getByT_S_PrevAndNext(Session session, DDMTemplateVersion ddmTemplateVersion, long templateId, int status, OrderByComparator<DDMTemplateVersion> orderByComparator, boolean previous) {
        List list;
        StringBundler sb = null;
        sb = orderByComparator != null ? new StringBundler(5 + orderByComparator.getOrderByConditionFields().length * 3 + orderByComparator.getOrderByFields().length * 3) : new StringBundler(4);
        sb.append(_SQL_SELECT_DDMTEMPLATEVERSION_WHERE);
        sb.append("ddmTemplateVersion.templateId = ? AND ");
        sb.append(_FINDER_COLUMN_T_S_STATUS_2);
        if (orderByComparator != null) {
            String[] orderByConditionFields = orderByComparator.getOrderByConditionFields();
            if (orderByConditionFields.length > 0) {
                sb.append(" AND ");
            }
            for (int i = 0; i < orderByConditionFields.length; ++i) {
                sb.append(_ORDER_BY_ENTITY_ALIAS);
                sb.append(orderByConditionFields[i]);
                if (i + 1 < orderByConditionFields.length) {
                    if (orderByComparator.isAscending() ^ previous) {
                        sb.append(" >= ? AND ");
                        continue;
                    }
                    sb.append(" <= ? AND ");
                    continue;
                }
                if (orderByComparator.isAscending() ^ previous) {
                    sb.append(" >= ? ");
                    continue;
                }
                sb.append(" <= ? ");
            }
            sb.append(" ORDER BY ");
            String[] orderByFields = orderByComparator.getOrderByFields();
            for (int i = 0; i < orderByFields.length; ++i) {
                sb.append(_ORDER_BY_ENTITY_ALIAS);
                sb.append(orderByFields[i]);
                if (i + 1 < orderByFields.length) {
                    if (orderByComparator.isAscending() ^ previous) {
                        sb.append(" ASC, ");
                        continue;
                    }
                    sb.append(" DESC, ");
                    continue;
                }
                if (orderByComparator.isAscending() ^ previous) {
                    sb.append(" ASC");
                    continue;
                }
                sb.append(" DESC");
            }
        } else {
            sb.append(" ORDER BY ddmTemplateVersion.templateVersionId ASC");
        }
        String sql = sb.toString();
        Query query = session.createQuery(sql);
        query.setFirstResult(0);
        query.setMaxResults(2);
        QueryPos queryPos = QueryPos.getInstance((Query)query);
        queryPos.add(templateId);
        queryPos.add(status);
        if (orderByComparator != null) {
            for (Object orderByConditionValue : orderByComparator.getOrderByConditionValues((Object)ddmTemplateVersion)) {
                queryPos.add(orderByConditionValue);
            }
        }
        if ((list = query.list()).size() == 2) {
            return (DDMTemplateVersion)list.get(1);
        }
        return null;
    }

    public void removeByT_S(long templateId, int status) {
        for (DDMTemplateVersion ddmTemplateVersion : this.findByT_S(templateId, status, -1, -1, null)) {
            this.remove((BaseModel)ddmTemplateVersion);
        }
    }

    public int countByT_S(long templateId, int status) {
        boolean productionMode = this.ctPersistenceHelper.isProductionMode(DDMTemplateVersion.class);
        FinderPath finderPath = null;
        Object[] finderArgs = null;
        Long count = null;
        if (productionMode) {
            finderPath = this._finderPathCountByT_S;
            finderArgs = new Object[]{templateId, status};
            count = (Long)this.finderCache.getResult(finderPath, finderArgs);
        }
        if (count == null) {
            StringBundler sb = new StringBundler(3);
            sb.append(_SQL_COUNT_DDMTEMPLATEVERSION_WHERE);
            sb.append("ddmTemplateVersion.templateId = ? AND ");
            sb.append(_FINDER_COLUMN_T_S_STATUS_2);
            String sql = sb.toString();
            Session session = null;
            try {
                session = this.openSession();
                Query query = session.createQuery(sql);
                QueryPos queryPos = QueryPos.getInstance((Query)query);
                queryPos.add(templateId);
                queryPos.add(status);
                count = (Long)query.uniqueResult();
                if (productionMode) {
                    this.finderCache.putResult(finderPath, finderArgs, (Object)count);
                }
            }
            catch (Exception exception) {
                throw this.processException(exception);
            }
            finally {
                this.closeSession(session);
            }
        }
        return count.intValue();
    }

    public DDMTemplateVersionPersistenceImpl() {
        this.setModelClass(DDMTemplateVersion.class);
        this.setModelImplClass(DDMTemplateVersionImpl.class);
        this.setModelPKClass(Long.TYPE);
        this.setTable((Table)DDMTemplateVersionTable.INSTANCE);
    }

    public void cacheResult(DDMTemplateVersion ddmTemplateVersion) {
        if (ddmTemplateVersion.getCtCollectionId() != 0L) {
            return;
        }
        this.entityCache.putResult(DDMTemplateVersionImpl.class, (Serializable)Long.valueOf(ddmTemplateVersion.getPrimaryKey()), (Serializable)ddmTemplateVersion);
        this.finderCache.putResult(this._finderPathFetchByT_V, new Object[]{ddmTemplateVersion.getTemplateId(), ddmTemplateVersion.getVersion()}, (Object)ddmTemplateVersion);
    }

    public void cacheResult(List<DDMTemplateVersion> ddmTemplateVersions) {
        for (DDMTemplateVersion ddmTemplateVersion : ddmTemplateVersions) {
            if (ddmTemplateVersion.getCtCollectionId() != 0L || this.entityCache.getResult(DDMTemplateVersionImpl.class, (Serializable)Long.valueOf(ddmTemplateVersion.getPrimaryKey())) != null) continue;
            this.cacheResult(ddmTemplateVersion);
        }
    }

    public void clearCache() {
        this.entityCache.clearCache(DDMTemplateVersionImpl.class);
        this.finderCache.clearCache(DDMTemplateVersionImpl.class);
    }

    public void clearCache(DDMTemplateVersion ddmTemplateVersion) {
        this.entityCache.removeResult(DDMTemplateVersionImpl.class, (BaseModel)ddmTemplateVersion);
    }

    public void clearCache(List<DDMTemplateVersion> ddmTemplateVersions) {
        for (DDMTemplateVersion ddmTemplateVersion : ddmTemplateVersions) {
            this.entityCache.removeResult(DDMTemplateVersionImpl.class, (BaseModel)ddmTemplateVersion);
        }
    }

    public void clearCache(Set<Serializable> primaryKeys) {
        this.finderCache.clearCache(DDMTemplateVersionImpl.class);
        for (Serializable primaryKey : primaryKeys) {
            this.entityCache.removeResult(DDMTemplateVersionImpl.class, primaryKey);
        }
    }

    protected void cacheUniqueFindersCache(DDMTemplateVersionModelImpl ddmTemplateVersionModelImpl) {
        Object[] args = new Object[]{ddmTemplateVersionModelImpl.getTemplateId(), ddmTemplateVersionModelImpl.getVersion()};
        this.finderCache.putResult(this._finderPathCountByT_V, args, (Object)1L);
        this.finderCache.putResult(this._finderPathFetchByT_V, args, (Object)ddmTemplateVersionModelImpl);
    }

    public DDMTemplateVersion create(long templateVersionId) {
        DDMTemplateVersionImpl ddmTemplateVersion = new DDMTemplateVersionImpl();
        ddmTemplateVersion.setNew(true);
        ddmTemplateVersion.setPrimaryKey(templateVersionId);
        ddmTemplateVersion.setCompanyId(CompanyThreadLocal.getCompanyId());
        return ddmTemplateVersion;
    }

    public DDMTemplateVersion remove(long templateVersionId) throws NoSuchTemplateVersionException {
        return this.remove(Long.valueOf(templateVersionId));
    }

    public DDMTemplateVersion remove(Serializable primaryKey) throws NoSuchTemplateVersionException {
        Session session = null;
        try {
            session = this.openSession();
            DDMTemplateVersion ddmTemplateVersion = (DDMTemplateVersion)session.get(DDMTemplateVersionImpl.class, primaryKey);
            if (ddmTemplateVersion == null) {
                if (_log.isDebugEnabled()) {
                    _log.debug((Object)(_NO_SUCH_ENTITY_WITH_PRIMARY_KEY + primaryKey));
                }
                throw new NoSuchTemplateVersionException(_NO_SUCH_ENTITY_WITH_PRIMARY_KEY + primaryKey);
            }
            DDMTemplateVersion dDMTemplateVersion = (DDMTemplateVersion)this.remove((BaseModel)ddmTemplateVersion);
            return dDMTemplateVersion;
        }
        catch (NoSuchTemplateVersionException noSuchEntityException) {
            throw noSuchEntityException;
        }
        catch (Exception exception) {
            throw this.processException(exception);
        }
        finally {
            this.closeSession(session);
        }
    }

    protected DDMTemplateVersion removeImpl(DDMTemplateVersion ddmTemplateVersion) {
        Session session = null;
        try {
            session = this.openSession();
            if (!session.contains((Object)ddmTemplateVersion)) {
                ddmTemplateVersion = (DDMTemplateVersion)session.get(DDMTemplateVersionImpl.class, ddmTemplateVersion.getPrimaryKeyObj());
            }
            if (ddmTemplateVersion != null && this.ctPersistenceHelper.isRemove((CTModel)ddmTemplateVersion)) {
                session.delete((Object)ddmTemplateVersion);
            }
        }
        catch (Exception exception) {
            throw this.processException(exception);
        }
        finally {
            this.closeSession(session);
        }
        if (ddmTemplateVersion != null) {
            this.clearCache(ddmTemplateVersion);
        }
        return ddmTemplateVersion;
    }

    public DDMTemplateVersion updateImpl(DDMTemplateVersion ddmTemplateVersion) {
        boolean isNew = ddmTemplateVersion.isNew();
        if (!(ddmTemplateVersion instanceof DDMTemplateVersionModelImpl)) {
            InvocationHandler invocationHandler = null;
            if (ProxyUtil.isProxyClass(ddmTemplateVersion.getClass())) {
                invocationHandler = ProxyUtil.getInvocationHandler((Object)ddmTemplateVersion);
                throw new IllegalArgumentException("Implement ModelWrapper in ddmTemplateVersion proxy " + invocationHandler.getClass());
            }
            throw new IllegalArgumentException("Implement ModelWrapper in custom DDMTemplateVersion implementation " + ddmTemplateVersion.getClass());
        }
        DDMTemplateVersionModelImpl ddmTemplateVersionModelImpl = (DDMTemplateVersionModelImpl)ddmTemplateVersion;
        if (isNew && ddmTemplateVersion.getCreateDate() == null) {
            ServiceContext serviceContext = ServiceContextThreadLocal.getServiceContext();
            Date date = new Date();
            if (serviceContext == null) {
                ddmTemplateVersion.setCreateDate(date);
            } else {
                ddmTemplateVersion.setCreateDate(serviceContext.getCreateDate(date));
            }
        }
        Session session = null;
        try {
            session = this.openSession();
            if (this.ctPersistenceHelper.isInsert((CTModel)ddmTemplateVersion)) {
                if (!isNew) {
                    session.evict(DDMTemplateVersionImpl.class, ddmTemplateVersion.getPrimaryKeyObj());
                }
                session.save((Object)ddmTemplateVersion);
            } else {
                ddmTemplateVersion = (DDMTemplateVersion)session.merge((Object)ddmTemplateVersion);
            }
        }
        catch (Exception exception) {
            throw this.processException(exception);
        }
        finally {
            this.closeSession(session);
        }
        if (ddmTemplateVersion.getCtCollectionId() != 0L) {
            if (isNew) {
                ddmTemplateVersion.setNew(false);
            }
            ddmTemplateVersion.resetOriginalValues();
            return ddmTemplateVersion;
        }
        this.entityCache.putResult(DDMTemplateVersionImpl.class, (BaseModel)ddmTemplateVersionModelImpl, false, true);
        this.cacheUniqueFindersCache(ddmTemplateVersionModelImpl);
        if (isNew) {
            ddmTemplateVersion.setNew(false);
        }
        ddmTemplateVersion.resetOriginalValues();
        return ddmTemplateVersion;
    }

    public DDMTemplateVersion findByPrimaryKey(Serializable primaryKey) throws NoSuchTemplateVersionException {
        DDMTemplateVersion ddmTemplateVersion = this.fetchByPrimaryKey(primaryKey);
        if (ddmTemplateVersion == null) {
            if (_log.isDebugEnabled()) {
                _log.debug((Object)(_NO_SUCH_ENTITY_WITH_PRIMARY_KEY + primaryKey));
            }
            throw new NoSuchTemplateVersionException(_NO_SUCH_ENTITY_WITH_PRIMARY_KEY + primaryKey);
        }
        return ddmTemplateVersion;
    }

    public DDMTemplateVersion findByPrimaryKey(long templateVersionId) throws NoSuchTemplateVersionException {
        return this.findByPrimaryKey(Long.valueOf(templateVersionId));
    }

    public DDMTemplateVersion fetchByPrimaryKey(Serializable primaryKey) {
        if (this.ctPersistenceHelper.isProductionMode(DDMTemplateVersion.class)) {
            return (DDMTemplateVersion)super.fetchByPrimaryKey(primaryKey);
        }
        DDMTemplateVersion ddmTemplateVersion = null;
        Session session = null;
        try {
            session = this.openSession();
            ddmTemplateVersion = (DDMTemplateVersion)session.get(DDMTemplateVersionImpl.class, primaryKey);
            if (ddmTemplateVersion != null) {
                this.cacheResult(ddmTemplateVersion);
            }
        }
        catch (Exception exception) {
            throw this.processException(exception);
        }
        finally {
            this.closeSession(session);
        }
        return ddmTemplateVersion;
    }

    public DDMTemplateVersion fetchByPrimaryKey(long templateVersionId) {
        return this.fetchByPrimaryKey(Long.valueOf(templateVersionId));
    }

    public Map<Serializable, DDMTemplateVersion> fetchByPrimaryKeys(Set<Serializable> primaryKeys) {
        if (this.ctPersistenceHelper.isProductionMode(DDMTemplateVersion.class)) {
            return super.fetchByPrimaryKeys(primaryKeys);
        }
        if (primaryKeys.isEmpty()) {
            return Collections.emptyMap();
        }
        HashMap<Serializable, DDMTemplateVersion> map = new HashMap<Serializable, DDMTemplateVersion>();
        if (primaryKeys.size() == 1) {
            Iterator<Serializable> iterator = primaryKeys.iterator();
            Serializable primaryKey = iterator.next();
            DDMTemplateVersion ddmTemplateVersion = this.fetchByPrimaryKey(primaryKey);
            if (ddmTemplateVersion != null) {
                map.put(primaryKey, ddmTemplateVersion);
            }
            return map;
        }
        StringBundler sb = new StringBundler(primaryKeys.size() * 2 + 1);
        sb.append(this.getSelectSQL());
        sb.append(" WHERE ");
        sb.append(this.getPKDBName());
        sb.append(" IN (");
        for (Serializable primaryKey : primaryKeys) {
            sb.append(((Long)primaryKey).longValue());
            sb.append(",");
        }
        sb.setIndex(sb.index() - 1);
        sb.append(")");
        String sql = sb.toString();
        Session session = null;
        try {
            session = this.openSession();
            Query query = session.createQuery(sql);
            for (DDMTemplateVersion ddmTemplateVersion : query.list()) {
                map.put(ddmTemplateVersion.getPrimaryKeyObj(), ddmTemplateVersion);
                this.cacheResult(ddmTemplateVersion);
            }
        }
        catch (Exception exception) {
            throw this.processException(exception);
        }
        finally {
            this.closeSession(session);
        }
        return map;
    }

    public List<DDMTemplateVersion> findAll() {
        return this.findAll(-1, -1, null);
    }

    public List<DDMTemplateVersion> findAll(int start, int end) {
        return this.findAll(start, end, null);
    }

    public List<DDMTemplateVersion> findAll(int start, int end, OrderByComparator<DDMTemplateVersion> orderByComparator) {
        return this.findAll(start, end, orderByComparator, true);
    }

    public List<DDMTemplateVersion> findAll(int start, int end, OrderByComparator<DDMTemplateVersion> orderByComparator, boolean useFinderCache) {
        boolean productionMode = this.ctPersistenceHelper.isProductionMode(DDMTemplateVersion.class);
        FinderPath finderPath = null;
        Object[] finderArgs = null;
        if (start == -1 && end == -1 && orderByComparator == null) {
            if (useFinderCache && productionMode) {
                finderPath = this._finderPathWithoutPaginationFindAll;
                finderArgs = FINDER_ARGS_EMPTY;
            }
        } else if (useFinderCache && productionMode) {
            finderPath = this._finderPathWithPaginationFindAll;
            finderArgs = new Object[]{start, end, orderByComparator};
        }
        List list = null;
        if (useFinderCache && productionMode) {
            list = (List)this.finderCache.getResult(finderPath, finderArgs);
        }
        if (list == null) {
            StringBundler sb = null;
            String sql = null;
            if (orderByComparator != null) {
                sb = new StringBundler(2 + orderByComparator.getOrderByFields().length * 2);
                sb.append(_SQL_SELECT_DDMTEMPLATEVERSION);
                this.appendOrderByComparator(sb, _ORDER_BY_ENTITY_ALIAS, orderByComparator);
                sql = sb.toString();
            } else {
                sql = _SQL_SELECT_DDMTEMPLATEVERSION;
                sql = sql.concat(" ORDER BY ddmTemplateVersion.templateVersionId ASC");
            }
            Session session = null;
            try {
                session = this.openSession();
                Query query = session.createQuery(sql);
                list = QueryUtil.list((Query)query, (Dialect)this.getDialect(), (int)start, (int)end);
                this.cacheResult(list);
                if (useFinderCache && productionMode) {
                    this.finderCache.putResult(finderPath, finderArgs, (Object)list);
                }
            }
            catch (Exception exception) {
                throw this.processException(exception);
            }
            finally {
                this.closeSession(session);
            }
        }
        return list;
    }

    public void removeAll() {
        for (DDMTemplateVersion ddmTemplateVersion : this.findAll()) {
            this.remove((BaseModel)ddmTemplateVersion);
        }
    }

    public int countAll() {
        boolean productionMode = this.ctPersistenceHelper.isProductionMode(DDMTemplateVersion.class);
        Long count = null;
        if (productionMode) {
            count = (Long)this.finderCache.getResult(this._finderPathCountAll, FINDER_ARGS_EMPTY);
        }
        if (count == null) {
            Session session = null;
            try {
                session = this.openSession();
                Query query = session.createQuery(_SQL_COUNT_DDMTEMPLATEVERSION);
                count = (Long)query.uniqueResult();
                if (productionMode) {
                    this.finderCache.putResult(this._finderPathCountAll, FINDER_ARGS_EMPTY, (Object)count);
                }
            }
            catch (Exception exception) {
                throw this.processException(exception);
            }
            finally {
                this.closeSession(session);
            }
        }
        return count.intValue();
    }

    protected EntityCache getEntityCache() {
        return this.entityCache;
    }

    protected String getPKDBName() {
        return "templateVersionId";
    }

    protected String getSelectSQL() {
        return _SQL_SELECT_DDMTEMPLATEVERSION;
    }

    public Set<String> getCTColumnNames(CTColumnResolutionType ctColumnResolutionType) {
        return _ctColumnNamesMap.getOrDefault(ctColumnResolutionType, Collections.emptySet());
    }

    public List<String> getMappingTableNames() {
        return _mappingTableNames;
    }

    public Map<String, Integer> getTableColumnsMap() {
        return DDMTemplateVersionModelImpl.TABLE_COLUMNS_MAP;
    }

    public String getTableName() {
        return "DDMTemplateVersion";
    }

    public List<String[]> getUniqueIndexColumnNames() {
        return _uniqueIndexColumnNames;
    }

    @Activate
    public void activate(BundleContext bundleContext) {
        this._bundleContext = bundleContext;
        this._argumentsResolverServiceRegistration = this._bundleContext.registerService(ArgumentsResolver.class, (Object)new DDMTemplateVersionModelArgumentsResolver(), (Dictionary)new HashMapDictionary());
        this._finderPathWithPaginationFindAll = new FinderPath(FINDER_CLASS_NAME_LIST_WITH_PAGINATION, "findAll", new String[0], new String[0], true);
        this._finderPathWithoutPaginationFindAll = new FinderPath(FINDER_CLASS_NAME_LIST_WITHOUT_PAGINATION, "findAll", new String[0], new String[0], true);
        this._finderPathCountAll = new FinderPath(FINDER_CLASS_NAME_LIST_WITHOUT_PAGINATION, "countAll", new String[0], new String[0], false);
        this._finderPathWithPaginationFindByTemplateId = new FinderPath(FINDER_CLASS_NAME_LIST_WITH_PAGINATION, "findByTemplateId", new String[]{Long.class.getName(), Integer.class.getName(), Integer.class.getName(), OrderByComparator.class.getName()}, new String[]{"templateId"}, true);
        this._finderPathWithoutPaginationFindByTemplateId = new FinderPath(FINDER_CLASS_NAME_LIST_WITHOUT_PAGINATION, "findByTemplateId", new String[]{Long.class.getName()}, new String[]{"templateId"}, true);
        this._finderPathCountByTemplateId = new FinderPath(FINDER_CLASS_NAME_LIST_WITHOUT_PAGINATION, "countByTemplateId", new String[]{Long.class.getName()}, new String[]{"templateId"}, false);
        this._finderPathFetchByT_V = new FinderPath(FINDER_CLASS_NAME_ENTITY, "fetchByT_V", new String[]{Long.class.getName(), String.class.getName()}, new String[]{"templateId", "version"}, true);
        this._finderPathCountByT_V = new FinderPath(FINDER_CLASS_NAME_LIST_WITHOUT_PAGINATION, "countByT_V", new String[]{Long.class.getName(), String.class.getName()}, new String[]{"templateId", "version"}, false);
        this._finderPathWithPaginationFindByT_S = new FinderPath(FINDER_CLASS_NAME_LIST_WITH_PAGINATION, "findByT_S", new String[]{Long.class.getName(), Integer.class.getName(), Integer.class.getName(), Integer.class.getName(), OrderByComparator.class.getName()}, new String[]{"templateId", "status"}, true);
        this._finderPathWithoutPaginationFindByT_S = new FinderPath(FINDER_CLASS_NAME_LIST_WITHOUT_PAGINATION, "findByT_S", new String[]{Long.class.getName(), Integer.class.getName()}, new String[]{"templateId", "status"}, true);
        this._finderPathCountByT_S = new FinderPath(FINDER_CLASS_NAME_LIST_WITHOUT_PAGINATION, "countByT_S", new String[]{Long.class.getName(), Integer.class.getName()}, new String[]{"templateId", "status"}, false);
    }

    @Deactivate
    public void deactivate() {
        this.entityCache.removeCache(DDMTemplateVersionImpl.class.getName());
        this._argumentsResolverServiceRegistration.unregister();
    }

    @Reference(target="(&(origin.bundle.symbolic.name=com.liferay.dynamic.data.mapping.service)(name=service))", unbind="-")
    public void setConfiguration(Configuration configuration) {
    }

    @Reference(target="(origin.bundle.symbolic.name=com.liferay.dynamic.data.mapping.service)", unbind="-")
    public void setDataSource(DataSource dataSource) {
        super.setDataSource(dataSource);
    }

    @Reference(target="(origin.bundle.symbolic.name=com.liferay.dynamic.data.mapping.service)", unbind="-")
    public void setSessionFactory(SessionFactory sessionFactory) {
        super.setSessionFactory(sessionFactory);
    }

    protected FinderCache getFinderCache() {
        return this.finderCache;
    }

    static {
        HashSet<String> ctControlColumnNames = new HashSet<String>();
        HashSet<String> ctStrictColumnNames = new HashSet<String>();
        ctControlColumnNames.add("mvccVersion");
        ctControlColumnNames.add("ctCollectionId");
        ctStrictColumnNames.add("groupId");
        ctStrictColumnNames.add("companyId");
        ctStrictColumnNames.add("userId");
        ctStrictColumnNames.add("userName");
        ctStrictColumnNames.add("createDate");
        ctStrictColumnNames.add("classNameId");
        ctStrictColumnNames.add("classPK");
        ctStrictColumnNames.add("templateId");
        ctStrictColumnNames.add("version");
        ctStrictColumnNames.add("name");
        ctStrictColumnNames.add("description");
        ctStrictColumnNames.add("language");
        ctStrictColumnNames.add("script");
        ctStrictColumnNames.add("status");
        ctStrictColumnNames.add("statusByUserId");
        ctStrictColumnNames.add("statusByUserName");
        ctStrictColumnNames.add("statusDate");
        _ctColumnNamesMap.put(CTColumnResolutionType.CONTROL, ctControlColumnNames);
        _ctColumnNamesMap.put(CTColumnResolutionType.PK, Collections.singleton("templateVersionId"));
        _ctColumnNamesMap.put(CTColumnResolutionType.STRICT, ctStrictColumnNames);
        _uniqueIndexColumnNames.add(new String[]{"templateId", "version"});
        _log = LogFactoryUtil.getLog(DDMTemplateVersionPersistenceImpl.class);
    }

    private static class DDMTemplateVersionModelArgumentsResolver
    implements ArgumentsResolver {
        private static final Map<FinderPath, Long> _finderPathColumnBitmasksCache = new ConcurrentHashMap<FinderPath, Long>();

        private DDMTemplateVersionModelArgumentsResolver() {
        }

        public Object[] getArguments(FinderPath finderPath, BaseModel<?> baseModel, boolean checkColumn, boolean original) {
            String[] columnNames = finderPath.getColumnNames();
            if (columnNames == null || columnNames.length == 0) {
                if (baseModel.isNew()) {
                    return FINDER_ARGS_EMPTY;
                }
                return null;
            }
            DDMTemplateVersionModelImpl ddmTemplateVersionModelImpl = (DDMTemplateVersionModelImpl)baseModel;
            long columnBitmask = ddmTemplateVersionModelImpl.getColumnBitmask();
            if (!checkColumn || columnBitmask == 0L) {
                return DDMTemplateVersionModelArgumentsResolver._getValue(ddmTemplateVersionModelImpl, columnNames, original);
            }
            Long finderPathColumnBitmask = _finderPathColumnBitmasksCache.get(finderPath);
            if (finderPathColumnBitmask == null) {
                finderPathColumnBitmask = 0L;
                for (String columnName : columnNames) {
                    finderPathColumnBitmask = finderPathColumnBitmask | DDMTemplateVersionModelImpl.getColumnBitmask(columnName);
                }
                _finderPathColumnBitmasksCache.put(finderPath, finderPathColumnBitmask);
            }
            if ((columnBitmask & finderPathColumnBitmask) != 0L) {
                return DDMTemplateVersionModelArgumentsResolver._getValue(ddmTemplateVersionModelImpl, columnNames, original);
            }
            return null;
        }

        public String getClassName() {
            return DDMTemplateVersionImpl.class.getName();
        }

        public String getTableName() {
            return DDMTemplateVersionTable.INSTANCE.getTableName();
        }

        private static Object[] _getValue(DDMTemplateVersionModelImpl ddmTemplateVersionModelImpl, String[] columnNames, boolean original) {
            Object[] arguments = new Object[columnNames.length];
            for (int i = 0; i < arguments.length; ++i) {
                String columnName = columnNames[i];
                arguments[i] = original ? ddmTemplateVersionModelImpl.getColumnOriginalValue(columnName) : ddmTemplateVersionModelImpl.getColumnValue(columnName);
            }
            return arguments;
        }
    }
}

