/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.dynamic.data.mapping.internal.util;

import com.liferay.dynamic.data.mapping.model.DDMFormField;
import com.liferay.dynamic.data.mapping.model.DDMStructure;
import com.liferay.dynamic.data.mapping.model.Value;
import com.liferay.dynamic.data.mapping.storage.DDMFormFieldValue;
import com.liferay.dynamic.data.mapping.storage.DDMFormValues;
import com.liferay.dynamic.data.mapping.storage.Field;
import com.liferay.dynamic.data.mapping.storage.Fields;
import com.liferay.dynamic.data.mapping.storage.constants.FieldConstants;
import com.liferay.dynamic.data.mapping.util.DDMFormValuesToFieldsConverter;
import com.liferay.petra.string.StringBundler;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.util.ArrayUtil;
import com.liferay.portal.kernel.util.LocaleUtil;
import com.liferay.portal.kernel.util.StringUtil;
import java.io.Serializable;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.osgi.service.component.annotations.Component;

@Component(immediate=true, service={DDMFormValuesToFieldsConverter.class})
public class DDMFormValuesToFieldsConverterImpl
implements DDMFormValuesToFieldsConverter {
    public Fields convert(DDMStructure ddmStructure, DDMFormValues ddmFormValues) throws PortalException {
        Map ddmFormFieldsMap = ddmStructure.getFullHierarchyDDMFormFieldsMap(true);
        List<DDMFormFieldValue> ddmFormFieldValues = this._filterDDMFormFieldValues(ddmFormFieldsMap, ddmFormValues.getDDMFormFieldValues());
        Fields ddmFields = this.createDDMFields(ddmStructure);
        for (DDMFormFieldValue ddmFormFieldValue : ddmFormFieldValues) {
            this._addMissingRepeatedDDMFormFieldValues(ddmFormFieldValue.getDDMFormField(), ddmFormValues.getDefaultLocale(), ddmFormValues.getAvailableLocales(), ddmFormFieldValue, false);
            this.addDDMFields(ddmStructure.getStructureId(), ddmFormFieldsMap, ddmFormFieldValue, ddmFields, ddmFormValues.getDefaultLocale());
        }
        return ddmFields;
    }

    protected void addDDMField(long ddmStructureId, DDMFormField ddmFormField, DDMFormFieldValue ddmFormFieldValue, Fields ddmFields, Locale defaultLocale) throws PortalException {
        if (ddmFormField == null || ddmFormField.isTransient() || ddmFormFieldValue.getValue() == null) {
            return;
        }
        Field ddmField = this.createDDMField(ddmStructureId, ddmFormField, ddmFormFieldValue, defaultLocale);
        Field existingDDMField = ddmFields.get(ddmField.getName());
        if (existingDDMField == null) {
            ddmFields.put(ddmField);
        } else {
            this.addDDMFieldValues(existingDDMField, ddmField);
        }
    }

    protected void addDDMFields(long ddmStructureId, Map<String, DDMFormField> ddmFormFieldsMap, DDMFormFieldValue ddmFormFieldValue, Fields ddmFields, Locale defaultLocale) throws PortalException {
        DDMFormField ddmFormField = ddmFormFieldsMap.get(ddmFormFieldValue.getName());
        this.addDDMField(ddmStructureId, ddmFormField, ddmFormFieldValue, ddmFields, defaultLocale);
        this.addFieldDisplayValue(ddmFields.get("_fieldsDisplay"), this.getFieldDisplayValue(ddmFormFieldValue));
        for (DDMFormFieldValue nestedDDMFormFieldValue : ddmFormFieldValue.getNestedDDMFormFieldValues()) {
            this.addDDMFields(ddmStructureId, ddmFormFieldsMap, nestedDDMFormFieldValue, ddmFields, defaultLocale);
        }
    }

    protected void addDDMFieldValues(Field existingDDMField, Field newDDMField) {
        for (Locale availableLocale : newDDMField.getAvailableLocales()) {
            existingDDMField.addValues(availableLocale, newDDMField.getValues(availableLocale));
        }
    }

    protected void addFieldDisplayValue(Field ddmFieldsDisplayField, String fieldDisplayValue) {
        Object[] fieldsDisplayValues = StringUtil.split((String)((String)((Object)ddmFieldsDisplayField.getValue())));
        fieldsDisplayValues = (String[])ArrayUtil.append((Object[])fieldsDisplayValues, (Object)fieldDisplayValue);
        ddmFieldsDisplayField.setValue((Serializable)((Object)StringUtil.merge((Object[])fieldsDisplayValues)));
    }

    protected Field createDDMField(long ddmStructureId, DDMFormField ddmFormField, DDMFormFieldValue ddmFormFieldValue, Locale defaultLocale) throws PortalException {
        Field ddmField = new Field();
        ddmField.setDDMStructureId(ddmStructureId);
        ddmField.setDefaultLocale(defaultLocale);
        ddmField.setName(ddmFormFieldValue.getName());
        String type = ddmFormField.getDataType();
        this.setDDMFieldValue(ddmField, type, ddmFormFieldValue.getValue(), defaultLocale);
        return ddmField;
    }

    protected Fields createDDMFields(DDMStructure ddmStructure) {
        Fields ddmFields = new Fields();
        Field fieldsDisplayField = new Field(ddmStructure.getStructureId(), "_fieldsDisplay", (Serializable)((Object)""));
        ddmFields.put(fieldsDisplayField);
        return ddmFields;
    }

    protected String getFieldDisplayValue(DDMFormFieldValue ddmFormFieldValue) {
        String fieldName = ddmFormFieldValue.getName();
        return StringBundler.concat((String[])new String[]{fieldName, "_INSTANCE_", ddmFormFieldValue.getInstanceId()});
    }

    protected void setDDMFieldLocalizedValue(Field ddmField, String type, Value value) {
        for (Locale availableLocale : value.getAvailableLocales()) {
            Serializable serializable = FieldConstants.getSerializable((Locale)availableLocale, (Locale)availableLocale, (String)type, (String)value.getString(availableLocale));
            ddmField.addValue(availableLocale, serializable);
        }
    }

    protected void setDDMFieldUnlocalizedValue(Field ddmField, String type, Value value, Locale defaultLocale) {
        Serializable serializable = FieldConstants.getSerializable((Locale)defaultLocale, (Locale)LocaleUtil.ROOT, (String)type, (String)value.getString(LocaleUtil.ROOT));
        ddmField.addValue(defaultLocale, serializable);
    }

    protected void setDDMFieldValue(Field ddmField, String type, Value value, Locale defaultLocale) {
        if (value.isLocalized()) {
            this.setDDMFieldLocalizedValue(ddmField, type, value);
        } else {
            this.setDDMFieldUnlocalizedValue(ddmField, type, value, defaultLocale);
        }
    }

    private void _addMissingRepeatedDDMFormFieldValues(DDMFormField ddmFormField, Locale locale, Set<Locale> availableLocales, DDMFormFieldValue ddmFormFieldValue, boolean repeatableAncestor) throws PortalException {
        if (ddmFormField.isLocalizable() && (ddmFormField.isRepeatable() || repeatableAncestor) && !StringUtil.equals((String)ddmFormField.getType(), (String)"fieldset")) {
            availableLocales.forEach(availableLocale -> {
                Map values;
                Value value;
                if (!locale.equals(availableLocale) && (value = ddmFormFieldValue.getValue()) != null && (values = value.getValues()).get(availableLocale) == null) {
                    value.addString(availableLocale, "_FIELD_EMPTY_VALUE_");
                }
            });
        }
        for (DDMFormFieldValue nestedDDMFormFieldValue : ddmFormFieldValue.getNestedDDMFormFieldValues()) {
            this._addMissingRepeatedDDMFormFieldValues(nestedDDMFormFieldValue.getDDMFormField(), locale, availableLocales, nestedDDMFormFieldValue, repeatableAncestor || ddmFormField.isRepeatable());
        }
    }

    private List<DDMFormFieldValue> _filterDDMFormFieldValues(Map<String, DDMFormField> ddmFormFieldsMap, List<DDMFormFieldValue> ddmFormFieldValues) {
        Stream stream = ddmFormFieldValues.stream();
        return stream.filter(ddmFormFieldValue -> ddmFormFieldsMap.containsKey(ddmFormFieldValue.getName())).peek(ddmFormFieldValue -> {
            List nestedDDMFormFieldValues = ddmFormFieldValue.getNestedDDMFormFieldValues();
            if (!nestedDDMFormFieldValues.isEmpty()) {
                ddmFormFieldValue.setNestedDDMFormFields(this._filterDDMFormFieldValues(ddmFormFieldsMap, nestedDDMFormFieldValues));
            }
        }).collect(Collectors.toList());
    }
}

