/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.dynamic.data.mapping.internal.upgrade.v3_10_2;

import com.liferay.dynamic.data.mapping.internal.upgrade.v3_10_2.util.DDMFormFieldUpgradeProcessUtil;
import com.liferay.dynamic.data.mapping.io.DDMFormDeserializer;
import com.liferay.dynamic.data.mapping.io.DDMFormValuesDeserializer;
import com.liferay.dynamic.data.mapping.io.DDMFormValuesSerializer;
import com.liferay.dynamic.data.mapping.model.DDMForm;
import com.liferay.dynamic.data.mapping.model.DDMFormField;
import com.liferay.dynamic.data.mapping.model.Value;
import com.liferay.dynamic.data.mapping.storage.DDMFormFieldValue;
import com.liferay.dynamic.data.mapping.storage.DDMFormValues;
import com.liferay.dynamic.data.mapping.util.DDMFormDeserializeUtil;
import com.liferay.dynamic.data.mapping.util.DDMFormValuesDeserializeUtil;
import com.liferay.dynamic.data.mapping.util.DDMFormValuesSerializeUtil;
import com.liferay.petra.string.StringBundler;
import com.liferay.portal.kernel.dao.jdbc.AutoBatchPreparedStatementUtil;
import com.liferay.portal.kernel.json.JSONFactory;
import com.liferay.portal.kernel.upgrade.UpgradeProcess;
import com.liferay.portal.kernel.util.StringUtil;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;

public class DDMContentUpgradeProcess
extends UpgradeProcess {
    private final DDMFormDeserializer _ddmFormDeserializer;
    private final DDMFormValuesDeserializer _ddmFormValuesDeserializer;
    private final DDMFormValuesSerializer _ddmFormValuesSerializer;
    private final JSONFactory _jsonFactory;

    public DDMContentUpgradeProcess(DDMFormDeserializer ddmFormDeserializer, DDMFormValuesDeserializer ddmFormValuesDeserializer, DDMFormValuesSerializer ddmFormValuesSerializer, JSONFactory jsonFactory) {
        this._ddmFormDeserializer = ddmFormDeserializer;
        this._ddmFormValuesDeserializer = ddmFormValuesDeserializer;
        this._ddmFormValuesSerializer = ddmFormValuesSerializer;
        this._jsonFactory = jsonFactory;
    }

    protected void doUpgrade() throws Exception {
        try (PreparedStatement selectPreparedStatement = this.connection.prepareStatement(StringBundler.concat((String[])new String[]{"select DDMContent.contentId, DDMContent.data_, ", "DDMStructureVersion.definition from DDMContent inner ", "join DDMFormInstanceRecordVersion on ", "DDMContent.contentId = ", "DDMFormInstanceRecordVersion.storageId inner join ", "DDMFormInstanceVersion on ", "DDMFormInstanceRecordVersion.formInstanceId = ", "DDMFormInstanceVersion.formInstanceId and ", "DDMFormInstanceRecordVersion.formInstanceVersion = ", "DDMFormInstanceVersion.version inner join ", "DDMStructureVersion on ", "DDMFormInstanceVersion.structureVersionId = ", "DDMStructureVersion.structureVersionId"}));
             PreparedStatement updatePreparedStatement = AutoBatchPreparedStatementUtil.concurrentAutoBatch((Connection)this.connection, (String)"update DDMContent set data_ = ? where contentId = ?");
             ResultSet resultSet = selectPreparedStatement.executeQuery();){
            while (resultSet.next()) {
                String newData;
                String data = resultSet.getString("data_");
                if (StringUtil.equals((String)data, (String)(newData = this.upgradeDDMContentData(data, resultSet.getString("definition"))))) continue;
                updatePreparedStatement.setString(1, newData);
                updatePreparedStatement.setLong(2, resultSet.getLong("contentId"));
                updatePreparedStatement.addBatch();
            }
            updatePreparedStatement.executeBatch();
        }
    }

    protected String upgradeDDMContentData(String data, String definition) throws Exception {
        DDMForm ddmForm = DDMFormDeserializeUtil.deserialize((DDMFormDeserializer)this._ddmFormDeserializer, (String)definition);
        Map ddmFormFieldsMap = ddmForm.getDDMFormFieldsMap(true);
        DDMFormValues ddmFormValues = DDMFormValuesDeserializeUtil.deserialize((String)data, (DDMForm)ddmForm, (DDMFormValuesDeserializer)this._ddmFormValuesDeserializer);
        this._normalizeDDMFormFieldValues(ddmFormFieldsMap, ddmFormValues.getDDMFormFieldValues());
        return DDMFormValuesSerializeUtil.serialize((DDMFormValues)ddmFormValues, (DDMFormValuesSerializer)this._ddmFormValuesSerializer);
    }

    private void _normalizeDDMFormFieldValue(Value value) throws Exception {
        if (value == null) {
            return;
        }
        HashSet availableLocales = new HashSet(value.getAvailableLocales());
        for (Locale availableLocale : availableLocales) {
            String valueString = value.getString(availableLocale);
            if (valueString.startsWith("[") && valueString.endsWith("]")) {
                value.addString(availableLocale, String.valueOf(DDMFormFieldUpgradeProcessUtil.getNormalizedJSONArray(this._jsonFactory.createJSONArray(valueString))));
                continue;
            }
            value.addString(availableLocale, DDMFormFieldUpgradeProcessUtil.getNormalizedName(valueString));
        }
    }

    private void _normalizeDDMFormFieldValues(Map<String, DDMFormField> ddmFormFieldsMap, List<DDMFormFieldValue> ddmFormFieldValues) throws Exception {
        for (DDMFormFieldValue ddmFormFieldValue : ddmFormFieldValues) {
            ddmFormFieldValue.setFieldReference(DDMFormFieldUpgradeProcessUtil.getNormalizedName(ddmFormFieldValue.getFieldReference()));
            String ddmFormFieldValueName = ddmFormFieldValue.getName();
            ddmFormFieldValue.setName(DDMFormFieldUpgradeProcessUtil.getNormalizedName(ddmFormFieldValueName));
            DDMFormField ddmFormField = ddmFormFieldsMap.get(ddmFormFieldValueName);
            if (DDMFormFieldUpgradeProcessUtil.isDDMFormFieldWithOptions(ddmFormField.getType())) {
                this._normalizeDDMFormFieldValue(ddmFormFieldValue.getValue());
            }
            this._normalizeDDMFormFieldValues(ddmFormFieldsMap, ddmFormFieldValue.getNestedDDMFormFieldValues());
        }
    }
}

