/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.dynamic.data.mapping.internal.util;

import com.liferay.dynamic.data.mapping.model.DDMForm;
import com.liferay.dynamic.data.mapping.model.DDMFormField;
import com.liferay.dynamic.data.mapping.model.DDMStructure;
import com.liferay.dynamic.data.mapping.model.LocalizedValue;
import com.liferay.dynamic.data.mapping.model.Value;
import com.liferay.dynamic.data.mapping.storage.DDMFormFieldValue;
import com.liferay.dynamic.data.mapping.storage.DDMFormValues;
import com.liferay.dynamic.data.mapping.util.DDMFormValuesToMapConverter;
import com.liferay.petra.string.StringBundler;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.json.JSONArray;
import com.liferay.portal.kernel.json.JSONException;
import com.liferay.portal.kernel.json.JSONFactoryUtil;
import com.liferay.portal.kernel.json.JSONUtil;
import com.liferay.portal.kernel.language.LanguageUtil;
import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.kernel.util.ListUtil;
import com.liferay.portal.kernel.util.StringUtil;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.osgi.service.component.annotations.Component;

@Component(immediate=true, service={DDMFormValuesToMapConverter.class})
public class DDMFormValuesToMapConverterImpl
implements DDMFormValuesToMapConverter {
    public Map<String, Object> convert(DDMFormValues ddmFormValues, DDMStructure ddmStructure) throws PortalException {
        if (ddmFormValues == null) {
            return Collections.emptyMap();
        }
        DDMForm ddmForm = ddmStructure.getDDMForm();
        this._addMissingDDMFormFieldValues(ddmForm.getDDMFormFields(), ddmFormValues);
        Map ddmFormFields = ddmStructure.getFullHierarchyDDMFormFieldsMap(true);
        LinkedHashMap<String, Object> values = new LinkedHashMap<String, Object>(ddmFormFields.size());
        for (DDMFormFieldValue ddmFormFieldValue : ddmFormValues.getDDMFormFieldValues()) {
            if (!ddmFormFields.containsKey(ddmFormFieldValue.getName())) continue;
            this._addValues(ddmFormFields, ddmFormFieldValue, values);
        }
        return values;
    }

    private void _addMissingDDMFormFieldValues(List<DDMFormField> ddmFormFields, DDMFormValues ddmFormValues) {
        Map ddmFormFieldValues = ddmFormValues.getDDMFormFieldValuesMap(false);
        for (final DDMFormField ddmFormField : ddmFormFields) {
            if (ddmFormFieldValues.containsKey(ddmFormField.getName()) || GetterUtil.getBoolean((Object)ddmFormField.getProperty("upgradedStructure"))) continue;
            DDMFormFieldValue ddmFormFieldValue = new DDMFormFieldValue(){
                {
                    this.setInstanceId(StringUtil.randomString());
                    this.setName(ddmFormField.getName());
                }
            };
            ddmFormValues.addDDMFormFieldValue(ddmFormFieldValue);
            if (!ListUtil.isNotEmpty((List)ddmFormField.getNestedDDMFormFields())) continue;
            this._addMissingDDMFormFieldValues(ddmFormField.getNestedDDMFormFields(), ddmFormFieldValues, ddmFormFieldValue);
        }
    }

    private void _addMissingDDMFormFieldValues(List<DDMFormField> ddmFormFields, Map<String, List<DDMFormFieldValue>> ddmFormFieldValues, DDMFormFieldValue parentDDMFormFieldValue) {
        for (final DDMFormField ddmFormField : ddmFormFields) {
            if (ddmFormFieldValues.containsKey(ddmFormField.getName())) continue;
            DDMFormFieldValue ddmFormFieldValue = new DDMFormFieldValue(){
                {
                    this.setInstanceId(StringUtil.randomString());
                    this.setName(ddmFormField.getName());
                }
            };
            parentDDMFormFieldValue.addNestedDDMFormFieldValue(ddmFormFieldValue);
            if (!ListUtil.isNotEmpty((List)ddmFormField.getNestedDDMFormFields())) continue;
            this._addMissingDDMFormFieldValues(ddmFormField.getNestedDDMFormFields(), ddmFormFieldValues, ddmFormFieldValue);
        }
    }

    private void _addValue(DDMFormField ddmFormField, DDMFormFieldValue ddmFormFieldValue, Map<String, Object> values) {
        if (ddmFormField == null) {
            return;
        }
        Value value = ddmFormFieldValue.getValue();
        if (value == null) {
            return;
        }
        if (ddmFormField.isLocalizable()) {
            values.put("value", this._toLocalizedMap(ddmFormField.getType(), (LocalizedValue)value));
        } else {
            values.put("value", value.getString(value.getDefaultLocale()));
        }
    }

    private void _addValues(Map<String, DDMFormField> ddmFormFields, DDMFormFieldValue ddmFormFieldValue, Map<String, Object> values) {
        Map fieldInstanceValue = (Map)values.computeIfAbsent(this._getDDMFormFieldValueInstanceKey(ddmFormFieldValue), k -> new LinkedHashMap());
        DDMFormField ddmFormField = ddmFormFields.get(ddmFormFieldValue.getName());
        if (ddmFormField == null) {
            return;
        }
        if (!Objects.equals(ddmFormField.getType(), "fieldset")) {
            this._addValue(ddmFormField, ddmFormFieldValue, fieldInstanceValue);
        }
        if (ListUtil.isNotEmpty((List)ddmFormFieldValue.getNestedDDMFormFieldValues())) {
            Map nestedFieldInstanceValues = (Map)fieldInstanceValue.computeIfAbsent("nestedValues", k -> new LinkedHashMap());
            for (DDMFormFieldValue nestedDDMFormFieldValue : ddmFormFieldValue.getNestedDDMFormFieldValues()) {
                this._addValues(ddmFormFields, nestedDDMFormFieldValue, nestedFieldInstanceValues);
            }
        }
    }

    private String _getDDMFormFieldValueInstanceKey(DDMFormFieldValue ddmFormFieldValue) {
        return StringBundler.concat((String[])new String[]{ddmFormFieldValue.getName(), "_INSTANCE_", ddmFormFieldValue.getInstanceId()});
    }

    private Map<String, Object> _toLocalizedMap(String fieldType, LocalizedValue localizedValue) {
        Set availableLocales = localizedValue.getAvailableLocales();
        Stream stream = availableLocales.stream();
        if (fieldType.equals("checkbox_multiple") || fieldType.equals("select")) {
            return stream.collect(Collectors.toMap(LanguageUtil::getLanguageId, locale -> this._toStringList((Locale)locale, localizedValue)));
        }
        return stream.collect(Collectors.toMap(LanguageUtil::getLanguageId, locale -> GetterUtil.getString((String)localizedValue.getString(locale))));
    }

    private List<String> _toStringList(Locale locale, LocalizedValue localizedValue) {
        try {
            return JSONUtil.toStringList((JSONArray)JSONFactoryUtil.createJSONArray((String)localizedValue.getString(locale)));
        }
        catch (JSONException jsonException) {
            return Collections.emptyList();
        }
    }
}

