/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.dynamic.data.mapping.internal.upgrade.v3_7_3;

import com.liferay.dynamic.data.mapping.internal.report.CheckboxMultipleDDMFormFieldTypeReportProcessor;
import com.liferay.dynamic.data.mapping.internal.report.NumericDDMFormFieldTypeReportProcessor;
import com.liferay.dynamic.data.mapping.internal.report.RadioDDMFormFieldTypeReportProcessor;
import com.liferay.dynamic.data.mapping.internal.report.TextDDMFormFieldTypeReportProcessor;
import com.liferay.dynamic.data.mapping.io.DDMFormDeserializer;
import com.liferay.dynamic.data.mapping.model.DDMForm;
import com.liferay.dynamic.data.mapping.model.DDMFormField;
import com.liferay.dynamic.data.mapping.model.DDMFormFieldOptions;
import com.liferay.dynamic.data.mapping.model.LocalizedValue;
import com.liferay.dynamic.data.mapping.model.UnlocalizedValue;
import com.liferay.dynamic.data.mapping.model.Value;
import com.liferay.dynamic.data.mapping.report.DDMFormFieldTypeReportProcessor;
import com.liferay.dynamic.data.mapping.storage.DDMFormFieldValue;
import com.liferay.dynamic.data.mapping.storage.DDMFormValues;
import com.liferay.dynamic.data.mapping.util.DDMFormDeserializeUtil;
import com.liferay.portal.kernel.dao.jdbc.AutoBatchPreparedStatementUtil;
import com.liferay.portal.kernel.json.JSONArray;
import com.liferay.portal.kernel.json.JSONException;
import com.liferay.portal.kernel.json.JSONFactory;
import com.liferay.portal.kernel.json.JSONFactoryUtil;
import com.liferay.portal.kernel.json.JSONObject;
import com.liferay.portal.kernel.json.JSONUtil;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.upgrade.UpgradeProcess;
import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.kernel.util.LocaleUtil;
import com.liferay.portal.kernel.util.StringBundler;
import com.liferay.portal.kernel.util.StringUtil;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.Set;

public class DDMFormInstanceReportUpgradeProcess
extends UpgradeProcess {
    private static final Log _log = LogFactoryUtil.getLog(DDMFormInstanceReportUpgradeProcess.class);
    private final DDMFormDeserializer _ddmFormDeserializer;
    private final DDMFormFieldTypeReportProcessorTracker _ddmFormFieldTypeReportProcessorTracker = new DDMFormFieldTypeReportProcessorTracker();
    private final JSONFactory _jsonFactory;

    public DDMFormInstanceReportUpgradeProcess(DDMFormDeserializer ddmFormDeserializer, JSONFactory jsonFactory) {
        this._ddmFormDeserializer = ddmFormDeserializer;
        this._jsonFactory = jsonFactory;
    }

    protected void doUpgrade() throws Exception {
        this.runSQL("delete from DDMFormInstanceReport;");
        StringBundler sb1 = new StringBundler(21);
        sb1.append("select DDMContent.data_, ");
        sb1.append("DDMFormInstanceRecord.formInstanceRecordId, ");
        sb1.append("DDMStructureVersion.definition from DDMContent inner ");
        sb1.append("join DDMFormInstanceRecordVersion on ");
        sb1.append("DDMContent.contentId = ");
        sb1.append("DDMFormInstanceRecordVersion.storageId inner join ");
        sb1.append("DDMFormInstanceRecord on ");
        sb1.append("DDMFormInstanceRecord.formInstanceRecordId = ");
        sb1.append("DDMFormInstanceRecordVersion.formInstanceRecordId inner ");
        sb1.append("join DDMFormInstanceVersion on ");
        sb1.append("DDMFormInstanceVersion.formInstanceId = ");
        sb1.append("DDMFormInstanceRecordVersion.formInstanceId and ");
        sb1.append("DDMFormInstanceVersion.version = ");
        sb1.append("DDMFormInstanceRecordVersion.formInstanceVersion inner ");
        sb1.append("join DDMStructureVersion on ");
        sb1.append("DDMStructureVersion.structureVersionId = ");
        sb1.append("DDMFormInstanceVersion.structureVersionId where ");
        sb1.append("DDMFormInstanceRecord.version = ");
        sb1.append("DDMFormInstanceRecordVersion.version and ");
        sb1.append("DDMFormInstanceRecord.formInstanceId = ? and ");
        sb1.append("DDMFormInstanceRecordVersion.status = ?");
        StringBundler sb2 = new StringBundler(3);
        sb2.append("insert into DDMFormInstanceReport (formInstanceReportId, ");
        sb2.append("groupId, companyId, createDate, modifiedDate, ");
        sb2.append("formInstanceId, data_) values (?, ?, ?, ?, ?, ?, ?)");
        try (PreparedStatement preparedStatement1 = this.connection.prepareStatement("select formInstanceId, groupId, companyId, createDate from DDMFormInstance");){
            ResultSet resultSet1 = preparedStatement1.executeQuery();
            while (resultSet1.next()) {
                long formInstanceId = resultSet1.getLong("formInstanceId");
                JSONObject dataJSONObject = this._jsonFactory.createJSONObject();
                try (PreparedStatement preparedStatement2 = this.connection.prepareStatement(sb1.toString());){
                    preparedStatement2.setLong(1, formInstanceId);
                    preparedStatement2.setInt(2, 0);
                    ResultSet resultSet2 = preparedStatement2.executeQuery();
                    while (resultSet2.next()) {
                        dataJSONObject = this._processDDMFormValues(dataJSONObject, this._getDDMFormValues(resultSet2.getString("data_"), DDMFormDeserializeUtil.deserialize((DDMFormDeserializer)this._ddmFormDeserializer, (String)resultSet2.getString("definition"))), resultSet2.getLong("formInstanceRecordId"));
                        dataJSONObject.put("totalItems", dataJSONObject.getInt("totalItems") + 1);
                    }
                }
                long groupId = resultSet1.getLong("groupId");
                long companyId = resultSet1.getLong("companyId");
                Timestamp createDate = resultSet1.getTimestamp("createDate");
                PreparedStatement preparedStatement3 = AutoBatchPreparedStatementUtil.concurrentAutoBatch((Connection)this.connection, (String)sb2.toString());
                Throwable throwable = null;
                try {
                    preparedStatement3.setLong(1, this.increment());
                    preparedStatement3.setLong(2, groupId);
                    preparedStatement3.setLong(3, companyId);
                    preparedStatement3.setTimestamp(4, createDate);
                    preparedStatement3.setTimestamp(5, createDate);
                    preparedStatement3.setLong(6, formInstanceId);
                    preparedStatement3.setString(7, dataJSONObject.toString());
                    preparedStatement3.execute();
                }
                catch (Throwable throwable2) {
                    throwable = throwable2;
                    throw throwable2;
                }
                finally {
                    if (preparedStatement3 == null) continue;
                    if (throwable != null) {
                        try {
                            preparedStatement3.close();
                        }
                        catch (Throwable throwable3) {
                            throwable.addSuppressed(throwable3);
                        }
                        continue;
                    }
                    preparedStatement3.close();
                }
            }
        }
    }

    private DDMFormValues _getDDMFormValues(String data, DDMForm ddmForm) throws Exception {
        DDMFormValues ddmFormValues = new DDMFormValues(ddmForm);
        ArrayList<DDMFormFieldValue> ddmFormFieldValues = new ArrayList<DDMFormFieldValue>();
        JSONObject dataJSONObject = this._jsonFactory.createJSONObject(data);
        JSONArray fieldValuesJSONArray = dataJSONObject.getJSONArray("fieldValues");
        for (JSONObject jsonObject : fieldValuesJSONArray) {
            DDMFormFieldValue ddmFormFieldValue = new DDMFormFieldValue();
            ddmFormFieldValue.setDDMFormValues(ddmFormValues);
            ddmFormFieldValue.setInstanceId(jsonObject.getString("instanceId"));
            ddmFormFieldValue.setName(jsonObject.getString("name"));
            DDMFormField ddmFormField = ddmFormFieldValue.getDDMFormField();
            if (ddmFormField == null) continue;
            LocalizedValue value = null;
            if (ddmFormField.isLocalizable()) {
                value = new LocalizedValue();
                JSONObject valueJSONObject = jsonObject.getJSONObject("value");
                if (valueJSONObject == null) continue;
                for (String languageId : valueJSONObject.keySet()) {
                    value.addString(LocaleUtil.fromLanguageId((String)languageId), GetterUtil.getString((String)valueJSONObject.getString(languageId)));
                }
            } else {
                value = new UnlocalizedValue(GetterUtil.getString((Object)jsonObject.get("value")));
            }
            ddmFormFieldValue.setValue((Value)value);
            ddmFormFieldValues.add(ddmFormFieldValue);
        }
        ddmFormValues.setDDMFormFieldValues(ddmFormFieldValues);
        return ddmFormValues;
    }

    private JSONObject _processDDMFormValues(JSONObject dataJSONObject, DDMFormValues ddmFormValues, long formInstanceRecordId) throws Exception {
        for (DDMFormFieldValue ddmFormFieldValue : ddmFormValues.getDDMFormFieldValues()) {
            DDMFormFieldTypeReportProcessor ddmFormFieldTypeReportProcessor = this._ddmFormFieldTypeReportProcessorTracker.getDDMFormFieldTypeReportProcessor(ddmFormFieldValue.getDDMFormField(), ddmFormFieldValue.getType());
            if (ddmFormFieldTypeReportProcessor == null) continue;
            String ddmFormFieldValueName = ddmFormFieldValue.getName();
            JSONObject fieldJSONObject = dataJSONObject.getJSONObject(ddmFormFieldValueName);
            if (fieldJSONObject == null) {
                fieldJSONObject = JSONUtil.put((String)"type", (Object)ddmFormFieldValue.getType()).put("values", this._jsonFactory.createJSONObject());
            }
            try {
                JSONObject processedFieldJSONObject = ddmFormFieldTypeReportProcessor.process(ddmFormFieldValue, this._jsonFactory.createJSONObject(fieldJSONObject.toJSONString()), formInstanceRecordId, "add");
                dataJSONObject.put(ddmFormFieldValueName, processedFieldJSONObject);
            }
            catch (JSONException jsonException) {
                if (!_log.isWarnEnabled()) continue;
                _log.warn((Object)jsonException, (Throwable)jsonException);
            }
        }
        return dataJSONObject;
    }

    private class UpgradeGridDDMFormFieldTypeReportProcessor
    implements DDMFormFieldTypeReportProcessor {
        private final DDMFormField _ddmFormField;

        public UpgradeGridDDMFormFieldTypeReportProcessor(DDMFormField ddmFormField) {
            this._ddmFormField = ddmFormField;
        }

        public JSONObject process(DDMFormFieldValue ddmFormFieldValue, JSONObject fieldJSONObject, long formInstanceRecordId, String ddmFormInstanceReportEvent) throws Exception {
            JSONObject valuesJSONObject = fieldJSONObject.getJSONObject("values");
            Value value = ddmFormFieldValue.getValue();
            JSONObject valueJSONObject = JSONFactoryUtil.createJSONObject((String)value.getString(value.getDefaultLocale()));
            Iterator iterator = valueJSONObject.keys();
            while (iterator.hasNext()) {
                String rowName = (String)iterator.next();
                JSONObject rowJSONObject = valuesJSONObject.getJSONObject(rowName);
                if (rowJSONObject == null) {
                    rowJSONObject = JSONFactoryUtil.createJSONObject();
                }
                String columnName = valueJSONObject.getString(rowName);
                rowJSONObject.put(columnName, rowJSONObject.getInt(columnName) + 1);
                valuesJSONObject.put(rowName, rowJSONObject);
            }
            int totalEntries = fieldJSONObject.getInt("totalEntries");
            if (valueJSONObject.length() != 0) {
                ++totalEntries;
            }
            fieldJSONObject.put("structure", JSONUtil.put((String)"columns", (Object)this._getOptionValuesJSONArray("columns")).put("rows", this._getOptionValuesJSONArray("rows"))).put("totalEntries", totalEntries);
            return fieldJSONObject;
        }

        private JSONArray _getOptionValuesJSONArray(String propertyName) {
            JSONArray jsonArray = JSONFactoryUtil.createJSONArray();
            DDMFormFieldOptions ddmFormFieldOptions = (DDMFormFieldOptions)this._ddmFormField.getProperty(propertyName);
            if (ddmFormFieldOptions != null) {
                Set optionsValues = ddmFormFieldOptions.getOptionsValues();
                optionsValues.forEach(optionValue -> jsonArray.put(optionValue));
            }
            return jsonArray;
        }
    }

    private class DDMFormFieldTypeReportProcessorTracker {
        private DDMFormFieldTypeReportProcessorTracker() {
        }

        public DDMFormFieldTypeReportProcessor getDDMFormFieldTypeReportProcessor(DDMFormField ddmFormField, String type) {
            if (StringUtil.equals((String)type, (String)"checkbox_multiple") || StringUtil.equals((String)type, (String)"select")) {
                return new CheckboxMultipleDDMFormFieldTypeReportProcessor();
            }
            if (StringUtil.equals((String)type, (String)"color") || StringUtil.equals((String)type, (String)"date") || StringUtil.equals((String)type, (String)"text")) {
                return new TextDDMFormFieldTypeReportProcessor();
            }
            if (StringUtil.equals((String)type, (String)"grid")) {
                return new UpgradeGridDDMFormFieldTypeReportProcessor(ddmFormField);
            }
            if (StringUtil.equals((String)type, (String)"numeric")) {
                return new NumericDDMFormFieldTypeReportProcessor();
            }
            if (StringUtil.equals((String)type, (String)"radio")) {
                return new RadioDDMFormFieldTypeReportProcessor();
            }
            return null;
        }
    }
}

