/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.dynamic.data.mapping.internal.upgrade.v3_2_3;

import com.liferay.portal.kernel.dao.jdbc.AutoBatchPreparedStatementUtil;
import com.liferay.portal.kernel.json.JSONArray;
import com.liferay.portal.kernel.json.JSONFactory;
import com.liferay.portal.kernel.json.JSONObject;
import com.liferay.portal.kernel.upgrade.UpgradeProcess;
import com.liferay.portal.kernel.util.PortalUtil;
import com.liferay.portal.kernel.util.StringUtil;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class DDMFormFieldValidationUpgradeProcess
extends UpgradeProcess {
    private final JSONFactory _jsonFactory;

    public DDMFormFieldValidationUpgradeProcess(JSONFactory jsonFactory) {
        this._jsonFactory = jsonFactory;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected void doUpgrade() throws Exception {
        try (PreparedStatement preparedStatement1 = this.connection.prepareStatement("select structureId, definition from DDMStructure where classNameId = ? ");
             PreparedStatement preparedStatement2 = AutoBatchPreparedStatementUtil.concurrentAutoBatch((Connection)this.connection, (String)"update DDMStructure set definition = ? where structureId = ?");
             PreparedStatement preparedStatement3 = this.connection.prepareStatement("select structureVersionId, definition from DDMStructureVersion where structureId = ?");
             PreparedStatement preparedStatement4 = AutoBatchPreparedStatementUtil.concurrentAutoBatch((Connection)this.connection, (String)"update DDMStructureVersion set definition = ? where structureVersionId = ?");){
            preparedStatement1.setLong(1, PortalUtil.getClassNameId((String)"com.liferay.dynamic.data.mapping.model.DDMFormInstance"));
            try (ResultSet resultSet = preparedStatement1.executeQuery();){
                while (resultSet.next()) {
                    ResultSet resultSet2;
                    block72: {
                        long structureId = resultSet.getLong("structureId");
                        String definition = resultSet.getString("definition");
                        JSONObject jsonObject1 = this._jsonFactory.createJSONObject(definition);
                        if (this._upgradeValidation(jsonObject1.getJSONArray("fields"))) {
                            preparedStatement2.setString(1, jsonObject1.toJSONString());
                            preparedStatement2.setLong(2, structureId);
                            preparedStatement2.addBatch();
                        }
                        preparedStatement3.setLong(1, structureId);
                        resultSet2 = preparedStatement3.executeQuery();
                        Throwable throwable = null;
                        try {
                            while (resultSet2.next()) {
                                definition = resultSet2.getString("definition");
                                JSONObject jsonObject2 = this._jsonFactory.createJSONObject(definition);
                                if (!this._upgradeValidation(jsonObject2.getJSONArray("fields"))) continue;
                                preparedStatement4.setString(1, jsonObject2.toJSONString());
                                long structureVersionId = resultSet2.getLong("structureVersionId");
                                preparedStatement4.setLong(2, structureVersionId);
                                preparedStatement4.addBatch();
                            }
                            if (resultSet2 == null) continue;
                            if (throwable == null) break block72;
                        }
                        catch (Throwable throwable2) {
                            try {
                                throwable = throwable2;
                                throw throwable2;
                            }
                            catch (Throwable throwable3) {
                                if (resultSet2 == null) throw throwable3;
                                if (throwable == null) {
                                    resultSet2.close();
                                    throw throwable3;
                                }
                                try {
                                    resultSet2.close();
                                    throw throwable3;
                                }
                                catch (Throwable throwable4) {
                                    throwable.addSuppressed(throwable4);
                                    throw throwable3;
                                }
                            }
                        }
                        try {
                            resultSet2.close();
                            continue;
                        }
                        catch (Throwable throwable5) {
                            throwable.addSuppressed(throwable5);
                            continue;
                        }
                    }
                    resultSet2.close();
                }
            }
            preparedStatement2.executeBatch();
            preparedStatement4.executeBatch();
            return;
        }
    }

    private String _replaceFieldName(String expression, String fieldName, String regex) {
        Pattern pattern = Pattern.compile(regex);
        Matcher matcher = pattern.matcher(expression);
        matcher.find();
        String oldFieldName = matcher.group(1);
        return StringUtil.replace((String)expression, (String)oldFieldName, (String)fieldName);
    }

    private String _upgradeExpression(String expression, String fieldName) {
        if (expression.matches("NOT\\(contains\\((.+), \"(.*)\"\\)\\)")) {
            expression = this._replaceFieldName(expression, fieldName, "NOT\\(contains\\((.+), \"(.*)\"\\)\\)");
        } else if (expression.matches("contains\\((.+), \"(.*)\"\\)")) {
            expression = this._replaceFieldName(expression, fieldName, "contains\\((.+), \"(.*)\"\\)");
        } else if (expression.matches("isURL\\((.+)\\)")) {
            expression = this._replaceFieldName(expression, fieldName, "isURL\\((.+)\\)");
        } else if (expression.matches("isEmailAddress\\((.+)\\)")) {
            expression = this._replaceFieldName(expression, fieldName, "isEmailAddress\\((.+)\\)");
        } else if (expression.matches("match\\((.+), \"(.*)\"\\)")) {
            expression = this._replaceFieldName(expression, fieldName, "match\\((.+), \"(.*)\"\\)");
        } else if (expression.matches("(.+)<(\\d+\\.?\\d*)?")) {
            expression = this._replaceFieldName(expression, fieldName, "(.+)<(\\d+\\.?\\d*)?");
        } else if (expression.matches("(.+)<=(\\d+\\.?\\d*)?")) {
            expression = this._replaceFieldName(expression, fieldName, "(.+)<=(\\d+\\.?\\d*)?");
        } else if (expression.matches("(.+)==(\\d+\\.?\\d*)?")) {
            expression = this._replaceFieldName(expression, fieldName, "(.+)==(\\d+\\.?\\d*)?");
        } else if (expression.matches("(.+)>(\\d+\\.?\\d*)?")) {
            expression = this._replaceFieldName(expression, fieldName, "(.+)>(\\d+\\.?\\d*)?");
        } else if (expression.matches("(.+)>=(\\d+\\.?\\d*)?")) {
            expression = this._replaceFieldName(expression, fieldName, "(.+)>=(\\d+\\.?\\d*)?");
        }
        return expression;
    }

    private boolean _upgradeValidation(JSONArray fieldsJSONArray) {
        boolean upgraded = false;
        for (int i = 0; i < fieldsJSONArray.length(); ++i) {
            JSONArray nestedFieldsJSONArray;
            JSONObject jsonObject = fieldsJSONArray.getJSONObject(i);
            JSONObject validationJSONObject = jsonObject.getJSONObject("validation");
            if (validationJSONObject != null) {
                JSONObject expressionJSONObject = validationJSONObject.getJSONObject("expression");
                String value = expressionJSONObject.getString("value");
                String upgradedValue = this._upgradeExpression(value, jsonObject.getString("name"));
                expressionJSONObject.put("value", upgradedValue);
                boolean bl = upgraded = upgraded || !StringUtil.equals((String)value, (String)upgradedValue);
            }
            if ((nestedFieldsJSONArray = jsonObject.getJSONArray("nestedFields")) == null) continue;
            upgraded = this._upgradeValidation(nestedFieldsJSONArray) || upgraded;
        }
        return upgraded;
    }
}

