/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.dynamic.data.mapping.internal.upgrade.v2_0_3;

import com.liferay.portal.kernel.dao.jdbc.AutoBatchPreparedStatementUtil;
import com.liferay.portal.kernel.json.JSONArray;
import com.liferay.portal.kernel.json.JSONFactory;
import com.liferay.portal.kernel.json.JSONObject;
import com.liferay.portal.kernel.upgrade.UpgradeProcess;
import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.portal.kernel.util.Validator;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.util.Objects;

public class DDMFormInstanceSettingsUpgradeProcess
extends UpgradeProcess {
    private final JSONFactory _jsonFactory;

    public DDMFormInstanceSettingsUpgradeProcess(JSONFactory jsonFactory) {
        this._jsonFactory = jsonFactory;
    }

    protected String addNewSetting(JSONObject settingsJSONObject, String propertyName, String value) {
        JSONArray fieldValuesJSONArray = settingsJSONObject.getJSONArray("fieldValues");
        JSONObject settingJSONObject = this.createSettingJSONObject(propertyName, value);
        fieldValuesJSONArray.put(settingJSONObject);
        settingsJSONObject.put("fieldValues", fieldValuesJSONArray);
        return settingsJSONObject.toJSONString();
    }

    protected void convertToJSONArrayValue(JSONObject fieldJSONObject, String defaultValue) {
        JSONArray valueJSONArray = this._jsonFactory.createJSONArray();
        valueJSONArray.put(fieldJSONObject.getString("value", defaultValue));
        fieldJSONObject.put("value", valueJSONArray);
    }

    protected JSONObject createSettingJSONObject(String propertyName, String value) {
        JSONObject settingJSONObject = this._jsonFactory.createJSONObject();
        settingJSONObject.put("instanceId", StringUtil.randomString()).put("name", propertyName).put("value", value);
        return settingJSONObject;
    }

    protected void doUpgrade() throws Exception {
        String sql = "select formInstanceId, settings_ from DDMFormInstance";
        try (PreparedStatement preparedStatement1 = this.connection.prepareStatement(sql);
             ResultSet resultSet = preparedStatement1.executeQuery();
             PreparedStatement preparedStatement2 = AutoBatchPreparedStatementUtil.concurrentAutoBatch((Connection)this.connection, (String)"update DDMFormInstance set settings_ = ? where formInstanceId = ?");){
            while (resultSet.next()) {
                String settings = resultSet.getString("settings_");
                if (!Validator.isNotNull((String)settings)) continue;
                JSONObject settingsJSONObject = this._jsonFactory.createJSONObject(settings);
                this.addNewSetting(settingsJSONObject, "autosaveEnabled", "true");
                this.addNewSetting(settingsJSONObject, "requireAuthentication", "false");
                this.updateSettings(settingsJSONObject);
                preparedStatement2.setString(1, settingsJSONObject.toJSONString());
                preparedStatement2.setLong(2, resultSet.getLong("formInstanceId"));
                preparedStatement2.addBatch();
            }
            preparedStatement2.executeBatch();
        }
    }

    protected JSONObject getFieldValueJSONObject(String fieldName, JSONArray fieldValuesJSONArray) {
        for (int i = 0; i < fieldValuesJSONArray.length(); ++i) {
            JSONObject jsonObject = fieldValuesJSONArray.getJSONObject(i);
            if (!Objects.equals(jsonObject.getString("name"), fieldName)) continue;
            return jsonObject;
        }
        return this._jsonFactory.createJSONObject();
    }

    protected void updateSettings(JSONObject settingsJSONObject) {
        JSONArray fieldValuesJSONArray = settingsJSONObject.getJSONArray("fieldValues");
        this.convertToJSONArrayValue(this.getFieldValueJSONObject("storageType", fieldValuesJSONArray), "json");
        this.convertToJSONArrayValue(this.getFieldValueJSONObject("workflowDefinition", fieldValuesJSONArray), "no-workflow");
    }
}

