/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.dynamic.data.mapping.internal.io;

import com.liferay.dynamic.data.mapping.form.field.type.DDMFormFieldTypeServicesTracker;
import com.liferay.dynamic.data.mapping.internal.io.DDMFormRuleJSONDeserializer;
import com.liferay.dynamic.data.mapping.internal.io.util.DDMFormFieldDeserializerUtil;
import com.liferay.dynamic.data.mapping.io.DDMFormLayoutDeserializer;
import com.liferay.dynamic.data.mapping.io.DDMFormLayoutDeserializerDeserializeRequest;
import com.liferay.dynamic.data.mapping.io.DDMFormLayoutDeserializerDeserializeResponse;
import com.liferay.dynamic.data.mapping.model.DDMFormLayout;
import com.liferay.dynamic.data.mapping.model.DDMFormLayoutColumn;
import com.liferay.dynamic.data.mapping.model.DDMFormLayoutPage;
import com.liferay.dynamic.data.mapping.model.DDMFormLayoutRow;
import com.liferay.dynamic.data.mapping.model.LocalizedValue;
import com.liferay.dynamic.data.mapping.util.LocalizedValueUtil;
import com.liferay.portal.kernel.json.JSONArray;
import com.liferay.portal.kernel.json.JSONFactory;
import com.liferay.portal.kernel.json.JSONFactoryUtil;
import com.liferay.portal.kernel.json.JSONObject;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.util.LocaleUtil;
import com.liferay.portal.kernel.util.Validator;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component(immediate=true, property={"ddm.form.layout.deserializer.type=json"}, service={DDMFormLayoutDeserializer.class})
public class DDMFormLayoutJSONDeserializer
implements DDMFormLayoutDeserializer {
    private static final Log _log = LogFactoryUtil.getLog(DDMFormLayoutJSONDeserializer.class);
    private DDMFormFieldTypeServicesTracker _ddmFormFieldTypeServicesTracker;
    private JSONFactory _jsonFactory;

    public DDMFormLayoutDeserializerDeserializeResponse deserialize(DDMFormLayoutDeserializerDeserializeRequest ddmFormLayoutDeserializerDeserializeRequest) {
        DDMFormLayout ddmFormLayout = new DDMFormLayout();
        DDMFormLayoutDeserializerDeserializeResponse.Builder builder = DDMFormLayoutDeserializerDeserializeResponse.Builder.newBuilder((DDMFormLayout)ddmFormLayout);
        try {
            JSONObject jsonObject = this._jsonFactory.createJSONObject(ddmFormLayoutDeserializerDeserializeRequest.getContent());
            ddmFormLayout.setDDMFormFields(DDMFormFieldDeserializerUtil.deserialize(this._ddmFormFieldTypeServicesTracker, Optional.ofNullable(jsonObject.getJSONArray("fields")).orElse(JSONFactoryUtil.createJSONArray()), this._jsonFactory));
            if (Validator.isNotNull((String)jsonObject.getString("definitionSchemaVersion"))) {
                ddmFormLayout.setDefinitionSchemaVersion(jsonObject.getString("definitionSchemaVersion"));
            }
            this.setDDMFormLayoutDefaultLocale(jsonObject.getString("defaultLanguageId"), ddmFormLayout);
            this.setDDMFormLayoutPages(jsonObject.getJSONArray("pages"), ddmFormLayout);
            this.setDDMFormLayoutPageTitlesDefaultLocale(ddmFormLayout);
            String paginationMode = jsonObject.getString("paginationMode");
            if (Validator.isNotNull((String)paginationMode)) {
                this.setDDMFormLayoutPaginationMode(paginationMode, ddmFormLayout);
            } else {
                this.setDDMFormLayoutPaginationMode("wizard", ddmFormLayout);
            }
            DDMFormLayoutJSONDeserializer.setDDMFormRules(jsonObject.getJSONArray("rules"), ddmFormLayout);
            return builder.build();
        }
        catch (Exception exception) {
            if (_log.isWarnEnabled()) {
                _log.warn((Object)exception, (Throwable)exception);
            }
            builder = builder.exception(exception);
            return builder.build();
        }
    }

    protected static void setDDMFormRules(JSONArray jsonArray, DDMFormLayout ddmFormLayout) {
        if (jsonArray == null || jsonArray.length() == 0) {
            return;
        }
        ddmFormLayout.setDDMFormRules(DDMFormRuleJSONDeserializer.deserialize(jsonArray));
    }

    protected DDMFormLayoutColumn getDDMFormLayoutColumn(JSONObject jsonObject) {
        DDMFormLayoutColumn ddmFormLayoutColumn = new DDMFormLayoutColumn(jsonObject.getInt("size"), new String[0]);
        this.setDDMFormLayouColumnFieldNames(jsonObject.getJSONArray("fieldNames"), ddmFormLayoutColumn);
        return ddmFormLayoutColumn;
    }

    protected List<String> getDDMFormLayoutColumnFieldNames(JSONArray jsonArray) {
        ArrayList<String> ddmFormFieldNames = new ArrayList<String>();
        for (int i = 0; i < jsonArray.length(); ++i) {
            ddmFormFieldNames.add(jsonArray.getString(i));
        }
        return ddmFormFieldNames;
    }

    protected List<DDMFormLayoutColumn> getDDMFormLayoutColumns(JSONArray jsonArray) {
        ArrayList<DDMFormLayoutColumn> ddmFormLayoutColumns = new ArrayList<DDMFormLayoutColumn>();
        for (int i = 0; i < jsonArray.length(); ++i) {
            DDMFormLayoutColumn ddmFormLayoutColumn = this.getDDMFormLayoutColumn(jsonArray.getJSONObject(i));
            ddmFormLayoutColumns.add(ddmFormLayoutColumn);
        }
        return ddmFormLayoutColumns;
    }

    protected DDMFormLayoutPage getDDMFormLayoutPage(JSONObject jsonObject) {
        DDMFormLayoutPage ddmFormLayoutPage = new DDMFormLayoutPage();
        this.setDDMFormLayoutPageDescription(jsonObject.getJSONObject("description"), ddmFormLayoutPage);
        this.setDDMFormLayoutPageRows(jsonObject.getJSONArray("rows"), ddmFormLayoutPage);
        this.setDDMFormLayoutPageTitle(jsonObject.getJSONObject("title"), ddmFormLayoutPage);
        return ddmFormLayoutPage;
    }

    protected List<DDMFormLayoutPage> getDDMFormLayoutPages(JSONArray jsonArray) {
        ArrayList<DDMFormLayoutPage> ddmFormLayoutPages = new ArrayList<DDMFormLayoutPage>();
        for (int i = 0; i < jsonArray.length(); ++i) {
            DDMFormLayoutPage ddmFormLayoutPage = this.getDDMFormLayoutPage(jsonArray.getJSONObject(i));
            ddmFormLayoutPages.add(ddmFormLayoutPage);
        }
        return ddmFormLayoutPages;
    }

    protected DDMFormLayoutRow getDDMFormLayoutRow(JSONObject jsonObject) {
        DDMFormLayoutRow ddmFormLayoutRow = new DDMFormLayoutRow();
        this.setDDMFormLayoutRowColumns(jsonObject.getJSONArray("columns"), ddmFormLayoutRow);
        return ddmFormLayoutRow;
    }

    protected List<DDMFormLayoutRow> getDDMFormLayoutRows(JSONArray jsonArray) {
        ArrayList<DDMFormLayoutRow> ddmFormLayoutRows = new ArrayList<DDMFormLayoutRow>();
        for (int i = 0; i < jsonArray.length(); ++i) {
            DDMFormLayoutRow ddmFormLayoutRow = this.getDDMFormLayoutRow(jsonArray.getJSONObject(i));
            ddmFormLayoutRows.add(ddmFormLayoutRow);
        }
        return ddmFormLayoutRows;
    }

    @Reference(unbind="-")
    protected void setDDMFormFieldTypeServicesTracker(DDMFormFieldTypeServicesTracker ddmFormFieldTypeServicesTracker) {
        this._ddmFormFieldTypeServicesTracker = ddmFormFieldTypeServicesTracker;
    }

    protected void setDDMFormLayouColumnFieldNames(JSONArray jsonArray, DDMFormLayoutColumn ddmFormLayoutColumn) {
        List<String> ddmFormLayoutColumnNames = this.getDDMFormLayoutColumnFieldNames(jsonArray);
        ddmFormLayoutColumn.setDDMFormFieldNames(ddmFormLayoutColumnNames);
    }

    protected void setDDMFormLayoutDefaultLocale(String defaultLanguageId, DDMFormLayout ddmFormLayout) {
        ddmFormLayout.setDefaultLocale(LocaleUtil.fromLanguageId((String)defaultLanguageId));
    }

    protected void setDDMFormLayoutPageDescription(JSONObject jsonObject, DDMFormLayoutPage ddmFormLayoutPage) {
        LocalizedValue description = LocalizedValueUtil.toLocalizedValue((JSONObject)jsonObject);
        if (description == null) {
            return;
        }
        ddmFormLayoutPage.setDescription(description);
    }

    protected void setDDMFormLayoutPageRows(JSONArray jsonArray, DDMFormLayoutPage ddmFormLayoutPage) {
        ddmFormLayoutPage.setDDMFormLayoutRows(this.getDDMFormLayoutRows(jsonArray));
    }

    protected void setDDMFormLayoutPages(JSONArray jsonArray, DDMFormLayout ddmFormLayout) {
        ddmFormLayout.setDDMFormLayoutPages(this.getDDMFormLayoutPages(jsonArray));
    }

    protected void setDDMFormLayoutPageTitle(JSONObject jsonObject, DDMFormLayoutPage ddmFormLayoutPage) {
        LocalizedValue title = LocalizedValueUtil.toLocalizedValue((JSONObject)jsonObject);
        if (title == null) {
            return;
        }
        ddmFormLayoutPage.setTitle(title);
    }

    protected void setDDMFormLayoutPageTitlesDefaultLocale(DDMFormLayout ddmFormLayout) {
        for (DDMFormLayoutPage ddmFormLayoutPage : ddmFormLayout.getDDMFormLayoutPages()) {
            LocalizedValue title = ddmFormLayoutPage.getTitle();
            title.setDefaultLocale(ddmFormLayout.getDefaultLocale());
        }
    }

    protected void setDDMFormLayoutPaginationMode(String paginationMode, DDMFormLayout ddmFormLayout) {
        ddmFormLayout.setPaginationMode(paginationMode);
    }

    protected void setDDMFormLayoutRowColumns(JSONArray jsonArray, DDMFormLayoutRow ddmFormLayoutRow) {
        ddmFormLayoutRow.setDDMFormLayoutColumns(this.getDDMFormLayoutColumns(jsonArray));
    }

    @Reference(unbind="-")
    protected void setJSONFactory(JSONFactory jsonFactory) {
        this._jsonFactory = jsonFactory;
    }
}

