/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.dynamic.data.mapping.internal.security.permission.resource;

import com.liferay.dynamic.data.mapping.model.DDMStructure;
import com.liferay.dynamic.data.mapping.security.permission.DDMPermissionSupport;
import com.liferay.dynamic.data.mapping.service.DDMStructureLocalService;
import com.liferay.exportimport.kernel.staging.permission.StagingPermission;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.portlet.PortletProvider;
import com.liferay.portal.kernel.portlet.PortletProviderUtil;
import com.liferay.portal.kernel.security.auth.PrincipalException;
import com.liferay.portal.kernel.security.permission.PermissionChecker;
import com.liferay.portal.kernel.security.permission.resource.ModelResourcePermission;
import com.liferay.portal.kernel.security.permission.resource.PortletResourcePermission;
import com.liferay.portal.kernel.util.Validator;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component(immediate=true, property={"model.class.name=com.liferay.dynamic.data.mapping.model.DDMStructure"}, service={ModelResourcePermission.class})
public class DDMStructureModelResourcePermission
implements ModelResourcePermission<DDMStructure> {
    @Reference
    private DDMPermissionSupport _ddmPermissionSupport;
    @Reference
    private DDMStructureLocalService _ddmStructureLocalService;
    @Reference
    private StagingPermission _stagingPermission;

    public void check(PermissionChecker permissionChecker, DDMStructure structure, String actionId) throws PortalException {
        if (!this.contains(permissionChecker, structure, actionId)) {
            throw new PrincipalException.MustHavePermission(permissionChecker, this._ddmPermissionSupport.getStructureModelResourceName(structure.getClassName()), structure.getStructureId(), new String[]{actionId});
        }
    }

    public void check(PermissionChecker permissionChecker, long primaryKey, String actionId) throws PortalException {
        DDMStructure structure = this._ddmStructureLocalService.getDDMStructure(primaryKey);
        this.check(permissionChecker, structure, actionId);
    }

    public boolean contains(PermissionChecker permissionChecker, DDMStructure structure, String actionId) throws PortalException {
        Boolean hasPermission;
        String structureModelResourceName = this._ddmPermissionSupport.getStructureModelResourceName(structure.getClassName());
        String portletId = PortletProviderUtil.getPortletId((String)structure.getClassName(), (PortletProvider.Action)PortletProvider.Action.EDIT);
        if (Validator.isNotNull((String)portletId) && (hasPermission = this._stagingPermission.hasPermission(permissionChecker, structure.getGroupId(), structureModelResourceName, structure.getStructureId(), portletId, actionId)) != null) {
            return hasPermission;
        }
        if (permissionChecker.hasOwnerPermission(structure.getCompanyId(), structureModelResourceName, structure.getStructureId(), structure.getUserId(), actionId)) {
            return true;
        }
        return permissionChecker.hasPermission(structure.getGroupId(), structureModelResourceName, structure.getStructureId(), actionId);
    }

    public boolean contains(PermissionChecker permissionChecker, long primaryKey, String actionId) throws PortalException {
        DDMStructure structure = this._ddmStructureLocalService.getDDMStructure(primaryKey);
        return this.contains(permissionChecker, structure, actionId);
    }

    public String getModelName() {
        return DDMStructure.class.getName();
    }

    public PortletResourcePermission getPortletResourcePermission() {
        return null;
    }
}

