/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.dynamic.data.mapping.internal.upgrade.v2_0_1;

import com.liferay.portal.kernel.dao.jdbc.AutoBatchPreparedStatementUtil;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.json.JSONArray;
import com.liferay.portal.kernel.json.JSONFactory;
import com.liferay.portal.kernel.json.JSONObject;
import com.liferay.portal.kernel.upgrade.UpgradeProcess;
import com.liferay.portal.kernel.util.PortalUtil;
import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.portal.kernel.util.Validator;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;

public class UpgradeDDMFormFieldValidation
extends UpgradeProcess {
    private final JSONFactory _jsonFactory;

    public UpgradeDDMFormFieldValidation(JSONFactory jsonFactory) {
        this._jsonFactory = jsonFactory;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected void doUpgrade() throws Exception {
        try (PreparedStatement ps1 = this.connection.prepareStatement("select structureId, definition from DDMStructure where classNameId = ? ");
             PreparedStatement ps2 = AutoBatchPreparedStatementUtil.concurrentAutoBatch((Connection)this.connection, (String)"update DDMStructure set definition = ? where structureId = ?");
             PreparedStatement ps3 = this.connection.prepareStatement("select structureVersionId, definition from DDMStructureVersion where structureId = ?");
             PreparedStatement ps4 = AutoBatchPreparedStatementUtil.concurrentAutoBatch((Connection)this.connection, (String)"update DDMStructureVersion set definition = ? where structureVersionId = ?");){
            ps1.setLong(1, PortalUtil.getClassNameId((String)"com.liferay.dynamic.data.mapping.model.DDMFormInstance"));
            try (ResultSet rs = ps1.executeQuery();){
                while (rs.next()) {
                    ResultSet rs2;
                    block71: {
                        String definition = rs.getString("definition");
                        ps2.setString(1, this.updateValidation(definition));
                        long structureId = rs.getLong("structureId");
                        ps2.setLong(2, structureId);
                        ps2.addBatch();
                        ps3.setLong(1, structureId);
                        rs2 = ps3.executeQuery();
                        Throwable throwable = null;
                        try {
                            while (rs2.next()) {
                                definition = rs2.getString("definition");
                                ps4.setString(1, this.updateValidation(definition));
                                long structureVersionId = rs2.getLong("structureVersionId");
                                ps4.setLong(2, structureVersionId);
                                ps4.addBatch();
                            }
                            if (rs2 == null) continue;
                            if (throwable == null) break block71;
                        }
                        catch (Throwable throwable2) {
                            try {
                                throwable = throwable2;
                                throw throwable2;
                            }
                            catch (Throwable throwable3) {
                                if (rs2 == null) throw throwable3;
                                if (throwable == null) {
                                    rs2.close();
                                    throw throwable3;
                                }
                                try {
                                    rs2.close();
                                    throw throwable3;
                                }
                                catch (Throwable throwable4) {
                                    throwable.addSuppressed(throwable4);
                                    throw throwable3;
                                }
                            }
                        }
                        try {
                            rs2.close();
                            continue;
                        }
                        catch (Throwable throwable5) {
                            throwable.addSuppressed(throwable5);
                            continue;
                        }
                    }
                    rs2.close();
                }
            }
            ps2.executeBatch();
            ps4.executeBatch();
            return;
        }
    }

    protected String updateValidation(String definition) throws PortalException {
        JSONObject definitionJSONObject = this._jsonFactory.createJSONObject(definition);
        JSONArray fieldsJSONArray = definitionJSONObject.getJSONArray("fields");
        for (int i = 0; i < fieldsJSONArray.length(); ++i) {
            JSONObject fieldJSONObject = fieldsJSONArray.getJSONObject(i);
            if (!fieldJSONObject.has("validation")) continue;
            JSONObject validationJSONObject = fieldJSONObject.getJSONObject("validation");
            if (validationJSONObject == null) {
                fieldJSONObject.remove("validation");
                continue;
            }
            JSONObject expressionJSONObject = validationJSONObject.getJSONObject("expression");
            String expressionValue = expressionJSONObject.getString("value");
            if (Validator.isNull((String)expressionValue)) {
                fieldJSONObject.remove("validation");
                continue;
            }
            if (Validator.isNotNull((String)expressionJSONObject.getString("name"))) continue;
            expressionJSONObject.put("name", this._getExpressionName(expressionValue));
            String parameterValue = this._getParameterValueFromExpression(expressionValue);
            this._addParameterValue(parameterValue, validationJSONObject, definitionJSONObject.getString("defaultLanguageId"));
            if (!Validator.isNotNull((String)parameterValue)) continue;
            expressionJSONObject.put("value", StringUtil.replace((String)expressionValue, (String)parameterValue, (String)"{parameter}"));
        }
        return definitionJSONObject.toString();
    }

    private void _addParameterValue(String value, JSONObject validationJSONObject, String defaultLanguageId) {
        JSONObject parameterJSONObject = validationJSONObject.getJSONObject("parameter");
        if (!parameterJSONObject.has(defaultLanguageId)) {
            parameterJSONObject.put(defaultLanguageId, value);
        }
    }

    private String _getExpressionName(String expressionValue) {
        String name = "";
        if (expressionValue.startsWith("contains")) {
            name = "contains";
        } else if (expressionValue.startsWith("NOT(contains")) {
            name = "notContains";
        } else if (expressionValue.startsWith("isEmailAddress")) {
            name = "email";
        } else if (expressionValue.startsWith("match")) {
            name = "regularExpression";
        } else if (expressionValue.startsWith("isURL")) {
            name = "url";
        }
        return name;
    }

    private String _getParameterValueFromExpression(String expressionValue) {
        String[] parts = expressionValue.split("\"");
        if (parts.length > 1) {
            return parts[1];
        }
        return "";
    }
}

