/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.dynamic.data.mapping.internal.upgrade.v1_1_1;

import com.liferay.petra.string.StringBundler;
import com.liferay.portal.kernel.dao.jdbc.AutoBatchPreparedStatementUtil;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.json.JSONArray;
import com.liferay.portal.kernel.json.JSONException;
import com.liferay.portal.kernel.json.JSONFactory;
import com.liferay.portal.kernel.json.JSONObject;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.upgrade.UpgradeProcess;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;

public class UpgradeDDMStructureIndexType
extends UpgradeProcess {
    private static final Log _log = LogFactoryUtil.getLog(UpgradeDDMStructureIndexType.class);
    private final JSONFactory _jsonFactory;

    public UpgradeDDMStructureIndexType(JSONFactory jsonFactory) {
        this._jsonFactory = jsonFactory;
    }

    protected void doUpgrade() throws Exception {
        this._upgradeDDMStructureDefinition();
    }

    private void _upgradeDDMStructureDefinition() throws Exception {
        StringBundler sb = new StringBundler(2);
        sb.append("select DDMStructure.definition, DDMStructure.structureId ");
        sb.append("from DDMStructure where structureKey = ? ");
        try (PreparedStatement ps1 = this.connection.prepareStatement(sb.toString());
             PreparedStatement ps2 = AutoBatchPreparedStatementUtil.concurrentAutoBatch((Connection)this.connection, (String)"update DDMStructure set definition = ? where structureId = ?");
             PreparedStatement ps3 = AutoBatchPreparedStatementUtil.concurrentAutoBatch((Connection)this.connection, (String)"update DDMStructureVersion set definition = ? where structureId = ?");){
            ps1.setString(1, "TIKARAWMETADATA");
            try (ResultSet rs = ps1.executeQuery();){
                while (rs.next()) {
                    String newDefinition = this._upgradeIndexType(rs.getString(1));
                    ps2.setString(1, newDefinition);
                    ps2.setLong(2, rs.getLong(2));
                    ps2.addBatch();
                    ps3.setString(1, newDefinition);
                    ps3.setLong(2, rs.getLong(2));
                    ps3.addBatch();
                }
                ps2.executeBatch();
                ps3.executeBatch();
            }
        }
    }

    private String _upgradeIndexType(String definition) throws PortalException {
        try {
            JSONObject definitionJSONObject = this._jsonFactory.createJSONObject(definition);
            JSONArray fieldsJSONArray = definitionJSONObject.getJSONArray("fields");
            for (int i = 0; i < fieldsJSONArray.length(); ++i) {
                JSONObject jsonObject = fieldsJSONArray.getJSONObject(i);
                if (jsonObject.has("indexType")) continue;
                jsonObject.put("indexType", "text");
            }
            return definitionJSONObject.toString();
        }
        catch (JSONException jsonException) {
            if (_log.isDebugEnabled()) {
                _log.debug((Throwable)jsonException);
            }
            return definition;
        }
    }
}

