/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.dynamic.data.mapping.internal.upgrade.v3_9_1;

import com.liferay.dynamic.data.mapping.io.DDMFormDeserializer;
import com.liferay.dynamic.data.mapping.io.DDMFormSerializer;
import com.liferay.dynamic.data.mapping.model.DDMForm;
import com.liferay.dynamic.data.mapping.model.DDMFormField;
import com.liferay.dynamic.data.mapping.model.DDMFormFieldOptions;
import com.liferay.dynamic.data.mapping.model.DDMFormInstance;
import com.liferay.dynamic.data.mapping.util.DDMFormDeserializeUtil;
import com.liferay.dynamic.data.mapping.util.DDMFormSerializeUtil;
import com.liferay.petra.string.StringBundler;
import com.liferay.portal.kernel.dao.jdbc.AutoBatchPreparedStatementUtil;
import com.liferay.portal.kernel.upgrade.UpgradeProcess;
import com.liferay.portal.kernel.util.PortalUtil;
import com.liferay.portal.kernel.util.StringUtil;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.util.List;
import java.util.Set;

public class UpgradeDDMStructure
extends UpgradeProcess {
    private final DDMFormDeserializer _ddmFormDeserializer;
    private final DDMFormSerializer _ddmFormSerializer;

    public UpgradeDDMStructure(DDMFormDeserializer ddmFormDeserializer, DDMFormSerializer ddmFormSerializer) {
        this._ddmFormDeserializer = ddmFormDeserializer;
        this._ddmFormSerializer = ddmFormSerializer;
    }

    protected void doUpgrade() throws Exception {
        this._upgradeDDMStructureVersion();
        this._upgradeDDMStructure();
    }

    private void _updateDDMFormFieldOptionsReferences(DDMFormFieldOptions ddmFormFieldOptions) {
        if (ddmFormFieldOptions == null) {
            return;
        }
        Set ddmFormFieldOptionsValues = ddmFormFieldOptions.getOptionsValues();
        ddmFormFieldOptionsValues.forEach(ddmFormFieldOptionsValue -> ddmFormFieldOptions.addOptionReference(ddmFormFieldOptionsValue, ddmFormFieldOptionsValue));
    }

    private void _updateDDMFormFieldReference(DDMFormField ddmFormField) {
        ddmFormField.setFieldReference(ddmFormField.getName());
        if (!StringUtil.equals((String)ddmFormField.getType(), (String)"fieldset")) {
            this._updateDDMFormFieldOptionsReferences(ddmFormField.getDDMFormFieldOptions());
            this._updateDDMFormFieldOptionsReferences((DDMFormFieldOptions)ddmFormField.getProperty("columns"));
            this._updateDDMFormFieldOptionsReferences((DDMFormFieldOptions)ddmFormField.getProperty("rows"));
        }
        List nestedDDMFormFields = ddmFormField.getNestedDDMFormFields();
        nestedDDMFormFields.forEach(nestedDDMFormField -> this._updateDDMFormFieldReference((DDMFormField)nestedDDMFormField));
    }

    private void _upgradeDDMStructure() throws Exception {
        StringBundler sb = new StringBundler(6);
        sb.append("select DDMStructure.structureId, ");
        sb.append("DDMStructureVersion.definition from DDMStructure inner ");
        sb.append("join DDMStructureVersion on DDMStructure.structureId = ");
        sb.append("DDMStructureVersion.structureId where ");
        sb.append("DDMStructure.version = DDMStructureVersion.version and ");
        sb.append("DDMStructure.classNameId = ?");
        try (PreparedStatement ps1 = this.connection.prepareStatement(sb.toString());
             PreparedStatement ps2 = AutoBatchPreparedStatementUtil.concurrentAutoBatch((Connection)this.connection, (String)"update DDMStructure set definition = ? where structureId = ?");){
            ps1.setLong(1, PortalUtil.getClassNameId((String)DDMFormInstance.class.getName()));
            try (ResultSet rs = ps1.executeQuery();){
                while (rs.next()) {
                    String definition = rs.getString("definition");
                    ps2.setString(1, definition);
                    long structureId = rs.getLong("structureId");
                    ps2.setLong(2, structureId);
                    ps2.addBatch();
                }
                ps2.executeBatch();
            }
        }
    }

    private void _upgradeDDMStructureVersion() throws Exception {
        StringBundler sb = new StringBundler(5);
        sb.append("select DDMStructureVersion.structureVersionId, ");
        sb.append("DDMStructureVersion.definition from DDMStructure inner ");
        sb.append("join DDMStructureVersion on DDMStructure.structureId = ");
        sb.append("DDMStructureVersion.structureId where ");
        sb.append("DDMStructure.classNameId = ?");
        try (PreparedStatement ps1 = this.connection.prepareStatement(sb.toString());
             PreparedStatement ps2 = AutoBatchPreparedStatementUtil.concurrentAutoBatch((Connection)this.connection, (String)"update DDMStructureVersion set definition = ? where structureVersionId = ?");){
            ps1.setLong(1, PortalUtil.getClassNameId((String)DDMFormInstance.class.getName()));
            try (ResultSet rs = ps1.executeQuery();){
                while (rs.next()) {
                    long structureVersionId = rs.getLong("structureVersionId");
                    ps2.setString(1, this._upgradeDDMStructureVersionDefinition(rs.getString("definition")));
                    ps2.setLong(2, structureVersionId);
                    ps2.addBatch();
                }
                ps2.executeBatch();
            }
        }
    }

    private String _upgradeDDMStructureVersionDefinition(String definition) throws Exception {
        DDMForm ddmForm = DDMFormDeserializeUtil.deserialize((DDMFormDeserializer)this._ddmFormDeserializer, (String)definition);
        List ddmFormFields = ddmForm.getDDMFormFields();
        ddmFormFields.forEach(ddmFormField -> this._updateDDMFormFieldReference((DDMFormField)ddmFormField));
        return DDMFormSerializeUtil.serialize((DDMForm)ddmForm, (DDMFormSerializer)this._ddmFormSerializer);
    }
}

