/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.dynamic.data.mapping.service.persistence.impl;

import com.liferay.dynamic.data.mapping.exception.NoSuchStructureVersionException;
import com.liferay.dynamic.data.mapping.model.DDMStructureVersion;
import com.liferay.dynamic.data.mapping.model.DDMStructureVersionTable;
import com.liferay.dynamic.data.mapping.model.impl.DDMStructureVersionImpl;
import com.liferay.dynamic.data.mapping.model.impl.DDMStructureVersionModelImpl;
import com.liferay.dynamic.data.mapping.service.persistence.DDMStructureVersionPersistence;
import com.liferay.dynamic.data.mapping.service.persistence.DDMStructureVersionUtil;
import com.liferay.petra.sql.dsl.Table;
import com.liferay.petra.string.StringBundler;
import com.liferay.portal.kernel.change.tracking.CTColumnResolutionType;
import com.liferay.portal.kernel.configuration.Configuration;
import com.liferay.portal.kernel.dao.orm.ArgumentsResolver;
import com.liferay.portal.kernel.dao.orm.Dialect;
import com.liferay.portal.kernel.dao.orm.EntityCache;
import com.liferay.portal.kernel.dao.orm.FinderCache;
import com.liferay.portal.kernel.dao.orm.FinderPath;
import com.liferay.portal.kernel.dao.orm.Query;
import com.liferay.portal.kernel.dao.orm.QueryPos;
import com.liferay.portal.kernel.dao.orm.QueryUtil;
import com.liferay.portal.kernel.dao.orm.Session;
import com.liferay.portal.kernel.dao.orm.SessionFactory;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.model.BaseModel;
import com.liferay.portal.kernel.model.change.tracking.CTModel;
import com.liferay.portal.kernel.security.auth.CompanyThreadLocal;
import com.liferay.portal.kernel.service.ServiceContext;
import com.liferay.portal.kernel.service.ServiceContextThreadLocal;
import com.liferay.portal.kernel.service.persistence.change.tracking.helper.CTPersistenceHelper;
import com.liferay.portal.kernel.service.persistence.impl.BasePersistenceImpl;
import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.kernel.util.MapUtil;
import com.liferay.portal.kernel.util.OrderByComparator;
import com.liferay.portal.kernel.util.PropsUtil;
import com.liferay.portal.kernel.util.ProxyUtil;
import com.liferay.portal.kernel.util.SetUtil;
import java.io.Serializable;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationHandler;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.EnumMap;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import javax.sql.DataSource;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceRegistration;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Deactivate;
import org.osgi.service.component.annotations.Reference;

@Component(service={DDMStructureVersionPersistence.class})
public class DDMStructureVersionPersistenceImpl
extends BasePersistenceImpl<DDMStructureVersion>
implements DDMStructureVersionPersistence {
    public static final String FINDER_CLASS_NAME_ENTITY = DDMStructureVersionImpl.class.getName();
    public static final String FINDER_CLASS_NAME_LIST_WITH_PAGINATION = FINDER_CLASS_NAME_ENTITY + ".List1";
    public static final String FINDER_CLASS_NAME_LIST_WITHOUT_PAGINATION = FINDER_CLASS_NAME_ENTITY + ".List2";
    private FinderPath _finderPathWithPaginationFindAll;
    private FinderPath _finderPathWithoutPaginationFindAll;
    private FinderPath _finderPathCountAll;
    private FinderPath _finderPathWithPaginationFindByStructureId;
    private FinderPath _finderPathWithoutPaginationFindByStructureId;
    private FinderPath _finderPathCountByStructureId;
    private static final String _FINDER_COLUMN_STRUCTUREID_STRUCTUREID_2 = "ddmStructureVersion.structureId = ?";
    private FinderPath _finderPathFetchByS_V;
    private FinderPath _finderPathCountByS_V;
    private static final String _FINDER_COLUMN_S_V_STRUCTUREID_2 = "ddmStructureVersion.structureId = ? AND ";
    private static final String _FINDER_COLUMN_S_V_VERSION_2 = "ddmStructureVersion.version = ?";
    private static final String _FINDER_COLUMN_S_V_VERSION_3 = "(ddmStructureVersion.version IS NULL OR ddmStructureVersion.version = '')";
    private FinderPath _finderPathWithPaginationFindByS_S;
    private FinderPath _finderPathWithoutPaginationFindByS_S;
    private FinderPath _finderPathCountByS_S;
    private static final String _FINDER_COLUMN_S_S_STRUCTUREID_2 = "ddmStructureVersion.structureId = ? AND ";
    private static final String _FINDER_COLUMN_S_S_STATUS_2 = "ddmStructureVersion.status = ?";
    private int _valueObjectFinderCacheListThreshold;
    private static final Map<CTColumnResolutionType, Set<String>> _ctColumnNamesMap = new EnumMap<CTColumnResolutionType, Set<String>>(CTColumnResolutionType.class);
    private static final List<String> _mappingTableNames = new ArrayList<String>();
    private static final List<String[]> _uniqueIndexColumnNames = new ArrayList<String[]>();
    private BundleContext _bundleContext;
    @Reference
    protected CTPersistenceHelper ctPersistenceHelper;
    @Reference
    protected EntityCache entityCache;
    @Reference
    protected FinderCache finderCache;
    private static final String _SQL_SELECT_DDMSTRUCTUREVERSION = "SELECT ddmStructureVersion FROM DDMStructureVersion ddmStructureVersion";
    private static final String _SQL_SELECT_DDMSTRUCTUREVERSION_WHERE = "SELECT ddmStructureVersion FROM DDMStructureVersion ddmStructureVersion WHERE ";
    private static final String _SQL_COUNT_DDMSTRUCTUREVERSION = "SELECT COUNT(ddmStructureVersion) FROM DDMStructureVersion ddmStructureVersion";
    private static final String _SQL_COUNT_DDMSTRUCTUREVERSION_WHERE = "SELECT COUNT(ddmStructureVersion) FROM DDMStructureVersion ddmStructureVersion WHERE ";
    private static final String _ORDER_BY_ENTITY_ALIAS = "ddmStructureVersion.";
    private static final String _NO_SUCH_ENTITY_WITH_PRIMARY_KEY = "No DDMStructureVersion exists with the primary key ";
    private static final String _NO_SUCH_ENTITY_WITH_KEY = "No DDMStructureVersion exists with the key {";
    private static final Log _log;
    private static final Set<String> _badColumnNames;
    private Set<ServiceRegistration<FinderPath>> _serviceRegistrations = new HashSet<ServiceRegistration<FinderPath>>();
    private ServiceRegistration<ArgumentsResolver> _argumentsResolverServiceRegistration;

    public List<DDMStructureVersion> findByStructureId(long structureId) {
        return this.findByStructureId(structureId, -1, -1, null);
    }

    public List<DDMStructureVersion> findByStructureId(long structureId, int start, int end) {
        return this.findByStructureId(structureId, start, end, null);
    }

    public List<DDMStructureVersion> findByStructureId(long structureId, int start, int end, OrderByComparator<DDMStructureVersion> orderByComparator) {
        return this.findByStructureId(structureId, start, end, orderByComparator, true);
    }

    public List<DDMStructureVersion> findByStructureId(long structureId, int start, int end, OrderByComparator<DDMStructureVersion> orderByComparator, boolean useFinderCache) {
        boolean productionMode = this.ctPersistenceHelper.isProductionMode(DDMStructureVersion.class);
        FinderPath finderPath = null;
        Object[] finderArgs = null;
        if (start == -1 && end == -1 && orderByComparator == null) {
            if (useFinderCache && productionMode) {
                finderPath = this._finderPathWithoutPaginationFindByStructureId;
                finderArgs = new Object[]{structureId};
            }
        } else if (useFinderCache && productionMode) {
            finderPath = this._finderPathWithPaginationFindByStructureId;
            finderArgs = new Object[]{structureId, start, end, orderByComparator};
        }
        List list = null;
        if (useFinderCache && productionMode && (list = (List)this.finderCache.getResult(finderPath, finderArgs, (BasePersistenceImpl)this)) != null && !list.isEmpty()) {
            for (DDMStructureVersion ddmStructureVersion : list) {
                if (structureId == ddmStructureVersion.getStructureId()) continue;
                list = null;
                break;
            }
        }
        if (list == null) {
            StringBundler sb = null;
            sb = orderByComparator != null ? new StringBundler(3 + orderByComparator.getOrderByFields().length * 2) : new StringBundler(3);
            sb.append(_SQL_SELECT_DDMSTRUCTUREVERSION_WHERE);
            sb.append(_FINDER_COLUMN_STRUCTUREID_STRUCTUREID_2);
            if (orderByComparator != null) {
                this.appendOrderByComparator(sb, _ORDER_BY_ENTITY_ALIAS, orderByComparator);
            } else {
                sb.append(" ORDER BY ddmStructureVersion.structureVersionId ASC");
            }
            String sql = sb.toString();
            Session session = null;
            try {
                session = this.openSession();
                Query query = session.createQuery(sql);
                QueryPos queryPos = QueryPos.getInstance((Query)query);
                queryPos.add(structureId);
                list = QueryUtil.list((Query)query, (Dialect)this.getDialect(), (int)start, (int)end);
                this.cacheResult(list);
                if (useFinderCache && productionMode) {
                    this.finderCache.putResult(finderPath, finderArgs, (Object)list);
                }
            }
            catch (Exception exception) {
                throw this.processException(exception);
            }
            finally {
                this.closeSession(session);
            }
        }
        return list;
    }

    public DDMStructureVersion findByStructureId_First(long structureId, OrderByComparator<DDMStructureVersion> orderByComparator) throws NoSuchStructureVersionException {
        DDMStructureVersion ddmStructureVersion = this.fetchByStructureId_First(structureId, orderByComparator);
        if (ddmStructureVersion != null) {
            return ddmStructureVersion;
        }
        StringBundler sb = new StringBundler(4);
        sb.append(_NO_SUCH_ENTITY_WITH_KEY);
        sb.append("structureId=");
        sb.append(structureId);
        sb.append("}");
        throw new NoSuchStructureVersionException(sb.toString());
    }

    public DDMStructureVersion fetchByStructureId_First(long structureId, OrderByComparator<DDMStructureVersion> orderByComparator) {
        List<DDMStructureVersion> list = this.findByStructureId(structureId, 0, 1, orderByComparator);
        if (!list.isEmpty()) {
            return list.get(0);
        }
        return null;
    }

    public DDMStructureVersion findByStructureId_Last(long structureId, OrderByComparator<DDMStructureVersion> orderByComparator) throws NoSuchStructureVersionException {
        DDMStructureVersion ddmStructureVersion = this.fetchByStructureId_Last(structureId, orderByComparator);
        if (ddmStructureVersion != null) {
            return ddmStructureVersion;
        }
        StringBundler sb = new StringBundler(4);
        sb.append(_NO_SUCH_ENTITY_WITH_KEY);
        sb.append("structureId=");
        sb.append(structureId);
        sb.append("}");
        throw new NoSuchStructureVersionException(sb.toString());
    }

    public DDMStructureVersion fetchByStructureId_Last(long structureId, OrderByComparator<DDMStructureVersion> orderByComparator) {
        int count = this.countByStructureId(structureId);
        if (count == 0) {
            return null;
        }
        List<DDMStructureVersion> list = this.findByStructureId(structureId, count - 1, count, orderByComparator);
        if (!list.isEmpty()) {
            return list.get(0);
        }
        return null;
    }

    public DDMStructureVersion[] findByStructureId_PrevAndNext(long structureVersionId, long structureId, OrderByComparator<DDMStructureVersion> orderByComparator) throws NoSuchStructureVersionException {
        DDMStructureVersion ddmStructureVersion = this.findByPrimaryKey(structureVersionId);
        Session session = null;
        try {
            session = this.openSession();
            DDMStructureVersion[] array = new DDMStructureVersionImpl[]{this.getByStructureId_PrevAndNext(session, ddmStructureVersion, structureId, orderByComparator, true), ddmStructureVersion, this.getByStructureId_PrevAndNext(session, ddmStructureVersion, structureId, orderByComparator, false)};
            DDMStructureVersion[] dDMStructureVersionArray = array;
            return dDMStructureVersionArray;
        }
        catch (Exception exception) {
            throw this.processException(exception);
        }
        finally {
            this.closeSession(session);
        }
    }

    protected DDMStructureVersion getByStructureId_PrevAndNext(Session session, DDMStructureVersion ddmStructureVersion, long structureId, OrderByComparator<DDMStructureVersion> orderByComparator, boolean previous) {
        List list;
        StringBundler sb = null;
        sb = orderByComparator != null ? new StringBundler(4 + orderByComparator.getOrderByConditionFields().length * 3 + orderByComparator.getOrderByFields().length * 3) : new StringBundler(3);
        sb.append(_SQL_SELECT_DDMSTRUCTUREVERSION_WHERE);
        sb.append(_FINDER_COLUMN_STRUCTUREID_STRUCTUREID_2);
        if (orderByComparator != null) {
            String[] orderByConditionFields = orderByComparator.getOrderByConditionFields();
            if (orderByConditionFields.length > 0) {
                sb.append(" AND ");
            }
            for (int i = 0; i < orderByConditionFields.length; ++i) {
                sb.append(_ORDER_BY_ENTITY_ALIAS);
                sb.append(orderByConditionFields[i]);
                if (i + 1 < orderByConditionFields.length) {
                    if (orderByComparator.isAscending() ^ previous) {
                        sb.append(" >= ? AND ");
                        continue;
                    }
                    sb.append(" <= ? AND ");
                    continue;
                }
                if (orderByComparator.isAscending() ^ previous) {
                    sb.append(" >= ? ");
                    continue;
                }
                sb.append(" <= ? ");
            }
            sb.append(" ORDER BY ");
            String[] orderByFields = orderByComparator.getOrderByFields();
            for (int i = 0; i < orderByFields.length; ++i) {
                sb.append(_ORDER_BY_ENTITY_ALIAS);
                sb.append(orderByFields[i]);
                if (i + 1 < orderByFields.length) {
                    if (orderByComparator.isAscending() ^ previous) {
                        sb.append(" ASC, ");
                        continue;
                    }
                    sb.append(" DESC, ");
                    continue;
                }
                if (orderByComparator.isAscending() ^ previous) {
                    sb.append(" ASC");
                    continue;
                }
                sb.append(" DESC");
            }
        } else {
            sb.append(" ORDER BY ddmStructureVersion.structureVersionId ASC");
        }
        String sql = sb.toString();
        Query query = session.createQuery(sql);
        query.setFirstResult(0);
        query.setMaxResults(2);
        QueryPos queryPos = QueryPos.getInstance((Query)query);
        queryPos.add(structureId);
        if (orderByComparator != null) {
            for (Object orderByConditionValue : orderByComparator.getOrderByConditionValues((Object)ddmStructureVersion)) {
                queryPos.add(orderByConditionValue);
            }
        }
        if ((list = query.list()).size() == 2) {
            return (DDMStructureVersion)list.get(1);
        }
        return null;
    }

    public void removeByStructureId(long structureId) {
        for (DDMStructureVersion ddmStructureVersion : this.findByStructureId(structureId, -1, -1, null)) {
            this.remove((BaseModel)ddmStructureVersion);
        }
    }

    public int countByStructureId(long structureId) {
        boolean productionMode = this.ctPersistenceHelper.isProductionMode(DDMStructureVersion.class);
        FinderPath finderPath = null;
        Object[] finderArgs = null;
        Long count = null;
        if (productionMode) {
            finderPath = this._finderPathCountByStructureId;
            finderArgs = new Object[]{structureId};
            count = (Long)this.finderCache.getResult(finderPath, finderArgs, (BasePersistenceImpl)this);
        }
        if (count == null) {
            StringBundler sb = new StringBundler(2);
            sb.append(_SQL_COUNT_DDMSTRUCTUREVERSION_WHERE);
            sb.append(_FINDER_COLUMN_STRUCTUREID_STRUCTUREID_2);
            String sql = sb.toString();
            Session session = null;
            try {
                session = this.openSession();
                Query query = session.createQuery(sql);
                QueryPos queryPos = QueryPos.getInstance((Query)query);
                queryPos.add(structureId);
                count = (Long)query.uniqueResult();
                if (productionMode) {
                    this.finderCache.putResult(finderPath, finderArgs, (Object)count);
                }
            }
            catch (Exception exception) {
                throw this.processException(exception);
            }
            finally {
                this.closeSession(session);
            }
        }
        return count.intValue();
    }

    public DDMStructureVersion findByS_V(long structureId, String version) throws NoSuchStructureVersionException {
        DDMStructureVersion ddmStructureVersion = this.fetchByS_V(structureId, version);
        if (ddmStructureVersion == null) {
            StringBundler sb = new StringBundler(6);
            sb.append(_NO_SUCH_ENTITY_WITH_KEY);
            sb.append("structureId=");
            sb.append(structureId);
            sb.append(", version=");
            sb.append(version);
            sb.append("}");
            if (_log.isDebugEnabled()) {
                _log.debug((Object)sb.toString());
            }
            throw new NoSuchStructureVersionException(sb.toString());
        }
        return ddmStructureVersion;
    }

    public DDMStructureVersion fetchByS_V(long structureId, String version) {
        return this.fetchByS_V(structureId, version, true);
    }

    public DDMStructureVersion fetchByS_V(long structureId, String version, boolean useFinderCache) {
        DDMStructureVersion ddmStructureVersion;
        version = Objects.toString(version, "");
        boolean productionMode = this.ctPersistenceHelper.isProductionMode(DDMStructureVersion.class);
        Object[] finderArgs = null;
        if (useFinderCache && productionMode) {
            finderArgs = new Object[]{structureId, version};
        }
        Object result = null;
        if (useFinderCache && productionMode) {
            result = this.finderCache.getResult(this._finderPathFetchByS_V, finderArgs, (BasePersistenceImpl)this);
        }
        if (result instanceof DDMStructureVersion && (structureId != (ddmStructureVersion = (DDMStructureVersion)result).getStructureId() || !Objects.equals(version, ddmStructureVersion.getVersion()))) {
            result = null;
        }
        if (result == null) {
            StringBundler sb = new StringBundler(4);
            sb.append(_SQL_SELECT_DDMSTRUCTUREVERSION_WHERE);
            sb.append("ddmStructureVersion.structureId = ? AND ");
            boolean bindVersion = false;
            if (version.isEmpty()) {
                sb.append(_FINDER_COLUMN_S_V_VERSION_3);
            } else {
                bindVersion = true;
                sb.append(_FINDER_COLUMN_S_V_VERSION_2);
            }
            String sql = sb.toString();
            Session session = null;
            try {
                List list;
                session = this.openSession();
                Query query = session.createQuery(sql);
                QueryPos queryPos = QueryPos.getInstance((Query)query);
                queryPos.add(structureId);
                if (bindVersion) {
                    queryPos.add(version);
                }
                if ((list = query.list()).isEmpty()) {
                    if (useFinderCache && productionMode) {
                        this.finderCache.putResult(this._finderPathFetchByS_V, finderArgs, (Object)list);
                    }
                } else {
                    DDMStructureVersion ddmStructureVersion2 = (DDMStructureVersion)list.get(0);
                    result = ddmStructureVersion2;
                    this.cacheResult(ddmStructureVersion2);
                }
            }
            catch (Exception exception) {
                throw this.processException(exception);
            }
            finally {
                this.closeSession(session);
            }
        }
        if (result instanceof List) {
            return null;
        }
        return (DDMStructureVersion)result;
    }

    public DDMStructureVersion removeByS_V(long structureId, String version) throws NoSuchStructureVersionException {
        DDMStructureVersion ddmStructureVersion = this.findByS_V(structureId, version);
        return (DDMStructureVersion)this.remove((BaseModel)ddmStructureVersion);
    }

    public int countByS_V(long structureId, String version) {
        version = Objects.toString(version, "");
        boolean productionMode = this.ctPersistenceHelper.isProductionMode(DDMStructureVersion.class);
        FinderPath finderPath = null;
        Object[] finderArgs = null;
        Long count = null;
        if (productionMode) {
            finderPath = this._finderPathCountByS_V;
            finderArgs = new Object[]{structureId, version};
            count = (Long)this.finderCache.getResult(finderPath, finderArgs, (BasePersistenceImpl)this);
        }
        if (count == null) {
            StringBundler sb = new StringBundler(3);
            sb.append(_SQL_COUNT_DDMSTRUCTUREVERSION_WHERE);
            sb.append("ddmStructureVersion.structureId = ? AND ");
            boolean bindVersion = false;
            if (version.isEmpty()) {
                sb.append(_FINDER_COLUMN_S_V_VERSION_3);
            } else {
                bindVersion = true;
                sb.append(_FINDER_COLUMN_S_V_VERSION_2);
            }
            String sql = sb.toString();
            Session session = null;
            try {
                session = this.openSession();
                Query query = session.createQuery(sql);
                QueryPos queryPos = QueryPos.getInstance((Query)query);
                queryPos.add(structureId);
                if (bindVersion) {
                    queryPos.add(version);
                }
                count = (Long)query.uniqueResult();
                if (productionMode) {
                    this.finderCache.putResult(finderPath, finderArgs, (Object)count);
                }
            }
            catch (Exception exception) {
                throw this.processException(exception);
            }
            finally {
                this.closeSession(session);
            }
        }
        return count.intValue();
    }

    public List<DDMStructureVersion> findByS_S(long structureId, int status) {
        return this.findByS_S(structureId, status, -1, -1, null);
    }

    public List<DDMStructureVersion> findByS_S(long structureId, int status, int start, int end) {
        return this.findByS_S(structureId, status, start, end, null);
    }

    public List<DDMStructureVersion> findByS_S(long structureId, int status, int start, int end, OrderByComparator<DDMStructureVersion> orderByComparator) {
        return this.findByS_S(structureId, status, start, end, orderByComparator, true);
    }

    public List<DDMStructureVersion> findByS_S(long structureId, int status, int start, int end, OrderByComparator<DDMStructureVersion> orderByComparator, boolean useFinderCache) {
        boolean productionMode = this.ctPersistenceHelper.isProductionMode(DDMStructureVersion.class);
        FinderPath finderPath = null;
        Object[] finderArgs = null;
        if (start == -1 && end == -1 && orderByComparator == null) {
            if (useFinderCache && productionMode) {
                finderPath = this._finderPathWithoutPaginationFindByS_S;
                finderArgs = new Object[]{structureId, status};
            }
        } else if (useFinderCache && productionMode) {
            finderPath = this._finderPathWithPaginationFindByS_S;
            finderArgs = new Object[]{structureId, status, start, end, orderByComparator};
        }
        List list = null;
        if (useFinderCache && productionMode && (list = (List)this.finderCache.getResult(finderPath, finderArgs, (BasePersistenceImpl)this)) != null && !list.isEmpty()) {
            for (DDMStructureVersion ddmStructureVersion : list) {
                if (structureId == ddmStructureVersion.getStructureId() && status == ddmStructureVersion.getStatus()) continue;
                list = null;
                break;
            }
        }
        if (list == null) {
            StringBundler sb = null;
            sb = orderByComparator != null ? new StringBundler(4 + orderByComparator.getOrderByFields().length * 2) : new StringBundler(4);
            sb.append(_SQL_SELECT_DDMSTRUCTUREVERSION_WHERE);
            sb.append("ddmStructureVersion.structureId = ? AND ");
            sb.append(_FINDER_COLUMN_S_S_STATUS_2);
            if (orderByComparator != null) {
                this.appendOrderByComparator(sb, _ORDER_BY_ENTITY_ALIAS, orderByComparator);
            } else {
                sb.append(" ORDER BY ddmStructureVersion.structureVersionId ASC");
            }
            String sql = sb.toString();
            Session session = null;
            try {
                session = this.openSession();
                Query query = session.createQuery(sql);
                QueryPos queryPos = QueryPos.getInstance((Query)query);
                queryPos.add(structureId);
                queryPos.add(status);
                list = QueryUtil.list((Query)query, (Dialect)this.getDialect(), (int)start, (int)end);
                this.cacheResult(list);
                if (useFinderCache && productionMode) {
                    this.finderCache.putResult(finderPath, finderArgs, (Object)list);
                }
            }
            catch (Exception exception) {
                throw this.processException(exception);
            }
            finally {
                this.closeSession(session);
            }
        }
        return list;
    }

    public DDMStructureVersion findByS_S_First(long structureId, int status, OrderByComparator<DDMStructureVersion> orderByComparator) throws NoSuchStructureVersionException {
        DDMStructureVersion ddmStructureVersion = this.fetchByS_S_First(structureId, status, orderByComparator);
        if (ddmStructureVersion != null) {
            return ddmStructureVersion;
        }
        StringBundler sb = new StringBundler(6);
        sb.append(_NO_SUCH_ENTITY_WITH_KEY);
        sb.append("structureId=");
        sb.append(structureId);
        sb.append(", status=");
        sb.append(status);
        sb.append("}");
        throw new NoSuchStructureVersionException(sb.toString());
    }

    public DDMStructureVersion fetchByS_S_First(long structureId, int status, OrderByComparator<DDMStructureVersion> orderByComparator) {
        List<DDMStructureVersion> list = this.findByS_S(structureId, status, 0, 1, orderByComparator);
        if (!list.isEmpty()) {
            return list.get(0);
        }
        return null;
    }

    public DDMStructureVersion findByS_S_Last(long structureId, int status, OrderByComparator<DDMStructureVersion> orderByComparator) throws NoSuchStructureVersionException {
        DDMStructureVersion ddmStructureVersion = this.fetchByS_S_Last(structureId, status, orderByComparator);
        if (ddmStructureVersion != null) {
            return ddmStructureVersion;
        }
        StringBundler sb = new StringBundler(6);
        sb.append(_NO_SUCH_ENTITY_WITH_KEY);
        sb.append("structureId=");
        sb.append(structureId);
        sb.append(", status=");
        sb.append(status);
        sb.append("}");
        throw new NoSuchStructureVersionException(sb.toString());
    }

    public DDMStructureVersion fetchByS_S_Last(long structureId, int status, OrderByComparator<DDMStructureVersion> orderByComparator) {
        int count = this.countByS_S(structureId, status);
        if (count == 0) {
            return null;
        }
        List<DDMStructureVersion> list = this.findByS_S(structureId, status, count - 1, count, orderByComparator);
        if (!list.isEmpty()) {
            return list.get(0);
        }
        return null;
    }

    public DDMStructureVersion[] findByS_S_PrevAndNext(long structureVersionId, long structureId, int status, OrderByComparator<DDMStructureVersion> orderByComparator) throws NoSuchStructureVersionException {
        DDMStructureVersion ddmStructureVersion = this.findByPrimaryKey(structureVersionId);
        Session session = null;
        try {
            session = this.openSession();
            DDMStructureVersion[] array = new DDMStructureVersionImpl[]{this.getByS_S_PrevAndNext(session, ddmStructureVersion, structureId, status, orderByComparator, true), ddmStructureVersion, this.getByS_S_PrevAndNext(session, ddmStructureVersion, structureId, status, orderByComparator, false)};
            DDMStructureVersion[] dDMStructureVersionArray = array;
            return dDMStructureVersionArray;
        }
        catch (Exception exception) {
            throw this.processException(exception);
        }
        finally {
            this.closeSession(session);
        }
    }

    protected DDMStructureVersion getByS_S_PrevAndNext(Session session, DDMStructureVersion ddmStructureVersion, long structureId, int status, OrderByComparator<DDMStructureVersion> orderByComparator, boolean previous) {
        List list;
        StringBundler sb = null;
        sb = orderByComparator != null ? new StringBundler(5 + orderByComparator.getOrderByConditionFields().length * 3 + orderByComparator.getOrderByFields().length * 3) : new StringBundler(4);
        sb.append(_SQL_SELECT_DDMSTRUCTUREVERSION_WHERE);
        sb.append("ddmStructureVersion.structureId = ? AND ");
        sb.append(_FINDER_COLUMN_S_S_STATUS_2);
        if (orderByComparator != null) {
            String[] orderByConditionFields = orderByComparator.getOrderByConditionFields();
            if (orderByConditionFields.length > 0) {
                sb.append(" AND ");
            }
            for (int i = 0; i < orderByConditionFields.length; ++i) {
                sb.append(_ORDER_BY_ENTITY_ALIAS);
                sb.append(orderByConditionFields[i]);
                if (i + 1 < orderByConditionFields.length) {
                    if (orderByComparator.isAscending() ^ previous) {
                        sb.append(" >= ? AND ");
                        continue;
                    }
                    sb.append(" <= ? AND ");
                    continue;
                }
                if (orderByComparator.isAscending() ^ previous) {
                    sb.append(" >= ? ");
                    continue;
                }
                sb.append(" <= ? ");
            }
            sb.append(" ORDER BY ");
            String[] orderByFields = orderByComparator.getOrderByFields();
            for (int i = 0; i < orderByFields.length; ++i) {
                sb.append(_ORDER_BY_ENTITY_ALIAS);
                sb.append(orderByFields[i]);
                if (i + 1 < orderByFields.length) {
                    if (orderByComparator.isAscending() ^ previous) {
                        sb.append(" ASC, ");
                        continue;
                    }
                    sb.append(" DESC, ");
                    continue;
                }
                if (orderByComparator.isAscending() ^ previous) {
                    sb.append(" ASC");
                    continue;
                }
                sb.append(" DESC");
            }
        } else {
            sb.append(" ORDER BY ddmStructureVersion.structureVersionId ASC");
        }
        String sql = sb.toString();
        Query query = session.createQuery(sql);
        query.setFirstResult(0);
        query.setMaxResults(2);
        QueryPos queryPos = QueryPos.getInstance((Query)query);
        queryPos.add(structureId);
        queryPos.add(status);
        if (orderByComparator != null) {
            for (Object orderByConditionValue : orderByComparator.getOrderByConditionValues((Object)ddmStructureVersion)) {
                queryPos.add(orderByConditionValue);
            }
        }
        if ((list = query.list()).size() == 2) {
            return (DDMStructureVersion)list.get(1);
        }
        return null;
    }

    public void removeByS_S(long structureId, int status) {
        for (DDMStructureVersion ddmStructureVersion : this.findByS_S(structureId, status, -1, -1, null)) {
            this.remove((BaseModel)ddmStructureVersion);
        }
    }

    public int countByS_S(long structureId, int status) {
        boolean productionMode = this.ctPersistenceHelper.isProductionMode(DDMStructureVersion.class);
        FinderPath finderPath = null;
        Object[] finderArgs = null;
        Long count = null;
        if (productionMode) {
            finderPath = this._finderPathCountByS_S;
            finderArgs = new Object[]{structureId, status};
            count = (Long)this.finderCache.getResult(finderPath, finderArgs, (BasePersistenceImpl)this);
        }
        if (count == null) {
            StringBundler sb = new StringBundler(3);
            sb.append(_SQL_COUNT_DDMSTRUCTUREVERSION_WHERE);
            sb.append("ddmStructureVersion.structureId = ? AND ");
            sb.append(_FINDER_COLUMN_S_S_STATUS_2);
            String sql = sb.toString();
            Session session = null;
            try {
                session = this.openSession();
                Query query = session.createQuery(sql);
                QueryPos queryPos = QueryPos.getInstance((Query)query);
                queryPos.add(structureId);
                queryPos.add(status);
                count = (Long)query.uniqueResult();
                if (productionMode) {
                    this.finderCache.putResult(finderPath, finderArgs, (Object)count);
                }
            }
            catch (Exception exception) {
                throw this.processException(exception);
            }
            finally {
                this.closeSession(session);
            }
        }
        return count.intValue();
    }

    public DDMStructureVersionPersistenceImpl() {
        HashMap<String, String> dbColumnNames = new HashMap<String, String>();
        dbColumnNames.put("type", "type_");
        this.setDBColumnNames(dbColumnNames);
        this.setModelClass(DDMStructureVersion.class);
        this.setModelImplClass(DDMStructureVersionImpl.class);
        this.setModelPKClass(Long.TYPE);
        this.setTable((Table)DDMStructureVersionTable.INSTANCE);
    }

    public void cacheResult(DDMStructureVersion ddmStructureVersion) {
        if (ddmStructureVersion.getCtCollectionId() != 0L) {
            return;
        }
        this.entityCache.putResult(DDMStructureVersionImpl.class, (Serializable)Long.valueOf(ddmStructureVersion.getPrimaryKey()), (Serializable)ddmStructureVersion);
        this.finderCache.putResult(this._finderPathFetchByS_V, new Object[]{ddmStructureVersion.getStructureId(), ddmStructureVersion.getVersion()}, (Object)ddmStructureVersion);
    }

    public void cacheResult(List<DDMStructureVersion> ddmStructureVersions) {
        if (this._valueObjectFinderCacheListThreshold == 0 || this._valueObjectFinderCacheListThreshold > 0 && ddmStructureVersions.size() > this._valueObjectFinderCacheListThreshold) {
            return;
        }
        for (DDMStructureVersion ddmStructureVersion : ddmStructureVersions) {
            if (ddmStructureVersion.getCtCollectionId() != 0L) continue;
            DDMStructureVersion cachedDDMStructureVersion = (DDMStructureVersion)this.entityCache.getResult(DDMStructureVersionImpl.class, (Serializable)Long.valueOf(ddmStructureVersion.getPrimaryKey()));
            if (cachedDDMStructureVersion == null) {
                this.cacheResult(ddmStructureVersion);
                continue;
            }
            DDMStructureVersionModelImpl ddmStructureVersionModelImpl = (DDMStructureVersionModelImpl)ddmStructureVersion;
            DDMStructureVersionModelImpl cachedDDMStructureVersionModelImpl = (DDMStructureVersionModelImpl)cachedDDMStructureVersion;
            ddmStructureVersionModelImpl.setDDMForm(cachedDDMStructureVersionModelImpl.getDDMForm());
        }
    }

    public void clearCache() {
        this.entityCache.clearCache(DDMStructureVersionImpl.class);
        this.finderCache.clearCache(FINDER_CLASS_NAME_ENTITY);
        this.finderCache.clearCache(FINDER_CLASS_NAME_LIST_WITH_PAGINATION);
        this.finderCache.clearCache(FINDER_CLASS_NAME_LIST_WITHOUT_PAGINATION);
    }

    public void clearCache(DDMStructureVersion ddmStructureVersion) {
        this.entityCache.removeResult(DDMStructureVersionImpl.class, (BaseModel)ddmStructureVersion);
    }

    public void clearCache(List<DDMStructureVersion> ddmStructureVersions) {
        for (DDMStructureVersion ddmStructureVersion : ddmStructureVersions) {
            this.entityCache.removeResult(DDMStructureVersionImpl.class, (BaseModel)ddmStructureVersion);
        }
    }

    public void clearCache(Set<Serializable> primaryKeys) {
        this.finderCache.clearCache(FINDER_CLASS_NAME_ENTITY);
        this.finderCache.clearCache(FINDER_CLASS_NAME_LIST_WITH_PAGINATION);
        this.finderCache.clearCache(FINDER_CLASS_NAME_LIST_WITHOUT_PAGINATION);
        for (Serializable primaryKey : primaryKeys) {
            this.entityCache.removeResult(DDMStructureVersionImpl.class, primaryKey);
        }
    }

    protected void cacheUniqueFindersCache(DDMStructureVersionModelImpl ddmStructureVersionModelImpl) {
        Object[] args = new Object[]{ddmStructureVersionModelImpl.getStructureId(), ddmStructureVersionModelImpl.getVersion()};
        this.finderCache.putResult(this._finderPathCountByS_V, args, (Object)1L, false);
        this.finderCache.putResult(this._finderPathFetchByS_V, args, (Object)ddmStructureVersionModelImpl, false);
    }

    public DDMStructureVersion create(long structureVersionId) {
        DDMStructureVersionImpl ddmStructureVersion = new DDMStructureVersionImpl();
        ddmStructureVersion.setNew(true);
        ddmStructureVersion.setPrimaryKey(structureVersionId);
        ddmStructureVersion.setCompanyId(CompanyThreadLocal.getCompanyId());
        return ddmStructureVersion;
    }

    public DDMStructureVersion remove(long structureVersionId) throws NoSuchStructureVersionException {
        return this.remove(Long.valueOf(structureVersionId));
    }

    public DDMStructureVersion remove(Serializable primaryKey) throws NoSuchStructureVersionException {
        Session session = null;
        try {
            session = this.openSession();
            DDMStructureVersion ddmStructureVersion = (DDMStructureVersion)session.get(DDMStructureVersionImpl.class, primaryKey);
            if (ddmStructureVersion == null) {
                if (_log.isDebugEnabled()) {
                    _log.debug((Object)(_NO_SUCH_ENTITY_WITH_PRIMARY_KEY + primaryKey));
                }
                throw new NoSuchStructureVersionException(_NO_SUCH_ENTITY_WITH_PRIMARY_KEY + primaryKey);
            }
            DDMStructureVersion dDMStructureVersion = (DDMStructureVersion)this.remove((BaseModel)ddmStructureVersion);
            return dDMStructureVersion;
        }
        catch (NoSuchStructureVersionException noSuchEntityException) {
            throw noSuchEntityException;
        }
        catch (Exception exception) {
            throw this.processException(exception);
        }
        finally {
            this.closeSession(session);
        }
    }

    protected DDMStructureVersion removeImpl(DDMStructureVersion ddmStructureVersion) {
        Session session = null;
        try {
            session = this.openSession();
            if (!session.contains((Object)ddmStructureVersion)) {
                ddmStructureVersion = (DDMStructureVersion)session.get(DDMStructureVersionImpl.class, ddmStructureVersion.getPrimaryKeyObj());
            }
            if (ddmStructureVersion != null && this.ctPersistenceHelper.isRemove((CTModel)ddmStructureVersion)) {
                session.delete((Object)ddmStructureVersion);
            }
        }
        catch (Exception exception) {
            throw this.processException(exception);
        }
        finally {
            this.closeSession(session);
        }
        if (ddmStructureVersion != null) {
            this.clearCache(ddmStructureVersion);
        }
        return ddmStructureVersion;
    }

    public DDMStructureVersion updateImpl(DDMStructureVersion ddmStructureVersion) {
        boolean isNew = ddmStructureVersion.isNew();
        if (!(ddmStructureVersion instanceof DDMStructureVersionModelImpl)) {
            InvocationHandler invocationHandler = null;
            if (ProxyUtil.isProxyClass(ddmStructureVersion.getClass())) {
                invocationHandler = ProxyUtil.getInvocationHandler((Object)ddmStructureVersion);
                throw new IllegalArgumentException("Implement ModelWrapper in ddmStructureVersion proxy " + invocationHandler.getClass());
            }
            throw new IllegalArgumentException("Implement ModelWrapper in custom DDMStructureVersion implementation " + ddmStructureVersion.getClass());
        }
        DDMStructureVersionModelImpl ddmStructureVersionModelImpl = (DDMStructureVersionModelImpl)ddmStructureVersion;
        if (isNew && ddmStructureVersion.getCreateDate() == null) {
            ServiceContext serviceContext = ServiceContextThreadLocal.getServiceContext();
            Date date = new Date();
            if (serviceContext == null) {
                ddmStructureVersion.setCreateDate(date);
            } else {
                ddmStructureVersion.setCreateDate(serviceContext.getCreateDate(date));
            }
        }
        Session session = null;
        try {
            session = this.openSession();
            if (this.ctPersistenceHelper.isInsert((CTModel)ddmStructureVersion)) {
                if (!isNew) {
                    session.evict(DDMStructureVersionImpl.class, ddmStructureVersion.getPrimaryKeyObj());
                }
                session.save((Object)ddmStructureVersion);
            } else {
                ddmStructureVersion = (DDMStructureVersion)session.merge((Object)ddmStructureVersion);
            }
        }
        catch (Exception exception) {
            throw this.processException(exception);
        }
        finally {
            this.closeSession(session);
        }
        if (ddmStructureVersion.getCtCollectionId() != 0L) {
            if (isNew) {
                ddmStructureVersion.setNew(false);
            }
            ddmStructureVersion.resetOriginalValues();
            return ddmStructureVersion;
        }
        this.entityCache.putResult(DDMStructureVersionImpl.class, (BaseModel)ddmStructureVersionModelImpl, false, true);
        this.cacheUniqueFindersCache(ddmStructureVersionModelImpl);
        if (isNew) {
            ddmStructureVersion.setNew(false);
        }
        ddmStructureVersion.resetOriginalValues();
        return ddmStructureVersion;
    }

    public DDMStructureVersion findByPrimaryKey(Serializable primaryKey) throws NoSuchStructureVersionException {
        DDMStructureVersion ddmStructureVersion = this.fetchByPrimaryKey(primaryKey);
        if (ddmStructureVersion == null) {
            if (_log.isDebugEnabled()) {
                _log.debug((Object)(_NO_SUCH_ENTITY_WITH_PRIMARY_KEY + primaryKey));
            }
            throw new NoSuchStructureVersionException(_NO_SUCH_ENTITY_WITH_PRIMARY_KEY + primaryKey);
        }
        return ddmStructureVersion;
    }

    public DDMStructureVersion findByPrimaryKey(long structureVersionId) throws NoSuchStructureVersionException {
        return this.findByPrimaryKey(Long.valueOf(structureVersionId));
    }

    public DDMStructureVersion fetchByPrimaryKey(Serializable primaryKey) {
        if (this.ctPersistenceHelper.isProductionMode(DDMStructureVersion.class)) {
            return (DDMStructureVersion)super.fetchByPrimaryKey(primaryKey);
        }
        DDMStructureVersion ddmStructureVersion = null;
        Session session = null;
        try {
            session = this.openSession();
            ddmStructureVersion = (DDMStructureVersion)session.get(DDMStructureVersionImpl.class, primaryKey);
            if (ddmStructureVersion != null) {
                this.cacheResult(ddmStructureVersion);
            }
        }
        catch (Exception exception) {
            throw this.processException(exception);
        }
        finally {
            this.closeSession(session);
        }
        return ddmStructureVersion;
    }

    public DDMStructureVersion fetchByPrimaryKey(long structureVersionId) {
        return this.fetchByPrimaryKey(Long.valueOf(structureVersionId));
    }

    public Map<Serializable, DDMStructureVersion> fetchByPrimaryKeys(Set<Serializable> primaryKeys) {
        if (this.ctPersistenceHelper.isProductionMode(DDMStructureVersion.class)) {
            return super.fetchByPrimaryKeys(primaryKeys);
        }
        if (primaryKeys.isEmpty()) {
            return Collections.emptyMap();
        }
        HashMap<Serializable, DDMStructureVersion> map = new HashMap<Serializable, DDMStructureVersion>();
        if (primaryKeys.size() == 1) {
            Iterator<Serializable> iterator = primaryKeys.iterator();
            Serializable primaryKey = iterator.next();
            DDMStructureVersion ddmStructureVersion = this.fetchByPrimaryKey(primaryKey);
            if (ddmStructureVersion != null) {
                map.put(primaryKey, ddmStructureVersion);
            }
            return map;
        }
        if (this.databaseInMaxParameters > 0 && primaryKeys.size() > this.databaseInMaxParameters) {
            Iterator<Serializable> iterator = primaryKeys.iterator();
            while (iterator.hasNext()) {
                HashSet<Serializable> page = new HashSet<Serializable>();
                for (int i = 0; i < this.databaseInMaxParameters && iterator.hasNext(); ++i) {
                    page.add(iterator.next());
                }
                map.putAll(this.fetchByPrimaryKeys(page));
            }
            return map;
        }
        StringBundler sb = new StringBundler(primaryKeys.size() * 2 + 1);
        sb.append(this.getSelectSQL());
        sb.append(" WHERE ");
        sb.append(this.getPKDBName());
        sb.append(" IN (");
        for (Serializable primaryKey : primaryKeys) {
            sb.append(((Long)primaryKey).longValue());
            sb.append(",");
        }
        sb.setIndex(sb.index() - 1);
        sb.append(")");
        String sql = sb.toString();
        Session session = null;
        try {
            session = this.openSession();
            Query query = session.createQuery(sql);
            for (DDMStructureVersion ddmStructureVersion : query.list()) {
                map.put(ddmStructureVersion.getPrimaryKeyObj(), ddmStructureVersion);
                this.cacheResult(ddmStructureVersion);
            }
        }
        catch (Exception exception) {
            throw this.processException(exception);
        }
        finally {
            this.closeSession(session);
        }
        return map;
    }

    public List<DDMStructureVersion> findAll() {
        return this.findAll(-1, -1, null);
    }

    public List<DDMStructureVersion> findAll(int start, int end) {
        return this.findAll(start, end, null);
    }

    public List<DDMStructureVersion> findAll(int start, int end, OrderByComparator<DDMStructureVersion> orderByComparator) {
        return this.findAll(start, end, orderByComparator, true);
    }

    public List<DDMStructureVersion> findAll(int start, int end, OrderByComparator<DDMStructureVersion> orderByComparator, boolean useFinderCache) {
        boolean productionMode = this.ctPersistenceHelper.isProductionMode(DDMStructureVersion.class);
        FinderPath finderPath = null;
        Object[] finderArgs = null;
        if (start == -1 && end == -1 && orderByComparator == null) {
            if (useFinderCache && productionMode) {
                finderPath = this._finderPathWithoutPaginationFindAll;
                finderArgs = FINDER_ARGS_EMPTY;
            }
        } else if (useFinderCache && productionMode) {
            finderPath = this._finderPathWithPaginationFindAll;
            finderArgs = new Object[]{start, end, orderByComparator};
        }
        List list = null;
        if (useFinderCache && productionMode) {
            list = (List)this.finderCache.getResult(finderPath, finderArgs, (BasePersistenceImpl)this);
        }
        if (list == null) {
            StringBundler sb = null;
            String sql = null;
            if (orderByComparator != null) {
                sb = new StringBundler(2 + orderByComparator.getOrderByFields().length * 2);
                sb.append(_SQL_SELECT_DDMSTRUCTUREVERSION);
                this.appendOrderByComparator(sb, _ORDER_BY_ENTITY_ALIAS, orderByComparator);
                sql = sb.toString();
            } else {
                sql = _SQL_SELECT_DDMSTRUCTUREVERSION;
                sql = sql.concat(" ORDER BY ddmStructureVersion.structureVersionId ASC");
            }
            Session session = null;
            try {
                session = this.openSession();
                Query query = session.createQuery(sql);
                list = QueryUtil.list((Query)query, (Dialect)this.getDialect(), (int)start, (int)end);
                this.cacheResult(list);
                if (useFinderCache && productionMode) {
                    this.finderCache.putResult(finderPath, finderArgs, (Object)list);
                }
            }
            catch (Exception exception) {
                throw this.processException(exception);
            }
            finally {
                this.closeSession(session);
            }
        }
        return list;
    }

    public void removeAll() {
        for (DDMStructureVersion ddmStructureVersion : this.findAll()) {
            this.remove((BaseModel)ddmStructureVersion);
        }
    }

    public int countAll() {
        boolean productionMode = this.ctPersistenceHelper.isProductionMode(DDMStructureVersion.class);
        Long count = null;
        if (productionMode) {
            count = (Long)this.finderCache.getResult(this._finderPathCountAll, FINDER_ARGS_EMPTY, (BasePersistenceImpl)this);
        }
        if (count == null) {
            Session session = null;
            try {
                session = this.openSession();
                Query query = session.createQuery(_SQL_COUNT_DDMSTRUCTUREVERSION);
                count = (Long)query.uniqueResult();
                if (productionMode) {
                    this.finderCache.putResult(this._finderPathCountAll, FINDER_ARGS_EMPTY, (Object)count);
                }
            }
            catch (Exception exception) {
                throw this.processException(exception);
            }
            finally {
                this.closeSession(session);
            }
        }
        return count.intValue();
    }

    public Set<String> getBadColumnNames() {
        return _badColumnNames;
    }

    protected EntityCache getEntityCache() {
        return this.entityCache;
    }

    protected String getPKDBName() {
        return "structureVersionId";
    }

    protected String getSelectSQL() {
        return _SQL_SELECT_DDMSTRUCTUREVERSION;
    }

    public Set<String> getCTColumnNames(CTColumnResolutionType ctColumnResolutionType) {
        return _ctColumnNamesMap.getOrDefault(ctColumnResolutionType, Collections.emptySet());
    }

    public List<String> getMappingTableNames() {
        return _mappingTableNames;
    }

    public Map<String, Integer> getTableColumnsMap() {
        return DDMStructureVersionModelImpl.TABLE_COLUMNS_MAP;
    }

    public String getTableName() {
        return "DDMStructureVersion";
    }

    public List<String[]> getUniqueIndexColumnNames() {
        return _uniqueIndexColumnNames;
    }

    @Activate
    public void activate(BundleContext bundleContext) {
        this._bundleContext = bundleContext;
        this._argumentsResolverServiceRegistration = this._bundleContext.registerService(ArgumentsResolver.class, (Object)new DDMStructureVersionModelArgumentsResolver(), MapUtil.singletonDictionary((Object)"model.class.name", (Object)DDMStructureVersion.class.getName()));
        this._valueObjectFinderCacheListThreshold = GetterUtil.getInteger((String)PropsUtil.get((String)"value.object.finder.cache.list.threshold"));
        this._finderPathWithPaginationFindAll = this._createFinderPath(FINDER_CLASS_NAME_LIST_WITH_PAGINATION, "findAll", new String[0], new String[0], true);
        this._finderPathWithoutPaginationFindAll = this._createFinderPath(FINDER_CLASS_NAME_LIST_WITHOUT_PAGINATION, "findAll", new String[0], new String[0], true);
        this._finderPathCountAll = this._createFinderPath(FINDER_CLASS_NAME_LIST_WITHOUT_PAGINATION, "countAll", new String[0], new String[0], false);
        this._finderPathWithPaginationFindByStructureId = this._createFinderPath(FINDER_CLASS_NAME_LIST_WITH_PAGINATION, "findByStructureId", new String[]{Long.class.getName(), Integer.class.getName(), Integer.class.getName(), OrderByComparator.class.getName()}, new String[]{"structureId"}, true);
        this._finderPathWithoutPaginationFindByStructureId = this._createFinderPath(FINDER_CLASS_NAME_LIST_WITHOUT_PAGINATION, "findByStructureId", new String[]{Long.class.getName()}, new String[]{"structureId"}, true);
        this._finderPathCountByStructureId = this._createFinderPath(FINDER_CLASS_NAME_LIST_WITHOUT_PAGINATION, "countByStructureId", new String[]{Long.class.getName()}, new String[]{"structureId"}, false);
        this._finderPathFetchByS_V = this._createFinderPath(FINDER_CLASS_NAME_ENTITY, "fetchByS_V", new String[]{Long.class.getName(), String.class.getName()}, new String[]{"structureId", "version"}, true);
        this._finderPathCountByS_V = this._createFinderPath(FINDER_CLASS_NAME_LIST_WITHOUT_PAGINATION, "countByS_V", new String[]{Long.class.getName(), String.class.getName()}, new String[]{"structureId", "version"}, false);
        this._finderPathWithPaginationFindByS_S = this._createFinderPath(FINDER_CLASS_NAME_LIST_WITH_PAGINATION, "findByS_S", new String[]{Long.class.getName(), Integer.class.getName(), Integer.class.getName(), Integer.class.getName(), OrderByComparator.class.getName()}, new String[]{"structureId", "status"}, true);
        this._finderPathWithoutPaginationFindByS_S = this._createFinderPath(FINDER_CLASS_NAME_LIST_WITHOUT_PAGINATION, "findByS_S", new String[]{Long.class.getName(), Integer.class.getName()}, new String[]{"structureId", "status"}, true);
        this._finderPathCountByS_S = this._createFinderPath(FINDER_CLASS_NAME_LIST_WITHOUT_PAGINATION, "countByS_S", new String[]{Long.class.getName(), Integer.class.getName()}, new String[]{"structureId", "status"}, false);
        this._setDDMStructureVersionUtilPersistence(this);
    }

    @Deactivate
    public void deactivate() {
        this._setDDMStructureVersionUtilPersistence(null);
        this.entityCache.removeCache(DDMStructureVersionImpl.class.getName());
        this._argumentsResolverServiceRegistration.unregister();
        for (ServiceRegistration<FinderPath> serviceRegistration : this._serviceRegistrations) {
            serviceRegistration.unregister();
        }
    }

    private void _setDDMStructureVersionUtilPersistence(DDMStructureVersionPersistence ddmStructureVersionPersistence) {
        try {
            Field field = DDMStructureVersionUtil.class.getDeclaredField("_persistence");
            field.setAccessible(true);
            field.set(null, ddmStructureVersionPersistence);
        }
        catch (ReflectiveOperationException reflectiveOperationException) {
            throw new RuntimeException(reflectiveOperationException);
        }
    }

    @Reference(target="(&(origin.bundle.symbolic.name=com.liferay.dynamic.data.mapping.service)(name=service))", unbind="-")
    public void setConfiguration(Configuration configuration) {
    }

    @Reference(target="(origin.bundle.symbolic.name=com.liferay.dynamic.data.mapping.service)", unbind="-")
    public void setDataSource(DataSource dataSource) {
        super.setDataSource(dataSource);
    }

    @Reference(target="(origin.bundle.symbolic.name=com.liferay.dynamic.data.mapping.service)", unbind="-")
    public void setSessionFactory(SessionFactory sessionFactory) {
        super.setSessionFactory(sessionFactory);
    }

    private FinderPath _createFinderPath(String cacheName, String methodName, String[] params, String[] columnNames, boolean baseModelResult) {
        FinderPath finderPath = new FinderPath(cacheName, methodName, params, columnNames, baseModelResult);
        if (!cacheName.equals(FINDER_CLASS_NAME_LIST_WITH_PAGINATION)) {
            this._serviceRegistrations.add((ServiceRegistration<FinderPath>)this._bundleContext.registerService(FinderPath.class, (Object)finderPath, MapUtil.singletonDictionary((Object)"cache.name", (Object)cacheName)));
        }
        return finderPath;
    }

    static {
        HashSet<String> ctControlColumnNames = new HashSet<String>();
        HashSet<String> ctStrictColumnNames = new HashSet<String>();
        ctControlColumnNames.add("mvccVersion");
        ctControlColumnNames.add("ctCollectionId");
        ctStrictColumnNames.add("groupId");
        ctStrictColumnNames.add("companyId");
        ctStrictColumnNames.add("userId");
        ctStrictColumnNames.add("userName");
        ctStrictColumnNames.add("createDate");
        ctStrictColumnNames.add("structureId");
        ctStrictColumnNames.add("version");
        ctStrictColumnNames.add("parentStructureId");
        ctStrictColumnNames.add("name");
        ctStrictColumnNames.add("description");
        ctStrictColumnNames.add("definition");
        ctStrictColumnNames.add("storageType");
        ctStrictColumnNames.add("type_");
        ctStrictColumnNames.add("status");
        ctStrictColumnNames.add("statusByUserId");
        ctStrictColumnNames.add("statusByUserName");
        ctStrictColumnNames.add("statusDate");
        _ctColumnNamesMap.put(CTColumnResolutionType.CONTROL, ctControlColumnNames);
        _ctColumnNamesMap.put(CTColumnResolutionType.PK, Collections.singleton("structureVersionId"));
        _ctColumnNamesMap.put(CTColumnResolutionType.STRICT, ctStrictColumnNames);
        _uniqueIndexColumnNames.add(new String[]{"structureId", "version"});
        _log = LogFactoryUtil.getLog(DDMStructureVersionPersistenceImpl.class);
        _badColumnNames = SetUtil.fromArray((Object[])new String[]{"type"});
    }

    private static class DDMStructureVersionModelArgumentsResolver
    implements ArgumentsResolver {
        private static final Map<FinderPath, Long> _finderPathColumnBitmasksCache = new ConcurrentHashMap<FinderPath, Long>();

        private DDMStructureVersionModelArgumentsResolver() {
        }

        public Object[] getArguments(FinderPath finderPath, BaseModel<?> baseModel, boolean checkColumn, boolean original) {
            String[] columnNames = finderPath.getColumnNames();
            if (columnNames == null || columnNames.length == 0) {
                if (baseModel.isNew()) {
                    return new Object[0];
                }
                return null;
            }
            DDMStructureVersionModelImpl ddmStructureVersionModelImpl = (DDMStructureVersionModelImpl)baseModel;
            long columnBitmask = ddmStructureVersionModelImpl.getColumnBitmask();
            if (!checkColumn || columnBitmask == 0L) {
                return DDMStructureVersionModelArgumentsResolver._getValue(ddmStructureVersionModelImpl, columnNames, original);
            }
            Long finderPathColumnBitmask = _finderPathColumnBitmasksCache.get(finderPath);
            if (finderPathColumnBitmask == null) {
                finderPathColumnBitmask = 0L;
                for (String columnName : columnNames) {
                    finderPathColumnBitmask = finderPathColumnBitmask | DDMStructureVersionModelImpl.getColumnBitmask(columnName);
                }
                _finderPathColumnBitmasksCache.put(finderPath, finderPathColumnBitmask);
            }
            if ((columnBitmask & finderPathColumnBitmask) != 0L) {
                return DDMStructureVersionModelArgumentsResolver._getValue(ddmStructureVersionModelImpl, columnNames, original);
            }
            return null;
        }

        private static Object[] _getValue(DDMStructureVersionModelImpl ddmStructureVersionModelImpl, String[] columnNames, boolean original) {
            Object[] arguments = new Object[columnNames.length];
            for (int i = 0; i < arguments.length; ++i) {
                String columnName = columnNames[i];
                arguments[i] = original ? ddmStructureVersionModelImpl.getColumnOriginalValue(columnName) : ddmStructureVersionModelImpl.getColumnValue(columnName);
            }
            return arguments;
        }
    }
}

