/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.dynamic.data.mapping.internal.upgrade.v3_10_1;

import com.liferay.portal.kernel.dao.jdbc.AutoBatchPreparedStatementUtil;
import com.liferay.portal.kernel.json.JSONArray;
import com.liferay.portal.kernel.json.JSONException;
import com.liferay.portal.kernel.json.JSONFactory;
import com.liferay.portal.kernel.json.JSONObject;
import com.liferay.portal.kernel.upgrade.UpgradeProcess;
import com.liferay.portal.kernel.util.StringUtil;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;

public class UpgradeDDMFormInstance
extends UpgradeProcess {
    private final JSONFactory _jsonFactory;

    public UpgradeDDMFormInstance(JSONFactory jsonFactory) {
        this._jsonFactory = jsonFactory;
    }

    protected void doUpgrade() throws Exception {
        StringBuilder sb = new StringBuilder(4);
        sb.append("where settings_ not like '%workflowDefinition\\\",\\\"");
        sb.append("value\\\":\\\"[\\\\\\\\\"no-workflow\\\\\\\\\"]\\\"%' and ");
        sb.append("settings_ like '%workflowDefinition\\\",\\\"value\\\":\\\"");
        sb.append("[\\\\\\\\\"%@%\\\\\\\\\"]\\\"%'");
        try (PreparedStatement ps1 = this.connection.prepareStatement("select formInstanceId, settings_ from DDMFormInstance " + sb.toString());
             PreparedStatement ps2 = AutoBatchPreparedStatementUtil.concurrentAutoBatch((Connection)this.connection, (String)"update DDMFormInstance set settings_ = ? where formInstanceId = ?");
             PreparedStatement ps3 = this.connection.prepareStatement("select formInstanceVersionId, settings_ from DDMFormInstanceVersion " + sb.toString());
             PreparedStatement ps4 = AutoBatchPreparedStatementUtil.concurrentAutoBatch((Connection)this.connection, (String)"update DDMFormInstanceVersion set settings_ = ? where formInstanceVersionId = ?");){
            this._executePreparedStatements("formInstanceId", ps1, ps2);
            this._executePreparedStatements("formInstanceVersionId", ps3, ps4);
        }
    }

    private void _executePreparedStatements(String idColumnName, PreparedStatement selectPreparedStatement, PreparedStatement updatePreparedStatement) throws JSONException, SQLException {
        try (ResultSet rs = selectPreparedStatement.executeQuery();){
            while (rs.next()) {
                JSONObject settingsJSONObject = this._jsonFactory.createJSONObject(rs.getString("settings_"));
                if (!this._upgradeSettings(settingsJSONObject)) continue;
                updatePreparedStatement.setString(1, settingsJSONObject.toJSONString());
                updatePreparedStatement.setLong(2, rs.getLong(idColumnName));
                updatePreparedStatement.addBatch();
            }
        }
        updatePreparedStatement.executeBatch();
    }

    private boolean _upgradeSettings(JSONObject settingsJSONObject) {
        boolean upgraded = false;
        JSONArray fieldValuesJSONArray = settingsJSONObject.getJSONArray("fieldValues");
        for (int i = 0; i < fieldValuesJSONArray.length(); ++i) {
            JSONObject fieldValueJSONObject = fieldValuesJSONArray.getJSONObject(i);
            if (!StringUtil.equals((String)fieldValueJSONObject.getString("name"), (String)"workflowDefinition")) continue;
            String workflowDefinition = fieldValueJSONObject.getString("value");
            if (!workflowDefinition.matches("\\[\".+@\\d+\"\\]")) break;
            fieldValueJSONObject.put("value", workflowDefinition.replaceAll("@\\d+\"\\]", "\"]"));
            upgraded = true;
            break;
        }
        return upgraded;
    }
}

