/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.dynamic.data.mapping.internal.upgrade.v3_11_0;

import com.liferay.dynamic.data.mapping.io.DDMFormDeserializer;
import com.liferay.dynamic.data.mapping.io.DDMFormLayoutDeserializer;
import com.liferay.dynamic.data.mapping.io.DDMFormLayoutSerializer;
import com.liferay.dynamic.data.mapping.io.DDMFormLayoutSerializerSerializeRequest;
import com.liferay.dynamic.data.mapping.io.DDMFormLayoutSerializerSerializeResponse;
import com.liferay.dynamic.data.mapping.io.DDMFormSerializer;
import com.liferay.dynamic.data.mapping.model.DDMForm;
import com.liferay.dynamic.data.mapping.model.DDMFormField;
import com.liferay.dynamic.data.mapping.model.DDMFormLayout;
import com.liferay.dynamic.data.mapping.model.DDMFormLayoutColumn;
import com.liferay.dynamic.data.mapping.model.DDMFormLayoutPage;
import com.liferay.dynamic.data.mapping.model.DDMFormLayoutRow;
import com.liferay.dynamic.data.mapping.model.LocalizedValue;
import com.liferay.dynamic.data.mapping.util.DDMFormDeserializeUtil;
import com.liferay.dynamic.data.mapping.util.DDMFormLayoutDeserializeUtil;
import com.liferay.dynamic.data.mapping.util.DDMFormSerializeUtil;
import com.liferay.petra.string.StringBundler;
import com.liferay.portal.kernel.dao.jdbc.AutoBatchPreparedStatementUtil;
import com.liferay.portal.kernel.json.JSONArray;
import com.liferay.portal.kernel.json.JSONFactoryUtil;
import com.liferay.portal.kernel.json.JSONObject;
import com.liferay.portal.kernel.json.JSONUtil;
import com.liferay.portal.kernel.language.LanguageUtil;
import com.liferay.portal.kernel.upgrade.UpgradeProcess;
import com.liferay.portal.kernel.upgrade.util.UpgradeProcessUtil;
import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.kernel.util.PortalUtil;
import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.portal.kernel.util.Validator;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;

public class UpgradeDDMStructure
extends UpgradeProcess {
    private final DDMFormDeserializer _ddmFormDeserializer;
    private final DDMFormLayoutDeserializer _ddmFormLayoutDeserializer;
    private final DDMFormLayoutSerializer _ddmFormLayoutSerializer;
    private final DDMFormSerializer _ddmFormSerializer;
    private final Map<Long, DDMFormField> _fieldSetMap = new HashMap<Long, DDMFormField>();

    public UpgradeDDMStructure(DDMFormDeserializer ddmFormDeserializer, DDMFormLayoutDeserializer ddmFormLayoutDeserializer, DDMFormLayoutSerializer ddmFormLayoutSerializer, DDMFormSerializer ddmFormSerializer) {
        this._ddmFormDeserializer = ddmFormDeserializer;
        this._ddmFormLayoutDeserializer = ddmFormLayoutDeserializer;
        this._ddmFormLayoutSerializer = ddmFormLayoutSerializer;
        this._ddmFormSerializer = ddmFormSerializer;
    }

    protected void doUpgrade() throws Exception {
        this._upgradeStructureDefinition();
        this._upgradeStructureLayoutDefinition();
        this._upgradeStructureVersionDefinition();
    }

    private DDMFormField _createFieldSetDDMFormField(final Locale defaultLocale, String name, final Long parentStructureId, final Long parentStructureLayoutId) {
        return new DDMFormField(name, "fieldset"){
            {
                super(x0, x1);
                this.setDataType("string");
                this.setIndexType("keyword");
                this.setLabel(new LocalizedValue(){
                    {
                        this.addString(defaultLocale, "");
                    }
                });
                this.setLocalizable(true);
                this.setReadOnly(false);
                this.setPredefinedValue(new LocalizedValue(){
                    {
                        this.addString(defaultLocale, "");
                    }
                });
                this.setProperty("ddmStructureId", parentStructureId);
                this.setProperty("ddmStructureLayoutId", parentStructureLayoutId);
                this.setProperty("upgradedStructure", true);
                this.setRepeatable(false);
                this.setRequired(false);
                this.setShowLabel(false);
                this.setTip(new LocalizedValue(){
                    {
                        this.addString(defaultLocale, "");
                    }
                });
                this.setVisibilityExpression("");
            }
        };
    }

    private void _upgradeColorField(JSONObject jsonObject) {
        jsonObject.put("dataType", "string").put("type", "color").put("visibilityExpression", "");
    }

    private void _upgradeDateField(JSONObject jsonObject) {
        jsonObject.put("dataType", "string").put("type", "date").put("visibilityExpression", "");
    }

    private String _upgradeDDMFormLayoutDefinition(String content) throws Exception {
        DDMFormLayout ddmFormLayout = DDMFormLayoutDeserializeUtil.deserialize((DDMFormLayoutDeserializer)this._ddmFormLayoutDeserializer, (String)content);
        ddmFormLayout.setDefinitionSchemaVersion("2.0");
        ddmFormLayout.setPaginationMode("single-page");
        for (DDMFormLayoutPage ddmFormLayoutPage : ddmFormLayout.getDDMFormLayoutPages()) {
            LocalizedValue localizedValue = ddmFormLayoutPage.getTitle();
            if (localizedValue == null) {
                localizedValue = new LocalizedValue();
                localizedValue.addString(ddmFormLayout.getDefaultLocale(), LanguageUtil.get((Locale)ddmFormLayout.getDefaultLocale(), (String)"page"));
                for (Locale locale : ddmFormLayout.getAvailableLocales()) {
                    localizedValue.addString(locale, LanguageUtil.get((Locale)locale, (String)"page"));
                }
            } else if (Validator.isNull((String)localizedValue.getString(ddmFormLayout.getDefaultLocale()))) {
                localizedValue.addString(ddmFormLayout.getDefaultLocale(), LanguageUtil.get((Locale)ddmFormLayout.getDefaultLocale(), (String)"page"));
            }
            ddmFormLayoutPage.setTitle(localizedValue);
            localizedValue = ddmFormLayoutPage.getDescription();
            if (localizedValue == null) {
                localizedValue = new LocalizedValue();
                localizedValue.addString(ddmFormLayout.getDefaultLocale(), LanguageUtil.get((Locale)ddmFormLayout.getDefaultLocale(), (String)"description"));
                for (Locale locale : ddmFormLayout.getAvailableLocales()) {
                    localizedValue.addString(locale, LanguageUtil.get((Locale)locale, (String)"description"));
                }
            } else if (Validator.isNull((String)localizedValue.getString(ddmFormLayout.getDefaultLocale()))) {
                localizedValue.addString(ddmFormLayout.getDefaultLocale(), LanguageUtil.get((Locale)ddmFormLayout.getDefaultLocale(), (String)"description"));
            }
            ddmFormLayoutPage.setDescription(localizedValue);
        }
        DDMFormLayoutSerializerSerializeResponse ddmFormLayoutSerializerSerializeResponse = this._ddmFormLayoutSerializer.serialize(DDMFormLayoutSerializerSerializeRequest.Builder.newBuilder((DDMFormLayout)ddmFormLayout).build());
        return ddmFormLayoutSerializerSerializeResponse.getContent();
    }

    private String _upgradeDDMFormLayoutDefinition(String definition, Long structureId) throws Exception {
        DDMFormLayout ddmFormLayout = DDMFormLayoutDeserializeUtil.deserialize((DDMFormLayoutDeserializer)this._ddmFormLayoutDeserializer, (String)definition);
        DDMFormLayoutPage ddmFormLayoutPage = ddmFormLayout.getDDMFormLayoutPage(0);
        List ddmFormLayoutRowList = ddmFormLayoutPage.getDDMFormLayoutRows();
        DDMFormLayoutRow ddmFormLayoutRow = new DDMFormLayoutRow();
        DDMFormField ddmFormField = this._fieldSetMap.get(structureId);
        ddmFormLayoutRow.addDDMFormLayoutColumn(new DDMFormLayoutColumn(12, new String[]{ddmFormField.getName()}));
        ddmFormLayoutRowList.add(0, ddmFormLayoutRow);
        ddmFormLayoutPage.setDDMFormLayoutRows(ddmFormLayoutRowList);
        DDMFormLayoutSerializerSerializeResponse ddmFormLayoutSerializerSerializeResponse = this._ddmFormLayoutSerializer.serialize(DDMFormLayoutSerializerSerializeRequest.Builder.newBuilder((DDMFormLayout)ddmFormLayout).build());
        return ddmFormLayoutSerializerSerializeResponse.getContent();
    }

    private void _upgradeDecimalField(JSONObject jsonObject) {
        jsonObject.put("dataType", "double").put("type", "numeric").put("visibilityExpression", "");
    }

    private String _upgradeDefinition(long companyId, String definition) throws Exception {
        JSONObject jsonObject = JSONFactoryUtil.createJSONObject((String)definition);
        jsonObject.put("definitionSchemaVersion", "2.0").put("fields", this._upgradeFields(companyId, jsonObject.getJSONArray("fields")));
        return jsonObject.toString();
    }

    private String _upgradeDefinition(String definition, Long parentStructureId, Long parentStructureLayoutId, Long structureId) throws Exception {
        DDMForm ddmForm = DDMFormDeserializeUtil.deserialize((DDMFormDeserializer)this._ddmFormDeserializer, (String)definition);
        this._fieldSetMap.computeIfAbsent(structureId, key -> this._createFieldSetDDMFormField(ddmForm.getDefaultLocale(), StringUtil.randomString(), parentStructureId, parentStructureLayoutId));
        ddmForm.addDDMFormField(this._fieldSetMap.get(structureId));
        return DDMFormSerializeUtil.serialize((DDMForm)ddmForm, (DDMFormSerializer)this._ddmFormSerializer);
    }

    private void _upgradeDocumentLibraryField(JSONObject jsonObject) {
        jsonObject.put("dataType", "string").put("type", "document_library").put("visibilityExpression", "");
    }

    private JSONArray _upgradeFields(long companyId, JSONArray fieldsJSONArray) throws Exception {
        JSONArray jsonArray = JSONFactoryUtil.createJSONArray();
        if (fieldsJSONArray != null) {
            for (int i = 0; i < fieldsJSONArray.length(); ++i) {
                JSONObject jsonObject = fieldsJSONArray.getJSONObject(i);
                String type = jsonObject.getString("type");
                if (StringUtil.equals((String)type, (String)"ddm-color")) {
                    this._upgradeColorField(jsonObject);
                } else if (StringUtil.equals((String)type, (String)"ddm-date")) {
                    this._upgradeDateField(jsonObject);
                } else if (type.startsWith("ddm-decimal")) {
                    this._upgradeDecimalField(jsonObject);
                } else if (type.startsWith("ddm-documentlibrary")) {
                    this._upgradeDocumentLibraryField(jsonObject);
                } else if (type.startsWith("ddm-geolocation")) {
                    this._upgradeGeolocation(jsonObject);
                } else if (type.startsWith("ddm-image")) {
                    this._upgradeImageField(jsonObject);
                } else if (type.startsWith("ddm-integer")) {
                    this._upgradeIntegerField(jsonObject);
                } else if (type.startsWith("ddm-journal-article")) {
                    this._upgradeJournalArticleField(jsonObject);
                } else if (type.startsWith("ddm-link-to-page")) {
                    this._upgradeLinkToPageField(jsonObject);
                } else if (type.startsWith("ddm-number")) {
                    this._upgradeNumberField(jsonObject);
                } else if (StringUtil.equals((String)type, (String)"ddm-separator")) {
                    this._upgradeSeparatorField(jsonObject);
                } else if (type.startsWith("ddm-text-html")) {
                    this._upgradeHTMLField(jsonObject);
                } else if (type.startsWith("ddm-")) {
                    jsonObject.put("dataType", "string").put("type", type.substring(4));
                } else if (StringUtil.equals((String)type, (String)"select")) {
                    this._upgradeSelectField(jsonObject);
                } else if (StringUtil.equals((String)type, (String)"text")) {
                    this._upgradeTextField(companyId, jsonObject);
                } else if (StringUtil.equals((String)type, (String)"textarea")) {
                    this._upgradeTextArea(companyId, jsonObject);
                }
                if (!StringUtil.equals((String)type, (String)"separator") && Validator.isNull((String)jsonObject.getString("indexType"))) {
                    jsonObject.put("indexType", "none");
                }
                if (jsonObject.has("nestedFields")) {
                    jsonObject.put("nestedFields", this._upgradeFields(companyId, jsonObject.getJSONArray("nestedFields")));
                }
                jsonArray.put(jsonObject);
            }
        }
        return jsonArray;
    }

    private void _upgradeGeolocation(JSONObject jsonObject) {
        jsonObject.put("dataType", "string").put("type", "geolocation");
    }

    private void _upgradeHTMLField(JSONObject jsonObject) {
        jsonObject.put("dataType", "string").put("type", "rich_text").put("visibilityExpression", "");
    }

    private void _upgradeImageField(JSONObject jsonObject) {
        jsonObject.put("type", "image").put("visibilityExpression", "");
    }

    private void _upgradeIntegerField(JSONObject jsonObject) {
        jsonObject.put("type", "numeric").put("visibilityExpression", "");
    }

    private void _upgradeJournalArticleField(JSONObject jsonObject) {
        jsonObject.put("dataType", "string").put("type", "journal_article");
    }

    private void _upgradeLinkToPageField(JSONObject jsonObject) {
        jsonObject.put("dataType", "link-to-page").put("type", "link_to_layout");
    }

    private void _upgradeNumberField(JSONObject jsonObject) {
        jsonObject.put("dataType", "double").put("type", "numeric").put("visibilityExpression", "");
    }

    private String _upgradeParentStructureDefinition(String definition, Long parentStructureId, Long structureId) throws Exception {
        StringBundler sb1 = new StringBundler(8);
        sb1.append("select DDMStructureLayout.structureLayoutId  from ");
        sb1.append("DDMStructureLayout inner join DDMStructureVersion on ");
        sb1.append("DDMStructureVersion.structureVersionId = ");
        sb1.append("DDMStructureLayout.structureVersionId inner join ");
        sb1.append("DDMStructure on DDMStructure.structureId = ");
        sb1.append("DDMStructureVersion.structureId and DDMStructure.version ");
        sb1.append("= DDMStructureVersion.version where ");
        sb1.append("DDMStructure.structureId = ?");
        try (PreparedStatement ps1 = this.connection.prepareStatement(sb1.toString());){
            ps1.setLong(1, parentStructureId);
            try (ResultSet rs = ps1.executeQuery();){
                if (rs.next()) {
                    String string = this._upgradeDefinition(definition, parentStructureId, rs.getLong("structureLayoutId"), structureId);
                    return string;
                }
            }
        }
        return definition;
    }

    private void _upgradeSelectField(JSONObject jsonObject) {
        jsonObject.put("dataSourceType", "[manual]").put("ddmDataProviderInstanceId", "[]").put("ddmDataProviderInstanceOutput", "[]").put("fieldNamespace", "").put("visibilityExpression", "");
    }

    private void _upgradeSeparatorField(JSONObject jsonObject) {
        jsonObject.put("dataType", "").put("type", "separator");
    }

    private void _upgradeStructureDefinition() throws Exception {
        try (PreparedStatement ps1 = this.connection.prepareStatement("select * from DDMStructure where classNameId = ? or classNameId = ? order by createDate");
             PreparedStatement ps2 = AutoBatchPreparedStatementUtil.concurrentAutoBatch((Connection)this.connection, (String)"update DDMStructure set definition = ? where structureId = ?");){
            ps1.setLong(1, PortalUtil.getClassNameId((String)"com.liferay.document.library.kernel.model.DLFileEntryMetadata"));
            ps1.setLong(2, PortalUtil.getClassNameId((String)"com.liferay.journal.model.JournalArticle"));
            try (ResultSet rs = ps1.executeQuery();){
                while (rs.next()) {
                    String definition = rs.getString("definition");
                    if (Validator.isNotNull((Long)rs.getLong("parentStructureId"))) {
                        definition = this._upgradeParentStructureDefinition(definition, rs.getLong("parentStructureId"), rs.getLong("structureId"));
                    }
                    ps2.setString(1, this._upgradeDefinition(rs.getLong("companyId"), definition));
                    ps2.setLong(2, rs.getLong("structureId"));
                    ps2.addBatch();
                }
                ps2.executeBatch();
            }
        }
    }

    private void _upgradeStructureLayoutDefinition() throws Exception {
        StringBundler sb1 = new StringBundler(13);
        sb1.append("select DDMStructure.structureId, ");
        sb1.append("DDMStructure.parentStructureId, DDMStructure.classNameId ");
        sb1.append(", DDMStructure.structureKey, ");
        sb1.append("DDMStructureLayout.structureLayoutId, ");
        sb1.append("DDMStructureLayout.definition from DDMStructureLayout ");
        sb1.append("inner join DDMStructureVersion on ");
        sb1.append("DDMStructureVersion.structureVersionId = ");
        sb1.append("DDMStructureLayout.structureVersionId inner join ");
        sb1.append("DDMStructure on DDMStructure.structureId = ");
        sb1.append("DDMStructureVersion.structureId and DDMStructure.version ");
        sb1.append("= DDMStructureVersion.version where ");
        sb1.append("DDMStructure.classNameId = ? or DDMStructure.classNameId ");
        sb1.append("= ?");
        try (PreparedStatement ps1 = this.connection.prepareStatement(sb1.toString());
             PreparedStatement ps2 = AutoBatchPreparedStatementUtil.concurrentAutoBatch((Connection)this.connection, (String)"update DDMStructureLayout set definition = ?, classNameId = ?, structureLayoutKey = ? where structureLayoutId = ?");){
            ps1.setLong(1, PortalUtil.getClassNameId((String)"com.liferay.document.library.kernel.model.DLFileEntryMetadata"));
            ps1.setLong(2, PortalUtil.getClassNameId((String)"com.liferay.journal.model.JournalArticle"));
            try (ResultSet rs = ps1.executeQuery();){
                while (rs.next()) {
                    String definition = rs.getString("definition");
                    if (Validator.isNotNull((Long)rs.getLong("parentStructureId"))) {
                        definition = this._upgradeDDMFormLayoutDefinition(definition, rs.getLong("structureId"));
                    }
                    ps2.setString(1, this._upgradeDDMFormLayoutDefinition(definition));
                    ps2.setLong(2, rs.getLong("classNameId"));
                    ps2.setString(3, rs.getString("structureKey"));
                    ps2.setLong(4, rs.getLong("structureLayoutId"));
                    ps2.addBatch();
                }
                ps2.executeBatch();
            }
        }
    }

    private void _upgradeStructureVersionDefinition() throws Exception {
        StringBundler sb1 = new StringBundler(6);
        sb1.append("select DDMStructure.structureKey, DDMStructureVersion.* ");
        sb1.append("from DDMStructureVersion inner join DDMStructure on ");
        sb1.append("DDMStructure.structureId = ");
        sb1.append("DDMStructureVersion.structureId where ");
        sb1.append("DDMStructure.classNameId = ? or DDMStructure.classNameId ");
        sb1.append("= ?");
        try (PreparedStatement ps1 = this.connection.prepareStatement(sb1.toString());
             PreparedStatement ps2 = AutoBatchPreparedStatementUtil.concurrentAutoBatch((Connection)this.connection, (String)"update DDMStructureVersion set definition = ? where structureVersionId = ?");){
            ps1.setLong(1, PortalUtil.getClassNameId((String)"com.liferay.document.library.kernel.model.DLFileEntryMetadata"));
            ps1.setLong(2, PortalUtil.getClassNameId((String)"com.liferay.journal.model.JournalArticle"));
            try (ResultSet rs = ps1.executeQuery();){
                while (rs.next()) {
                    String definition = rs.getString("definition");
                    if (Validator.isNotNull((Long)rs.getLong("parentStructureId"))) {
                        definition = this._upgradeParentStructureDefinition(definition, rs.getLong("parentStructureId"), rs.getLong("structureId"));
                    }
                    ps2.setString(1, this._upgradeDefinition(rs.getLong("companyId"), definition));
                    ps2.setLong(2, rs.getLong("structureVersionId"));
                    ps2.addBatch();
                }
                ps2.executeBatch();
            }
        }
    }

    private void _upgradeTextArea(long companyId, JSONObject jsonObject) throws Exception {
        jsonObject.put("autocomplete", false).put("dataSourceType", "manual").put("ddmDataProviderInstanceId", "[]").put("ddmDataProviderInstanceOutput", "[]").put("displayStyle", "multiline").put("fieldNamespace", "").put("options", JSONUtil.put((Object)JSONUtil.put((String)"label", (Object)JSONUtil.put((String)UpgradeProcessUtil.getDefaultLanguageId((long)companyId), (Object)GetterUtil.getString((String)"Option"))).put("value", "Option"))).put("placeholder", JSONUtil.put((String)UpgradeProcessUtil.getDefaultLanguageId((long)companyId), (Object)"")).put("tooltip", JSONUtil.put((String)UpgradeProcessUtil.getDefaultLanguageId((long)companyId), (Object)"")).put("type", "text").put("visibilityExpression", "");
    }

    private void _upgradeTextField(long companyId, JSONObject jsonObject) throws Exception {
        jsonObject.put("autocomplete", false).put("dataSourceType", "manual").put("ddmDataProviderInstanceId", "[]").put("ddmDataProviderInstanceOutput", "[]").put("displayStyle", "singleline").put("fieldNamespace", "").put("options", JSONUtil.put((Object)JSONUtil.put((String)"label", (Object)JSONUtil.put((String)UpgradeProcessUtil.getDefaultLanguageId((long)companyId), (Object)GetterUtil.getString((String)"Option"))).put("value", "Option"))).put("placeholder", JSONUtil.put((String)UpgradeProcessUtil.getDefaultLanguageId((long)companyId), (Object)"")).put("tooltip", JSONUtil.put((String)UpgradeProcessUtil.getDefaultLanguageId((long)companyId), (Object)"")).put("type", "text").put("visibilityExpression", "");
    }
}

