/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.dynamic.data.mapping.internal.upgrade.v3_8_1;

import com.liferay.portal.kernel.dao.jdbc.AutoBatchPreparedStatementUtil;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.json.JSONArray;
import com.liferay.portal.kernel.json.JSONFactory;
import com.liferay.portal.kernel.json.JSONObject;
import com.liferay.portal.kernel.json.JSONUtil;
import com.liferay.portal.kernel.upgrade.UpgradeProcess;
import com.liferay.portal.kernel.util.PortalUtil;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;

public class UpgradeDDMFormFieldDataSourceType
extends UpgradeProcess {
    private final JSONFactory _jsonFactory;

    public UpgradeDDMFormFieldDataSourceType(JSONFactory jsonFactory) {
        this._jsonFactory = jsonFactory;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected void doUpgrade() throws Exception {
        try (PreparedStatement ps1 = this.connection.prepareStatement("select structureId, definition from DDMStructure where classNameId = ? ");
             PreparedStatement ps2 = AutoBatchPreparedStatementUtil.concurrentAutoBatch((Connection)this.connection, (String)"update DDMStructure set definition = ? where structureId = ?");
             PreparedStatement ps3 = this.connection.prepareStatement("select structureVersionId, definition from DDMStructureVersion where structureId = ?");
             PreparedStatement ps4 = AutoBatchPreparedStatementUtil.concurrentAutoBatch((Connection)this.connection, (String)"update DDMStructureVersion set definition = ? where structureVersionId = ?");){
            ps1.setLong(1, PortalUtil.getClassNameId((String)"com.liferay.dynamic.data.mapping.model.DDMFormInstance"));
            try (ResultSet rs = ps1.executeQuery();){
                while (rs.next()) {
                    ResultSet rs2;
                    block71: {
                        String definition = rs.getString("definition");
                        ps2.setString(1, this._upgradeDefinition(definition));
                        long structureId = rs.getLong("structureId");
                        ps2.setLong(2, structureId);
                        ps2.addBatch();
                        ps3.setLong(1, structureId);
                        rs2 = ps3.executeQuery();
                        Throwable throwable = null;
                        try {
                            while (rs2.next()) {
                                definition = rs2.getString("definition");
                                ps4.setString(1, this._upgradeDefinition(definition));
                                long structureVersionId = rs2.getLong("structureVersionId");
                                ps4.setLong(2, structureVersionId);
                                ps4.addBatch();
                            }
                            if (rs2 == null) continue;
                            if (throwable == null) break block71;
                        }
                        catch (Throwable throwable2) {
                            try {
                                throwable = throwable2;
                                throw throwable2;
                            }
                            catch (Throwable throwable3) {
                                if (rs2 == null) throw throwable3;
                                if (throwable == null) {
                                    rs2.close();
                                    throw throwable3;
                                }
                                try {
                                    rs2.close();
                                    throw throwable3;
                                }
                                catch (Throwable throwable4) {
                                    throwable.addSuppressed(throwable4);
                                    throw throwable3;
                                }
                            }
                        }
                        try {
                            rs2.close();
                            continue;
                        }
                        catch (Throwable throwable5) {
                            throwable.addSuppressed(throwable5);
                            continue;
                        }
                    }
                    rs2.close();
                }
            }
            ps2.executeBatch();
            ps4.executeBatch();
            return;
        }
    }

    private String _upgradeDefinition(String definition) throws PortalException {
        JSONObject jsonObject = this._jsonFactory.createJSONObject(definition);
        this._upgradeFields(jsonObject.getJSONArray("fields"));
        return jsonObject.toJSONString();
    }

    private void _upgradeFields(JSONArray fieldsJSONArray) {
        for (int i = 0; i < fieldsJSONArray.length(); ++i) {
            JSONArray nestedFieldsJSONArray;
            String dataSourceTypeString;
            JSONObject jsonObject = fieldsJSONArray.getJSONObject(i);
            Object dataSourceType = jsonObject.get("dataSourceType");
            if (!(!(dataSourceType instanceof String) || (dataSourceTypeString = (String)dataSourceType).startsWith("[") && dataSourceTypeString.endsWith("]"))) {
                jsonObject.put("dataSourceType", JSONUtil.put((Object)dataSourceType).toString());
            }
            if ((nestedFieldsJSONArray = jsonObject.getJSONArray("nestedFields")) == null) continue;
            this._upgradeFields(nestedFieldsJSONArray);
        }
    }
}

