/**
 * Copyright (c) 2000-present Liferay, Inc. All rights reserved.
 *
 * This library is free software; you can redistribute it and/or modify it under
 * the terms of the GNU Lesser General Public License as published by the Free
 * Software Foundation; either version 2.1 of the License, or (at your option)
 * any later version.
 *
 * This library is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE. See the GNU Lesser General Public License for more
 * details.
 */

package com.liferay.dynamic.data.mapping.model.impl;

import com.liferay.dynamic.data.mapping.model.DDMFormInstanceReport;
import com.liferay.dynamic.data.mapping.service.DDMFormInstanceReportLocalServiceUtil;

/**
 * The extended model base implementation for the DDMFormInstanceReport service. Represents a row in the &quot;DDMFormInstanceReport&quot; database table, with each column mapped to a property of this class.
 *
 * <p>
 * This class exists only as a container for the default extended model level methods generated by ServiceBuilder. Helper methods and all application logic should be put in {@link DDMFormInstanceReportImpl}.
 * </p>
 *
 * @author Brian Wing Shun Chan
 * @see DDMFormInstanceReportImpl
 * @see DDMFormInstanceReport
 * @generated
 */
public abstract class DDMFormInstanceReportBaseImpl
	extends DDMFormInstanceReportModelImpl implements DDMFormInstanceReport {

	/*
	 * NOTE FOR DEVELOPERS:
	 *
	 * Never modify or reference this class directly. All methods that expect a ddm form instance report model instance should use the <code>DDMFormInstanceReport</code> interface instead.
	 */
	@Override
	public void persist() {
		if (this.isNew()) {
			DDMFormInstanceReportLocalServiceUtil.addDDMFormInstanceReport(
				this);
		}
		else {
			DDMFormInstanceReportLocalServiceUtil.updateDDMFormInstanceReport(
				this);
		}
	}

}