/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.dynamic.data.mapping.service.impl;

import com.liferay.dynamic.data.mapping.model.DDMStorageLink;
import com.liferay.dynamic.data.mapping.model.DDMStructureVersion;
import com.liferay.dynamic.data.mapping.model.DDMStructureVersionModel;
import com.liferay.dynamic.data.mapping.service.DDMStructureVersionLocalService;
import com.liferay.dynamic.data.mapping.service.base.DDMStorageLinkLocalServiceBaseImpl;
import com.liferay.portal.aop.AopService;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.model.BaseModel;
import com.liferay.portal.kernel.service.ServiceContext;
import com.liferay.portal.kernel.util.ListUtil;
import java.util.List;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component(property={"model.class.name=com.liferay.dynamic.data.mapping.model.DDMStorageLink"}, service={AopService.class})
public class DDMStorageLinkLocalServiceImpl
extends DDMStorageLinkLocalServiceBaseImpl {
    @Reference
    private DDMStructureVersionLocalService _ddmStructureVersionLocalService;

    public DDMStorageLink addStorageLink(long classNameId, long classPK, long structureVersionId, ServiceContext serviceContext) throws PortalException {
        DDMStructureVersion ddmStructureVersion = this._ddmStructureVersionLocalService.getDDMStructureVersion(structureVersionId);
        long storageLinkId = this.counterLocalService.increment();
        DDMStorageLink storageLink = this.ddmStorageLinkPersistence.create(storageLinkId);
        storageLink.setClassNameId(classNameId);
        storageLink.setClassPK(classPK);
        storageLink.setStructureId(ddmStructureVersion.getStructureId());
        storageLink.setStructureVersionId(structureVersionId);
        return (DDMStorageLink)this.ddmStorageLinkPersistence.update((BaseModel)storageLink);
    }

    public void deleteClassStorageLink(long classPK) {
        DDMStorageLink storageLink = this.ddmStorageLinkPersistence.fetchByClassPK(classPK);
        if (storageLink != null) {
            this.deleteStorageLink(storageLink);
        }
    }

    public void deleteStorageLink(DDMStorageLink storageLink) {
        this.ddmStorageLinkPersistence.remove((BaseModel)storageLink);
    }

    public void deleteStorageLink(long storageLinkId) {
        DDMStorageLink storageLink = this.ddmStorageLinkPersistence.fetchByPrimaryKey(storageLinkId);
        if (storageLink != null) {
            this.deleteStorageLink(storageLink);
        }
    }

    public void deleteStructureStorageLinks(long structureId) {
        List storageLinks = this.ddmStorageLinkPersistence.findByStructureId(structureId);
        for (DDMStorageLink storageLink : storageLinks) {
            this.deleteStorageLink(storageLink);
        }
    }

    public DDMStorageLink getClassStorageLink(long classPK) throws PortalException {
        return this.ddmStorageLinkPersistence.findByClassPK(classPK);
    }

    public DDMStorageLink getStorageLink(long storageLinkId) throws PortalException {
        return this.ddmStorageLinkPersistence.findByPrimaryKey(storageLinkId);
    }

    public List<DDMStorageLink> getStructureStorageLinks(long structureId) {
        return this.ddmStorageLinkPersistence.findByStructureVersionId(ListUtil.toLongArray((List)this._ddmStructureVersionLocalService.getStructureVersions(structureId), DDMStructureVersionModel::getStructureVersionId));
    }

    public int getStructureStorageLinksCount(long structureId) {
        return this.ddmStorageLinkPersistence.countByStructureVersionId(ListUtil.toLongArray((List)this._ddmStructureVersionLocalService.getStructureVersions(structureId), DDMStructureVersionModel::getStructureVersionId));
    }

    public List<DDMStorageLink> getStructureVersionStorageLinks(long structureVersionId) {
        return this.ddmStorageLinkPersistence.findByStructureVersionId(structureVersionId);
    }

    public int getStructureVersionStorageLinksCount(long structureVersionId) {
        return this.ddmStorageLinkPersistence.countByStructureVersionId(structureVersionId);
    }

    public DDMStorageLink updateStorageLink(long storageLinkId, long classNameId, long classPK) throws PortalException {
        DDMStorageLink storageLink = this.ddmStorageLinkPersistence.findByPrimaryKey(storageLinkId);
        storageLink.setClassNameId(classNameId);
        storageLink.setClassPK(classPK);
        return (DDMStorageLink)this.ddmStorageLinkPersistence.update((BaseModel)storageLink);
    }
}

