/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.dynamic.data.mapping.internal.upgrade.v3_7_3;

import com.liferay.dynamic.data.mapping.internal.report.CheckboxMultipleDDMFormFieldTypeReportProcessor;
import com.liferay.dynamic.data.mapping.internal.report.NumericDDMFormFieldTypeReportProcessor;
import com.liferay.dynamic.data.mapping.internal.report.RadioDDMFormFieldTypeReportProcessor;
import com.liferay.dynamic.data.mapping.internal.report.TextDDMFormFieldTypeReportProcessor;
import com.liferay.dynamic.data.mapping.io.DDMFormDeserializer;
import com.liferay.dynamic.data.mapping.model.DDMForm;
import com.liferay.dynamic.data.mapping.model.DDMFormField;
import com.liferay.dynamic.data.mapping.model.DDMFormFieldOptions;
import com.liferay.dynamic.data.mapping.model.LocalizedValue;
import com.liferay.dynamic.data.mapping.model.UnlocalizedValue;
import com.liferay.dynamic.data.mapping.model.Value;
import com.liferay.dynamic.data.mapping.report.DDMFormFieldTypeReportProcessor;
import com.liferay.dynamic.data.mapping.storage.DDMFormFieldValue;
import com.liferay.dynamic.data.mapping.storage.DDMFormValues;
import com.liferay.dynamic.data.mapping.util.DDMFormDeserializeUtil;
import com.liferay.portal.kernel.dao.jdbc.AutoBatchPreparedStatementUtil;
import com.liferay.portal.kernel.json.JSONArray;
import com.liferay.portal.kernel.json.JSONException;
import com.liferay.portal.kernel.json.JSONFactory;
import com.liferay.portal.kernel.json.JSONFactoryUtil;
import com.liferay.portal.kernel.json.JSONObject;
import com.liferay.portal.kernel.json.JSONUtil;
import com.liferay.portal.kernel.upgrade.UpgradeException;
import com.liferay.portal.kernel.upgrade.UpgradeProcess;
import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.kernel.util.LocaleUtil;
import com.liferay.portal.kernel.util.StringBundler;
import com.liferay.portal.kernel.util.StringUtil;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.Set;

public class UpgradeDDMFormInstanceReport
extends UpgradeProcess {
    private final DDMFormDeserializer _ddmFormDeserializer;
    private DDMFormFieldTypeReportProcessorTracker _ddmFormFieldTypeReportProcessorTracker = new DDMFormFieldTypeReportProcessorTracker();
    private final JSONFactory _jsonFactory;

    public UpgradeDDMFormInstanceReport(DDMFormDeserializer ddmFormDeserializer, JSONFactory jsonFactory) {
        this._ddmFormDeserializer = ddmFormDeserializer;
        this._jsonFactory = jsonFactory;
    }

    protected void doUpgrade() throws Exception {
        this.runSQL("delete from DDMFormInstanceReport;");
        StringBundler sb1 = new StringBundler(12);
        sb1.append("select DDMContent.data_, ");
        sb1.append("DDMFormInstanceRecord.formInstanceRecordId from ");
        sb1.append("DDMContent inner join DDMFormInstanceRecordVersion on ");
        sb1.append("DDMContent.contentId = ");
        sb1.append("DDMFormInstanceRecordVersion.storageId inner join ");
        sb1.append("DDMFormInstanceRecord on ");
        sb1.append("DDMFormInstanceRecord.formInstanceRecordId = ");
        sb1.append("DDMFormInstanceRecordVersion.formInstanceRecordId where ");
        sb1.append("DDMFormInstanceRecord.version = ");
        sb1.append("DDMFormInstanceRecordVersion.version and ");
        sb1.append("DDMFormInstanceRecord.formInstanceId = ? and ");
        sb1.append("DDMFormInstanceRecordVersion.status = ?");
        StringBundler sb2 = new StringBundler(3);
        sb2.append("insert into DDMFormInstanceReport (formInstanceReportId, ");
        sb2.append("groupId, companyId, createDate, modifiedDate, ");
        sb2.append("formInstanceId, data_) values (?, ?, ?, ?, ?, ?, ?)");
        try (PreparedStatement ps1 = this.connection.prepareStatement("select formInstanceId, groupId, companyId, createDate, structureId from DDMFormInstance");){
            ResultSet rs1 = ps1.executeQuery();
            while (rs1.next()) {
                long formInstanceId = rs1.getLong("formInstanceId");
                long structureId = rs1.getLong("structureId");
                DDMForm ddmForm = this._getDDMForm(structureId);
                JSONObject dataJSONObject = this._jsonFactory.createJSONObject();
                try (PreparedStatement ps2 = this.connection.prepareStatement(sb1.toString());){
                    ps2.setLong(1, formInstanceId);
                    ps2.setInt(2, 0);
                    ResultSet rs2 = ps2.executeQuery();
                    while (rs2.next()) {
                        String data = rs2.getString("data_");
                        long formInstanceRecordId = rs2.getLong("formInstanceRecordId");
                        DDMFormValues ddmFormValues = this._getDDMFormValues(data, ddmForm);
                        dataJSONObject = this._processDDMFormValues(dataJSONObject, ddmFormValues, formInstanceRecordId);
                        dataJSONObject.put("totalItems", dataJSONObject.getInt("totalItems") + 1);
                    }
                }
                long groupId = rs1.getLong("groupId");
                long companyId = rs1.getLong("companyId");
                Timestamp createDate = rs1.getTimestamp("createDate");
                PreparedStatement ps3 = AutoBatchPreparedStatementUtil.concurrentAutoBatch((Connection)this.connection, (String)sb2.toString());
                Throwable throwable = null;
                try {
                    ps3.setLong(1, this.increment());
                    ps3.setLong(2, groupId);
                    ps3.setLong(3, companyId);
                    ps3.setTimestamp(4, createDate);
                    ps3.setTimestamp(5, createDate);
                    ps3.setLong(6, formInstanceId);
                    ps3.setString(7, dataJSONObject.toString());
                    ps3.execute();
                }
                catch (Throwable throwable2) {
                    throwable = throwable2;
                    throw throwable2;
                }
                finally {
                    if (ps3 == null) continue;
                    if (throwable != null) {
                        try {
                            ps3.close();
                        }
                        catch (Throwable throwable3) {
                            throwable.addSuppressed(throwable3);
                        }
                        continue;
                    }
                    ps3.close();
                }
            }
        }
    }

    /*
     * Loose catch block
     */
    private DDMForm _getDDMForm(long structureId) throws Exception {
        Throwable throwable = null;
        try (PreparedStatement ps = this.connection.prepareStatement("select definition from DDMStructure where structureId = ?");){
            Throwable throwable2;
            ResultSet rs;
            block29: {
                DDMForm dDMForm;
                block30: {
                    block31: {
                        ps.setLong(1, structureId);
                        rs = ps.executeQuery();
                        throwable2 = null;
                        if (!rs.next()) break block29;
                        dDMForm = DDMFormDeserializeUtil.deserialize((DDMFormDeserializer)this._ddmFormDeserializer, (String)rs.getString("definition"));
                        if (rs == null) break block30;
                        if (throwable2 == null) break block31;
                        try {
                            rs.close();
                        }
                        catch (Throwable throwable3) {
                            throwable2.addSuppressed(throwable3);
                        }
                        break block30;
                    }
                    rs.close();
                }
                return dDMForm;
            }
            try {
                block32: {
                    if (rs != null) {
                        if (throwable2 != null) {
                            try {
                                rs.close();
                            }
                            catch (Throwable throwable4) {
                                throwable2.addSuppressed(throwable4);
                            }
                        } else {
                            rs.close();
                        }
                    }
                    break block32;
                    catch (Throwable throwable5) {
                        try {
                            throwable2 = throwable5;
                            throw throwable5;
                        }
                        catch (Throwable throwable6) {
                            if (rs != null) {
                                if (throwable2 != null) {
                                    try {
                                        rs.close();
                                    }
                                    catch (Throwable throwable7) {
                                        throwable2.addSuppressed(throwable7);
                                    }
                                } else {
                                    rs.close();
                                }
                            }
                            throw throwable6;
                        }
                    }
                }
                throw new UpgradeException("Unable to find dynamic data mapping structure with ID " + structureId);
            }
            catch (Throwable throwable8) {
                throwable = throwable8;
                throw throwable8;
            }
        }
    }

    private DDMFormValues _getDDMFormValues(String data, DDMForm ddmForm) throws Exception {
        DDMFormValues ddmFormValues = new DDMFormValues(ddmForm);
        ArrayList<DDMFormFieldValue> ddmFormFieldValues = new ArrayList<DDMFormFieldValue>();
        JSONObject dataJSONObject = this._jsonFactory.createJSONObject(data);
        JSONArray fieldValuesJSONArray = dataJSONObject.getJSONArray("fieldValues");
        for (JSONObject jsonObject : fieldValuesJSONArray) {
            DDMFormFieldValue ddmFormFieldValue = new DDMFormFieldValue();
            ddmFormFieldValue.setDDMFormValues(ddmFormValues);
            ddmFormFieldValue.setInstanceId(jsonObject.getString("instanceId"));
            ddmFormFieldValue.setName(jsonObject.getString("name"));
            DDMFormField ddmFormField = ddmFormFieldValue.getDDMFormField();
            LocalizedValue value = null;
            if (ddmFormField.isLocalizable()) {
                value = new LocalizedValue();
                JSONObject valueJSONObject = jsonObject.getJSONObject("value");
                if (valueJSONObject == null) continue;
                for (String languageId : valueJSONObject.keySet()) {
                    value.addString(LocaleUtil.fromLanguageId((String)languageId), GetterUtil.getString((String)valueJSONObject.getString(languageId)));
                }
            } else {
                value = new UnlocalizedValue(GetterUtil.getString((Object)jsonObject.get("value")));
            }
            ddmFormFieldValue.setValue((Value)value);
            ddmFormFieldValues.add(ddmFormFieldValue);
        }
        ddmFormValues.setDDMFormFieldValues(ddmFormFieldValues);
        return ddmFormValues;
    }

    private JSONObject _processDDMFormValues(JSONObject dataJSONObject, DDMFormValues ddmFormValues, long formInstanceRecordId) throws Exception, JSONException {
        for (DDMFormFieldValue ddmFormFieldValue : ddmFormValues.getDDMFormFieldValues()) {
            DDMFormFieldTypeReportProcessor ddmFormFieldTypeReportProcessor = this._ddmFormFieldTypeReportProcessorTracker.getDDMFormFieldTypeReportProcessor(ddmFormFieldValue.getDDMFormField(), ddmFormFieldValue.getType());
            if (ddmFormFieldTypeReportProcessor == null) continue;
            String ddmFormFieldValueName = ddmFormFieldValue.getName();
            JSONObject fieldJSONObject = dataJSONObject.getJSONObject(ddmFormFieldValueName);
            if (fieldJSONObject == null) {
                fieldJSONObject = JSONUtil.put((String)"type", (Object)ddmFormFieldValue.getType()).put("values", this._jsonFactory.createJSONObject());
            }
            JSONObject processedFieldJSONObject = ddmFormFieldTypeReportProcessor.process(ddmFormFieldValue, this._jsonFactory.createJSONObject(fieldJSONObject.toJSONString()), formInstanceRecordId, "add");
            dataJSONObject.put(ddmFormFieldValueName, processedFieldJSONObject);
        }
        return dataJSONObject;
    }

    private class UpgradeGridDDMFormFieldTypeReportProcessor
    implements DDMFormFieldTypeReportProcessor {
        private final DDMFormField _ddmFormField;

        public UpgradeGridDDMFormFieldTypeReportProcessor(DDMFormField ddmFormField) {
            this._ddmFormField = ddmFormField;
        }

        public JSONObject process(DDMFormFieldValue ddmFormFieldValue, JSONObject fieldJSONObject, long formInstanceRecordId, String ddmFormInstanceReportEvent) throws Exception {
            JSONObject valuesJSONObject = fieldJSONObject.getJSONObject("values");
            Value value = ddmFormFieldValue.getValue();
            JSONObject valueJSONObject = JSONFactoryUtil.createJSONObject((String)value.getString(value.getDefaultLocale()));
            Iterator iterator = valueJSONObject.keys();
            while (iterator.hasNext()) {
                String rowName = (String)iterator.next();
                JSONObject rowJSONObject = valuesJSONObject.getJSONObject(rowName);
                if (rowJSONObject == null) {
                    rowJSONObject = JSONFactoryUtil.createJSONObject();
                }
                String columnName = valueJSONObject.getString(rowName);
                rowJSONObject.put(columnName, rowJSONObject.getInt(columnName) + 1);
                valuesJSONObject.put(rowName, rowJSONObject);
            }
            int totalEntries = fieldJSONObject.getInt("totalEntries");
            if (valueJSONObject.length() != 0) {
                ++totalEntries;
            }
            fieldJSONObject.put("structure", JSONUtil.put((String)"columns", (Object)this._getOptionValuesJSONArray("columns")).put("rows", this._getOptionValuesJSONArray("rows"))).put("totalEntries", totalEntries);
            return fieldJSONObject;
        }

        private JSONArray _getOptionValuesJSONArray(String propertyName) {
            JSONArray jsonArray = JSONFactoryUtil.createJSONArray();
            DDMFormFieldOptions ddmFormFieldOptions = (DDMFormFieldOptions)this._ddmFormField.getProperty(propertyName);
            if (ddmFormFieldOptions != null) {
                Set optionsValues = ddmFormFieldOptions.getOptionsValues();
                optionsValues.forEach(optionValue -> jsonArray.put(optionValue));
            }
            return jsonArray;
        }
    }

    private class DDMFormFieldTypeReportProcessorTracker {
        private DDMFormFieldTypeReportProcessorTracker() {
        }

        public DDMFormFieldTypeReportProcessor getDDMFormFieldTypeReportProcessor(DDMFormField ddmFormField, String type) {
            if (StringUtil.equals((String)type, (String)"checkbox_multiple") || StringUtil.equals((String)type, (String)"select")) {
                return new CheckboxMultipleDDMFormFieldTypeReportProcessor();
            }
            if (StringUtil.equals((String)type, (String)"color") || StringUtil.equals((String)type, (String)"date") || StringUtil.equals((String)type, (String)"text")) {
                return new TextDDMFormFieldTypeReportProcessor();
            }
            if (StringUtil.equals((String)type, (String)"grid")) {
                return new UpgradeGridDDMFormFieldTypeReportProcessor(ddmFormField);
            }
            if (StringUtil.equals((String)type, (String)"numeric")) {
                return new NumericDDMFormFieldTypeReportProcessor();
            }
            if (StringUtil.equals((String)type, (String)"radio")) {
                return new RadioDDMFormFieldTypeReportProcessor();
            }
            return null;
        }
    }
}

