/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.dynamic.data.mapping.internal.upgrade.v3_2_4;

import com.liferay.petra.string.StringBundler;
import com.liferay.portal.kernel.dao.jdbc.AutoBatchPreparedStatementUtil;
import com.liferay.portal.kernel.json.JSONArray;
import com.liferay.portal.kernel.json.JSONFactory;
import com.liferay.portal.kernel.json.JSONObject;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.upgrade.UpgradeProcess;
import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.kernel.util.LocaleUtil;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.text.DecimalFormat;
import java.text.ParseException;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicBoolean;

public class UpgradeDDMContent
extends UpgradeProcess {
    private static final Log _log = LogFactoryUtil.getLog(UpgradeDDMContent.class);
    private static final Map<Locale, DecimalFormat> _decimalFormatsMap = new ConcurrentHashMap<Locale, DecimalFormat>();
    private final JSONFactory _jsonFactory;

    public UpgradeDDMContent(JSONFactory jsonFactory) {
        this._jsonFactory = jsonFactory;
    }

    protected void doUpgrade() throws Exception {
        try (PreparedStatement ps1 = this.connection.prepareStatement(StringBundler.concat((String[])new String[]{"select contentId, data_, DDMStructureVersion.definition ", "from DDMContent join DDMFormInstanceRecordVersion on  ", "storageId = contentId join DDMFormInstanceVersion on ", "DDMFormInstanceVersion.formInstanceId = ", "DDMFormInstanceRecordVersion.formInstanceId and ", "DDMFormInstanceVersion.version = ", "DDMFormInstanceRecordVersion.formInstanceVersion join ", "DDMStructureVersion on DDMStructureVersion.", "structureVersionId = DDMFormInstanceVersion.", "structureVersionId"}));
             PreparedStatement ps2 = AutoBatchPreparedStatementUtil.concurrentAutoBatch((Connection)this.connection, (String)"update DDMContent set data_ = ? where contentId = ?");){
            try (ResultSet rs = ps1.executeQuery();){
                while (rs.next()) {
                    String definition = rs.getString("definition");
                    JSONObject definitionJSONObject = this._jsonFactory.createJSONObject(definition);
                    String data = rs.getString("data_");
                    JSONObject dataJSONObject = this._jsonFactory.createJSONObject(data);
                    if (!this._upgradeDDMContentData(dataJSONObject.getJSONArray("fieldValues"), definitionJSONObject.getJSONArray("fields"))) continue;
                    ps2.setString(1, dataJSONObject.toJSONString());
                    long contentId = rs.getLong("contentId");
                    ps2.setLong(2, contentId);
                    ps2.addBatch();
                }
            }
            ps2.executeBatch();
        }
    }

    private DecimalFormat _getDecimalFormat(Locale locale) {
        DecimalFormat decimalFormat = _decimalFormatsMap.get(locale);
        if (decimalFormat == null) {
            decimalFormat = (DecimalFormat)DecimalFormat.getInstance(locale);
            decimalFormat.setGroupingUsed(false);
            decimalFormat.setMaximumFractionDigits(Integer.MAX_VALUE);
            decimalFormat.setParseBigDecimal(true);
            _decimalFormatsMap.put(locale, decimalFormat);
        }
        return decimalFormat;
    }

    private HashMap<String, JSONObject> _mapDataFieldValues(JSONArray fieldValuesJSONArray) {
        HashMap<String, JSONObject> dataFieldValuesMap = new HashMap<String, JSONObject>();
        fieldValuesJSONArray.forEach(object -> {
            JSONObject fieldValueJSONObject = (JSONObject)object;
            dataFieldValuesMap.put(fieldValueJSONObject.getString("name"), fieldValueJSONObject.getJSONObject("value"));
        });
        return dataFieldValuesMap;
    }

    private boolean _upgradeDDMContentData(JSONArray fieldValuesJSONArray, JSONArray fieldsJSONArray) {
        AtomicBoolean upgraded = new AtomicBoolean(false);
        HashMap<String, JSONObject> dataFieldValuesMap = this._mapDataFieldValues(fieldValuesJSONArray);
        fieldsJSONArray.forEach(object -> {
            JSONObject fieldJSONObject = (JSONObject)object;
            String type = fieldJSONObject.getString("type");
            if (type.equals("numeric")) {
                String name = fieldJSONObject.getString("name");
                JSONObject fieldValueJSONObject = (JSONObject)dataFieldValuesMap.get(name);
                JSONArray namesJSONArray = fieldValueJSONObject.names();
                namesJSONArray.forEach(languageId -> {
                    block3: {
                        try {
                            DecimalFormat decimalFormat = this._getDecimalFormat(LocaleUtil.fromLanguageId((String)GetterUtil.getString((Object)languageId)));
                            String valueString = fieldValueJSONObject.getString(GetterUtil.getString((Object)languageId));
                            Number number = GetterUtil.getNumber((Object)decimalFormat.parse(valueString));
                            String formattedNumber = decimalFormat.format(number);
                            if (!valueString.equals(formattedNumber)) {
                                DecimalFormat defaultDecimalFormat = this._getDecimalFormat(LocaleUtil.US);
                                number = defaultDecimalFormat.parse(valueString);
                                formattedNumber = decimalFormat.format(number);
                                upgraded.set(true);
                                fieldValueJSONObject.put(languageId.toString(), formattedNumber);
                            }
                        }
                        catch (ParseException parseException) {
                            if (!_log.isWarnEnabled()) break block3;
                            _log.warn((Object)parseException, (Throwable)parseException);
                        }
                    }
                });
            }
        });
        return upgraded.get();
    }
}

