/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.dynamic.data.mapping.internal.upgrade.v1_1_1;

import com.liferay.dynamic.data.mapping.io.DDMFormDeserializer;
import com.liferay.dynamic.data.mapping.io.DDMFormSerializer;
import com.liferay.dynamic.data.mapping.io.DDMFormSerializerSerializeRequest;
import com.liferay.dynamic.data.mapping.io.DDMFormSerializerSerializeResponse;
import com.liferay.dynamic.data.mapping.model.DDMForm;
import com.liferay.dynamic.data.mapping.model.DDMFormField;
import com.liferay.dynamic.data.mapping.util.DDMFormDeserializeUtil;
import com.liferay.petra.string.StringBundler;
import com.liferay.portal.kernel.dao.jdbc.AutoBatchPreparedStatementUtil;
import com.liferay.portal.kernel.upgrade.UpgradeProcess;
import com.liferay.portal.kernel.util.GetterUtil;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.util.Map;
import java.util.Objects;

public class UpgradeDDMFormFieldSettings
extends UpgradeProcess {
    private static final int _SCOPE_FORMS = 2;
    private final DDMFormDeserializer _ddmFormDeserializer;
    private final DDMFormSerializer _ddmFormSerializer;

    public UpgradeDDMFormFieldSettings(DDMFormDeserializer ddmFormDeserializer, DDMFormSerializer ddmFormSerializer) {
        this._ddmFormDeserializer = ddmFormDeserializer;
        this._ddmFormSerializer = ddmFormSerializer;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected void doUpgrade() throws Exception {
        StringBundler sb = new StringBundler(5);
        sb.append("select DDMStructure.structureId, DDMStructure.definition ");
        sb.append("from DDLRecordSet inner join DDMStructure on ");
        sb.append("DDLRecordSet.DDMStructureId = DDMStructure.structureId ");
        sb.append("where DDLRecordSet.scope = ? and DDMStructure.definition ");
        sb.append("like ?");
        try (PreparedStatement ps1 = this.connection.prepareStatement(sb.toString());
             PreparedStatement ps2 = AutoBatchPreparedStatementUtil.concurrentAutoBatch((Connection)this.connection, (String)"update DDMStructure set definition = ? where structureId = ?");
             PreparedStatement ps3 = this.connection.prepareStatement("select structureVersionId, definition from DDMStructureVersion where structureId = ?");
             PreparedStatement ps4 = AutoBatchPreparedStatementUtil.concurrentAutoBatch((Connection)this.connection, (String)"update DDMStructureVersion set definition = ? where structureVersionId = ?");){
            ps1.setInt(1, 2);
            ps1.setString(2, "%ddmDataProviderInstanceId%");
            try (ResultSet rs = ps1.executeQuery();){
                while (rs.next()) {
                    ResultSet rs2;
                    block71: {
                        String newDefinition;
                        String definition = rs.getString(2);
                        if (Objects.equals(definition, newDefinition = this.upgradeRecordSetStructure(definition))) continue;
                        ps2.setString(1, newDefinition);
                        long structureId = rs.getLong(1);
                        ps2.setLong(2, structureId);
                        ps2.addBatch();
                        ps3.setLong(1, structureId);
                        rs2 = ps3.executeQuery();
                        Throwable throwable = null;
                        try {
                            while (rs2.next()) {
                                definition = rs2.getString("definition");
                                if (Objects.equals(definition, newDefinition = this.upgradeRecordSetStructure(definition))) continue;
                                ps4.setString(1, newDefinition);
                                long structureVersionId = rs2.getLong("structureVersionId");
                                ps4.setLong(2, structureVersionId);
                                ps4.addBatch();
                            }
                            if (rs2 == null) continue;
                            if (throwable == null) break block71;
                        }
                        catch (Throwable throwable2) {
                            try {
                                throwable = throwable2;
                                throw throwable2;
                            }
                            catch (Throwable throwable3) {
                                if (rs2 == null) throw throwable3;
                                if (throwable == null) {
                                    rs2.close();
                                    throw throwable3;
                                }
                                try {
                                    rs2.close();
                                    throw throwable3;
                                }
                                catch (Throwable throwable4) {
                                    throwable.addSuppressed(throwable4);
                                    throw throwable3;
                                }
                            }
                        }
                        try {
                            rs2.close();
                            continue;
                        }
                        catch (Throwable throwable5) {
                            throwable.addSuppressed(throwable5);
                            continue;
                        }
                    }
                    rs2.close();
                }
                ps2.executeBatch();
                ps4.executeBatch();
                return;
            }
        }
    }

    protected String upgradeRecordSetStructure(String definition) throws Exception {
        DDMForm ddmForm = DDMFormDeserializeUtil.deserialize((DDMFormDeserializer)this._ddmFormDeserializer, (String)definition);
        for (DDMFormField ddmFormField : ddmForm.getDDMFormFields()) {
            Map properties = ddmFormField.getProperties();
            if (!properties.containsKey("ddmDataProviderInstanceId")) continue;
            String ddmDataProviderInstanceId = GetterUtil.getString(properties.get("ddmDataProviderInstanceId"));
            ddmFormField.setProperty("ddmDataProviderInstanceId", (Object)("[\"" + ddmDataProviderInstanceId + "\"]"));
            ddmFormField.setProperty("ddmDataProviderInstanceOutput", (Object)"[\"Default-Output\"]");
        }
        DDMFormSerializerSerializeRequest.Builder serializerBuilder = DDMFormSerializerSerializeRequest.Builder.newBuilder((DDMForm)ddmForm);
        DDMFormSerializerSerializeResponse ddmFormSerializerSerializeResponse = this._ddmFormSerializer.serialize(serializerBuilder.build());
        return ddmFormSerializerSerializeResponse.getContent();
    }
}

