/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.dynamic.data.mapping.service.impl;

import com.liferay.dynamic.data.mapping.exception.InvalidParentStructureException;
import com.liferay.dynamic.data.mapping.exception.InvalidStructureVersionException;
import com.liferay.dynamic.data.mapping.exception.NoSuchStructureException;
import com.liferay.dynamic.data.mapping.exception.NoSuchStructureLayoutException;
import com.liferay.dynamic.data.mapping.exception.RequiredStructureException;
import com.liferay.dynamic.data.mapping.exception.StructureDefinitionException;
import com.liferay.dynamic.data.mapping.exception.StructureDuplicateElementException;
import com.liferay.dynamic.data.mapping.exception.StructureDuplicateStructureKeyException;
import com.liferay.dynamic.data.mapping.exception.StructureNameException;
import com.liferay.dynamic.data.mapping.internal.background.task.DDMStructureIndexerBackgroundTaskExecutor;
import com.liferay.dynamic.data.mapping.internal.background.task.DDMStructureIndexerTracker;
import com.liferay.dynamic.data.mapping.internal.search.util.DDMSearchHelper;
import com.liferay.dynamic.data.mapping.internal.util.DDMFormTemplateSynchonizer;
import com.liferay.dynamic.data.mapping.io.DDMFormDeserializer;
import com.liferay.dynamic.data.mapping.io.DDMFormDeserializerDeserializeRequest;
import com.liferay.dynamic.data.mapping.io.DDMFormDeserializerDeserializeResponse;
import com.liferay.dynamic.data.mapping.io.DDMFormSerializer;
import com.liferay.dynamic.data.mapping.io.DDMFormSerializerSerializeRequest;
import com.liferay.dynamic.data.mapping.io.DDMFormSerializerSerializeResponse;
import com.liferay.dynamic.data.mapping.model.DDMDataProviderInstance;
import com.liferay.dynamic.data.mapping.model.DDMDataProviderInstanceLink;
import com.liferay.dynamic.data.mapping.model.DDMForm;
import com.liferay.dynamic.data.mapping.model.DDMFormField;
import com.liferay.dynamic.data.mapping.model.DDMFormLayout;
import com.liferay.dynamic.data.mapping.model.DDMFormRule;
import com.liferay.dynamic.data.mapping.model.DDMStructure;
import com.liferay.dynamic.data.mapping.model.DDMStructureVersion;
import com.liferay.dynamic.data.mapping.model.DDMTemplate;
import com.liferay.dynamic.data.mapping.security.permission.DDMPermissionSupport;
import com.liferay.dynamic.data.mapping.service.DDMDataProviderInstanceLinkLocalService;
import com.liferay.dynamic.data.mapping.service.DDMDataProviderInstanceLocalService;
import com.liferay.dynamic.data.mapping.service.DDMStructureLayoutLocalService;
import com.liferay.dynamic.data.mapping.service.DDMStructureVersionLocalService;
import com.liferay.dynamic.data.mapping.service.DDMTemplateLocalService;
import com.liferay.dynamic.data.mapping.service.base.DDMStructureLocalServiceBaseImpl;
import com.liferay.dynamic.data.mapping.service.persistence.DDMStructurePersistence;
import com.liferay.dynamic.data.mapping.util.DDM;
import com.liferay.dynamic.data.mapping.util.DDMXML;
import com.liferay.dynamic.data.mapping.validator.DDMFormValidationException;
import com.liferay.dynamic.data.mapping.validator.DDMFormValidator;
import com.liferay.exportimport.kernel.lar.ExportImportThreadLocal;
import com.liferay.petra.string.StringBundler;
import com.liferay.portal.aop.AopService;
import com.liferay.portal.kernel.backgroundtask.BackgroundTaskManager;
import com.liferay.portal.kernel.exception.LocaleException;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.json.JSONArray;
import com.liferay.portal.kernel.json.JSONFactory;
import com.liferay.portal.kernel.language.LanguageUtil;
import com.liferay.portal.kernel.model.BaseModel;
import com.liferay.portal.kernel.model.User;
import com.liferay.portal.kernel.search.DDMStructureIndexer;
import com.liferay.portal.kernel.search.Indexable;
import com.liferay.portal.kernel.search.IndexableType;
import com.liferay.portal.kernel.search.SearchContext;
import com.liferay.portal.kernel.security.auth.CompanyThreadLocal;
import com.liferay.portal.kernel.service.ServiceContext;
import com.liferay.portal.kernel.service.permission.ModelPermissions;
import com.liferay.portal.kernel.systemevent.SystemEvent;
import com.liferay.portal.kernel.transaction.TransactionCommitCallbackUtil;
import com.liferay.portal.kernel.transaction.Transactional;
import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.kernel.util.GroupThreadLocal;
import com.liferay.portal.kernel.util.HashMapBuilder;
import com.liferay.portal.kernel.util.ListUtil;
import com.liferay.portal.kernel.util.MapUtil;
import com.liferay.portal.kernel.util.OrderByComparator;
import com.liferay.portal.kernel.util.Portal;
import com.liferay.portal.kernel.util.SetUtil;
import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.portal.kernel.util.Validator;
import java.io.Serializable;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.Callable;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component(property={"model.class.name=com.liferay.dynamic.data.mapping.model.DDMStructure"}, service={AopService.class})
public class DDMStructureLocalServiceImpl
extends DDMStructureLocalServiceBaseImpl {
    private static final Pattern _callFunctionPattern = Pattern.compile("call\\(\\s*'([0-9a-f]{8}-[0-9a-f]{4}-[0-9a-f]{4}-[0-9a-f]{4}-[0-9a-f]{12})'\\s*,\\s*'(.*)'\\s*,\\s*'(.*)'\\s*\\)");
    @Reference
    private BackgroundTaskManager _backgroundTaskManager;
    @Reference
    private DDM _ddm;
    @Reference
    private DDMDataProviderInstanceLinkLocalService _ddmDataProviderInstanceLinkLocalService;
    @Reference
    private DDMDataProviderInstanceLocalService _ddmDataProviderInstanceLocalService;
    @Reference
    private DDMFormValidator _ddmFormValidator;
    @Reference
    private DDMPermissionSupport _ddmPermissionSupport;
    @Reference
    private DDMSearchHelper _ddmSearchHelper;
    @Reference
    private DDMStructureIndexerTracker _ddmStructureIndexerTracker;
    @Reference
    private DDMStructureLayoutLocalService _ddmStructureLayoutLocalService;
    @Reference
    private DDMStructureVersionLocalService _ddmStructureVersionLocalService;
    @Reference
    private DDMTemplateLocalService _ddmTemplateLocalService;
    @Reference
    private DDMXML _ddmXML;
    @Reference(target="(ddm.form.deserializer.type=json)")
    private DDMFormDeserializer _jsonDDMFormDeserializer;
    @Reference(target="(ddm.form.serializer.type=json)")
    private DDMFormSerializer _jsonDDMFormSerializer;
    @Reference
    private JSONFactory _jsonFactory;
    @Reference
    private Portal _portal;
    @Reference(target="(ddm.form.deserializer.type=xsd)")
    private DDMFormDeserializer _xsdDDMFormDeserializer;

    @Indexable(type=IndexableType.REINDEX)
    public DDMStructure addStructure(long userId, long groupId, long parentStructureId, long classNameId, String structureKey, Map<Locale, String> nameMap, Map<Locale, String> descriptionMap, DDMForm ddmForm, DDMFormLayout ddmFormLayout, String storageType, int type, ServiceContext serviceContext) throws PortalException {
        User user = this.userLocalService.getUser(userId);
        structureKey = Validator.isNull((String)structureKey) ? String.valueOf(this.counterLocalService.increment()) : StringUtil.toUpperCase((String)structureKey.trim());
        this.validate(groupId, parentStructureId, classNameId, structureKey, nameMap, ddmForm);
        long structureId = this.counterLocalService.increment();
        DDMStructure structure = this.ddmStructurePersistence.create(structureId);
        structure.setUuid(serviceContext.getUuid());
        structure.setGroupId(groupId);
        structure.setCompanyId(user.getCompanyId());
        structure.setUserId(user.getUserId());
        structure.setUserName(user.getFullName());
        structure.setVersionUserId(user.getUserId());
        structure.setVersionUserName(user.getFullName());
        structure.setParentStructureId(parentStructureId);
        structure.setClassNameId(classNameId);
        structure.setStructureKey(structureKey);
        structure.setVersion("1.0");
        structure.setDescriptionMap(descriptionMap, ddmForm.getDefaultLocale());
        structure.setNameMap(nameMap, ddmForm.getDefaultLocale());
        structure.setDefinition(this.serializeJSONDDMForm(ddmForm));
        structure.setStorageType(storageType);
        structure.setType(type);
        structure = (DDMStructure)this.ddmStructurePersistence.update((BaseModel)structure);
        if (serviceContext.isAddGroupPermissions() || serviceContext.isAddGuestPermissions()) {
            this.addStructureResources(structure, serviceContext.isAddGroupPermissions(), serviceContext.isAddGuestPermissions());
        } else {
            this.addStructureResources(structure, serviceContext.getModelPermissions());
        }
        DDMStructureVersion structureVersion = this.addStructureVersion(user, structure, "1.0", serviceContext);
        this._ddmStructureLayoutLocalService.addStructureLayout(userId, groupId, structureVersion.getStructureVersionId(), ddmFormLayout, serviceContext);
        this.addDataProviderInstanceLinks(groupId, structureId, ddmForm);
        return structure;
    }

    @Indexable(type=IndexableType.REINDEX)
    public DDMStructure addStructure(long userId, long groupId, long parentStructureId, long classNameId, String structureKey, Map<Locale, String> nameMap, Map<Locale, String> descriptionMap, String definition, String storageType, ServiceContext serviceContext) throws PortalException {
        User user = this.userLocalService.getUser(userId);
        structureKey = Validator.isNull((String)structureKey) ? String.valueOf(this.counterLocalService.increment()) : StringUtil.toUpperCase((String)structureKey.trim());
        long structureId = this.counterLocalService.increment();
        DDMStructure structure = this.ddmStructurePersistence.create(structureId);
        structure.setUuid(serviceContext.getUuid());
        structure.setGroupId(groupId);
        structure.setCompanyId(user.getCompanyId());
        structure.setUserId(user.getUserId());
        structure.setUserName(user.getFullName());
        structure.setVersionUserId(user.getUserId());
        structure.setVersionUserName(user.getFullName());
        structure.setCreateDate(new Date());
        structure.setModifiedDate(new Date());
        structure.setParentStructureId(parentStructureId);
        structure.setClassNameId(classNameId);
        structure.setStructureKey(structureKey);
        structure.setVersion("1.0");
        structure.setNameMap(nameMap);
        structure.setDescriptionMap(descriptionMap);
        structure.setDefinition(definition);
        structure.setStorageType(storageType);
        structure.setType(0);
        structure = (DDMStructure)this.ddmStructurePersistence.update((BaseModel)structure);
        this.addStructureVersion(user, structure, "1.0", serviceContext);
        return structure;
    }

    public DDMStructure addStructure(long userId, long groupId, long classNameId, Map<Locale, String> nameMap, Map<Locale, String> descriptionMap, DDMForm ddmForm, DDMFormLayout ddmFormLayout, String storageType, ServiceContext serviceContext) throws PortalException {
        return this.addStructure(userId, groupId, 0L, classNameId, null, nameMap, descriptionMap, ddmForm, ddmFormLayout, storageType, 0, serviceContext);
    }

    public DDMStructure addStructure(long userId, long groupId, String parentStructureKey, long classNameId, String structureKey, Map<Locale, String> nameMap, Map<Locale, String> descriptionMap, DDMForm ddmForm, DDMFormLayout ddmFormLayout, String storageType, int type, ServiceContext serviceContext) throws PortalException {
        DDMStructure parentStructure = this.fetchStructure(groupId, classNameId, parentStructureKey);
        long parentStructureId = 0L;
        if (parentStructure != null) {
            parentStructureId = parentStructure.getStructureId();
        }
        return this.addStructure(userId, groupId, parentStructureId, classNameId, structureKey, nameMap, descriptionMap, ddmForm, ddmFormLayout, storageType, type, serviceContext);
    }

    public void addStructureResources(DDMStructure structure, boolean addGroupPermissions, boolean addGuestPermissions) throws PortalException {
        String resourceName = this._ddmPermissionSupport.getStructureModelResourceName(structure.getClassName());
        this.resourceLocalService.addResources(structure.getCompanyId(), structure.getGroupId(), structure.getUserId(), resourceName, structure.getStructureId(), false, addGroupPermissions, addGuestPermissions);
    }

    public void addStructureResources(DDMStructure structure, ModelPermissions modelPermissions) throws PortalException {
        String resourceName = this._ddmPermissionSupport.getStructureModelResourceName(structure.getClassName());
        this.resourceLocalService.addModelResources(structure.getCompanyId(), structure.getGroupId(), structure.getUserId(), resourceName, structure.getStructureId(), modelPermissions);
    }

    public DDMStructure copyStructure(long userId, long structureId, Map<Locale, String> nameMap, Map<Locale, String> descriptionMap, ServiceContext serviceContext) throws PortalException {
        DDMStructure structure = this.ddmStructurePersistence.findByPrimaryKey(structureId);
        return this.addStructure(userId, structure.getGroupId(), structure.getParentStructureId(), structure.getClassNameId(), null, nameMap, descriptionMap, structure.getDDMForm(), structure.getDDMFormLayout(), structure.getStorageType(), structure.getType(), serviceContext);
    }

    public DDMStructure copyStructure(long userId, long structureId, ServiceContext serviceContext) throws PortalException {
        DDMStructure structure = this.ddmStructurePersistence.findByPrimaryKey(structureId);
        return this.addStructure(userId, structure.getGroupId(), structure.getParentStructureId(), structure.getClassNameId(), null, (Map<Locale, String>)structure.getNameMap(), (Map<Locale, String>)structure.getDescriptionMap(), structure.getDDMForm(), structure.getDDMFormLayout(), structure.getStorageType(), structure.getType(), serviceContext);
    }

    @Indexable(type=IndexableType.DELETE)
    @SystemEvent(type=1)
    public DDMStructure deleteStructure(DDMStructure structure) throws PortalException {
        if (!GroupThreadLocal.isDeleteInProcess()) {
            int count = this.ddmStructureLinkPersistence.countByStructureId(structure.getStructureId());
            if (count > 0) {
                throw new RequiredStructureException.MustNotDeleteStructureReferencedByStructureLinks(structure.getStructureId());
            }
            count = this.ddmStructurePersistence.countByParentStructureId(structure.getStructureId());
            if (count > 0) {
                throw new RequiredStructureException.MustNotDeleteStructureThatHasChild(structure.getStructureId());
            }
            count = this.ddmTemplatePersistence.countByClassPK(structure.getStructureId());
            if (count > 0) {
                throw new RequiredStructureException.MustNotDeleteStructureReferencedByTemplates(structure.getStructureId());
            }
        }
        this.ddmStructurePersistence.remove((BaseModel)structure);
        this.ddmDataProviderInstanceLinkPersistence.removeByStructureId(structure.getStructureId());
        this.ddmStructureLinkPersistence.removeByStructureId(structure.getStructureId());
        List structureVersions = this._ddmStructureVersionLocalService.getStructureVersions(structure.getStructureId());
        for (DDMStructureVersion structureVersion : structureVersions) {
            try {
                this.ddmStructureLayoutPersistence.removeByStructureVersionId(structureVersion.getStructureVersionId());
            }
            catch (NoSuchStructureLayoutException noSuchStructureLayoutException) {
                continue;
            }
            this.ddmStructureVersionPersistence.remove((BaseModel)structureVersion);
        }
        String resourceName = this._ddmPermissionSupport.getStructureModelResourceName(structure.getClassName());
        this.resourceLocalService.deleteResource(structure.getCompanyId(), resourceName, 4, structure.getStructureId());
        String backgroundTaskName = DDMStructureIndexerBackgroundTaskExecutor.getBackgroundTaskName(structure.getStructureId());
        this._backgroundTaskManager.deleteGroupBackgroundTasks(structure.getGroupId(), backgroundTaskName, DDMStructureIndexerBackgroundTaskExecutor.class.getName());
        return structure;
    }

    public void deleteStructure(long structureId) throws PortalException {
        DDMStructure structure = this.ddmStructurePersistence.findByPrimaryKey(structureId);
        this.ddmStructureLocalService.deleteStructure(structure);
    }

    public void deleteStructure(long groupId, long classNameId, String structureKey) throws PortalException {
        structureKey = this.getStructureKey(structureKey);
        DDMStructure structure = this.ddmStructurePersistence.findByG_C_S(groupId, classNameId, structureKey);
        this.ddmStructureLocalService.deleteStructure(structure);
    }

    public void deleteStructures(long groupId) throws PortalException {
        List structures = this.ddmStructurePersistence.findByGroupId(groupId);
        this.deleteStructures(structures);
    }

    public void deleteStructures(long groupId, long classNameId) throws PortalException {
        List structures = this.ddmStructurePersistence.findByG_C(groupId, classNameId);
        this.deleteStructures(structures);
    }

    public DDMStructure fetchStructure(long structureId) {
        return this.ddmStructurePersistence.fetchByPrimaryKey(structureId);
    }

    public DDMStructure fetchStructure(long groupId, long classNameId, String structureKey) {
        structureKey = this.getStructureKey(structureKey);
        return this.ddmStructurePersistence.fetchByG_C_S(groupId, classNameId, structureKey);
    }

    public DDMStructure fetchStructure(long groupId, long classNameId, String structureKey, boolean includeAncestorStructures) {
        DDMStructure structure = this.ddmStructurePersistence.fetchByG_C_S(groupId, classNameId, structureKey = this.getStructureKey(structureKey));
        if (structure != null) {
            return structure;
        }
        if (!includeAncestorStructures) {
            return null;
        }
        for (long ancestorSiteGroupId : this._portal.getAncestorSiteGroupIds(groupId)) {
            structure = this.ddmStructurePersistence.fetchByG_C_S(ancestorSiteGroupId, classNameId, structureKey);
            if (structure == null) continue;
            return structure;
        }
        return null;
    }

    public DDMStructure fetchStructureByUuidAndGroupId(String uuid, long groupId, boolean includeAncestorStructures) {
        DDMStructure structure = this.ddmStructurePersistence.fetchByUUID_G(uuid, groupId);
        if (structure != null) {
            return structure;
        }
        if (!includeAncestorStructures) {
            return null;
        }
        for (long ancestorSiteGroupId : this._portal.getAncestorSiteGroupIds(groupId)) {
            structure = this.ddmStructurePersistence.fetchByUUID_G(uuid, ancestorSiteGroupId);
            if (structure == null) continue;
            return structure;
        }
        return null;
    }

    public List<DDMStructure> getChildrenStructures(long parentStructureId) {
        return this.ddmStructurePersistence.findByParentStructureId(parentStructureId);
    }

    public List<DDMStructure> getClassStructures(long companyId, long classNameId) {
        return this.ddmStructurePersistence.findByC_C(companyId, classNameId);
    }

    public List<DDMStructure> getClassStructures(long companyId, long classNameId, int start, int end) {
        return this.ddmStructurePersistence.findByC_C(companyId, classNameId, start, end);
    }

    public List<DDMStructure> getClassStructures(long companyId, long classNameId, OrderByComparator<DDMStructure> orderByComparator) {
        return this.ddmStructurePersistence.findByC_C(companyId, classNameId, -1, -1, orderByComparator);
    }

    public DDMStructure getStructure(long structureId) throws PortalException {
        return this.ddmStructurePersistence.findByPrimaryKey(structureId);
    }

    public DDMStructure getStructure(long groupId, long classNameId, String structureKey) throws PortalException {
        structureKey = this.getStructureKey(structureKey);
        return this.ddmStructurePersistence.findByG_C_S(groupId, classNameId, structureKey);
    }

    public DDMStructure getStructure(long groupId, long classNameId, String structureKey, boolean includeAncestorStructures) throws PortalException {
        DDMStructure structure = this.ddmStructurePersistence.fetchByG_C_S(groupId, classNameId, structureKey = this.getStructureKey(structureKey));
        if (structure != null) {
            return structure;
        }
        if (!includeAncestorStructures) {
            throw new NoSuchStructureException("No DDMStructure exists with the structure key " + structureKey);
        }
        for (long curGroupId : this._portal.getAncestorSiteGroupIds(groupId)) {
            structure = this.ddmStructurePersistence.fetchByG_C_S(curGroupId, classNameId, structureKey);
            if (structure == null) continue;
            return structure;
        }
        throw new NoSuchStructureException("No DDMStructure exists with the structure key " + structureKey + " in the ancestor groups");
    }

    public List<DDMStructure> getStructure(long groupId, String name, String description) {
        return this.ddmStructurePersistence.findByG_N_D(groupId, name, description);
    }

    @Transactional(enabled=false)
    public DDMForm getStructureDDMForm(DDMStructure structure) throws PortalException {
        return this.deserializeJSONDDMForm(structure.getDefinition());
    }

    public List<DDMStructure> getStructures() {
        return this.ddmStructurePersistence.findAll();
    }

    public List<DDMStructure> getStructures(long groupId) {
        return this.ddmStructurePersistence.findByGroupId(groupId);
    }

    public List<DDMStructure> getStructures(long groupId, int start, int end) {
        return this.ddmStructurePersistence.findByGroupId(groupId, start, end);
    }

    public List<DDMStructure> getStructures(long groupId, long classNameId) {
        return this.ddmStructurePersistence.findByG_C(groupId, classNameId);
    }

    public List<DDMStructure> getStructures(long groupId, long classNameId, int start, int end) {
        return this.ddmStructurePersistence.findByG_C(groupId, classNameId, start, end);
    }

    public List<DDMStructure> getStructures(long groupId, long classNameId, int start, int end, OrderByComparator<DDMStructure> orderByComparator) {
        return this.ddmStructurePersistence.findByG_C(groupId, classNameId, start, end, orderByComparator);
    }

    public List<DDMStructure> getStructures(long companyId, long[] groupIds, long classNameId, int start, int end, OrderByComparator<DDMStructure> orderByComparator) {
        return this.ddmStructureFinder.findByC_G_C_S(companyId, groupIds, classNameId, -1, start, end, orderByComparator);
    }

    public List<DDMStructure> getStructures(long companyId, long[] groupIds, long classNameId, String keywords, int status, int start, int end, OrderByComparator<DDMStructure> orderByComparator) {
        return this.ddmStructureFinder.findByKeywords(companyId, groupIds, classNameId, keywords, status, start, end, orderByComparator);
    }

    public List<DDMStructure> getStructures(long groupId, String name, String description) {
        return this.ddmStructurePersistence.findByG_N_D(groupId, name, description);
    }

    public List<DDMStructure> getStructures(long[] groupIds) {
        return this.ddmStructurePersistence.findByGroupId(groupIds);
    }

    public List<DDMStructure> getStructures(long[] groupIds, long classNameId) {
        return this.ddmStructurePersistence.findByG_C(groupIds, classNameId);
    }

    public List<DDMStructure> getStructures(long[] groupIds, long classNameId, int start, int end) {
        return this.ddmStructurePersistence.findByG_C(groupIds, classNameId, start, end);
    }

    public List<DDMStructure> getStructures(long[] groupIds, long classNameId, OrderByComparator<DDMStructure> orderByComparator) {
        return this.ddmStructurePersistence.findByG_C(groupIds, classNameId, -1, -1, orderByComparator);
    }

    public List<DDMStructure> getStructures(long[] groupIds, long classNameId, String name, String description, int start, int end, OrderByComparator<DDMStructure> orderByComparator) {
        return this.ddmStructurePersistence.findByG_C_N_D(groupIds, classNameId, name, description, start, end, orderByComparator);
    }

    public int getStructuresCount(long groupId) {
        return this.ddmStructurePersistence.countByGroupId(groupId);
    }

    public int getStructuresCount(long groupId, long classNameId) {
        return this.ddmStructurePersistence.countByG_C(groupId, classNameId);
    }

    public int getStructuresCount(long companyId, long[] groupIds, long classNameId, String keywords, int status) {
        return this.ddmStructureFinder.countByKeywords(companyId, groupIds, classNameId, keywords, status);
    }

    public int getStructuresCount(long[] groupIds, long classNameId) {
        return this.ddmStructurePersistence.countByG_C(groupIds, classNameId);
    }

    public String prepareLocalizedDefinitionForImport(DDMStructure structure, Locale defaultImportLocale) {
        DDMForm ddmForm = this._ddm.updateDDMFormDefaultLocale(structure.getDDMForm(), defaultImportLocale);
        return this.serializeJSONDDMForm(ddmForm);
    }

    public void revertStructure(long userId, long structureId, String version, ServiceContext serviceContext) throws PortalException {
        DDMStructureVersion structureVersion = this._ddmStructureVersionLocalService.getStructureVersion(structureId, version);
        if (!structureVersion.isApproved()) {
            throw new InvalidStructureVersionException("Unable to revert from an unapproved file version");
        }
        DDMStructure structure = structureVersion.getStructure();
        serviceContext.setAttribute("majorVersion", (Serializable)Boolean.TRUE);
        serviceContext.setAttribute("status", (Serializable)Integer.valueOf(0));
        serviceContext.setCommand("revert");
        this.ddmStructureLocalService.updateStructure(userId, structure.getGroupId(), structureVersion.getParentStructureId(), structure.getClassNameId(), structure.getStructureKey(), structureVersion.getNameMap(), structureVersion.getDescriptionMap(), structureVersion.getDDMForm(), structureVersion.getDDMFormLayout(), serviceContext);
    }

    public List<DDMStructure> search(long companyId, long[] groupIds, long classNameId, long classPK, String keywords, int start, int end, OrderByComparator<DDMStructure> orderByComparator) throws PortalException {
        SearchContext searchContext = this._ddmSearchHelper.buildStructureSearchContext(companyId, groupIds, classNameId, classPK, keywords, keywords, "", null, -1, start, end, orderByComparator);
        return this._ddmSearchHelper.doSearch(searchContext, DDMStructure.class, arg_0 -> ((DDMStructurePersistence)this.ddmStructurePersistence).findByPrimaryKey(arg_0));
    }

    public List<DDMStructure> search(long companyId, long[] groupIds, long classNameId, String keywords, int status, int start, int end, OrderByComparator<DDMStructure> orderByComparator) {
        SearchContext searchContext = this._ddmSearchHelper.buildStructureSearchContext(companyId, groupIds, classNameId, null, keywords, keywords, "", null, status, start, end, orderByComparator);
        return this._ddmSearchHelper.doSearch(searchContext, DDMStructure.class, arg_0 -> ((DDMStructurePersistence)this.ddmStructurePersistence).findByPrimaryKey(arg_0));
    }

    public List<DDMStructure> search(long companyId, long[] groupIds, long classNameId, String name, String description, String storageType, int type, int status, boolean andOperator, int start, int end, OrderByComparator<DDMStructure> orderByComparator) {
        SearchContext searchContext = this._ddmSearchHelper.buildStructureSearchContext(companyId, groupIds, classNameId, null, name, description, storageType, type, status, start, end, orderByComparator);
        return this._ddmSearchHelper.doSearch(searchContext, DDMStructure.class, arg_0 -> ((DDMStructurePersistence)this.ddmStructurePersistence).findByPrimaryKey(arg_0));
    }

    public int searchCount(long companyId, long[] groupIds, long classNameId, long classPK, String keywords) throws PortalException {
        SearchContext searchContext = this._ddmSearchHelper.buildStructureSearchContext(companyId, groupIds, classNameId, classPK, keywords, keywords, "", null, -1, -1, -1, null);
        return this._ddmSearchHelper.doSearchCount(searchContext, DDMStructure.class);
    }

    public int searchCount(long companyId, long[] groupIds, long classNameId, String keywords, int status) {
        SearchContext searchContext = this._ddmSearchHelper.buildStructureSearchContext(companyId, groupIds, classNameId, null, keywords, keywords, "", null, status, -1, -1, null);
        return this._ddmSearchHelper.doSearchCount(searchContext, DDMStructure.class);
    }

    public int searchCount(long companyId, long[] groupIds, long classNameId, String name, String description, String storageType, int type, int status, boolean andOperator) {
        SearchContext searchContext = this._ddmSearchHelper.buildStructureSearchContext(companyId, groupIds, classNameId, null, name, description, storageType, type, status, -1, -1, null);
        return this._ddmSearchHelper.doSearchCount(searchContext, DDMStructure.class);
    }

    @Indexable(type=IndexableType.REINDEX)
    public DDMStructure updateStructure(long userId, long structureId, DDMForm ddmForm, DDMFormLayout ddmFormLayout, ServiceContext serviceContext) throws PortalException {
        DDMStructure structure = this.ddmStructurePersistence.findByPrimaryKey(structureId);
        return this.doUpdateStructure(userId, structure.getParentStructureId(), structure.getNameMap(), structure.getDescriptionMap(), ddmForm, ddmFormLayout, serviceContext, structure);
    }

    @Indexable(type=IndexableType.REINDEX)
    public DDMStructure updateStructure(long userId, long groupId, long parentStructureId, long classNameId, String structureKey, Map<Locale, String> nameMap, Map<Locale, String> descriptionMap, DDMForm ddmForm, DDMFormLayout ddmFormLayout, ServiceContext serviceContext) throws PortalException {
        structureKey = this.getStructureKey(structureKey);
        DDMStructure structure = this.ddmStructurePersistence.findByG_C_S(groupId, classNameId, structureKey);
        return this.doUpdateStructure(userId, parentStructureId, nameMap, descriptionMap, ddmForm, ddmFormLayout, serviceContext, structure);
    }

    @Indexable(type=IndexableType.REINDEX)
    public DDMStructure updateStructure(long userId, long structureId, long parentStructureId, Map<Locale, String> nameMap, Map<Locale, String> descriptionMap, DDMForm ddmForm, DDMFormLayout ddmFormLayout, ServiceContext serviceContext) throws PortalException {
        DDMStructure structure = this.ddmStructurePersistence.findByPrimaryKey(structureId);
        return this.doUpdateStructure(userId, parentStructureId, nameMap, descriptionMap, ddmForm, ddmFormLayout, serviceContext, structure);
    }

    @Indexable(type=IndexableType.REINDEX)
    public DDMStructure updateStructure(long userId, long structureId, long parentStructureId, Map<Locale, String> nameMap, Map<Locale, String> descriptionMap, String definition, ServiceContext serviceContext) throws PortalException {
        DDMStructure structure = this.ddmStructurePersistence.findByPrimaryKey(structureId);
        User user = this.userLocalService.getUser(userId);
        structure.setUserId(userId);
        structure.setParentStructureId(parentStructureId);
        DDMStructureVersion latestStructureVersion = this._ddmStructureVersionLocalService.getLatestStructureVersion(structure.getStructureId());
        structure.setVersion(latestStructureVersion.getVersion());
        structure.setNameMap(nameMap);
        structure.setVersionUserId(user.getUserId());
        structure.setVersionUserName(user.getFullName());
        structure.setModifiedDate(new Date());
        structure.setDescriptionMap(descriptionMap);
        structure.setDefinition(definition);
        structure = (DDMStructure)this.ddmStructurePersistence.update((BaseModel)structure);
        this.reindexStructure(structure, serviceContext);
        return structure;
    }

    protected void addDataProviderInstanceLinks(long groupId, long structureId, DDMForm ddmForm) {
        Set<Long> dataProviderInstanceIds = this.getDataProviderInstanceIds(groupId, ddmForm);
        for (Long dataProviderInstanceId : dataProviderInstanceIds) {
            this._ddmDataProviderInstanceLinkLocalService.addDataProviderInstanceLink(dataProviderInstanceId.longValue(), structureId);
        }
    }

    protected DDMStructureVersion addStructureVersion(User user, DDMStructure structure, String version, ServiceContext serviceContext) {
        long structureVersionId = this.counterLocalService.increment();
        DDMStructureVersion structureVersion = this.ddmStructureVersionPersistence.create(structureVersionId);
        structureVersion.setGroupId(structure.getGroupId());
        structureVersion.setCompanyId(structure.getCompanyId());
        structureVersion.setUserId(user.getUserId());
        structureVersion.setUserName(user.getFullName());
        structureVersion.setCreateDate(structure.getModifiedDate());
        structureVersion.setStructureId(structure.getStructureId());
        structureVersion.setVersion(version);
        structureVersion.setParentStructureId(structure.getParentStructureId());
        structureVersion.setName(structure.getName());
        structureVersion.setDescription(structure.getDescription());
        structureVersion.setDefinition(structure.getDefinition());
        structureVersion.setStorageType(structure.getStorageType());
        structureVersion.setType(structure.getType());
        int status = GetterUtil.getInteger((Object)serviceContext.getAttribute("status"), (int)0);
        structureVersion.setStatus(status);
        structureVersion.setStatusByUserId(user.getUserId());
        structureVersion.setStatusByUserName(user.getFullName());
        structureVersion.setStatusDate(structure.getModifiedDate());
        return (DDMStructureVersion)this.ddmStructureVersionPersistence.update((BaseModel)structureVersion);
    }

    protected Set<Long> deleteStructures(List<DDMStructure> structures) throws PortalException {
        if (ListUtil.isEmpty(structures)) {
            return Collections.emptySet();
        }
        HashSet<Long> deletedStructureIds = new HashSet<Long>();
        for (DDMStructure structure : structures) {
            if (deletedStructureIds.contains(structure.getStructureId())) continue;
            if (!GroupThreadLocal.isDeleteInProcess()) {
                List childDDMStructures = this.ddmStructurePersistence.findByParentStructureId(structure.getStructureId());
                deletedStructureIds.addAll(this.deleteStructures(childDDMStructures));
            }
            this.ddmStructureLocalService.deleteStructure(structure);
            deletedStructureIds.add(structure.getStructureId());
        }
        return deletedStructureIds;
    }

    protected DDMForm deserializeDDMForm(String content, DDMFormDeserializer ddmFormDeserializer) {
        DDMFormDeserializerDeserializeRequest.Builder builder = DDMFormDeserializerDeserializeRequest.Builder.newBuilder((String)content);
        DDMFormDeserializerDeserializeResponse ddmFormDeserializerDeserializeResponse = ddmFormDeserializer.deserialize(builder.build());
        return ddmFormDeserializerDeserializeResponse.getDDMForm();
    }

    protected DDMForm deserializeJSONDDMForm(String content) {
        return this.deserializeDDMForm(content, this._jsonDDMFormDeserializer);
    }

    protected DDMForm deserializeXSDDDMForm(String content) {
        return this.deserializeDDMForm(content, this._xsdDDMFormDeserializer);
    }

    protected DDMStructure doUpdateStructure(long userId, long parentStructureId, Map<Locale, String> nameMap, Map<Locale, String> descriptionMap, DDMForm ddmForm, DDMFormLayout ddmFormLayout, ServiceContext serviceContext, DDMStructure structure) throws PortalException {
        User user = this.userLocalService.getUser(userId);
        DDMForm parentDDMForm = this.getParentDDMForm(parentStructureId);
        this.validateParentStructure(structure.getStructureId(), parentStructureId);
        this.validate(nameMap, parentDDMForm, ddmForm);
        structure.setUserId(userId);
        structure.setParentStructureId(parentStructureId);
        DDMStructureVersion latestStructureVersion = this._ddmStructureVersionLocalService.getLatestStructureVersion(structure.getStructureId());
        boolean majorVersion = GetterUtil.getBoolean((Object)serviceContext.getAttribute("majorVersion"));
        String version = this.getNextVersion(latestStructureVersion.getVersion(), majorVersion);
        structure.setVersion(version);
        structure.setNameMap(nameMap, ddmForm.getDefaultLocale());
        structure.setVersionUserId(user.getUserId());
        structure.setVersionUserName(user.getFullName());
        structure.setDescriptionMap(descriptionMap, ddmForm.getDefaultLocale());
        structure.setDefinition(this.serializeJSONDDMForm(ddmForm));
        DDMStructureVersion structureVersion = this.addStructureVersion(user, structure, version, serviceContext);
        serviceContext.getUuid();
        this._ddmStructureLayoutLocalService.addStructureLayout(structureVersion.getUserId(), structureVersion.getGroupId(), structureVersion.getStructureVersionId(), ddmFormLayout, serviceContext);
        if (!structureVersion.isApproved() && structureVersion.isPending()) {
            return structure;
        }
        structure = (DDMStructure)this.ddmStructurePersistence.update((BaseModel)structure);
        this.syncStructureTemplatesFields(structure);
        this.updateDataProviderInstanceLinks(structure.getGroupId(), structure.getStructureId(), ddmForm);
        this.reindexStructure(structure, serviceContext);
        return structure;
    }

    protected Set<Long> getDataProviderInstanceIds(long groupId, DDMForm ddmForm) {
        HashSet<Long> dataProviderInstanceIds = new HashSet<Long>();
        Map ddmFormFieldsMap = ddmForm.getDDMFormFieldsMap(true);
        for (DDMFormField ddmFormField : ddmFormFieldsMap.values()) {
            long[] ddmDataProviderInstanceIds;
            for (long ddmDataProviderInstanceId : ddmDataProviderInstanceIds = this.getDDMDataProviderInstanceIds(ddmFormField.getProperty("ddmDataProviderInstanceId"))) {
                if (ddmDataProviderInstanceId <= 0L) continue;
                dataProviderInstanceIds.add(ddmDataProviderInstanceId);
            }
        }
        for (DDMFormRule ddmFormRule : ddmForm.getDDMFormRules()) {
            Set<Long> ddmFormDataProviderInstanceIds = this.getDataProviderInstanceIds(groupId, ddmFormRule);
            dataProviderInstanceIds.addAll(ddmFormDataProviderInstanceIds);
        }
        return dataProviderInstanceIds;
    }

    protected Set<Long> getDataProviderInstanceIds(long groupId, DDMFormRule ddmFormRule) {
        List actions = ddmFormRule.getActions();
        if (ListUtil.isEmpty((List)actions)) {
            return Collections.emptySet();
        }
        HashSet<Long> dataProviderInstanceIds = new HashSet<Long>();
        for (String action : actions) {
            Matcher matcher = _callFunctionPattern.matcher(action);
            while (matcher.find()) {
                String dataProviderUuid = matcher.group(1);
                DDMDataProviderInstance dataProviderInstance = this._ddmDataProviderInstanceLocalService.fetchDDMDataProviderInstanceByUuidAndGroupId(dataProviderUuid, groupId);
                if (dataProviderInstance == null) continue;
                dataProviderInstanceIds.add(dataProviderInstance.getDataProviderInstanceId());
            }
        }
        return dataProviderInstanceIds;
    }

    protected long[] getDDMDataProviderInstanceIds(JSONArray jsonArray) {
        long[] ddmDataProviderInstanceIds = new long[jsonArray.length()];
        for (int i = 0; i < jsonArray.length(); ++i) {
            ddmDataProviderInstanceIds[i] = jsonArray.getLong(i);
        }
        return ddmDataProviderInstanceIds;
    }

    protected long[] getDDMDataProviderInstanceIds(Object ddmDataProviderInstanceId) {
        long ddmDataProviderInstanceIdLong;
        if (ddmDataProviderInstanceId instanceof JSONArray) {
            JSONArray jsonArray = (JSONArray)ddmDataProviderInstanceId;
            return this.getDDMDataProviderInstanceIds(jsonArray);
        }
        if (ddmDataProviderInstanceId instanceof String) {
            try {
                JSONArray jsonArray = this._jsonFactory.createJSONArray((String)ddmDataProviderInstanceId);
                return this.getDDMDataProviderInstanceIds(jsonArray);
            }
            catch (Exception jsonArray) {
                // empty catch block
            }
        }
        if ((ddmDataProviderInstanceIdLong = GetterUtil.getLong((Object)ddmDataProviderInstanceId)) > 0L) {
            return new long[]{ddmDataProviderInstanceIdLong};
        }
        return GetterUtil.DEFAULT_LONG_VALUES;
    }

    protected Set<String> getDDMFormFieldsNames(DDMForm ddmForm) {
        Map ddmFormFieldsMap = ddmForm.getDDMFormFieldsMap(true);
        if (MapUtil.isEmpty((Map)ddmFormFieldsMap)) {
            return Collections.emptySet();
        }
        HashSet<String> ddmFormFieldsNames = new HashSet<String>();
        for (String ddmFormFieldName : ddmFormFieldsMap.keySet()) {
            ddmFormFieldsNames.add(StringUtil.toLowerCase((String)ddmFormFieldName));
        }
        return ddmFormFieldsNames;
    }

    protected String getNextVersion(String version, boolean majorVersion) {
        int[] versionParts = StringUtil.split((String)version, (String)".", (int)0);
        if (majorVersion) {
            versionParts[0] = versionParts[0] + 1;
            versionParts[1] = 0;
        } else {
            versionParts[1] = versionParts[1] + 1;
        }
        return versionParts[0] + "." + versionParts[1];
    }

    protected DDMForm getParentDDMForm(long parentStructureId) {
        DDMStructure parentStructure = this.ddmStructurePersistence.fetchByPrimaryKey(parentStructureId);
        if (parentStructure == null) {
            return null;
        }
        return parentStructure.getFullHierarchyDDMForm();
    }

    protected String getStructureKey(String structureKey) {
        if (structureKey != null) {
            structureKey = structureKey.trim();
            return StringUtil.toUpperCase((String)structureKey);
        }
        return "";
    }

    protected List<DDMTemplate> getStructureTemplates(DDMStructure structure, String type) {
        long classNameId = this.classNameLocalService.getClassNameId(DDMStructure.class);
        return this._ddmTemplateLocalService.getTemplates(structure.getGroupId(), classNameId, structure.getStructureId(), type);
    }

    protected void reindexStructure(DDMStructure structure, ServiceContext serviceContext) throws PortalException {
        if (!serviceContext.isIndexingEnabled()) {
            return;
        }
        DDMStructureIndexer ddmStructureIndexer = this._ddmStructureIndexerTracker.getDDMStructureIndexer(structure.getClassName());
        if (ddmStructureIndexer == null) {
            return;
        }
        String backgroundTaskName = DDMStructureIndexerBackgroundTaskExecutor.getBackgroundTaskName(structure.getStructureId());
        HashMap taskContextMap = HashMapBuilder.put((Object)"structureId", (Object)structure.getStructureId()).build();
        this._backgroundTaskManager.addBackgroundTask(structure.getUserId(), structure.getGroupId(), backgroundTaskName, DDMStructureIndexerBackgroundTaskExecutor.class.getName(), (Map)taskContextMap, serviceContext);
    }

    protected String serializeJSONDDMForm(DDMForm ddmForm) {
        DDMFormSerializerSerializeRequest.Builder builder = DDMFormSerializerSerializeRequest.Builder.newBuilder((DDMForm)ddmForm);
        DDMFormSerializerSerializeResponse ddmFormSerializerSerializeResponse = this._jsonDDMFormSerializer.serialize(builder.build());
        return ddmFormSerializerSerializeResponse.getContent();
    }

    protected void syncStructureTemplatesFields(final DDMStructure structure) {
        TransactionCommitCallbackUtil.registerCallback((Callable)new Callable<Void>(){

            @Override
            public Void call() throws Exception {
                DDMFormTemplateSynchonizer ddmFormTemplateSynchonizer = new DDMFormTemplateSynchonizer(structure.getDDMForm(), DDMStructureLocalServiceImpl.this._jsonDDMFormDeserializer, DDMStructureLocalServiceImpl.this._jsonDDMFormSerializer, DDMStructureLocalServiceImpl.this._ddmTemplateLocalService);
                List<DDMTemplate> templates = DDMStructureLocalServiceImpl.this.getStructureTemplates(structure, "form");
                ddmFormTemplateSynchonizer.setDDMFormTemplates(templates);
                ddmFormTemplateSynchonizer.synchronize();
                return null;
            }
        });
    }

    protected void updateDataProviderInstanceLinks(long groupId, long structureId, DDMForm ddmForm) {
        Set<Long> dataProviderInstanceIds = this.getDataProviderInstanceIds(groupId, ddmForm);
        List dataProviderInstanceLinks = this._ddmDataProviderInstanceLinkLocalService.getDataProviderInstanceLinks(structureId);
        for (DDMDataProviderInstanceLink dataProviderInstanceLink : dataProviderInstanceLinks) {
            if (dataProviderInstanceIds.remove(dataProviderInstanceLink.getDataProviderInstanceId())) continue;
            this._ddmDataProviderInstanceLinkLocalService.deleteDataProviderInstanceLink(dataProviderInstanceLink);
        }
        for (Long dataProviderInstanceId : dataProviderInstanceIds) {
            this._ddmDataProviderInstanceLinkLocalService.addDataProviderInstanceLink(dataProviderInstanceId.longValue(), structureId);
        }
    }

    protected void validate(DDMForm ddmForm) throws PortalException {
        this._ddmFormValidator.validate(ddmForm);
    }

    protected void validate(DDMForm parentDDMForm, DDMForm ddmForm) throws PortalException {
        Set commonDDMFormFieldNames = SetUtil.intersect(this.getDDMFormFieldsNames(parentDDMForm), this.getDDMFormFieldsNames(ddmForm));
        if (!commonDDMFormFieldNames.isEmpty()) {
            throw new StructureDuplicateElementException("Duplicate DDM form field names: " + StringUtil.merge((Collection)commonDDMFormFieldNames));
        }
    }

    protected void validate(long groupId, long parentStructureId, long classNameId, String structureKey, Map<Locale, String> nameMap, DDMForm ddmForm) throws PortalException {
        DDMStructure structure = this.ddmStructurePersistence.fetchByG_C_S(groupId, classNameId, structureKey = this.getStructureKey(structureKey));
        if (structure != null) {
            StructureDuplicateStructureKeyException structureDuplicateStructureKeyException = new StructureDuplicateStructureKeyException();
            structureDuplicateStructureKeyException.setStructureKey(structure.getStructureKey());
            throw structureDuplicateStructureKeyException;
        }
        this.validate(nameMap, this.getParentDDMForm(parentStructureId), ddmForm);
    }

    protected void validate(Map<Locale, String> nameMap, DDMForm parentDDMForm, DDMForm ddmForm) throws PortalException {
        try {
            if (!ExportImportThreadLocal.isImportInProcess()) {
                this.validate(nameMap, ddmForm.getDefaultLocale());
            }
            this.validate(ddmForm);
            if (parentDDMForm != null) {
                this.validate(parentDDMForm, ddmForm);
            }
        }
        catch (DDMFormValidationException ddmFormValidationException) {
            throw ddmFormValidationException;
        }
        catch (LocaleException localeException) {
            throw localeException;
        }
        catch (StructureDuplicateElementException structureDuplicateElementException) {
            throw structureDuplicateElementException;
        }
        catch (StructureNameException structureNameException) {
            throw structureNameException;
        }
        catch (StructureDefinitionException structureDefinitionException) {
            throw structureDefinitionException;
        }
        catch (Exception exception) {
            throw new StructureDefinitionException((Throwable)exception);
        }
    }

    protected void validate(Map<Locale, String> nameMap, Locale contentDefaultLocale) throws PortalException {
        String name = nameMap.get(contentDefaultLocale);
        if (Validator.isNull((String)name)) {
            throw new StructureNameException("Name is null for locale " + contentDefaultLocale.getDisplayName());
        }
        if (!LanguageUtil.isAvailableLocale((Locale)contentDefaultLocale)) {
            LocaleException localeException = new LocaleException(3, StringBundler.concat((Object[])new Object[]{"The locale ", contentDefaultLocale, " is not available in company ", CompanyThreadLocal.getCompanyId()}));
            localeException.setSourceAvailableLocales(Collections.singleton(contentDefaultLocale));
            localeException.setTargetAvailableLocales((Collection)LanguageUtil.getAvailableLocales());
            throw localeException;
        }
    }

    protected void validateParentStructure(long structureId, long parentStructureId) throws PortalException {
        while (parentStructureId != 0L) {
            DDMStructure parentStructure = this.ddmStructurePersistence.fetchByPrimaryKey(parentStructureId);
            if (structureId == parentStructure.getStructureId()) {
                throw new InvalidParentStructureException();
            }
            parentStructureId = parentStructure.getParentStructureId();
        }
    }
}

