/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.dynamic.data.mapping.service.impl;

import com.liferay.dynamic.data.mapping.model.DDMFormInstance;
import com.liferay.dynamic.data.mapping.model.DDMFormInstanceRecordVersion;
import com.liferay.dynamic.data.mapping.model.DDMFormInstanceReport;
import com.liferay.dynamic.data.mapping.report.DDMFormFieldTypeReportProcessor;
import com.liferay.dynamic.data.mapping.report.DDMFormFieldTypeReportProcessorTracker;
import com.liferay.dynamic.data.mapping.service.DDMFormInstanceRecordVersionLocalService;
import com.liferay.dynamic.data.mapping.service.base.DDMFormInstanceReportLocalServiceBaseImpl;
import com.liferay.dynamic.data.mapping.service.persistence.DDMFormInstancePersistence;
import com.liferay.dynamic.data.mapping.storage.DDMFormFieldValue;
import com.liferay.dynamic.data.mapping.storage.DDMFormValues;
import com.liferay.petra.string.StringBundler;
import com.liferay.portal.aop.AopService;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.json.JSONFactoryUtil;
import com.liferay.portal.kernel.json.JSONObject;
import com.liferay.portal.kernel.json.JSONUtil;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.model.BaseModel;
import java.util.Date;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component(property={"model.class.name=com.liferay.dynamic.data.mapping.model.DDMFormInstanceReport"}, service={AopService.class})
public class DDMFormInstanceReportLocalServiceImpl
extends DDMFormInstanceReportLocalServiceBaseImpl {
    private static final Log _log = LogFactoryUtil.getLog(DDMFormInstanceReportLocalServiceImpl.class);
    @Reference
    private DDMFormFieldTypeReportProcessorTracker _ddmFormFieldTypeReportProcessorTracker;
    @Reference
    private DDMFormInstancePersistence _ddmFormInstancePersistence;
    @Reference
    private DDMFormInstanceRecordVersionLocalService _ddmFormInstanceRecordVersionLocalService;

    public DDMFormInstanceReport addFormInstanceReport(long formInstanceId) throws PortalException {
        DDMFormInstanceReport ddmFormInstanceReport = this.ddmFormInstanceReportPersistence.create(this.counterLocalService.increment());
        DDMFormInstance ddmFormInstance = this._ddmFormInstancePersistence.findByPrimaryKey(formInstanceId);
        ddmFormInstanceReport.setGroupId(ddmFormInstance.getGroupId());
        ddmFormInstanceReport.setCompanyId(ddmFormInstance.getCompanyId());
        ddmFormInstanceReport.setCreateDate(new Date());
        ddmFormInstanceReport.setFormInstanceId(ddmFormInstance.getFormInstanceId());
        return (DDMFormInstanceReport)this.ddmFormInstanceReportPersistence.update((BaseModel)ddmFormInstanceReport);
    }

    public DDMFormInstanceReport getFormInstanceReportByFormInstanceId(long formInstanceId) throws PortalException {
        return this.ddmFormInstanceReportPersistence.findByFormInstanceId(formInstanceId);
    }

    public void processFormInstanceReportEvent(long formInstanceReportId, long formInstanceRecordVersionId, String ddmFormInstanceReportEvent) {
        block2: {
            try {
                this.ddmFormInstanceReportLocalService.updateFormInstanceReport(formInstanceReportId, formInstanceRecordVersionId, ddmFormInstanceReportEvent);
            }
            catch (Exception exception) {
                if (!_log.isWarnEnabled()) break block2;
                StringBundler sb = new StringBundler(3);
                sb.append("Unable to update dynamic data mapping form ");
                sb.append("instance report ");
                sb.append(formInstanceReportId);
                _log.warn((Object)sb.toString(), (Throwable)exception);
            }
        }
    }

    public DDMFormInstanceReport updateFormInstanceReport(long formInstanceReportId, long formInstanceRecordVersionId, String ddmFormInstanceReportEvent) throws PortalException {
        DDMFormInstanceReport ddmFormInstanceReport = this.ddmFormInstanceReportPersistence.findByPrimaryKey(formInstanceReportId);
        ddmFormInstanceReport.setModifiedDate(new Date());
        ddmFormInstanceReport.setData(this._getData(formInstanceRecordVersionId, ddmFormInstanceReportEvent));
        return (DDMFormInstanceReport)this.ddmFormInstanceReportPersistence.update((BaseModel)ddmFormInstanceReport);
    }

    private String _getData(long formInstanceRecordVersionId, String ddmFormInstanceReportEvent) throws PortalException {
        try {
            DDMFormInstanceRecordVersion ddmFormInstanceRecordVersion = this._ddmFormInstanceRecordVersionLocalService.getDDMFormInstanceRecordVersion(formInstanceRecordVersionId);
            DDMFormInstanceReport ddmFormInstanceReport = this.ddmFormInstanceReportPersistence.findByFormInstanceId(ddmFormInstanceRecordVersion.getFormInstanceId());
            JSONObject ddmFormInstanceReportDataJSONObject = JSONFactoryUtil.createJSONObject((String)ddmFormInstanceReport.getData());
            DDMFormValues ddmFormValues = ddmFormInstanceRecordVersion.getDDMFormValues();
            for (DDMFormFieldValue ddmFormFieldValue : ddmFormValues.getDDMFormFieldValues()) {
                DDMFormFieldTypeReportProcessor ddmFormFieldTypeReportProcessor = this._ddmFormFieldTypeReportProcessorTracker.getDDMFormFieldTypeReportProcessor(ddmFormFieldValue.getType());
                if (ddmFormFieldTypeReportProcessor == null) continue;
                String fieldName = ddmFormFieldValue.getName();
                JSONObject fieldJSONObject = ddmFormInstanceReportDataJSONObject.getJSONObject(fieldName);
                if (fieldJSONObject == null) {
                    fieldJSONObject = JSONUtil.put((String)"type", (Object)ddmFormFieldValue.getType()).put("values", JSONFactoryUtil.createJSONObject());
                }
                JSONObject processedFieldJSONObject = ddmFormFieldTypeReportProcessor.process(ddmFormFieldValue, JSONFactoryUtil.createJSONObject((String)fieldJSONObject.toJSONString()), ddmFormInstanceRecordVersion.getFormInstanceRecordId(), ddmFormInstanceReportEvent);
                ddmFormInstanceReportDataJSONObject.put(fieldName, processedFieldJSONObject);
            }
            int totalItems = ddmFormInstanceReportDataJSONObject.getInt("totalItems");
            if (ddmFormInstanceReportEvent.equals("add")) {
                ++totalItems;
            } else if (ddmFormInstanceReportEvent.equals("delete")) {
                --totalItems;
            }
            ddmFormInstanceReportDataJSONObject.put("totalItems", totalItems);
            return ddmFormInstanceReportDataJSONObject.toString();
        }
        catch (Exception exception) {
            throw new PortalException("Unable to process data for form instance record version " + formInstanceRecordVersionId, (Throwable)exception);
        }
    }
}

