/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.dynamic.data.mapping.internal.petra.executor;

import com.liferay.petra.concurrent.NoticeableExecutorService;
import com.liferay.petra.concurrent.ThreadPoolHandler;
import com.liferay.petra.concurrent.ThreadPoolHandlerAdapter;
import com.liferay.petra.executor.PortalExecutorConfig;
import com.liferay.petra.executor.PortalExecutorManager;
import com.liferay.petra.function.UnsafeRunnable;
import com.liferay.petra.lang.CentralizedThreadLocal;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.util.NamedThreadFactory;
import com.liferay.portal.kernel.util.PortalClassLoaderUtil;
import com.liferay.portal.kernel.util.PortalRunMode;
import java.util.concurrent.RejectedExecutionHandler;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceRegistration;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Deactivate;
import org.osgi.service.component.annotations.Reference;

@Component(immediate=true, service={DDMFormInstanceReportPortalExecutor.class})
public class DDMFormInstanceReportPortalExecutor {
    private static final Log _log = LogFactoryUtil.getLog(DDMFormInstanceReportPortalExecutor.class);
    private NoticeableExecutorService _noticeableExecutorService;
    @Reference
    private PortalExecutorManager _portalExecutorManager;
    private ServiceRegistration<PortalExecutorConfig> _serviceRegistration;

    public <T extends Throwable> void execute(UnsafeRunnable<T> unsafeRunnable) {
        if (PortalRunMode.isTestMode()) {
            try {
                unsafeRunnable.run();
            }
            catch (Throwable t) {
                _log.error((Object)t, t);
            }
        } else {
            this._noticeableExecutorService.submit(() -> {
                try {
                    unsafeRunnable.run();
                }
                catch (Throwable t) {
                    _log.error((Object)t, t);
                }
            });
        }
    }

    @Activate
    protected void activate(BundleContext bundleContext) {
        this._registerPortalExecutorConfig(bundleContext);
        this._noticeableExecutorService = this._portalExecutorManager.getPortalExecutor(DDMFormInstanceReportPortalExecutor.class.getName());
    }

    @Deactivate
    protected void deactivate() {
        this._noticeableExecutorService.shutdown();
        this._serviceRegistration.unregister();
    }

    private void _registerPortalExecutorConfig(BundleContext bundleContext) {
        PortalExecutorConfig portalExecutorConfig = new PortalExecutorConfig(DDMFormInstanceReportPortalExecutor.class.getName(), 1, 1, 60L, TimeUnit.SECONDS, Integer.MAX_VALUE, (ThreadFactory)new NamedThreadFactory(DDMFormInstanceReportPortalExecutor.class.getName(), 5, PortalClassLoaderUtil.getClassLoader()), (RejectedExecutionHandler)new ThreadPoolExecutor.AbortPolicy(), (ThreadPoolHandler)new ThreadPoolHandlerAdapter(){

            public void afterExecute(Runnable runnable, Throwable throwable) {
                CentralizedThreadLocal.clearShortLivedThreadLocals();
            }
        });
        this._serviceRegistration = bundleContext.registerService(PortalExecutorConfig.class, (Object)portalExecutorConfig, null);
    }
}

