/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.dynamic.data.mapping.internal.storage;

import com.liferay.dynamic.data.mapping.io.DDMFormValuesDeserializer;
import com.liferay.dynamic.data.mapping.io.DDMFormValuesDeserializerDeserializeRequest;
import com.liferay.dynamic.data.mapping.io.DDMFormValuesDeserializerDeserializeResponse;
import com.liferay.dynamic.data.mapping.io.DDMFormValuesSerializer;
import com.liferay.dynamic.data.mapping.io.DDMFormValuesSerializerSerializeRequest;
import com.liferay.dynamic.data.mapping.io.DDMFormValuesSerializerSerializeResponse;
import com.liferay.dynamic.data.mapping.model.DDMContent;
import com.liferay.dynamic.data.mapping.model.DDMForm;
import com.liferay.dynamic.data.mapping.model.DDMStorageLink;
import com.liferay.dynamic.data.mapping.model.DDMStructure;
import com.liferay.dynamic.data.mapping.model.DDMStructureVersion;
import com.liferay.dynamic.data.mapping.service.DDMContentLocalService;
import com.liferay.dynamic.data.mapping.service.DDMStorageLinkLocalService;
import com.liferay.dynamic.data.mapping.service.DDMStructureLocalService;
import com.liferay.dynamic.data.mapping.service.DDMStructureVersionLocalService;
import com.liferay.dynamic.data.mapping.storage.BaseStorageAdapter;
import com.liferay.dynamic.data.mapping.storage.DDMFormValues;
import com.liferay.dynamic.data.mapping.storage.StorageAdapter;
import com.liferay.dynamic.data.mapping.storage.StorageType;
import com.liferay.dynamic.data.mapping.validator.DDMFormValuesValidator;
import com.liferay.portal.kernel.service.ServiceContext;
import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.kernel.util.Portal;
import java.util.List;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component(service={StorageAdapter.class})
public class JSONStorageAdapter
extends BaseStorageAdapter {
    private DDMContentLocalService _ddmContentLocalService;
    private DDMFormValuesValidator _ddmFormValuesValidator;
    private DDMStorageLinkLocalService _ddmStorageLinkLocalService;
    private DDMStructureLocalService _ddmStructureLocalService;
    private DDMStructureVersionLocalService _ddmStructureVersionLocalService;
    @Reference(target="(ddm.form.values.deserializer.type=json)")
    private DDMFormValuesDeserializer _jsonDDMFormValuesDeserializer;
    @Reference(target="(ddm.form.values.serializer.type=json)")
    private DDMFormValuesSerializer _jsonDDMFormValuesSerializer;
    @Reference
    private Portal _portal;

    public long doCreate(long companyId, long ddmStructureId, DDMFormValues ddmFormValues, ServiceContext serviceContext) throws Exception {
        this.validate(ddmFormValues, serviceContext);
        long classNameId = this._portal.getClassNameId(DDMContent.class.getName());
        String serializedDDMFormValues = this.serialize(ddmFormValues);
        DDMContent ddmContent = this._ddmContentLocalService.addContent(serviceContext.getUserId(), serviceContext.getScopeGroupId(), DDMStorageLink.class.getName(), null, serializedDDMFormValues, serviceContext);
        DDMStructure ddmStructure = this._ddmStructureLocalService.getDDMStructure(ddmStructureId);
        DDMStructureVersion ddmStructureVersion = ddmStructure.getLatestStructureVersion();
        this._ddmStorageLinkLocalService.addStorageLink(classNameId, ddmContent.getPrimaryKey(), ddmStructureVersion.getStructureVersionId(), serviceContext);
        return ddmContent.getPrimaryKey();
    }

    public void doUpdate(long classPK, DDMFormValues ddmFormValues, ServiceContext serviceContext) throws Exception {
        this.validate(ddmFormValues, serviceContext);
        DDMContent ddmContent = this._ddmContentLocalService.getContent(classPK);
        ddmContent.setModifiedDate(serviceContext.getModifiedDate(null));
        String serializedDDMFormValues = this.serialize(ddmFormValues);
        ddmContent.setData(serializedDDMFormValues);
        this._ddmContentLocalService.updateContent(ddmContent.getPrimaryKey(), ddmContent.getName(), ddmContent.getDescription(), ddmContent.getData(), serviceContext);
    }

    public String getStorageType() {
        return StorageType.JSON.toString();
    }

    protected DDMFormValues deserialize(String content, DDMForm ddmForm) {
        DDMFormValuesDeserializerDeserializeRequest.Builder builder = DDMFormValuesDeserializerDeserializeRequest.Builder.newBuilder((String)content, (DDMForm)ddmForm);
        DDMFormValuesDeserializerDeserializeResponse ddmFormValuesDeserializerDeserializeResponse = this._jsonDDMFormValuesDeserializer.deserialize(builder.build());
        return ddmFormValuesDeserializerDeserializeResponse.getDDMFormValues();
    }

    protected void doDeleteByClass(long classPK) throws Exception {
        this._ddmContentLocalService.deleteDDMContent(classPK);
        this._ddmStorageLinkLocalService.deleteClassStorageLink(classPK);
    }

    protected void doDeleteByDDMStructure(long ddmStructureId) throws Exception {
        List ddmStorageLinks = this._ddmStorageLinkLocalService.getStructureStorageLinks(ddmStructureId);
        for (DDMStorageLink ddmStorageLink : ddmStorageLinks) {
            this.doDeleteByClass(ddmStorageLink.getClassPK());
        }
    }

    protected DDMFormValues doGetDDMFormValues(long classPK) throws Exception {
        DDMContent ddmContent = this._ddmContentLocalService.getContent(classPK);
        DDMStorageLink ddmStorageLink = this._ddmStorageLinkLocalService.getClassStorageLink(ddmContent.getPrimaryKey());
        DDMStructureVersion ddmStructureVersion = this._ddmStructureVersionLocalService.getDDMStructureVersion(ddmStorageLink.getStructureVersionId());
        return this.deserialize(ddmContent.getData(), ddmStructureVersion.getDDMForm());
    }

    protected String serialize(DDMFormValues ddmFormValues) {
        DDMFormValuesSerializerSerializeRequest.Builder builder = DDMFormValuesSerializerSerializeRequest.Builder.newBuilder((DDMFormValues)ddmFormValues);
        DDMFormValuesSerializerSerializeResponse ddmFormValuesSerializerSerializeResponse = this._jsonDDMFormValuesSerializer.serialize(builder.build());
        return ddmFormValuesSerializerSerializeResponse.getContent();
    }

    @Reference(unbind="-")
    protected void setDDMContentLocalService(DDMContentLocalService ddmContentLocalService) {
        this._ddmContentLocalService = ddmContentLocalService;
    }

    @Reference(unbind="-")
    protected void setDDMFormValuesValidator(DDMFormValuesValidator ddmFormValuesValidator) {
        this._ddmFormValuesValidator = ddmFormValuesValidator;
    }

    @Reference(unbind="-")
    protected void setDDMStorageLinkLocalService(DDMStorageLinkLocalService ddmStorageLinkLocalService) {
        this._ddmStorageLinkLocalService = ddmStorageLinkLocalService;
    }

    @Reference(unbind="-")
    protected void setDDMStructureLocalService(DDMStructureLocalService ddmStructureLocalService) {
        this._ddmStructureLocalService = ddmStructureLocalService;
    }

    @Reference(unbind="-")
    protected void setDDMStructureVersionLocalService(DDMStructureVersionLocalService ddmStructureVersionLocalService) {
        this._ddmStructureVersionLocalService = ddmStructureVersionLocalService;
    }

    protected void validate(DDMFormValues ddmFormValues, ServiceContext serviceContext) throws Exception {
        boolean validateDDMFormValues = GetterUtil.getBoolean((Object)serviceContext.getAttribute("validateDDMFormValues"), (boolean)true);
        if (!validateDDMFormValues) {
            return;
        }
        this._ddmFormValuesValidator.validate(ddmFormValues);
    }
}

