/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.dynamic.data.mapping.internal.io;

import com.liferay.dynamic.data.mapping.form.field.type.DDMFormFieldType;
import com.liferay.dynamic.data.mapping.form.field.type.DDMFormFieldTypeServicesTracker;
import com.liferay.dynamic.data.mapping.form.field.type.DefaultDDMFormFieldTypeSettings;
import com.liferay.dynamic.data.mapping.model.DDMForm;
import com.liferay.dynamic.data.mapping.model.DDMFormField;
import com.liferay.dynamic.data.mapping.model.DDMFormFieldOptions;
import com.liferay.dynamic.data.mapping.model.DDMFormFieldValidation;
import com.liferay.dynamic.data.mapping.model.DDMFormFieldValidationExpression;
import com.liferay.dynamic.data.mapping.model.LocalizedValue;
import com.liferay.dynamic.data.mapping.util.DDMFormFactory;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.json.JSONArray;
import com.liferay.portal.kernel.json.JSONFactory;
import com.liferay.portal.kernel.json.JSONObject;
import com.liferay.portal.kernel.util.LocaleUtil;
import com.liferay.portal.kernel.util.Validator;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;

public class JSONObjectToDDMFormFieldTransformer {
    private final DDMFormFieldTypeServicesTracker _ddmFormFieldTypeServicesTracker;
    private final JSONFactory _jsonFactory;

    public JSONObjectToDDMFormFieldTransformer(DDMFormFieldTypeServicesTracker ddmFormFieldTypeServicesTracker, JSONFactory jsonFactory) {
        this._ddmFormFieldTypeServicesTracker = ddmFormFieldTypeServicesTracker;
        this._jsonFactory = jsonFactory;
    }

    public DDMFormField transform(JSONObject jsonObject) throws PortalException {
        return this.getDDMFormField(jsonObject);
    }

    protected void addOptionValueLabels(JSONObject jsonObject, DDMFormFieldOptions ddmFormFieldOptions, String optionValue) {
        Iterator itr = jsonObject.keys();
        while (itr.hasNext()) {
            String languageId = (String)itr.next();
            ddmFormFieldOptions.addOptionLabel(optionValue, LocaleUtil.fromLanguageId((String)languageId), jsonObject.getString(languageId));
        }
    }

    protected DDMFormFieldOptions deserializeDDMFormFieldOptions(String serializedDDMFormFieldProperty) throws PortalException {
        if (Validator.isNull((String)serializedDDMFormFieldProperty)) {
            return new DDMFormFieldOptions();
        }
        JSONArray jsonArray = this._jsonFactory.createJSONArray(serializedDDMFormFieldProperty);
        return this.getDDMFormFieldOptions(jsonArray);
    }

    protected Object deserializeDDMFormFieldProperty(String serializedDDMFormFieldProperty, DDMFormField ddmFormFieldTypeSetting) throws PortalException {
        if (ddmFormFieldTypeSetting.isLocalizable()) {
            return this.deserializeLocalizedValue(serializedDDMFormFieldProperty);
        }
        String dataType = ddmFormFieldTypeSetting.getDataType();
        if (Objects.equals(dataType, "boolean")) {
            return Boolean.valueOf(serializedDDMFormFieldProperty);
        }
        if (Objects.equals(dataType, "ddm-options")) {
            return this.deserializeDDMFormFieldOptions(serializedDDMFormFieldProperty);
        }
        if (Objects.equals(ddmFormFieldTypeSetting.getType(), "validation")) {
            return this.deserializeDDMFormFieldValidation(serializedDDMFormFieldProperty);
        }
        return serializedDDMFormFieldProperty;
    }

    protected DDMFormFieldValidation deserializeDDMFormFieldValidation(String serializedDDMFormFieldProperty) throws PortalException {
        DDMFormFieldValidation ddmFormFieldValidation = new DDMFormFieldValidation();
        if (Validator.isNull((String)serializedDDMFormFieldProperty)) {
            return ddmFormFieldValidation;
        }
        JSONObject jsonObject = this._jsonFactory.createJSONObject(serializedDDMFormFieldProperty);
        final JSONObject expressionJSONObject = jsonObject.getJSONObject("expression");
        if (expressionJSONObject != null) {
            ddmFormFieldValidation.setDDMFormFieldValidationExpression(new DDMFormFieldValidationExpression(){
                {
                    this.setName(expressionJSONObject.getString("name"));
                    this.setValue(expressionJSONObject.getString("value"));
                }
            });
        }
        ddmFormFieldValidation.setErrorMessageLocalizedValue(this.deserializeLocalizedValue(jsonObject.getString("errorMessage")));
        ddmFormFieldValidation.setParameterLocalizedValue(this.deserializeLocalizedValue(jsonObject.getString("parameter")));
        return ddmFormFieldValidation;
    }

    protected LocalizedValue deserializeLocalizedValue(String serializedDDMFormFieldProperty) throws PortalException {
        LocalizedValue localizedValue = new LocalizedValue();
        if (Validator.isNull((String)serializedDDMFormFieldProperty)) {
            return localizedValue;
        }
        JSONObject jsonObject = this._jsonFactory.createJSONObject(serializedDDMFormFieldProperty);
        Iterator itr = jsonObject.keys();
        while (itr.hasNext()) {
            String languageId = (String)itr.next();
            localizedValue.addString(LocaleUtil.fromLanguageId((String)languageId), jsonObject.getString(languageId));
        }
        return localizedValue;
    }

    protected DDMFormField getDDMFormField(JSONObject jsonObject) throws PortalException {
        String name = jsonObject.getString("name");
        String type = jsonObject.getString("type");
        DDMFormField ddmFormField = new DDMFormField(name, type);
        this.setDDMFormFieldProperties(jsonObject, ddmFormField);
        this.setNestedDDMFormField(jsonObject.getJSONArray("nestedFields"), ddmFormField);
        return ddmFormField;
    }

    protected DDMFormFieldOptions getDDMFormFieldOptions(JSONArray jsonArray) {
        DDMFormFieldOptions ddmFormFieldOptions = new DDMFormFieldOptions();
        for (int i = 0; i < jsonArray.length(); ++i) {
            JSONObject jsonObject = jsonArray.getJSONObject(i);
            String value = jsonObject.getString("value");
            ddmFormFieldOptions.addOption(value);
            this.addOptionValueLabels(jsonObject.getJSONObject("label"), ddmFormFieldOptions, value);
        }
        return ddmFormFieldOptions;
    }

    protected List<DDMFormField> getDDMFormFields(JSONArray jsonArray) throws PortalException {
        ArrayList<DDMFormField> ddmFormFields = new ArrayList<DDMFormField>();
        for (int i = 0; i < jsonArray.length(); ++i) {
            DDMFormField ddmFormField = this.getDDMFormField(jsonArray.getJSONObject(i));
            ddmFormFields.add(ddmFormField);
        }
        return ddmFormFields;
    }

    protected DDMForm getDDMFormFieldTypeSettingsDDMForm(String type) {
        DDMFormFieldType ddmFormFieldType = this._ddmFormFieldTypeServicesTracker.getDDMFormFieldType(type);
        Class ddmFormFieldTypeSettings = DefaultDDMFormFieldTypeSettings.class;
        if (ddmFormFieldType != null) {
            ddmFormFieldTypeSettings = ddmFormFieldType.getDDMFormFieldTypeSettings();
        }
        return DDMFormFactory.create(ddmFormFieldTypeSettings);
    }

    protected void setDDMFormFieldProperties(JSONObject jsonObject, DDMFormField ddmFormField) throws PortalException {
        DDMForm ddmFormFieldTypeSettingsDDMForm = this.getDDMFormFieldTypeSettingsDDMForm(ddmFormField.getType());
        for (DDMFormField ddmFormFieldTypeSetting : ddmFormFieldTypeSettingsDDMForm.getDDMFormFields()) {
            this.setDDMFormFieldProperty(jsonObject, ddmFormField, ddmFormFieldTypeSetting);
        }
    }

    protected void setDDMFormFieldProperty(JSONObject jsonObject, DDMFormField ddmFormField, DDMFormField ddmFormFieldTypeSetting) throws PortalException {
        String settingName = ddmFormFieldTypeSetting.getName();
        if (jsonObject.has(settingName)) {
            Object deserializedDDMFormFieldProperty = this.deserializeDDMFormFieldProperty(jsonObject.getString(settingName), ddmFormFieldTypeSetting);
            ddmFormField.setProperty(settingName, deserializedDDMFormFieldProperty);
        }
    }

    protected void setNestedDDMFormField(JSONArray jsonArray, DDMFormField ddmFormField) throws PortalException {
        if (jsonArray == null || jsonArray.length() == 0) {
            return;
        }
        ddmFormField.setNestedDDMFormFields(this.getDDMFormFields(jsonArray));
    }
}

