/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.dynamic.data.mapping.internal.io;

import com.liferay.dynamic.data.mapping.form.field.type.DDMFormFieldValueJSONDeserializer;
import com.liferay.dynamic.data.mapping.io.DDMFormValuesDeserializer;
import com.liferay.dynamic.data.mapping.io.DDMFormValuesDeserializerDeserializeRequest;
import com.liferay.dynamic.data.mapping.io.DDMFormValuesDeserializerDeserializeResponse;
import com.liferay.dynamic.data.mapping.model.DDMForm;
import com.liferay.dynamic.data.mapping.model.DDMFormField;
import com.liferay.dynamic.data.mapping.model.LocalizedValue;
import com.liferay.dynamic.data.mapping.model.UnlocalizedValue;
import com.liferay.dynamic.data.mapping.model.Value;
import com.liferay.dynamic.data.mapping.storage.DDMFormFieldValue;
import com.liferay.dynamic.data.mapping.storage.DDMFormValues;
import com.liferay.osgi.service.tracker.collections.map.ServiceTrackerMap;
import com.liferay.osgi.service.tracker.collections.map.ServiceTrackerMapFactory;
import com.liferay.portal.kernel.json.JSONArray;
import com.liferay.portal.kernel.json.JSONFactory;
import com.liferay.portal.kernel.json.JSONObject;
import com.liferay.portal.kernel.json.JSONUtil;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.util.LocaleUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.stream.Stream;
import org.osgi.framework.BundleContext;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Deactivate;
import org.osgi.service.component.annotations.Reference;

@Component(immediate=true, property={"ddm.form.values.deserializer.type=json"}, service={DDMFormValuesDeserializer.class})
public class DDMFormValuesJSONDeserializer
implements DDMFormValuesDeserializer {
    private static final Log _log = LogFactoryUtil.getLog(DDMFormValuesJSONDeserializer.class);
    private JSONFactory _jsonFactory;
    private ServiceTrackerMap<String, DDMFormFieldValueJSONDeserializer> _serviceTrackerMap;

    public DDMFormValuesDeserializerDeserializeResponse deserialize(DDMFormValuesDeserializerDeserializeRequest ddmFormValuesDeserializerDeserializeRequest) {
        DDMFormValues ddmFormValues;
        block4: {
            ddmFormValues = null;
            try {
                JSONObject jsonObject = this._jsonFactory.createJSONObject(ddmFormValuesDeserializerDeserializeRequest.getContent());
                String defaultLanguageId = jsonObject.getString("defaultLanguageId");
                DDMForm ddmForm = ddmFormValuesDeserializerDeserializeRequest.getDDMForm();
                ddmFormValues = new DDMFormValues(ddmForm);
                JSONArray jsonArray = jsonObject.getJSONArray("availableLanguageIds");
                JSONArray fieldValuesJSONArray = jsonObject.getJSONArray("fieldValues");
                if (fieldValuesJSONArray == null) {
                    jsonArray = this._jsonFactory.createJSONArray((Object[])LocaleUtil.toLanguageIds((Collection)ddmForm.getAvailableLocales()));
                    defaultLanguageId = LocaleUtil.toLanguageId((Locale)ddmForm.getDefaultLocale());
                    fieldValuesJSONArray = this._jsonFactory.createJSONArray();
                    for (String name : jsonObject.keySet()) {
                        fieldValuesJSONArray.put(JSONUtil.put((String)"name", (Object)name).put("value", JSONUtil.put((String)defaultLanguageId, (Object)jsonObject.getString(name))));
                    }
                }
                this.setDDMFormValuesAvailableLocales(jsonArray, ddmFormValues);
                this.setDDMFormValuesDefaultLocale(defaultLanguageId, ddmFormValues);
                this.setDDMFormFieldValues(fieldValuesJSONArray, ddmForm, ddmFormValues);
                this.setDDMFormLocalizedValuesDefaultLocale(ddmFormValues);
            }
            catch (Exception exception) {
                if (!_log.isWarnEnabled()) break block4;
                _log.warn((Object)exception, (Throwable)exception);
            }
        }
        DDMFormValuesDeserializerDeserializeResponse.Builder builder = DDMFormValuesDeserializerDeserializeResponse.Builder.newBuilder(ddmFormValues);
        return builder.build();
    }

    @Activate
    protected void activate(BundleContext bundleContext) {
        this._serviceTrackerMap = ServiceTrackerMapFactory.openSingleValueMap((BundleContext)bundleContext, DDMFormFieldValueJSONDeserializer.class, (String)"ddm.form.field.type.name");
    }

    @Deactivate
    protected void deactivate() {
        this._serviceTrackerMap.close();
    }

    protected Set<Locale> getAvailableLocales(JSONArray jsonArray) {
        HashSet<Locale> availableLocales = new HashSet<Locale>();
        if (jsonArray == null) {
            return availableLocales;
        }
        for (int i = 0; i < jsonArray.length(); ++i) {
            Locale availableLocale = LocaleUtil.fromLanguageId((String)jsonArray.getString(i));
            availableLocales.add(availableLocale);
        }
        return availableLocales;
    }

    protected DDMFormFieldValue getDDMFormFieldValue(JSONObject jsonObject, Map<String, DDMFormField> ddmFormFieldsMap) {
        DDMFormFieldValue ddmFormFieldValue = new DDMFormFieldValue();
        String instanceId = jsonObject.getString("instanceId");
        if (instanceId.matches("[a-zA-Z0-9]*")) {
            ddmFormFieldValue.setInstanceId(instanceId);
        }
        ddmFormFieldValue.setName(jsonObject.getString("name"));
        this.setDDMFormFieldValueValue(jsonObject, ddmFormFieldsMap.get(jsonObject.getString("name")), ddmFormFieldValue);
        this.setNestedDDMFormFieldValues(jsonObject.getJSONArray("nestedFieldValues"), ddmFormFieldsMap, ddmFormFieldValue);
        return ddmFormFieldValue;
    }

    protected DDMFormFieldValueJSONDeserializer getDDMFormFieldValueJSONDeserializer(DDMFormField ddmFormField) {
        if (ddmFormField == null) {
            return null;
        }
        return (DDMFormFieldValueJSONDeserializer)this._serviceTrackerMap.getService((Object)ddmFormField.getType());
    }

    protected List<DDMFormFieldValue> getDDMFormFieldValues(JSONArray jsonArray, Map<String, DDMFormField> ddmFormFieldsMap) {
        ArrayList<DDMFormFieldValue> ddmFormFieldValues = new ArrayList<DDMFormFieldValue>();
        for (int i = 0; i < jsonArray.length(); ++i) {
            DDMFormFieldValue ddmFormFieldValue = this.getDDMFormFieldValue(jsonArray.getJSONObject(i), ddmFormFieldsMap);
            ddmFormFieldValues.add(ddmFormFieldValue);
        }
        return ddmFormFieldValues;
    }

    protected LocalizedValue getLocalizedValue(JSONObject jsonObject) {
        LocalizedValue localizedValue = new LocalizedValue();
        Iterator itr = jsonObject.keys();
        while (itr.hasNext()) {
            String languageId = (String)itr.next();
            if (this.isInvalidLocale(languageId)) continue;
            localizedValue.addString(LocaleUtil.fromLanguageId((String)languageId), jsonObject.getString(languageId));
        }
        return localizedValue;
    }

    protected Value getValue(DDMFormField ddmFormField, JSONObject jsonObject) {
        DDMFormFieldValueJSONDeserializer ddmFormFieldValueJSONDeserializer = this.getDDMFormFieldValueJSONDeserializer(ddmFormField);
        if (ddmFormFieldValueJSONDeserializer != null) {
            return ddmFormFieldValueJSONDeserializer.deserialize(ddmFormField, String.valueOf(jsonObject.get("value")));
        }
        JSONObject valueJSONObject = jsonObject.getJSONObject("value");
        if (this.isLocalized(valueJSONObject)) {
            return this.getLocalizedValue(valueJSONObject);
        }
        return new UnlocalizedValue(jsonObject.getString("value"));
    }

    protected boolean isInvalidLocale(String languageId) {
        return LocaleUtil.fromLanguageId((String)languageId, (boolean)true, (boolean)false) == null;
    }

    protected boolean isLocalized(JSONObject jsonObject) {
        if (jsonObject == null) {
            return false;
        }
        Set keys = jsonObject.keySet();
        Stream stream = keys.stream();
        return !stream.anyMatch(this::isInvalidLocale);
    }

    protected void setDDMFormFieldValueLocalizedValueDefaultLocale(DDMFormFieldValue ddmFormFieldValue, Locale defaultLocale) {
        Value value = ddmFormFieldValue.getValue();
        if (value != null && value.isLocalized()) {
            value.setDefaultLocale(defaultLocale);
        }
        for (DDMFormFieldValue nestedDDMFormFieldValue : ddmFormFieldValue.getNestedDDMFormFieldValues()) {
            this.setDDMFormFieldValueLocalizedValueDefaultLocale(nestedDDMFormFieldValue, defaultLocale);
        }
    }

    protected void setDDMFormFieldValues(JSONArray jsonArray, DDMForm ddmForm, DDMFormValues ddmFormValues) {
        List<DDMFormFieldValue> ddmFormFieldValues = this.getDDMFormFieldValues(jsonArray, ddmForm.getDDMFormFieldsMap(true));
        ddmFormValues.setDDMFormFieldValues(ddmFormFieldValues);
    }

    protected void setDDMFormFieldValueValue(JSONObject jsonObject, DDMFormField ddmFormField, DDMFormFieldValue ddmFormFieldValue) {
        String valueString = jsonObject.getString("value", null);
        if (valueString == null) {
            return;
        }
        ddmFormFieldValue.setValue(this.getValue(ddmFormField, jsonObject));
    }

    protected void setDDMFormLocalizedValuesDefaultLocale(DDMFormValues ddmFormValues) {
        for (DDMFormFieldValue ddmFormFieldValue : ddmFormValues.getDDMFormFieldValues()) {
            this.setDDMFormFieldValueLocalizedValueDefaultLocale(ddmFormFieldValue, ddmFormValues.getDefaultLocale());
        }
    }

    protected void setDDMFormValuesAvailableLocales(JSONArray jsonArray, DDMFormValues ddmFormValues) {
        ddmFormValues.setAvailableLocales(this.getAvailableLocales(jsonArray));
    }

    protected void setDDMFormValuesDefaultLocale(String defaultLanguageId, DDMFormValues ddmFormValues) {
        Locale defaultLocale = LocaleUtil.fromLanguageId((String)defaultLanguageId);
        ddmFormValues.setDefaultLocale(defaultLocale);
        Set availableLocales = ddmFormValues.getAvailableLocales();
        if (availableLocales != null && !availableLocales.contains(defaultLocale)) {
            availableLocales.add(defaultLocale);
        }
    }

    @Reference(unbind="-")
    protected void setJSONFactory(JSONFactory jsonFactory) {
        this._jsonFactory = jsonFactory;
    }

    protected void setNestedDDMFormFieldValues(JSONArray jsonArray, Map<String, DDMFormField> ddmFormFieldsMap, DDMFormFieldValue ddmFormFieldValue) {
        if (jsonArray == null || jsonArray.length() == 0) {
            return;
        }
        List<DDMFormFieldValue> nestedDDMFormFieldValues = this.getDDMFormFieldValues(jsonArray, ddmFormFieldsMap);
        ddmFormFieldValue.setNestedDDMFormFields(nestedDDMFormFieldValues);
    }
}

