/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.dynamic.data.mapping.internal.util;

import com.liferay.dynamic.data.mapping.configuration.DDMIndexerConfiguration;
import com.liferay.dynamic.data.mapping.model.DDMFormField;
import com.liferay.dynamic.data.mapping.model.DDMStructure;
import com.liferay.dynamic.data.mapping.service.DDMStructureLocalService;
import com.liferay.dynamic.data.mapping.storage.DDMFormValues;
import com.liferay.dynamic.data.mapping.storage.Fields;
import com.liferay.dynamic.data.mapping.util.DDM;
import com.liferay.dynamic.data.mapping.util.DDMFormValuesToFieldsConverter;
import com.liferay.dynamic.data.mapping.util.DDMIndexer;
import com.liferay.petra.string.StringBundler;
import com.liferay.portal.configuration.metatype.bnd.util.ConfigurableUtil;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.json.JSONArray;
import com.liferay.portal.kernel.json.JSONFactoryUtil;
import com.liferay.portal.kernel.json.JSONObject;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.search.BooleanQuery;
import com.liferay.portal.kernel.search.Document;
import com.liferay.portal.kernel.search.DocumentImpl;
import com.liferay.portal.kernel.search.Field;
import com.liferay.portal.kernel.search.FieldArray;
import com.liferay.portal.kernel.search.filter.QueryFilter;
import com.liferay.portal.kernel.search.generic.BooleanQueryImpl;
import com.liferay.portal.kernel.search.generic.NestedQuery;
import com.liferay.portal.kernel.util.ArrayUtil;
import com.liferay.portal.kernel.util.FastDateFormatFactoryUtil;
import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.kernel.util.HtmlUtil;
import com.liferay.portal.kernel.util.LocaleUtil;
import com.liferay.portal.kernel.util.PropsUtil;
import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.portal.search.engine.SearchEngineInformation;
import com.liferay.portal.search.query.Queries;
import com.liferay.portal.search.query.Query;
import com.liferay.portal.search.sort.FieldSort;
import com.liferay.portal.search.sort.NestedSort;
import com.liferay.portal.search.sort.Sort;
import com.liferay.portal.search.sort.SortBuilderFactory;
import com.liferay.portal.search.sort.SortOrder;
import com.liferay.portal.search.sort.Sorts;
import java.io.Serializable;
import java.math.BigDecimal;
import java.text.Format;
import java.util.Date;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Modified;
import org.osgi.service.component.annotations.Reference;

@Component(configurationPid={"com.liferay.dynamic.data.mapping.configuration.DDMIndexerConfiguration"}, immediate=true, service={DDMIndexer.class})
public class DDMIndexerImpl
implements DDMIndexer {
    @Reference
    protected Queries queries;
    @Reference
    protected SearchEngineInformation searchEngineInformation;
    @Reference
    protected SortBuilderFactory sortBuilderFactory;
    @Reference
    protected Sorts sorts;
    private static final Log _log = LogFactoryUtil.getLog(DDMIndexerImpl.class);
    private DDM _ddm;
    private DDMFormValuesToFieldsConverter _ddmFormValuesToFieldsConverter;
    private volatile DDMIndexerConfiguration _ddmIndexerConfiguration;
    private DDMStructureLocalService _ddmStructureLocalService;

    public void addAttributes(Document document, DDMStructure ddmStructure, DDMFormValues ddmFormValues) {
        boolean legacyDDMIndexFieldsEnabled = this.isLegacyDDMIndexFieldsEnabled();
        FieldArray fieldArray = (FieldArray)document.getField("ddmFieldArray");
        if (fieldArray == null && !legacyDDMIndexFieldsEnabled) {
            fieldArray = new FieldArray("ddmFieldArray");
            document.add((Field)fieldArray);
        }
        Set locales = ddmFormValues.getAvailableLocales();
        Fields fields = this.toFields(ddmStructure, ddmFormValues);
        for (com.liferay.dynamic.data.mapping.storage.Field field : fields) {
            try {
                String indexType = ddmStructure.getFieldProperty(field.getName(), "indexType");
                if (Validator.isNull((String)indexType) || indexType.equals("none")) continue;
                String name = null;
                Serializable value = null;
                if (GetterUtil.getBoolean((String)ddmStructure.getFieldProperty(field.getName(), "localizable"))) {
                    for (Locale locale : locales) {
                        name = this.encodeName(ddmStructure.getStructureId(), field.getName(), locale, indexType);
                        value = field.getValue(locale);
                        if (legacyDDMIndexFieldsEnabled) {
                            this.addToDocument(document, field, name, value, indexType);
                            continue;
                        }
                        fieldArray.addField(this.createField(field, name, value, indexType, locale));
                    }
                    continue;
                }
                name = this.encodeName(ddmStructure.getStructureId(), field.getName(), null, indexType);
                value = field.getValue(ddmFormValues.getDefaultLocale());
                if (legacyDDMIndexFieldsEnabled) {
                    this.addToDocument(document, field, name, value, indexType);
                    continue;
                }
                fieldArray.addField(this.createField(field, name, value, indexType, null));
            }
            catch (Exception exception) {
                if (!_log.isWarnEnabled()) continue;
                _log.warn((Object)exception, (Throwable)exception);
            }
        }
    }

    public Sort createDDMStructureFieldSort(DDMStructure ddmStructure, String fieldName, Locale locale, SortOrder sortOrder) throws PortalException {
        DDMFormField ddmFormField = ddmStructure.getDDMFormField(fieldName);
        if (GetterUtil.getBoolean((Object)ddmFormField.getProperty("localizable"))) {
            if (locale == null) {
                throw new IllegalArgumentException("Locale cannot be null if the dynamic data mapping form field is localizable");
            }
        } else {
            locale = null;
        }
        StringBundler sb = new StringBundler(5);
        if (this.isLegacyDDMIndexFieldsEnabled()) {
            sb.append(this.encodeName(ddmStructure.getStructureId(), fieldName, locale));
        } else {
            sb.append("ddmFieldArray");
            sb.append(".");
            String indexType = ddmStructure.getFieldProperty(fieldName, "indexType");
            sb.append(this.getValueFieldName(indexType, locale));
        }
        sb.append("_");
        String ddmFormFieldType = ddmFormField.getType();
        if (Objects.equals(ddmFormFieldType, "ddm-decimal") || Objects.equals(ddmFormFieldType, "ddm-integer") || Objects.equals(ddmFormFieldType, "ddm-number") || Objects.equals(ddmFormFieldType, "numeric")) {
            sb.append("Number");
        } else {
            sb.append("String");
        }
        FieldSort fieldSort = this.sorts.field(Field.getSortableFieldName((String)sb.toString()), sortOrder);
        if (this.isLegacyDDMIndexFieldsEnabled()) {
            return fieldSort;
        }
        NestedSort nestedSort = this.sorts.nested("ddmFieldArray");
        nestedSort.setFilterQuery((Query)this.queries.term(StringBundler.concat((String[])new String[]{"ddmFieldArray", ".", "ddmFieldName"}), (Object)this.encodeName(ddmStructure.getStructureId(), fieldName, locale)));
        fieldSort.setNestedSort(nestedSort);
        return fieldSort;
    }

    public Sort createDDMStructureFieldSort(String ddmStructureFieldName, Locale locale, SortOrder sortOrder) throws PortalException {
        String[] ddmStructureFieldNameParts = StringUtil.split((String)ddmStructureFieldName, (String)"__");
        long ddmStructureId = GetterUtil.getLong((String)ddmStructureFieldNameParts[2]);
        String fieldName = StringUtil.replaceLast((String)ddmStructureFieldNameParts[3], (String)"_".concat(LocaleUtil.toLanguageId((Locale)locale)), (String)"");
        DDMStructure ddmStructure = this._ddmStructureLocalService.getStructure(ddmStructureId);
        return this.createDDMStructureFieldSort(ddmStructure, fieldName, locale, sortOrder);
    }

    public QueryFilter createFieldValueQueryFilter(DDMStructure ddmStructure, String fieldName, Locale locale, Serializable value) throws Exception {
        String indexType = ddmStructure.getFieldProperty(fieldName, "indexType");
        return this.createFieldValueQueryFilter(ddmStructure, this.encodeName(ddmStructure.getStructureId(), fieldName, locale), value, fieldName, indexType, locale);
    }

    public QueryFilter createFieldValueQueryFilter(String ddmStructureFieldName, Serializable ddmStructureFieldValue, Locale locale) throws Exception {
        String[] ddmStructureFieldNameParts = StringUtil.split((String)ddmStructureFieldName, (String)"__");
        DDMStructure ddmStructure = this._ddmStructureLocalService.getStructure(GetterUtil.getLong((String)ddmStructureFieldNameParts[2]));
        String fieldName = StringUtil.replaceLast((String)ddmStructureFieldNameParts[3], (String)"_".concat(LocaleUtil.toLanguageId((Locale)locale)), (String)"");
        return this.createFieldValueQueryFilter(ddmStructure, ddmStructureFieldName, ddmStructureFieldValue, fieldName, ddmStructureFieldNameParts[1], locale);
    }

    public String encodeName(long ddmStructureId, String fieldName) {
        return this.encodeName(ddmStructureId, fieldName, null);
    }

    public String encodeName(long ddmStructureId, String fieldName, Locale locale) {
        DDMStructure ddmStructure;
        String indexType = "";
        boolean localizable = true;
        if (ddmStructureId > 0L && (ddmStructure = this._ddmStructureLocalService.fetchDDMStructure(ddmStructureId)) != null) {
            try {
                indexType = ddmStructure.getFieldProperty(fieldName, "indexType");
                localizable = GetterUtil.getBoolean((String)ddmStructure.getFieldProperty(fieldName, "localizable"));
            }
            catch (PortalException portalException) {
                throw new IllegalArgumentException(StringBundler.concat((Object[])new Object[]{"Unable to obtain index tpe for field ", fieldName, " and DDM structure ID ", ddmStructureId}), portalException);
            }
        }
        if (localizable) {
            return this.encodeName(ddmStructureId, fieldName, locale, indexType);
        }
        return this.encodeName(ddmStructureId, fieldName, null, indexType);
    }

    public String extractIndexableAttributes(DDMStructure ddmStructure, DDMFormValues ddmFormValues, Locale locale) {
        Format dateFormat = FastDateFormatFactoryUtil.getSimpleDateFormat((String)PropsUtil.get((String)"index.date.format.pattern"));
        StringBundler sb = new StringBundler();
        Fields fields = this.toFields(ddmStructure, ddmFormValues);
        for (com.liferay.dynamic.data.mapping.storage.Field field : fields) {
            try {
                String indexType = ddmStructure.getFieldProperty(field.getName(), "indexType");
                if (Validator.isNull((String)indexType) || indexType.equals("none")) continue;
                Serializable value = field.getValue(locale);
                if (value instanceof Boolean || value instanceof Number) {
                    sb.append((Object)value);
                } else if (value instanceof Date) {
                    sb.append(dateFormat.format(value));
                } else if (value instanceof Date[]) {
                    Date[] dates = (Date[])value;
                    for (int i = 0; i < dates.length; ++i) {
                        sb.append(dateFormat.format(dates[i]));
                        if (i >= dates.length - 1) continue;
                        sb.append(" ");
                    }
                } else if (value instanceof Object[]) {
                    Object[] values = (Object[])value;
                    String type = field.getType();
                    boolean richText = type.equals("ddm-text-html");
                    for (int i = 0; i < values.length; ++i) {
                        if (richText) {
                            String valueString = String.valueOf(values[i]);
                            sb.append(HtmlUtil.extractText((String)valueString));
                        } else {
                            sb.append(values[i]);
                        }
                        if (i >= values.length - 1) continue;
                        sb.append(" ");
                    }
                } else {
                    String valueString = String.valueOf(value);
                    String type = field.getType();
                    if (type.equals("select")) {
                        JSONArray jsonArray = JSONFactoryUtil.createJSONArray((String)valueString);
                        String[] stringArray = ArrayUtil.toStringArray((JSONArray)jsonArray);
                        sb.append(stringArray);
                    } else {
                        if (type.equals("ddm-text-html")) {
                            valueString = HtmlUtil.extractText((String)valueString);
                        }
                        sb.append(valueString);
                    }
                }
                sb.append(" ");
            }
            catch (Exception exception) {
                if (!_log.isWarnEnabled()) continue;
                _log.warn((Object)exception, (Throwable)exception);
            }
        }
        if (sb.index() > 0) {
            sb.setIndex(sb.index() - 1);
        }
        return sb.toString();
    }

    public String getValueFieldName(String indexType) {
        return this.getValueFieldName(indexType, null);
    }

    public String getValueFieldName(String indexType, Locale locale) {
        String valueFieldName = "ddmFieldValue";
        if (indexType != null) {
            valueFieldName = valueFieldName.concat(StringUtil.upperCaseFirstLetter((String)indexType));
        }
        if (locale != null) {
            valueFieldName = StringBundler.concat((String[])new String[]{valueFieldName, "_", LocaleUtil.toLanguageId((Locale)locale)});
        }
        return valueFieldName;
    }

    public boolean isLegacyDDMIndexFieldsEnabled() {
        if (Objects.equals(this.searchEngineInformation.getVendorString(), "Solr")) {
            return true;
        }
        return this._ddmIndexerConfiguration.enableLegacyDDMIndexFields();
    }

    @Activate
    @Modified
    protected void activate(Map<String, Object> properties) {
        this._ddmIndexerConfiguration = (DDMIndexerConfiguration)ConfigurableUtil.createConfigurable(DDMIndexerConfiguration.class, properties);
    }

    protected void addFieldValueRequiredTerm(BooleanQuery booleanQuery, String ddmStructureFieldName, String ddmStructureFieldValue, String indexType, Locale locale) {
        if (this.isLegacyDDMIndexFieldsEnabled()) {
            booleanQuery.addRequiredTerm(ddmStructureFieldName, "\"" + ddmStructureFieldValue + "\"");
            return;
        }
        booleanQuery.addRequiredTerm(StringBundler.concat((String[])new String[]{"ddmFieldArray", ".", "ddmFieldName"}), ddmStructureFieldName);
        booleanQuery.addRequiredTerm(StringBundler.concat((String[])new String[]{"ddmFieldArray", ".", this.getValueFieldName(indexType, locale)}), "\"" + ddmStructureFieldValue + "\"");
    }

    protected void addToDocument(Document document, com.liferay.dynamic.data.mapping.storage.Field field, String name, Serializable value, String indexType) throws PortalException {
        if (value instanceof BigDecimal) {
            document.addNumberSortable(name, (BigDecimal)value);
        } else if (value instanceof BigDecimal[]) {
            document.addNumberSortable(name, (BigDecimal[])value);
        } else if (value instanceof Boolean) {
            document.addKeywordSortable(name, (Boolean)value);
        } else if (value instanceof Boolean[]) {
            document.addKeywordSortable(name, (Boolean[])value);
        } else if (value instanceof Date) {
            document.addDateSortable(name, (Date)value);
        } else if (value instanceof Date[]) {
            document.addDateSortable(name, (Date[])value);
        } else if (value instanceof Double) {
            document.addNumberSortable(name, (Double)value);
        } else if (value instanceof Double[]) {
            document.addNumberSortable(name, (Double[])value);
        } else if (value instanceof Integer) {
            document.addNumberSortable(name, (Integer)value);
        } else if (value instanceof Integer[]) {
            document.addNumberSortable(name, (Integer[])value);
        } else if (value instanceof Long) {
            document.addNumberSortable(name, (Long)value);
        } else if (value instanceof Long[]) {
            document.addNumberSortable(name, (Long[])value);
        } else if (value instanceof Float) {
            document.addNumberSortable(name, (Float)value);
        } else if (value instanceof Float[]) {
            document.addNumberSortable(name, (Float[])value);
        } else if (value instanceof Number[]) {
            Number[] numbers = (Number[])value;
            Double[] doubles = new Double[numbers.length];
            for (int i = 0; i < numbers.length; ++i) {
                doubles[i] = numbers[i].doubleValue();
            }
            document.addNumberSortable(name, doubles);
        } else if (value instanceof Object[]) {
            String[] valuesString = ArrayUtil.toStringArray((Object[])((Object[])value));
            if (indexType.equals("keyword")) {
                document.addKeywordSortable(name, valuesString);
            } else {
                document.addTextSortable(name, valuesString);
            }
        } else {
            String valueString = String.valueOf(value);
            String type = field.getType();
            if (type.equals("ddm-geolocation")) {
                JSONObject jsonObject = JSONFactoryUtil.createJSONObject((String)valueString);
                double latitude = jsonObject.getDouble("latitude", 0.0);
                double longitude = jsonObject.getDouble("longitude", 0.0);
                document.addGeoLocation(name.concat("_geolocation"), latitude, longitude);
            } else if (type.equals("select")) {
                JSONArray jsonArray = JSONFactoryUtil.createJSONArray((String)valueString);
                String[] stringArray = ArrayUtil.toStringArray((JSONArray)jsonArray);
                document.addKeywordSortable(name, stringArray);
            } else {
                if (type.equals("ddm-text-html")) {
                    valueString = HtmlUtil.extractText((String)valueString);
                }
                if (indexType.equals("keyword")) {
                    document.addKeywordSortable(name, valueString);
                } else {
                    document.addTextSortable(name, valueString);
                }
            }
        }
    }

    protected Field createField(com.liferay.dynamic.data.mapping.storage.Field ddmStructureField, String name, Serializable value, String indexType, Locale locale) throws PortalException {
        DocumentImpl document = new DocumentImpl();
        String valueFieldName = this.getValueFieldName(indexType, locale);
        this.addToDocument((Document)document, ddmStructureField, valueFieldName, value, indexType);
        Map fields = document.getFields();
        Field ddmField = new Field("");
        ddmField.addField(new Field("ddmFieldName", name));
        ddmField.addField(new Field("ddmValueFieldName", valueFieldName));
        for (Field field : fields.values()) {
            ddmField.addField(field);
        }
        return ddmField;
    }

    protected QueryFilter createFieldValueQueryFilter(DDMStructure ddmStructure, String ddmStructureFieldName, Serializable ddmStructureFieldValue, String fieldName, String indexType, Locale locale) throws Exception {
        BooleanQueryImpl booleanQuery = new BooleanQueryImpl();
        if (ddmStructure.hasField(fieldName)) {
            ddmStructureFieldValue = this._ddm.getIndexedFieldValue(ddmStructureFieldValue, ddmStructure.getFieldType(fieldName));
        }
        if (ddmStructureFieldValue instanceof String[]) {
            String[] ddmStructureFieldValueArray;
            for (String ddmStructureFieldValueString : ddmStructureFieldValueArray = (String[])ddmStructureFieldValue) {
                this.addFieldValueRequiredTerm((BooleanQuery)booleanQuery, ddmStructureFieldName, ddmStructureFieldValueString, indexType, locale);
            }
        } else {
            this.addFieldValueRequiredTerm((BooleanQuery)booleanQuery, ddmStructureFieldName, String.valueOf(ddmStructureFieldValue), indexType, locale);
        }
        if (this.isLegacyDDMIndexFieldsEnabled()) {
            return new QueryFilter((com.liferay.portal.kernel.search.Query)booleanQuery);
        }
        return new QueryFilter((com.liferay.portal.kernel.search.Query)new NestedQuery("ddmFieldArray", (com.liferay.portal.kernel.search.Query)booleanQuery));
    }

    protected String encodeName(long ddmStructureId, String fieldName, Locale locale, String indexType) {
        StringBundler sb = new StringBundler(8);
        sb.append("ddm__");
        if (Validator.isNotNull((String)indexType)) {
            sb.append(indexType);
            sb.append("__");
        }
        sb.append(ddmStructureId);
        sb.append("__");
        sb.append(fieldName);
        if (locale != null) {
            sb.append("_");
            sb.append(LocaleUtil.toLanguageId((Locale)locale));
        }
        return sb.toString();
    }

    @Reference(unbind="-")
    protected void setDDM(DDM ddm) {
        this._ddm = ddm;
    }

    @Reference(unbind="-")
    protected void setDDMFormValuesToFieldsConverter(DDMFormValuesToFieldsConverter ddmFormValuesToFieldsConverter) {
        this._ddmFormValuesToFieldsConverter = ddmFormValuesToFieldsConverter;
    }

    @Reference(unbind="-")
    protected void setDDMStructureLocalService(DDMStructureLocalService ddmStructureLocalService) {
        this._ddmStructureLocalService = ddmStructureLocalService;
    }

    protected Fields toFields(DDMStructure ddmStructure, DDMFormValues ddmFormValues) {
        try {
            return this._ddmFormValuesToFieldsConverter.convert(ddmStructure, ddmFormValues);
        }
        catch (PortalException portalException) {
            _log.error((Object)"Unable to convert DDMFormValues to Fields", (Throwable)portalException);
            return new Fields();
        }
    }
}

