/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.dynamic.data.mapping.internal.render;

import com.liferay.dynamic.data.mapping.model.DDMFormField;
import com.liferay.dynamic.data.mapping.model.DDMFormFieldOptions;
import com.liferay.dynamic.data.mapping.model.LocalizedValue;
import com.liferay.dynamic.data.mapping.model.Value;
import com.liferay.dynamic.data.mapping.render.BaseDDMFormFieldValueRenderer;
import com.liferay.dynamic.data.mapping.render.ValueAccessor;
import com.liferay.dynamic.data.mapping.storage.DDMFormFieldValue;
import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.kernel.util.Validator;
import java.util.Locale;

public class RadioDDMFormFieldValueRenderer
extends BaseDDMFormFieldValueRenderer {
    public String getSupportedDDMFormFieldType() {
        return "radio";
    }

    protected ValueAccessor getValueAcessor(Locale locale) {
        return new ValueAccessor(locale){

            public String get(DDMFormFieldValue ddmFormFieldValue) {
                Value value = ddmFormFieldValue.getValue();
                String valueString = value.getString(this.locale);
                if (Validator.isNull((String)valueString)) {
                    return "";
                }
                LocalizedValue label = this.getDDMFormFieldOptionLabel(ddmFormFieldValue, valueString);
                if (label == null) {
                    return "";
                }
                return GetterUtil.getString((String)label.getString(this.locale));
            }

            protected LocalizedValue getDDMFormFieldOptionLabel(DDMFormFieldValue ddmFormFieldValue, String optionValue) {
                DDMFormField ddmFormField = this.getDDMFormField(ddmFormFieldValue);
                DDMFormFieldOptions ddmFormFieldOptions = ddmFormField.getDDMFormFieldOptions();
                return ddmFormFieldOptions.getOptionLabels(optionValue);
            }
        };
    }
}

