/**
 * Copyright (c) 2000-present Liferay, Inc. All rights reserved.
 *
 * The contents of this file are subject to the terms of the Liferay Enterprise
 * Subscription License ("License"). You may not use this file except in
 * compliance with the License. You can obtain a copy of the License by
 * contacting Liferay, Inc. See the License for the specific language governing
 * permissions and limitations under the License, including but not limited to
 * distribution rights of the Software.
 *
 *
 *
 */

package com.liferay.dynamic.data.mapping.internal.webdav;

import com.liferay.dynamic.data.mapping.model.DDMStructure;
import com.liferay.petra.string.StringPool;
import com.liferay.portal.kernel.io.unsync.UnsyncByteArrayInputStream;
import com.liferay.portal.kernel.util.ContentTypes;
import com.liferay.portal.kernel.webdav.BaseResourceImpl;
import com.liferay.portal.kernel.webdav.WebDAVException;

import java.io.InputStream;

/**
 * @author Juan Fernández
 */
public class DDMStructureResourceImpl extends BaseResourceImpl {

	public DDMStructureResourceImpl(
		DDMStructure structure, String parentPath, String name) {

		super(
			parentPath, name,
			structure.getName(structure.getDefaultLanguageId()),
			structure.getCreateDate(), structure.getModifiedDate(),
			structure.getDefinition().getBytes().length);

		setModel(structure);
		setClassName(DDMStructure.class.getName());
		setPrimaryKey(structure.getPrimaryKey());

		_structure = structure;
	}

	@Override
	public InputStream getContentAsStream() throws WebDAVException {
		try {
			String definition = _structure.getDefinition();

			return new UnsyncByteArrayInputStream(
				definition.getBytes(StringPool.UTF8));
		}
		catch (Exception exception) {
			throw new WebDAVException(exception);
		}
	}

	@Override
	public String getContentType() {
		return ContentTypes.TEXT_XML;
	}

	@Override
	public boolean isCollection() {
		return false;
	}

	private final DDMStructure _structure;

}