/**
 * Copyright (c) 2000-present Liferay, Inc. All rights reserved.
 *
 * The contents of this file are subject to the terms of the Liferay Enterprise
 * Subscription License ("License"). You may not use this file except in
 * compliance with the License. You can obtain a copy of the License by
 * contacting Liferay, Inc. See the License for the specific language governing
 * permissions and limitations under the License, including but not limited to
 * distribution rights of the Software.
 *
 *
 *
 */

package com.liferay.dynamic.data.mapping.internal.util;

import com.liferay.portal.kernel.util.Validator;

import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.Stream;

/**
 * @author Marcos Martins
 * @review
 */
public class ExpressionParameterValueExtractor {

	/**
	 * @param expression Ex: equals('Country', "US")
	 * @return a list with the given expression parameters Ex: ['Country', "US"]
	 */
	public static List<String> extractParameterValues(String expression) {
		List<String> parameterValues = Arrays.asList(
			expression.split(_FUNCTION_STRUCTURE_REGEX));

		Stream<String> parameterValueStream = parameterValues.stream();

		return parameterValueStream.filter(
			parameterValue -> Validator.isNotNull(parameterValue)
		).collect(
			Collectors.toList()
		);
	}

	private static final String _FUNCTION_STRUCTURE_REGEX =
		"\\(+|[aA-zZ]+\\(|,\\s*|\\)+|(\\|\\||&&)|\".*?\"";

}