/**
 * Copyright (c) 2000-present Liferay, Inc. All rights reserved.
 *
 * The contents of this file are subject to the terms of the Liferay Enterprise
 * Subscription License ("License"). You may not use this file except in
 * compliance with the License. You can obtain a copy of the License by
 * contacting Liferay, Inc. See the License for the specific language governing
 * permissions and limitations under the License, including but not limited to
 * distribution rights of the Software.
 *
 *
 *
 */

package com.liferay.dynamic.data.mapping.internal.upgrade.v3_2_6;

import com.liferay.dynamic.data.mapping.internal.upgrade.v3_2_6.util.DDMFormInstanceTable;
import com.liferay.dynamic.data.mapping.internal.upgrade.v3_2_6.util.DDMFormInstanceVersionTable;
import com.liferay.portal.kernel.upgrade.UpgradeProcess;
import com.liferay.portal.kernel.util.LoggingTimer;

/**
 * @author Rodrigo Paulino
 */
public class UpgradeSchema extends UpgradeProcess {

	protected void alterTables() throws Exception {
		try (LoggingTimer loggingTimer = new LoggingTimer()) {
			if (!hasColumnType(
					DDMFormInstanceTable.TABLE_NAME, "description",
					"TEXT null")) {

				alter(
					DDMFormInstanceTable.class,
					new AlterColumnType("description", "TEXT null"));
			}

			if (!hasColumnType(
					DDMFormInstanceVersionTable.TABLE_NAME, "description",
					"TEXT null")) {

				alter(
					DDMFormInstanceVersionTable.class,
					new AlterColumnType("description", "TEXT null"));
			}
		}
	}

	@Override
	protected void doUpgrade() throws Exception {
		alterTables();
	}

}