/**
 * Copyright (c) 2000-present Liferay, Inc. All rights reserved.
 *
 * The contents of this file are subject to the terms of the Liferay Enterprise
 * Subscription License ("License"). You may not use this file except in
 * compliance with the License. You can obtain a copy of the License by
 * contacting Liferay, Inc. See the License for the specific language governing
 * permissions and limitations under the License, including but not limited to
 * distribution rights of the Software.
 *
 *
 *
 */

package com.liferay.dynamic.data.mapping.internal.storage;

import com.liferay.document.library.kernel.service.DLAppService;
import com.liferay.dynamic.data.mapping.storage.FieldRenderer;
import com.liferay.dynamic.data.mapping.storage.FieldRendererFactory;
import com.liferay.portal.kernel.json.JSONFactory;
import com.liferay.portal.kernel.language.Language;
import com.liferay.portal.kernel.service.LayoutService;

import java.util.HashMap;

import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Deactivate;
import org.osgi.service.component.annotations.Reference;

/**
 * @author Preston Crary
 */
@Component(immediate = true, service = {})
public class FieldRendererRegistrar {

	@Activate
	public void activate() {
		_fieldRendererFactory.setFieldRenderers(
			new HashMap<String, FieldRenderer>() {
				{
					put("date", new DateFieldRenderer(_language));
					put(
						"document-library",
						new DocumentLibraryFieldRenderer(
							_dlAppService, _jsonFactory, _language));
					put(
						"geolocation",
						new GeolocationFieldRenderer(_jsonFactory, _language));
					put(
						"link-to-page",
						new LinkToPageFieldRenderer(
							_jsonFactory, _language, _layoutService));
					put("string", new StringFieldRenderer(_jsonFactory));
				}
			});
	}

	@Deactivate
	public void deactivate() {
		_fieldRendererFactory.setFieldRenderers(null);
	}

	@Reference
	private DLAppService _dlAppService;

	private final FieldRendererFactory _fieldRendererFactory =
		new FieldRendererFactory();

	@Reference
	private JSONFactory _jsonFactory;

	@Reference
	private Language _language;

	@Reference
	private LayoutService _layoutService;

}