/**
 * Copyright (c) 2000-present Liferay, Inc. All rights reserved.
 *
 * The contents of this file are subject to the terms of the Liferay Enterprise
 * Subscription License ("License"). You may not use this file except in
 * compliance with the License. You can obtain a copy of the License by
 * contacting Liferay, Inc. See the License for the specific language governing
 * permissions and limitations under the License, including but not limited to
 * distribution rights of the Software.
 *
 *
 *
 */

package com.liferay.dynamic.data.mapping.internal.storage;

import com.liferay.dynamic.data.mapping.storage.DDMStorageAdapter;
import com.liferay.dynamic.data.mapping.storage.DDMStorageAdapterTracker;
import com.liferay.osgi.service.tracker.collections.map.ServiceTrackerMap;
import com.liferay.osgi.service.tracker.collections.map.ServiceTrackerMapFactory;

import java.util.Set;

import org.osgi.framework.BundleContext;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Deactivate;

/**
 * @author Leonardo Barros
 */
@Component(immediate = true, service = DDMStorageAdapterTracker.class)
public class DDMStorageAdapterTrackerImpl implements DDMStorageAdapterTracker {

	@Override
	public DDMStorageAdapter getDDMStorageAdapter(String type) {
		return ddmStorageAdapterServiceTrackerMap.getService(type);
	}

	@Override
	public Set<String> getDDMStorageAdapterTypes() {
		return ddmStorageAdapterServiceTrackerMap.keySet();
	}

	@Activate
	protected void activate(BundleContext bundleContext) {
		ddmStorageAdapterServiceTrackerMap =
			ServiceTrackerMapFactory.openSingleValueMap(
				bundleContext, DDMStorageAdapter.class,
				"ddm.storage.adapter.type");
	}

	@Deactivate
	protected void deactivate() {
		ddmStorageAdapterServiceTrackerMap.close();
	}

	protected ServiceTrackerMap<String, DDMStorageAdapter>
		ddmStorageAdapterServiceTrackerMap;

}