/**
 * Copyright (c) 2000-present Liferay, Inc. All rights reserved.
 *
 * The contents of this file are subject to the terms of the Liferay Enterprise
 * Subscription License ("License"). You may not use this file except in
 * compliance with the License. You can obtain a copy of the License by
 * contacting Liferay, Inc. See the License for the specific language governing
 * permissions and limitations under the License, including but not limited to
 * distribution rights of the Software.
 *
 *
 *
 */

package com.liferay.dynamic.data.mapping.internal.security.permission.support;

import com.liferay.dynamic.data.mapping.util.DDMStructurePermissionSupport;
import com.liferay.dynamic.data.mapping.util.DDMTemplatePermissionSupport;
import com.liferay.osgi.service.tracker.collections.map.ServiceTrackerCustomizerFactory;
import com.liferay.osgi.service.tracker.collections.map.ServiceTrackerCustomizerFactory.ServiceWrapper;
import com.liferay.osgi.service.tracker.collections.map.ServiceTrackerMap;
import com.liferay.osgi.service.tracker.collections.map.ServiceTrackerMapFactory;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.util.Portal;

import org.osgi.framework.BundleContext;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Deactivate;
import org.osgi.service.component.annotations.Reference;

/**
 * @author Marcellus Tavares
 */
@Component(immediate = true, service = DDMPermissionSupportTracker.class)
public class DDMPermissionSupportTracker {

	public ServiceWrapper<DDMStructurePermissionSupport>
			getDDMStructurePermissionSupportServiceWrapper(long classNameId)
		throws PortalException {

		return getDDMStructurePermissionSupportServiceWrapper(
			_portal.getClassName(classNameId));
	}

	public ServiceWrapper<DDMStructurePermissionSupport>
			getDDMStructurePermissionSupportServiceWrapper(String className)
		throws PortalException {

		ServiceWrapper<DDMStructurePermissionSupport>
			ddmStructurePermissionSupportServiceWrapper =
				_ddmStructurePermissionSupportServiceTrackerMap.getService(
					className);

		if (ddmStructurePermissionSupportServiceWrapper == null) {
			throw new PortalException(
				"The model does not support DDMStructure permission checking " +
					className);
		}

		return ddmStructurePermissionSupportServiceWrapper;
	}

	public ServiceWrapper<DDMTemplatePermissionSupport>
			getDDMTemplatePermissionSupportServiceWrapper(
				long resourceClassNameId)
		throws PortalException {

		return getDDMTemplatePermissionSupportServiceWrapper(
			_portal.getClassName(resourceClassNameId));
	}

	public ServiceWrapper<DDMTemplatePermissionSupport>
			getDDMTemplatePermissionSupportServiceWrapper(
				String resourceClassName)
		throws PortalException {

		ServiceWrapper<DDMTemplatePermissionSupport>
			ddmTemplatePermissionSupportServiceWrapper =
				_ddmTemplatePermissionSupportServiceTrackerMap.getService(
					resourceClassName);

		if (ddmTemplatePermissionSupportServiceWrapper == null) {
			throw new PortalException(
				"The model does not support DDMTemplate permission checking " +
					resourceClassName);
		}

		return ddmTemplatePermissionSupportServiceWrapper;
	}

	@Activate
	protected void activate(BundleContext bundleContext) {
		_ddmStructurePermissionSupportServiceTrackerMap =
			ServiceTrackerMapFactory.openSingleValueMap(
				bundleContext, DDMStructurePermissionSupport.class,
				"model.class.name",
				ServiceTrackerCustomizerFactory.
					<DDMStructurePermissionSupport>serviceWrapper(
						bundleContext));

		_ddmTemplatePermissionSupportServiceTrackerMap =
			ServiceTrackerMapFactory.openSingleValueMap(
				bundleContext, DDMTemplatePermissionSupport.class,
				"model.class.name",
				ServiceTrackerCustomizerFactory.
					<DDMTemplatePermissionSupport>serviceWrapper(
						bundleContext));
	}

	@Deactivate
	protected void deactivate() {
		_ddmStructurePermissionSupportServiceTrackerMap.close();

		_ddmTemplatePermissionSupportServiceTrackerMap.close();
	}

	private ServiceTrackerMap
		<String, ServiceWrapper<DDMStructurePermissionSupport>>
			_ddmStructurePermissionSupportServiceTrackerMap;
	private ServiceTrackerMap
		<String, ServiceWrapper<DDMTemplatePermissionSupport>>
			_ddmTemplatePermissionSupportServiceTrackerMap;

	@Reference
	private Portal _portal;

}