/**
 * Copyright (c) 2000-present Liferay, Inc. All rights reserved.
 *
 * The contents of this file are subject to the terms of the Liferay Enterprise
 * Subscription License ("License"). You may not use this file except in
 * compliance with the License. You can obtain a copy of the License by
 * contacting Liferay, Inc. See the License for the specific language governing
 * permissions and limitations under the License, including but not limited to
 * distribution rights of the Software.
 *
 *
 *
 */

package com.liferay.dynamic.data.mapping.internal.render;

import com.liferay.dynamic.data.mapping.render.DDMFormFieldValueRenderer;
import com.liferay.dynamic.data.mapping.render.DDMFormFieldValueRendererRegistry;
import com.liferay.dynamic.data.mapping.render.DDMFormFieldValueRendererRegistryUtil;
import com.liferay.osgi.service.tracker.collections.map.ServiceTrackerMap;
import com.liferay.osgi.service.tracker.collections.map.ServiceTrackerMapFactory;

import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceRegistration;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Deactivate;

/**
 * @author Marcellus Tavares
 */
@Component(immediate = true, service = DDMFormFieldValueRendererRegistry.class)
public class DDMFormFieldValueRendererRegistryImpl
	implements DDMFormFieldValueRendererRegistry {

	@Activate
	public void activate(BundleContext bundleContext) {
		for (int i = 0; i < _defaultDDMFormFieldValueRenderers.length; i++) {
			_serviceRegistrations[i] = bundleContext.registerService(
				DDMFormFieldValueRenderer.class,
				_defaultDDMFormFieldValueRenderers[i], null);
		}

		_serviceTrackerMap = ServiceTrackerMapFactory.openSingleValueMap(
			bundleContext, DDMFormFieldValueRenderer.class, null,
			(serviceReference, emitter) -> {
				DDMFormFieldValueRenderer ddmFormFieldValueRenderer =
					bundleContext.getService(serviceReference);

				try {
					emitter.emit(
						ddmFormFieldValueRenderer.
							getSupportedDDMFormFieldType());
				}
				finally {
					bundleContext.ungetService(serviceReference);
				}
			});

		_ddmFormFieldValueRendererRegistryUtil.
			setDDMFormFieldValueRendererRegistry(this);
	}

	@Deactivate
	public void deactivate() {
		_ddmFormFieldValueRendererRegistryUtil.
			setDDMFormFieldValueRendererRegistry(null);

		_serviceTrackerMap.close();

		for (ServiceRegistration<?> serviceRegistration :
				_serviceRegistrations) {

			serviceRegistration.unregister();
		}
	}

	@Override
	public DDMFormFieldValueRenderer getDDMFormFieldValueRenderer(
		String ddmFormFieldType) {

		return _serviceTrackerMap.getService(ddmFormFieldType);
	}

	private final DDMFormFieldValueRendererRegistryUtil
		_ddmFormFieldValueRendererRegistryUtil =
			new DDMFormFieldValueRendererRegistryUtil();
	private final DDMFormFieldValueRenderer[]
		_defaultDDMFormFieldValueRenderers = {
			new CheckboxDDMFormFieldValueRenderer(),
			new ColorDDMFormFieldValueRenderer(),
			new DateDDMFormFieldValueRenderer(),
			new DecimalDDMFormFieldValueRenderer(),
			new DocumentLibraryDDMFormFieldValueRenderer(),
			new GeolocationDDMFormFieldValueRenderer(),
			new IntegerDDMFormFieldValueRenderer(),
			new JournalArticleDDMFormFieldValueRenderer(),
			new LinkToPageDDMFormFieldValueRenderer(),
			new NumberDDMFormFieldValueRenderer(),
			new RadioDDMFormFieldValueRenderer(),
			new SelectDDMFormFieldValueRenderer(),
			new TextAreaDDMFormFieldValueRenderer(),
			new TextDDMFormFieldValueRenderer(),
			new TextHTMLDDMFormFieldValueRenderer()
		};
	private final ServiceRegistration<?>[] _serviceRegistrations =
		new ServiceRegistration[_defaultDDMFormFieldValueRenderers.length];
	private ServiceTrackerMap<String, DDMFormFieldValueRenderer>
		_serviceTrackerMap;

}