/**
 * Copyright (c) 2000-present Liferay, Inc. All rights reserved.
 *
 * The contents of this file are subject to the terms of the Liferay Enterprise
 * Subscription License ("License"). You may not use this file except in
 * compliance with the License. You can obtain a copy of the License by
 * contacting Liferay, Inc. See the License for the specific language governing
 * permissions and limitations under the License, including but not limited to
 * distribution rights of the Software.
 *
 *
 *
 */

package com.liferay.dynamic.data.mapping.internal.render;

import com.liferay.dynamic.data.mapping.model.Value;
import com.liferay.dynamic.data.mapping.render.BaseDDMFormFieldValueRenderer;
import com.liferay.dynamic.data.mapping.render.ValueAccessor;
import com.liferay.dynamic.data.mapping.storage.DDMFormFieldValue;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.util.GetterUtil;

import java.text.NumberFormat;
import java.text.ParseException;

import java.util.Locale;

/**
 * @author Marcellus Tavares
 */
public abstract class BaseNumberDDMFormFieldValueRenderer
	extends BaseDDMFormFieldValueRenderer {

	@Override
	protected ValueAccessor getValueAcessor(Locale locale) {
		return new ValueAccessor(locale) {

			@Override
			public String get(DDMFormFieldValue ddmFormFieldValue) {
				Value value = ddmFormFieldValue.getValue();

				String valueString = value.getString(locale);

				Number number = GetterUtil.getNumber(valueString);

				NumberFormat numberFormat = NumberFormat.getNumberInstance(
					locale);

				if (!valueString.equals(number.toString())) {
					try {
						number = numberFormat.parse(valueString);
					}
					catch (ParseException parseException) {
						if (_log.isWarnEnabled()) {
							_log.warn(parseException, parseException);
						}
					}
				}

				return numberFormat.format(number);
			}

		};
	}

	private static final Log _log = LogFactoryUtil.getLog(
		BaseNumberDDMFormFieldValueRenderer.class);

}