/**
 * Copyright (c) 2000-present Liferay, Inc. All rights reserved.
 *
 * The contents of this file are subject to the terms of the Liferay Enterprise
 * Subscription License ("License"). You may not use this file except in
 * compliance with the License. You can obtain a copy of the License by
 * contacting Liferay, Inc. See the License for the specific language governing
 * permissions and limitations under the License, including but not limited to
 * distribution rights of the Software.
 *
 *
 *
 */

package com.liferay.dynamic.data.mapping.internal.model.listener;

import com.liferay.dynamic.data.mapping.model.DDMFormInstanceRecord;
import com.liferay.dynamic.data.mapping.model.DDMFormInstanceRecordVersion;
import com.liferay.exportimport.kernel.lar.ExportImportClassedModelUtil;
import com.liferay.exportimport.kernel.lar.StagedModelDataHandler;
import com.liferay.exportimport.kernel.lar.StagedModelDataHandlerRegistryUtil;
import com.liferay.portal.kernel.exception.ModelListenerException;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.model.BaseModelListener;
import com.liferay.portal.kernel.model.ModelListener;
import com.liferay.portal.kernel.util.ArrayUtil;
import com.liferay.staging.model.listener.StagingModelListener;

import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

/**
 * @author Akos Thurzo
 */
@Component(immediate = true, service = ModelListener.class)
public class DDMFormInstanceRecordStagingModelListener
	extends BaseModelListener<DDMFormInstanceRecord> {

	@Override
	public void onAfterCreate(DDMFormInstanceRecord ddmFormInstanceRecord)
		throws ModelListenerException {

		if (_isSkipEvent(ddmFormInstanceRecord)) {
			return;
		}

		_stagingModelListener.onAfterCreate(ddmFormInstanceRecord);
	}

	@Override
	public void onAfterRemove(DDMFormInstanceRecord ddmFormInstanceRecord)
		throws ModelListenerException {

		_stagingModelListener.onAfterRemove(ddmFormInstanceRecord);
	}

	@Override
	public void onAfterUpdate(DDMFormInstanceRecord ddmFormInstanceRecord)
		throws ModelListenerException {

		if (_isSkipEvent(ddmFormInstanceRecord)) {
			return;
		}

		_stagingModelListener.onAfterUpdate(ddmFormInstanceRecord);
	}

	private boolean _isSkipEvent(DDMFormInstanceRecord ddmFormInstanceRecord) {
		try {
			StagedModelDataHandler stagedModelDataHandler =
				StagedModelDataHandlerRegistryUtil.getStagedModelDataHandler(
					ExportImportClassedModelUtil.getClassName(
						ddmFormInstanceRecord));

			if (stagedModelDataHandler != null) {
				int[] exportableStatuses =
					stagedModelDataHandler.getExportableStatuses();

				DDMFormInstanceRecordVersion formInstanceRecordVersion =
					ddmFormInstanceRecord.getFormInstanceRecordVersion();

				if (ArrayUtil.contains(
						exportableStatuses,
						formInstanceRecordVersion.getStatus())) {

					return false;
				}
			}
		}
		catch (PortalException portalException) {
			if (_log.isDebugEnabled()) {
				_log.debug(portalException, portalException);
			}
		}

		return true;
	}

	private static final Log _log = LogFactoryUtil.getLog(
		DDMFormInstanceRecordStagingModelListener.class);

	@Reference
	private StagingModelListener<DDMFormInstanceRecord> _stagingModelListener;

}