/**
 * Copyright (c) 2000-present Liferay, Inc. All rights reserved.
 *
 * The contents of this file are subject to the terms of the Liferay Enterprise
 * Subscription License ("License"). You may not use this file except in
 * compliance with the License. You can obtain a copy of the License by
 * contacting Liferay, Inc. See the License for the specific language governing
 * permissions and limitations under the License, including but not limited to
 * distribution rights of the Software.
 *
 *
 *
 */

package com.liferay.dynamic.data.mapping.internal;

import com.liferay.dynamic.data.mapping.kernel.DDMStructureLink;
import com.liferay.dynamic.data.mapping.kernel.DDMStructureLinkManager;
import com.liferay.dynamic.data.mapping.service.DDMStructureLinkLocalService;
import com.liferay.portal.kernel.exception.PortalException;

import java.util.ArrayList;
import java.util.List;

import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

/**
 * @author Rafael Praxedes
 */
@Component(immediate = true, service = DDMStructureLinkManager.class)
public class DDMStructureLinkManagerImpl implements DDMStructureLinkManager {

	@Override
	public DDMStructureLink addStructureLink(
		long classNameId, long classPK, long structureId) {

		com.liferay.dynamic.data.mapping.model.DDMStructureLink
			ddmStructureLink = _ddmStructureLinkLocalService.addStructureLink(
				classNameId, classPK, structureId);

		return new DDMStructureLinkImpl(ddmStructureLink);
	}

	@Override
	public void deleteStructureLink(
			long classNameId, long classPK, long structureId)
		throws PortalException {

		_ddmStructureLinkLocalService.deleteStructureLink(
			classNameId, classPK, structureId);
	}

	@Override
	public void deleteStructureLinks(long classNameId, long classPK) {
		_ddmStructureLinkLocalService.deleteStructureLinks(
			classNameId, classPK);
	}

	@Override
	public List<DDMStructureLink> getClassNameStructureLinks(long classNameId) {
		List<DDMStructureLink> ddmStructureLinks = new ArrayList<>();

		for (com.liferay.dynamic.data.mapping.model.DDMStructureLink
				structureLink :
					_ddmStructureLinkLocalService.getClassNameStructureLinks(
						classNameId)) {

			ddmStructureLinks.add(new DDMStructureLinkImpl(structureLink));
		}

		return ddmStructureLinks;
	}

	@Override
	public List<DDMStructureLink> getStructureLinks(
		long classNameId, long classPK) {

		List<DDMStructureLink> ddmStructureLinks = new ArrayList<>();

		for (com.liferay.dynamic.data.mapping.model.DDMStructureLink
				ddmStructureLink :
					_ddmStructureLinkLocalService.getStructureLinks(
						classNameId, classPK)) {

			ddmStructureLinks.add(new DDMStructureLinkImpl(ddmStructureLink));
		}

		return ddmStructureLinks;
	}

	@Reference(unbind = "-")
	protected void setDDMStructureLinkLocalService(
		DDMStructureLinkLocalService ddmStructureLinkLocalService) {

		_ddmStructureLinkLocalService = ddmStructureLinkLocalService;
	}

	private DDMStructureLinkLocalService _ddmStructureLinkLocalService;

}