/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.dynamic.data.mapping.internal.io;

import com.liferay.dynamic.data.mapping.form.field.type.DDMFormFieldType;
import com.liferay.dynamic.data.mapping.form.field.type.DDMFormFieldTypeServicesTracker;
import com.liferay.dynamic.data.mapping.form.field.type.DefaultDDMFormFieldTypeSettings;
import com.liferay.dynamic.data.mapping.io.DDMFormDeserializer;
import com.liferay.dynamic.data.mapping.io.DDMFormDeserializerDeserializeRequest;
import com.liferay.dynamic.data.mapping.io.DDMFormDeserializerDeserializeResponse;
import com.liferay.dynamic.data.mapping.model.DDMForm;
import com.liferay.dynamic.data.mapping.model.DDMFormField;
import com.liferay.dynamic.data.mapping.model.DDMFormFieldOptions;
import com.liferay.dynamic.data.mapping.model.DDMFormFieldValidation;
import com.liferay.dynamic.data.mapping.model.DDMFormFieldValidationExpression;
import com.liferay.dynamic.data.mapping.model.DDMFormRule;
import com.liferay.dynamic.data.mapping.model.DDMFormSuccessPageSettings;
import com.liferay.dynamic.data.mapping.model.LocalizedValue;
import com.liferay.dynamic.data.mapping.util.DDMFormFactory;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.json.JSONArray;
import com.liferay.portal.kernel.json.JSONFactory;
import com.liferay.portal.kernel.json.JSONObject;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.util.LocaleUtil;
import com.liferay.portal.kernel.util.Validator;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Objects;
import java.util.Set;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component(immediate=true, property={"ddm.form.deserializer.type=json"}, service={DDMFormDeserializer.class})
public class DDMFormJSONDeserializer
implements DDMFormDeserializer {
    private static final Log _log = LogFactoryUtil.getLog(DDMFormJSONDeserializer.class);
    private static DDMFormFieldTypeServicesTracker _ddmFormFieldTypeServicesTracker;
    private static JSONFactory _jsonFactory;

    public static DDMFormDeserializerDeserializeResponse internalDeserialize(DDMFormDeserializerDeserializeRequest ddmFormDeserializerDeserializeRequest) {
        DDMForm ddmForm = new DDMForm();
        DDMFormDeserializerDeserializeResponse.Builder builder = DDMFormDeserializerDeserializeResponse.Builder.newBuilder((DDMForm)ddmForm);
        try {
            JSONObject jsonObject = _jsonFactory.createJSONObject(ddmFormDeserializerDeserializeRequest.getContent());
            DDMFormJSONDeserializer.setDDMFormAvailableLocales(jsonObject.getJSONArray("availableLanguageIds"), ddmForm);
            DDMFormJSONDeserializer.setDDMFormDefaultLocale(jsonObject.getString("defaultLanguageId"), ddmForm);
            DDMFormJSONDeserializer.setDDMFormFields(jsonObject.getJSONArray("fields"), ddmForm);
            DDMFormJSONDeserializer.setDDMFormRules(jsonObject.getJSONArray("rules"), ddmForm);
            DDMFormJSONDeserializer.setDDMFormLocalizedValuesDefaultLocale(ddmForm);
            DDMFormJSONDeserializer.setDDMFormSuccessPageSettings(jsonObject.getJSONObject("successPage"), ddmForm);
            return builder.build();
        }
        catch (Exception exception) {
            if (_log.isWarnEnabled()) {
                _log.warn((Object)exception, (Throwable)exception);
            }
            return builder.build();
        }
    }

    public DDMFormDeserializerDeserializeResponse deserialize(DDMFormDeserializerDeserializeRequest ddmFormDeserializerDeserializeRequest) {
        return DDMFormJSONDeserializer.internalDeserialize(ddmFormDeserializerDeserializeRequest);
    }

    protected static void addOptionValueLabels(JSONObject jsonObject, DDMFormFieldOptions ddmFormFieldOptions, String optionValue) {
        Iterator itr = jsonObject.keys();
        while (itr.hasNext()) {
            String languageId = (String)itr.next();
            ddmFormFieldOptions.addOptionLabel(optionValue, LocaleUtil.fromLanguageId((String)languageId), jsonObject.getString(languageId));
        }
    }

    protected static DDMFormFieldOptions deserializeDDMFormFieldOptions(String serializedDDMFormFieldProperty) throws PortalException {
        if (Validator.isNull((String)serializedDDMFormFieldProperty) || !serializedDDMFormFieldProperty.startsWith("[")) {
            return new DDMFormFieldOptions();
        }
        JSONArray jsonArray = _jsonFactory.createJSONArray(serializedDDMFormFieldProperty);
        return DDMFormJSONDeserializer.getDDMFormFieldOptions(jsonArray);
    }

    protected static Object deserializeDDMFormFieldProperty(String serializedDDMFormFieldProperty, DDMFormField ddmFormFieldTypeSetting) throws PortalException {
        if (ddmFormFieldTypeSetting.isLocalizable()) {
            return DDMFormJSONDeserializer.deserializeLocalizedValue(serializedDDMFormFieldProperty);
        }
        String dataType = ddmFormFieldTypeSetting.getDataType();
        if (Objects.equals(dataType, "boolean")) {
            return Boolean.valueOf(serializedDDMFormFieldProperty);
        }
        if (Objects.equals(dataType, "ddm-options")) {
            return DDMFormJSONDeserializer.deserializeDDMFormFieldOptions(serializedDDMFormFieldProperty);
        }
        if (Objects.equals(ddmFormFieldTypeSetting.getType(), "validation")) {
            return DDMFormJSONDeserializer.deserializeDDMFormFieldValidation(serializedDDMFormFieldProperty);
        }
        return serializedDDMFormFieldProperty;
    }

    protected static DDMFormFieldValidation deserializeDDMFormFieldValidation(String serializedDDMFormFieldProperty) throws PortalException {
        DDMFormFieldValidation ddmFormFieldValidation = new DDMFormFieldValidation();
        if (Validator.isNull((String)serializedDDMFormFieldProperty)) {
            return ddmFormFieldValidation;
        }
        final JSONObject jsonObject = _jsonFactory.createJSONObject(serializedDDMFormFieldProperty);
        ddmFormFieldValidation.setErrorMessageLocalizedValue(DDMFormJSONDeserializer.deserializeLocalizedValue(jsonObject.getString("errorMessage")));
        final JSONObject expressionJSONObject = jsonObject.getJSONObject("expression");
        if (expressionJSONObject != null) {
            ddmFormFieldValidation.setDDMFormFieldValidationExpression(new DDMFormFieldValidationExpression(){
                {
                    this.setName(expressionJSONObject.getString("name"));
                    this.setValue(expressionJSONObject.getString("value"));
                }
            });
        } else {
            ddmFormFieldValidation.setDDMFormFieldValidationExpression(new DDMFormFieldValidationExpression(){
                {
                    this.setValue(jsonObject.getString("expression"));
                }
            });
        }
        ddmFormFieldValidation.setParameterLocalizedValue(DDMFormJSONDeserializer.deserializeLocalizedValue(jsonObject.getString("parameter")));
        return ddmFormFieldValidation;
    }

    protected static LocalizedValue deserializeLocalizedValue(String value) throws PortalException {
        LocalizedValue localizedValue = new LocalizedValue();
        if (Validator.isNull((String)value)) {
            return localizedValue;
        }
        JSONObject jsonObject = _jsonFactory.createJSONObject(value);
        Iterator itr = jsonObject.keys();
        while (itr.hasNext()) {
            String languageId = (String)itr.next();
            localizedValue.addString(LocaleUtil.fromLanguageId((String)languageId), jsonObject.getString(languageId));
        }
        return localizedValue;
    }

    protected static Set<Locale> getAvailableLocales(JSONArray jsonArray) {
        HashSet<Locale> availableLocales = new HashSet<Locale>();
        for (int i = 0; i < jsonArray.length(); ++i) {
            Locale availableLocale = LocaleUtil.fromLanguageId((String)jsonArray.getString(i));
            availableLocales.add(availableLocale);
        }
        return availableLocales;
    }

    protected static DDMFormField getDDMFormField(JSONObject jsonObject) throws PortalException {
        String name = jsonObject.getString("name");
        String type = jsonObject.getString("type");
        DDMFormField ddmFormField = new DDMFormField(name, type);
        DDMFormJSONDeserializer.setDDMFormFieldProperties(jsonObject, ddmFormField);
        DDMFormJSONDeserializer.setNestedDDMFormField(jsonObject.getJSONArray("nestedFields"), ddmFormField);
        return ddmFormField;
    }

    protected static DDMFormFieldOptions getDDMFormFieldOptions(JSONArray jsonArray) {
        DDMFormFieldOptions ddmFormFieldOptions = new DDMFormFieldOptions();
        for (int i = 0; i < jsonArray.length(); ++i) {
            JSONObject jsonObject = jsonArray.getJSONObject(i);
            String value = jsonObject.getString("value");
            ddmFormFieldOptions.addOption(value);
            DDMFormJSONDeserializer.addOptionValueLabels(jsonObject.getJSONObject("label"), ddmFormFieldOptions, value);
        }
        return ddmFormFieldOptions;
    }

    protected static List<DDMFormField> getDDMFormFields(JSONArray jsonArray) throws PortalException {
        ArrayList<DDMFormField> ddmFormFields = new ArrayList<DDMFormField>();
        for (int i = 0; i < jsonArray.length(); ++i) {
            DDMFormField ddmFormField = DDMFormJSONDeserializer.getDDMFormField(jsonArray.getJSONObject(i));
            ddmFormFields.add(ddmFormField);
        }
        return ddmFormFields;
    }

    protected static DDMForm getDDMFormFieldTypeSettingsDDMForm(String type) {
        DDMFormFieldType ddmFormFieldType = _ddmFormFieldTypeServicesTracker.getDDMFormFieldType(type);
        Class ddmFormFieldTypeSettings = DefaultDDMFormFieldTypeSettings.class;
        if (ddmFormFieldType != null) {
            ddmFormFieldTypeSettings = ddmFormFieldType.getDDMFormFieldTypeSettings();
        }
        return DDMFormFactory.create(ddmFormFieldTypeSettings);
    }

    protected static DDMFormRule getDDMFormRule(JSONObject jsonObject) {
        String condition = jsonObject.getString("condition");
        List<String> actions = DDMFormJSONDeserializer.getDDMFormRuleActions(jsonObject.getJSONArray("actions"));
        DDMFormRule ddmFormRule = new DDMFormRule(condition, actions);
        boolean enabled = jsonObject.getBoolean("enabled", true);
        ddmFormRule.setEnabled(enabled);
        return ddmFormRule;
    }

    protected static List<String> getDDMFormRuleActions(JSONArray jsonArray) {
        ArrayList<String> actions = new ArrayList<String>();
        for (int i = 0; i < jsonArray.length(); ++i) {
            actions.add(jsonArray.getString(i));
        }
        return actions;
    }

    protected static List<DDMFormRule> getDDMFormRules(JSONArray jsonArray) {
        ArrayList<DDMFormRule> ddmFormRules = new ArrayList<DDMFormRule>();
        for (int i = 0; i < jsonArray.length(); ++i) {
            DDMFormRule ddmFormRule = DDMFormJSONDeserializer.getDDMFormRule(jsonArray.getJSONObject(i));
            ddmFormRules.add(ddmFormRule);
        }
        return ddmFormRules;
    }

    protected static void setDDMFormAvailableLocales(JSONArray jsonArray, DDMForm ddmForm) {
        ddmForm.setAvailableLocales(DDMFormJSONDeserializer.getAvailableLocales(jsonArray));
    }

    protected static void setDDMFormDefaultLocale(String defaultLanguageId, DDMForm ddmForm) {
        Locale defaultLocale = LocaleUtil.fromLanguageId((String)defaultLanguageId);
        ddmForm.setDefaultLocale(defaultLocale);
    }

    protected static void setDDMFormFieldLocalizedValueDefaultLocale(LocalizedValue localizedValue, Locale defaultLocale) {
        if (localizedValue == null) {
            return;
        }
        localizedValue.setDefaultLocale(defaultLocale);
    }

    protected static void setDDMFormFieldLocalizedValuesDefaultLocale(DDMFormField ddmFormField, Locale defaultLocale) {
        DDMFormJSONDeserializer.setDDMFormFieldLocalizedValueDefaultLocale(ddmFormField.getLabel(), defaultLocale);
        DDMFormJSONDeserializer.setDDMFormFieldLocalizedValueDefaultLocale(ddmFormField.getPredefinedValue(), defaultLocale);
        DDMFormJSONDeserializer.setDDMFormFieldLocalizedValueDefaultLocale(ddmFormField.getStyle(), defaultLocale);
        DDMFormJSONDeserializer.setDDMFormFieldLocalizedValueDefaultLocale(ddmFormField.getTip(), defaultLocale);
        DDMFormFieldOptions ddmFormFieldOptions = ddmFormField.getDDMFormFieldOptions();
        if (ddmFormFieldOptions != null) {
            ddmFormFieldOptions.setDefaultLocale(defaultLocale);
        }
        for (DDMFormField nestedDDMFormField : ddmFormField.getNestedDDMFormFields()) {
            DDMFormJSONDeserializer.setDDMFormFieldLocalizedValuesDefaultLocale(nestedDDMFormField, defaultLocale);
        }
    }

    protected static void setDDMFormFieldProperties(JSONObject jsonObject, DDMFormField ddmFormField) throws PortalException {
        DDMForm ddmFormFieldTypeSettingsDDMForm = DDMFormJSONDeserializer.getDDMFormFieldTypeSettingsDDMForm(ddmFormField.getType());
        for (DDMFormField ddmFormFieldTypeSetting : ddmFormFieldTypeSettingsDDMForm.getDDMFormFields()) {
            DDMFormJSONDeserializer.setDDMFormFieldProperty(jsonObject, ddmFormField, ddmFormFieldTypeSetting);
        }
    }

    protected static void setDDMFormFieldProperty(JSONObject jsonObject, DDMFormField ddmFormField, DDMFormField ddmFormFieldTypeSetting) throws PortalException {
        String settingName = ddmFormFieldTypeSetting.getName();
        if (jsonObject.has(settingName)) {
            Object deserializedDDMFormFieldProperty = DDMFormJSONDeserializer.deserializeDDMFormFieldProperty(jsonObject.getString(settingName), ddmFormFieldTypeSetting);
            ddmFormField.setProperty(settingName, deserializedDDMFormFieldProperty);
        }
    }

    protected static void setDDMFormFields(JSONArray jsonArray, DDMForm ddmForm) throws PortalException {
        ddmForm.setDDMFormFields(DDMFormJSONDeserializer.getDDMFormFields(jsonArray));
    }

    protected static void setDDMFormLocalizedValuesDefaultLocale(DDMForm ddmForm) {
        for (DDMFormField ddmFormField : ddmForm.getDDMFormFields()) {
            DDMFormJSONDeserializer.setDDMFormFieldLocalizedValuesDefaultLocale(ddmFormField, ddmForm.getDefaultLocale());
        }
    }

    protected static void setDDMFormRules(JSONArray jsonArray, DDMForm ddmForm) {
        if (jsonArray == null || jsonArray.length() == 0) {
            return;
        }
        ddmForm.setDDMFormRules(DDMFormJSONDeserializer.getDDMFormRules(jsonArray));
    }

    protected static void setDDMFormSuccessPageSettings(JSONObject jsonObject, DDMForm ddmForm) throws PortalException {
        if (jsonObject == null) {
            return;
        }
        DDMFormSuccessPageSettings ddmFormSuccessPageSettings = new DDMFormSuccessPageSettings(DDMFormJSONDeserializer.deserializeLocalizedValue(jsonObject.getString("body")), DDMFormJSONDeserializer.deserializeLocalizedValue(jsonObject.getString("title")), jsonObject.getBoolean("enabled"));
        ddmForm.setDDMFormSuccessPageSettings(ddmFormSuccessPageSettings);
    }

    protected static void setNestedDDMFormField(JSONArray jsonArray, DDMFormField ddmFormField) throws PortalException {
        if (jsonArray == null || jsonArray.length() == 0) {
            return;
        }
        List<DDMFormField> nestedDDMFormFields = DDMFormJSONDeserializer.getDDMFormFields(jsonArray);
        ddmFormField.setNestedDDMFormFields(nestedDDMFormFields);
    }

    @Reference(unbind="-")
    protected void setDDMFormFieldTypeServicesTracker(DDMFormFieldTypeServicesTracker ddmFormFieldTypeServicesTracker) {
        _ddmFormFieldTypeServicesTracker = ddmFormFieldTypeServicesTracker;
    }

    @Reference(unbind="-")
    protected void setJSONFactory(JSONFactory jsonFactory) {
        _jsonFactory = jsonFactory;
    }
}

