/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.dynamic.data.mapping.internal.upgrade.v1_1_1;

import com.liferay.dynamic.data.mapping.data.provider.DDMDataProvider;
import com.liferay.dynamic.data.mapping.data.provider.DDMDataProviderTracker;
import com.liferay.dynamic.data.mapping.io.DDMFormValuesDeserializer;
import com.liferay.dynamic.data.mapping.io.DDMFormValuesDeserializerDeserializeRequest;
import com.liferay.dynamic.data.mapping.io.DDMFormValuesDeserializerDeserializeResponse;
import com.liferay.dynamic.data.mapping.io.DDMFormValuesSerializer;
import com.liferay.dynamic.data.mapping.io.DDMFormValuesSerializerSerializeRequest;
import com.liferay.dynamic.data.mapping.io.DDMFormValuesSerializerSerializeResponse;
import com.liferay.dynamic.data.mapping.model.DDMForm;
import com.liferay.dynamic.data.mapping.model.UnlocalizedValue;
import com.liferay.dynamic.data.mapping.model.Value;
import com.liferay.dynamic.data.mapping.storage.DDMFormFieldValue;
import com.liferay.dynamic.data.mapping.storage.DDMFormValues;
import com.liferay.dynamic.data.mapping.util.DDMFormFactory;
import com.liferay.petra.string.StringBundler;
import com.liferay.portal.kernel.dao.jdbc.AutoBatchPreparedStatementUtil;
import com.liferay.portal.kernel.upgrade.UpgradeProcess;
import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.portal.kernel.util.Validator;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;

public class UpgradeDataProviderInstance
extends UpgradeProcess {
    private static final String _DEFAULT_OUTPUT_PARAMETER_LABEL = "Default Output";
    private static final String _DEFAULT_OUTPUT_PARAMETER_NAME = "Default-Output";
    private final DDMDataProviderTracker _ddmDataProviderTracker;
    private final DDMFormValuesDeserializer _ddmFormValuesDeserializer;
    private final DDMFormValuesSerializer _ddmFormValuesSerializer;

    public UpgradeDataProviderInstance(DDMDataProviderTracker ddmDataProviderTracker, DDMFormValuesDeserializer ddmFormValuesDeserializer, DDMFormValuesSerializer ddmFormValuesSerializer) {
        this._ddmDataProviderTracker = ddmDataProviderTracker;
        this._ddmFormValuesDeserializer = ddmFormValuesDeserializer;
        this._ddmFormValuesSerializer = ddmFormValuesSerializer;
    }

    protected void addDefaultInputParameters(DDMFormValues ddmFormValues) {
        DDMFormFieldValue ddmFormFieldValue = this.createDDMFormFieldValue(ddmFormValues, "inputParameters", null);
        ddmFormFieldValue.addNestedDDMFormFieldValue(this.createDDMFormFieldValue(ddmFormValues, "inputParameterLabel", ""));
        ddmFormFieldValue.addNestedDDMFormFieldValue(this.createDDMFormFieldValue(ddmFormValues, "inputParameterName", ""));
        ddmFormFieldValue.addNestedDDMFormFieldValue(this.createDDMFormFieldValue(ddmFormValues, "inputParameterRequired", "false"));
        ddmFormFieldValue.addNestedDDMFormFieldValue(this.createDDMFormFieldValue(ddmFormValues, "inputParameterType", "[]"));
        ddmFormValues.addDDMFormFieldValue(ddmFormFieldValue);
    }

    protected void addDefaultOutputParameters(DDMFormValues ddmFormValues) {
        Map ddmFormFieldValuesMap = ddmFormValues.getDDMFormFieldValuesMap();
        if (!ddmFormFieldValuesMap.containsKey("key") || !ddmFormFieldValuesMap.containsKey("value")) {
            return;
        }
        List ddmFormFieldValues = (List)ddmFormFieldValuesMap.get("key");
        DDMFormFieldValue keyDDMFormFieldValue = (DDMFormFieldValue)ddmFormFieldValues.get(0);
        ddmFormFieldValues = (List)ddmFormFieldValuesMap.get("value");
        DDMFormFieldValue valueDDMFormFieldValue = (DDMFormFieldValue)ddmFormFieldValues.get(0);
        String outputParameterPath = this.createOutputPathValue(ddmFormValues.getDefaultLocale(), keyDDMFormFieldValue.getValue(), valueDDMFormFieldValue.getValue());
        ddmFormValues.addDDMFormFieldValue(this.createDefaultOutputParameters(ddmFormValues, outputParameterPath));
    }

    protected void addPaginationParameter(DDMFormValues ddmFormValues) {
        Map ddmFormFieldValuesMap = ddmFormValues.getDDMFormFieldValuesMap();
        if (ddmFormFieldValuesMap.containsKey("pagination")) {
            return;
        }
        ddmFormValues.addDDMFormFieldValue(this.createDDMFormFieldValue(ddmFormValues, "pagination", "false"));
    }

    protected void addStartEndParameters(DDMFormValues ddmFormValues) {
        Map ddmFormFieldValuesMap = ddmFormValues.getDDMFormFieldValuesMap();
        if (ddmFormFieldValuesMap.containsKey("paginationStartParameterName") || ddmFormFieldValuesMap.containsKey("paginationEndParameterName")) {
            return;
        }
        ddmFormValues.addDDMFormFieldValue(this.createDDMFormFieldValue(ddmFormValues, "paginationStartParameterName", "start"));
        ddmFormValues.addDDMFormFieldValue(this.createDDMFormFieldValue(ddmFormValues, "paginationEndParameterName", "end"));
    }

    protected DDMFormFieldValue createDDMFormFieldValue(DDMFormValues ddmFormValues, String name, String value) {
        DDMFormFieldValue ddmFormFieldValue = new DDMFormFieldValue();
        ddmFormFieldValue.setDDMFormValues(ddmFormValues);
        ddmFormFieldValue.setInstanceId(StringUtil.randomString());
        ddmFormFieldValue.setName(name);
        if (Validator.isNotNull((String)value)) {
            ddmFormFieldValue.setValue((Value)new UnlocalizedValue(value));
        }
        return ddmFormFieldValue;
    }

    protected DDMFormFieldValue createDefaultOutputParameters(DDMFormValues ddmFormValues, String outputParameterPath) {
        DDMFormFieldValue ddmFormFieldValue = this.createDDMFormFieldValue(ddmFormValues, "outputParameters", null);
        ddmFormFieldValue.addNestedDDMFormFieldValue(this.createDDMFormFieldValue(ddmFormValues, "outputParameterLabel", _DEFAULT_OUTPUT_PARAMETER_LABEL));
        ddmFormFieldValue.addNestedDDMFormFieldValue(this.createDDMFormFieldValue(ddmFormValues, "outputParameterName", _DEFAULT_OUTPUT_PARAMETER_NAME));
        ddmFormFieldValue.addNestedDDMFormFieldValue(this.createDDMFormFieldValue(ddmFormValues, "outputParameterPath", outputParameterPath));
        ddmFormFieldValue.addNestedDDMFormFieldValue(this.createDDMFormFieldValue(ddmFormValues, "outputParameterType", "[\"list\"]"));
        return ddmFormFieldValue;
    }

    protected String createOutputPathValue(Locale locale, Value key, Value value) {
        StringBundler sb = new StringBundler(3);
        sb.append(key.getString(locale));
        sb.append(';');
        sb.append(value.getString(locale));
        return sb.toString();
    }

    protected DDMFormValues deserialize(String content, DDMForm ddmForm) {
        DDMFormValuesDeserializerDeserializeRequest.Builder builder = DDMFormValuesDeserializerDeserializeRequest.Builder.newBuilder((String)content, (DDMForm)ddmForm);
        DDMFormValuesDeserializerDeserializeResponse ddmFormValuesDeserializerDeserializeResponse = this._ddmFormValuesDeserializer.deserialize(builder.build());
        return ddmFormValuesDeserializerDeserializeResponse.getDDMFormValues();
    }

    protected void doUpgrade() throws Exception {
        try (PreparedStatement ps1 = this.connection.prepareStatement("select dataProviderInstanceId, definition, type_ from DDMDataProviderInstance");
             PreparedStatement ps2 = AutoBatchPreparedStatementUtil.concurrentAutoBatch((Connection)this.connection, (String)"update DDMDataProviderInstance set definition = ? where dataProviderInstanceId = ?");
             ResultSet rs = ps1.executeQuery();){
            while (rs.next()) {
                String dataProviderInstanceDefinition = rs.getString(2);
                String type = rs.getString(3);
                String newDefinition = this.upgradeDataProviderInstanceDefinition(dataProviderInstanceDefinition, type);
                ps2.setString(1, newDefinition);
                long dataProviderInstanceId = rs.getLong(1);
                ps2.setLong(2, dataProviderInstanceId);
                ps2.addBatch();
            }
            ps2.executeBatch();
        }
    }

    protected String serialize(DDMFormValues ddmFormValues) {
        DDMFormValuesSerializerSerializeRequest.Builder builder = DDMFormValuesSerializerSerializeRequest.Builder.newBuilder((DDMFormValues)ddmFormValues);
        DDMFormValuesSerializerSerializeResponse ddmFormValuesSerializerSerializeResponse = this._ddmFormValuesSerializer.serialize(builder.build());
        return ddmFormValuesSerializerSerializeResponse.getContent();
    }

    protected String upgradeDataProviderInstanceDefinition(String dataProviderInstanceDefinition, String type) {
        DDMDataProvider ddmDataProvider = this._ddmDataProviderTracker.getDDMDataProvider(type);
        DDMFormValues ddmFormValues = this.deserialize(dataProviderInstanceDefinition, DDMFormFactory.create((Class)ddmDataProvider.getSettings()));
        this.addDefaultInputParameters(ddmFormValues);
        this.addDefaultOutputParameters(ddmFormValues);
        this.addPaginationParameter(ddmFormValues);
        this.addStartEndParameters(ddmFormValues);
        return this.serialize(ddmFormValues);
    }
}

