/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.dynamic.data.mapping.internal.search.util;

import com.liferay.dynamic.data.mapping.model.DDMStructure;
import com.liferay.dynamic.data.mapping.model.DDMStructureLayout;
import com.liferay.dynamic.data.mapping.model.DDMTemplate;
import com.liferay.petra.function.UnsafeFunction;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.model.BaseModel;
import com.liferay.portal.kernel.search.Document;
import com.liferay.portal.kernel.search.Hits;
import com.liferay.portal.kernel.search.Indexer;
import com.liferay.portal.kernel.search.IndexerRegistryUtil;
import com.liferay.portal.kernel.search.SearchContext;
import com.liferay.portal.kernel.search.Sort;
import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.kernel.util.OrderByComparator;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Stream;
import org.osgi.service.component.annotations.Component;

@Component(immediate=true, service={DDMSearchHelper.class})
public class DDMSearchHelper {
    private static final Log _log = LogFactoryUtil.getLog(DDMSearchHelper.class);
    private static final Map<String, String> _fieldNameOrderByCols = new HashMap<String, String>(){
        {
            this.put("createDate", "createDate");
            this.put("modifiedDate", "modified");
            this.put("structureId", "entryClassPK");
            this.put("templateId", "entryClassPK");
        }
    };
    private static final Map<String, Integer> _fieldNameSortTypes = new HashMap<String, Integer>(){
        {
            this.put("createDate", 6);
            this.put("entryClassPK", 6);
            this.put("modified", 6);
        }
    };

    public SearchContext buildStructureLayoutSearchContext(long companyId, long[] groupIds, long classNameId, String name, String description, String storageType, Integer type, int status, int start, int end, OrderByComparator<DDMStructureLayout> orderByComparator) {
        SearchContext searchContext = new SearchContext();
        searchContext.setAttribute("classNameId", (Serializable)Long.valueOf(classNameId));
        searchContext.setAttribute("classPK", null);
        searchContext.setAttribute("description", (Serializable)((Object)description));
        searchContext.setAttribute("name", (Serializable)((Object)name));
        searchContext.setCompanyId(companyId);
        searchContext.setEnd(end);
        searchContext.setGroupIds(groupIds);
        if (orderByComparator != null) {
            searchContext.setSorts(this.getSortsFromComparator(orderByComparator));
        }
        searchContext.setStart(start);
        return searchContext;
    }

    public SearchContext buildStructureSearchContext(long companyId, long[] groupIds, long userId, long classNameId, Long classPK, String name, String description, String storageType, Integer type, int status, int start, int end, OrderByComparator<DDMStructure> orderByComparator) {
        SearchContext searchContext = new SearchContext();
        searchContext.setAttribute("classNameId", (Serializable)Long.valueOf(classNameId));
        searchContext.setAttribute("classPK", (Serializable)classPK);
        searchContext.setAttribute("description", (Serializable)((Object)description));
        searchContext.setAttribute("name", (Serializable)((Object)name));
        searchContext.setAttribute("status", (Serializable)Integer.valueOf(status));
        searchContext.setAttribute("storageType", (Serializable)((Object)storageType));
        searchContext.setAttribute("type", (Serializable)type);
        searchContext.setCompanyId(companyId);
        searchContext.setEnd(end);
        searchContext.setGroupIds(groupIds);
        searchContext.setStart(start);
        if (userId > 0L) {
            searchContext.setUserId(userId);
        }
        if (orderByComparator != null) {
            searchContext.setSorts(this.getSortsFromComparator(orderByComparator));
        }
        return searchContext;
    }

    public SearchContext buildStructureSearchContext(long companyId, long[] groupIds, long classNameId, Long classPK, String name, String description, String storageType, Integer type, int status, int start, int end, OrderByComparator<DDMStructure> orderByComparator) {
        return this.buildStructureSearchContext(companyId, groupIds, 0L, classNameId, classPK, name, description, storageType, type, status, start, end, orderByComparator);
    }

    public SearchContext buildTemplateSearchContext(long companyId, long groupId, long userId, long classNameId, long classPK, long resourceClassNameId, String name, String description, String type, String mode, String language, int status, int start, int end, OrderByComparator<DDMTemplate> orderByComparator) {
        return this.buildTemplateSearchContext(companyId, new long[]{groupId}, userId, new long[]{classNameId}, new long[]{classPK}, resourceClassNameId, name, description, type, mode, language, status, start, end, orderByComparator);
    }

    public SearchContext buildTemplateSearchContext(long companyId, long groupId, long classNameId, long classPK, long resourceClassNameId, String name, String description, String type, String mode, String language, int status, int start, int end, OrderByComparator<DDMTemplate> orderByComparator) {
        return this.buildTemplateSearchContext(companyId, new long[]{groupId}, new long[]{classNameId}, new long[]{classPK}, resourceClassNameId, name, description, type, mode, language, status, start, end, orderByComparator);
    }

    public SearchContext buildTemplateSearchContext(long companyId, long[] groupIds, long userId, long[] classNameIds, long[] classPKs, long resourceClassNameId, String name, String description, String type, String mode, String language, int status, int start, int end, OrderByComparator<DDMTemplate> orderByComparator) {
        SearchContext searchContext = new SearchContext();
        searchContext.setAttribute("description", (Serializable)((Object)description));
        searchContext.setAttribute("name", (Serializable)((Object)name));
        searchContext.setAttribute("status", (Serializable)Integer.valueOf(status));
        searchContext.setAttribute("classNameIds", (Serializable)classNameIds);
        searchContext.setAttribute("classPKs", (Serializable)classPKs);
        searchContext.setAttribute("language", (Serializable)((Object)language));
        searchContext.setAttribute("mode", (Serializable)((Object)mode));
        searchContext.setAttribute("resourceClassNameId", (Serializable)Long.valueOf(resourceClassNameId));
        searchContext.setAttribute("type", (Serializable)((Object)type));
        searchContext.setCompanyId(companyId);
        searchContext.setEnd(end);
        searchContext.setGroupIds(groupIds);
        searchContext.setStart(start);
        if (userId > 0L) {
            searchContext.setUserId(userId);
        }
        if (orderByComparator != null) {
            searchContext.setSorts(this.getSortsFromComparator(orderByComparator));
        }
        return searchContext;
    }

    public SearchContext buildTemplateSearchContext(long companyId, long[] groupIds, long[] classNameIds, long[] classPKs, long resourceClassNameId, String name, String description, String type, String mode, String language, int status, int start, int end, OrderByComparator<DDMTemplate> orderByComparator) {
        return this.buildTemplateSearchContext(companyId, groupIds, 0L, classNameIds, classPKs, resourceClassNameId, name, description, type, mode, language, status, start, end, orderByComparator);
    }

    public <T> List<T> doSearch(SearchContext searchContext, Class<T> modelClass, UnsafeFunction<Long, T, ? extends PortalException> getModelUnsafeFunction) {
        try {
            Indexer indexer = IndexerRegistryUtil.getIndexer(modelClass);
            Hits hits = indexer.search(searchContext);
            ArrayList models = new ArrayList();
            for (Document document : hits.getDocs()) {
                long entryClassPK = GetterUtil.getLong((String)document.get("entryClassPK"));
                Optional.ofNullable(getModelUnsafeFunction.apply((Object)entryClassPK)).ifPresent(models::add);
            }
            return models;
        }
        catch (PortalException portalException) {
            if (_log.isDebugEnabled()) {
                _log.debug((Object)portalException, (Throwable)portalException);
            }
            return Collections.emptyList();
        }
    }

    public <T> int doSearchCount(SearchContext searchContext, Class<T> modelClass) {
        try {
            Indexer indexer = IndexerRegistryUtil.getIndexer(modelClass);
            return (int)indexer.searchCount(searchContext);
        }
        catch (PortalException portalException) {
            if (_log.isDebugEnabled()) {
                _log.debug((Object)portalException, (Throwable)portalException);
            }
            return 0;
        }
    }

    protected Sort[] getSortsFromComparator(OrderByComparator<? extends BaseModel<?>> orderByComparator) {
        Stream<String> stream = Arrays.stream(orderByComparator.getOrderByFields());
        return (Sort[])stream.map(orderByFieldName -> {
            String fieldName = _fieldNameOrderByCols.getOrDefault(orderByFieldName, (String)orderByFieldName);
            int sortType = _fieldNameSortTypes.getOrDefault(fieldName, 3);
            return new Sort(fieldName, sortType, !orderByComparator.isAscending());
        }).toArray(Sort[]::new);
    }
}

