/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.dynamic.data.mapping.service.impl;

import com.liferay.dynamic.data.mapping.background.task.DDMStructureIndexerBackgroundTaskExecutor;
import com.liferay.dynamic.data.mapping.background.task.DDMStructureIndexerTracker;
import com.liferay.dynamic.data.mapping.exception.InvalidParentStructureException;
import com.liferay.dynamic.data.mapping.exception.InvalidStructureVersionException;
import com.liferay.dynamic.data.mapping.exception.NoSuchStructureException;
import com.liferay.dynamic.data.mapping.exception.RequiredStructureException;
import com.liferay.dynamic.data.mapping.exception.StructureDefinitionException;
import com.liferay.dynamic.data.mapping.exception.StructureDuplicateElementException;
import com.liferay.dynamic.data.mapping.exception.StructureDuplicateStructureKeyException;
import com.liferay.dynamic.data.mapping.exception.StructureNameException;
import com.liferay.dynamic.data.mapping.internal.search.util.DDMSearchHelper;
import com.liferay.dynamic.data.mapping.internal.util.DDMFormTemplateSynchonizer;
import com.liferay.dynamic.data.mapping.io.DDMFormDeserializer;
import com.liferay.dynamic.data.mapping.io.DDMFormDeserializerDeserializeRequest;
import com.liferay.dynamic.data.mapping.io.DDMFormDeserializerDeserializeResponse;
import com.liferay.dynamic.data.mapping.io.DDMFormDeserializerTracker;
import com.liferay.dynamic.data.mapping.io.DDMFormSerializer;
import com.liferay.dynamic.data.mapping.io.DDMFormSerializerSerializeRequest;
import com.liferay.dynamic.data.mapping.io.DDMFormSerializerSerializeResponse;
import com.liferay.dynamic.data.mapping.io.DDMFormSerializerTracker;
import com.liferay.dynamic.data.mapping.model.DDMDataProviderInstance;
import com.liferay.dynamic.data.mapping.model.DDMDataProviderInstanceLink;
import com.liferay.dynamic.data.mapping.model.DDMForm;
import com.liferay.dynamic.data.mapping.model.DDMFormField;
import com.liferay.dynamic.data.mapping.model.DDMFormLayout;
import com.liferay.dynamic.data.mapping.model.DDMFormRule;
import com.liferay.dynamic.data.mapping.model.DDMStructure;
import com.liferay.dynamic.data.mapping.model.DDMStructureVersion;
import com.liferay.dynamic.data.mapping.model.DDMTemplate;
import com.liferay.dynamic.data.mapping.security.permission.DDMPermissionSupport;
import com.liferay.dynamic.data.mapping.service.base.DDMStructureLocalServiceBaseImpl;
import com.liferay.dynamic.data.mapping.service.persistence.DDMStructurePersistence;
import com.liferay.dynamic.data.mapping.storage.StorageType;
import com.liferay.dynamic.data.mapping.util.DDM;
import com.liferay.dynamic.data.mapping.util.DDMXML;
import com.liferay.dynamic.data.mapping.validator.DDMFormValidationException;
import com.liferay.dynamic.data.mapping.validator.DDMFormValidator;
import com.liferay.exportimport.kernel.lar.ExportImportThreadLocal;
import com.liferay.petra.string.StringBundler;
import com.liferay.portal.kernel.backgroundtask.BackgroundTaskManager;
import com.liferay.portal.kernel.exception.LocaleException;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.json.JSONArray;
import com.liferay.portal.kernel.json.JSONFactory;
import com.liferay.portal.kernel.language.LanguageUtil;
import com.liferay.portal.kernel.model.BaseModel;
import com.liferay.portal.kernel.model.User;
import com.liferay.portal.kernel.search.DDMStructureIndexer;
import com.liferay.portal.kernel.search.Indexable;
import com.liferay.portal.kernel.search.IndexableType;
import com.liferay.portal.kernel.search.SearchContext;
import com.liferay.portal.kernel.security.auth.CompanyThreadLocal;
import com.liferay.portal.kernel.service.ServiceContext;
import com.liferay.portal.kernel.service.permission.ModelPermissions;
import com.liferay.portal.kernel.systemevent.SystemEvent;
import com.liferay.portal.kernel.transaction.TransactionCommitCallbackUtil;
import com.liferay.portal.kernel.transaction.Transactional;
import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.kernel.util.GroupThreadLocal;
import com.liferay.portal.kernel.util.ListUtil;
import com.liferay.portal.kernel.util.MapUtil;
import com.liferay.portal.kernel.util.OrderByComparator;
import com.liferay.portal.kernel.util.PortalUtil;
import com.liferay.portal.kernel.util.SetUtil;
import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.portal.spring.extender.service.ServiceReference;
import java.io.Serializable;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.Callable;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class DDMStructureLocalServiceImpl
extends DDMStructureLocalServiceBaseImpl {
    @ServiceReference(type=BackgroundTaskManager.class)
    protected BackgroundTaskManager backgroundTaskmanager;
    @ServiceReference(type=DDM.class)
    protected DDM ddm;
    @ServiceReference(type=DDMFormDeserializerTracker.class)
    protected DDMFormDeserializerTracker ddmFormDeserializerTracker;
    @ServiceReference(type=DDMFormSerializerTracker.class)
    protected DDMFormSerializerTracker ddmFormSerializerTracker;
    @ServiceReference(type=DDMFormValidator.class)
    protected DDMFormValidator ddmFormValidator;
    @ServiceReference(type=DDMPermissionSupport.class)
    protected DDMPermissionSupport ddmPermissionSupport;
    @ServiceReference(type=DDMSearchHelper.class)
    protected DDMSearchHelper ddmSearchHelper;
    @ServiceReference(type=DDMStructureIndexerTracker.class)
    protected DDMStructureIndexerTracker ddmStructureIndexerTracker;
    @ServiceReference(type=DDMXML.class)
    protected DDMXML ddmXML;
    @ServiceReference(type=JSONFactory.class)
    protected JSONFactory jsonFactory;
    private static final Pattern _callFunctionPattern = Pattern.compile("call\\(\\s*'([0-9a-f]{8}-[0-9a-f]{4}-[0-9a-f]{4}-[0-9a-f]{4}-[0-9a-f]{12})'\\s*,\\s*'(.*)'\\s*,\\s*'(.*)'\\s*\\)");

    @Indexable(type=IndexableType.REINDEX)
    public DDMStructure addStructure(long userId, long groupId, long parentStructureId, long classNameId, String structureKey, Map<Locale, String> nameMap, Map<Locale, String> descriptionMap, DDMForm ddmForm, DDMFormLayout ddmFormLayout, String storageType, int type, ServiceContext serviceContext) throws PortalException {
        User user = this.userLocalService.getUser(userId);
        structureKey = Validator.isNull((String)structureKey) ? String.valueOf(this.counterLocalService.increment()) : StringUtil.toUpperCase((String)structureKey.trim());
        this.validate(groupId, parentStructureId, classNameId, structureKey, nameMap, ddmForm);
        long structureId = this.counterLocalService.increment();
        DDMStructure structure = this.ddmStructurePersistence.create(structureId);
        structure.setUuid(serviceContext.getUuid());
        structure.setGroupId(groupId);
        structure.setCompanyId(user.getCompanyId());
        structure.setUserId(user.getUserId());
        structure.setUserName(user.getFullName());
        structure.setVersionUserId(user.getUserId());
        structure.setVersionUserName(user.getFullName());
        structure.setParentStructureId(parentStructureId);
        structure.setClassNameId(classNameId);
        structure.setStructureKey(structureKey);
        structure.setVersion("1.0");
        structure.setDescriptionMap(descriptionMap, ddmForm.getDefaultLocale());
        structure.setNameMap(nameMap, ddmForm.getDefaultLocale());
        structure.setDefinition(this.serializeJSONDDMForm(ddmForm));
        structure.setStorageType(storageType);
        structure.setType(type);
        this.ddmStructurePersistence.update((BaseModel)structure);
        if (serviceContext.isAddGroupPermissions() || serviceContext.isAddGuestPermissions()) {
            this.addStructureResources(structure, serviceContext.isAddGroupPermissions(), serviceContext.isAddGuestPermissions());
        } else {
            this.addStructureResources(structure, serviceContext.getModelPermissions());
        }
        DDMStructureVersion structureVersion = this.addStructureVersion(user, structure, "1.0", serviceContext);
        this.ddmStructureLayoutLocalService.addStructureLayout(userId, groupId, structureVersion.getStructureVersionId(), ddmFormLayout, serviceContext);
        this.addDataProviderInstanceLinks(groupId, structureId, ddmForm);
        return structure;
    }

    @Deprecated
    public DDMStructure addStructure(long userId, long groupId, long parentStructureId, long classNameId, String structureKey, Map<Locale, String> nameMap, Map<Locale, String> descriptionMap, String definition, String storageType, int type, ServiceContext serviceContext) throws PortalException {
        this.ddmXML.validateXML(definition);
        DDMForm ddmForm = this.deserializeXSDDDMForm(definition);
        DDMFormLayout ddmFormLayout = this.ddm.getDefaultDDMFormLayout(ddmForm);
        return this.addStructure(userId, groupId, parentStructureId, classNameId, structureKey, nameMap, descriptionMap, ddmForm, ddmFormLayout, storageType, type, serviceContext);
    }

    @Indexable(type=IndexableType.REINDEX)
    public DDMStructure addStructure(long userId, long groupId, long parentStructureId, long classNameId, String structureKey, Map<Locale, String> nameMap, Map<Locale, String> descriptionMap, String definition, String storageType, ServiceContext serviceContext) throws PortalException {
        User user = this.userLocalService.getUser(userId);
        structureKey = Validator.isNull((String)structureKey) ? String.valueOf(this.counterLocalService.increment()) : StringUtil.toUpperCase((String)structureKey.trim());
        long structureId = this.counterLocalService.increment();
        DDMStructure structure = this.ddmStructurePersistence.create(structureId);
        structure.setUuid(serviceContext.getUuid());
        structure.setGroupId(groupId);
        structure.setCompanyId(user.getCompanyId());
        structure.setUserId(user.getUserId());
        structure.setUserName(user.getFullName());
        structure.setVersionUserId(user.getUserId());
        structure.setVersionUserName(user.getFullName());
        structure.setCreateDate(new Date());
        structure.setModifiedDate(new Date());
        structure.setParentStructureId(parentStructureId);
        structure.setClassNameId(classNameId);
        structure.setStructureKey(structureKey);
        structure.setVersion("1.0");
        structure.setNameMap(nameMap);
        structure.setDescriptionMap(descriptionMap);
        structure.setDefinition(definition);
        structure.setStorageType(storageType);
        structure.setType(0);
        this.ddmStructurePersistence.update((BaseModel)structure);
        this.addStructureVersion(user, structure, "1.0", serviceContext);
        return structure;
    }

    public DDMStructure addStructure(long userId, long groupId, long classNameId, Map<Locale, String> nameMap, Map<Locale, String> descriptionMap, DDMForm ddmForm, DDMFormLayout ddmFormLayout, String storageType, ServiceContext serviceContext) throws PortalException {
        return this.addStructure(userId, groupId, 0L, classNameId, null, nameMap, descriptionMap, ddmForm, ddmFormLayout, storageType, 0, serviceContext);
    }

    @Deprecated
    public DDMStructure addStructure(long userId, long groupId, long classNameId, Map<Locale, String> nameMap, Map<Locale, String> descriptionMap, String definition, ServiceContext serviceContext) throws PortalException {
        return this.addStructure(userId, groupId, 0L, classNameId, null, nameMap, descriptionMap, definition, StorageType.JSON.toString(), 0, serviceContext);
    }

    public DDMStructure addStructure(long userId, long groupId, String parentStructureKey, long classNameId, String structureKey, Map<Locale, String> nameMap, Map<Locale, String> descriptionMap, DDMForm ddmForm, DDMFormLayout ddmFormLayout, String storageType, int type, ServiceContext serviceContext) throws PortalException {
        DDMStructure parentStructure = this.fetchStructure(groupId, classNameId, parentStructureKey);
        long parentStructureId = 0L;
        if (parentStructure != null) {
            parentStructureId = parentStructure.getStructureId();
        }
        return this.addStructure(userId, groupId, parentStructureId, classNameId, structureKey, nameMap, descriptionMap, ddmForm, ddmFormLayout, storageType, type, serviceContext);
    }

    @Deprecated
    public DDMStructure addStructure(long userId, long groupId, String parentStructureKey, long classNameId, String structureKey, Map<Locale, String> nameMap, Map<Locale, String> descriptionMap, String definition, String storageType, int type, ServiceContext serviceContext) throws PortalException {
        this.ddmXML.validateXML(definition);
        DDMForm ddmForm = this.deserializeXSDDDMForm(definition);
        DDMFormLayout ddmFormLayout = this.ddm.getDefaultDDMFormLayout(ddmForm);
        return this.addStructure(userId, groupId, parentStructureKey, classNameId, structureKey, nameMap, descriptionMap, ddmForm, ddmFormLayout, storageType, type, serviceContext);
    }

    public void addStructureResources(DDMStructure structure, boolean addGroupPermissions, boolean addGuestPermissions) throws PortalException {
        String resourceName = this.ddmPermissionSupport.getStructureModelResourceName(structure.getClassName());
        this.resourceLocalService.addResources(structure.getCompanyId(), structure.getGroupId(), structure.getUserId(), resourceName, structure.getStructureId(), false, addGroupPermissions, addGuestPermissions);
    }

    public void addStructureResources(DDMStructure structure, ModelPermissions modelPermissions) throws PortalException {
        String resourceName = this.ddmPermissionSupport.getStructureModelResourceName(structure.getClassName());
        this.resourceLocalService.addModelResources(structure.getCompanyId(), structure.getGroupId(), structure.getUserId(), resourceName, structure.getStructureId(), modelPermissions);
    }

    public DDMStructure copyStructure(long userId, long structureId, Map<Locale, String> nameMap, Map<Locale, String> descriptionMap, ServiceContext serviceContext) throws PortalException {
        DDMStructure structure = this.ddmStructurePersistence.findByPrimaryKey(structureId);
        return this.addStructure(userId, structure.getGroupId(), structure.getParentStructureId(), structure.getClassNameId(), null, nameMap, descriptionMap, structure.getDDMForm(), structure.getDDMFormLayout(), structure.getStorageType(), structure.getType(), serviceContext);
    }

    public DDMStructure copyStructure(long userId, long structureId, ServiceContext serviceContext) throws PortalException {
        DDMStructure structure = this.ddmStructurePersistence.findByPrimaryKey(structureId);
        return this.addStructure(userId, structure.getGroupId(), structure.getParentStructureId(), structure.getClassNameId(), null, (Map<Locale, String>)structure.getNameMap(), (Map<Locale, String>)structure.getDescriptionMap(), structure.getDDMForm(), structure.getDDMFormLayout(), structure.getStorageType(), structure.getType(), serviceContext);
    }

    @Indexable(type=IndexableType.DELETE)
    @SystemEvent(type=1)
    public DDMStructure deleteStructure(DDMStructure structure) throws PortalException {
        if (!GroupThreadLocal.isDeleteInProcess()) {
            if (this.ddmStructureLinkPersistence.countByStructureId(structure.getStructureId()) > 0) {
                throw new RequiredStructureException.MustNotDeleteStructureReferencedByStructureLinks(structure.getStructureId());
            }
            if (this.ddmStructurePersistence.countByParentStructureId(structure.getStructureId()) > 0) {
                throw new RequiredStructureException.MustNotDeleteStructureThatHasChild(structure.getStructureId());
            }
            if (this.ddmTemplatePersistence.countByClassPK(structure.getStructureId()) > 0) {
                throw new RequiredStructureException.MustNotDeleteStructureReferencedByTemplates(structure.getStructureId());
            }
        }
        this.ddmStructurePersistence.remove((BaseModel)structure);
        this.ddmDataProviderInstanceLinkPersistence.removeByStructureId(structure.getStructureId());
        this.ddmStructureLinkPersistence.removeByStructureId(structure.getStructureId());
        List structureVersions = this.ddmStructureVersionLocalService.getStructureVersions(structure.getStructureId());
        for (DDMStructureVersion structureVersion : structureVersions) {
            this.ddmStructureLayoutPersistence.removeByStructureVersionId(structureVersion.getStructureVersionId());
            this.ddmStructureVersionPersistence.remove((BaseModel)structureVersion);
        }
        String resourceName = this.ddmPermissionSupport.getStructureModelResourceName(structure.getClassName());
        this.resourceLocalService.deleteResource(structure.getCompanyId(), resourceName, 4, structure.getStructureId());
        String backgroundTaskName = DDMStructureIndexerBackgroundTaskExecutor.getBackgroundTaskName(structure.getStructureId());
        this.backgroundTaskmanager.deleteGroupBackgroundTasks(structure.getGroupId(), backgroundTaskName, DDMStructureIndexerBackgroundTaskExecutor.class.getName());
        return structure;
    }

    public void deleteStructure(long structureId) throws PortalException {
        DDMStructure structure = this.ddmStructurePersistence.findByPrimaryKey(structureId);
        this.ddmStructureLocalService.deleteStructure(structure);
    }

    public void deleteStructure(long groupId, long classNameId, String structureKey) throws PortalException {
        structureKey = this.getStructureKey(structureKey);
        DDMStructure structure = this.ddmStructurePersistence.findByG_C_S(groupId, classNameId, structureKey);
        this.ddmStructureLocalService.deleteStructure(structure);
    }

    public void deleteStructures(long groupId) throws PortalException {
        List structures = this.ddmStructurePersistence.findByGroupId(groupId);
        this.deleteStructures(structures);
    }

    public void deleteStructures(long groupId, long classNameId) throws PortalException {
        List structures = this.ddmStructurePersistence.findByG_C(groupId, classNameId);
        this.deleteStructures(structures);
    }

    public DDMStructure fetchStructure(long structureId) {
        return this.ddmStructurePersistence.fetchByPrimaryKey(structureId);
    }

    public DDMStructure fetchStructure(long groupId, long classNameId, String structureKey) {
        structureKey = this.getStructureKey(structureKey);
        return this.ddmStructurePersistence.fetchByG_C_S(groupId, classNameId, structureKey);
    }

    public DDMStructure fetchStructure(long groupId, long classNameId, String structureKey, boolean includeAncestorStructures) {
        DDMStructure structure = this.ddmStructurePersistence.fetchByG_C_S(groupId, classNameId, structureKey = this.getStructureKey(structureKey));
        if (structure != null) {
            return structure;
        }
        if (!includeAncestorStructures) {
            return null;
        }
        for (long ancestorSiteGroupId : PortalUtil.getAncestorSiteGroupIds((long)groupId)) {
            structure = this.ddmStructurePersistence.fetchByG_C_S(ancestorSiteGroupId, classNameId, structureKey);
            if (structure == null) continue;
            return structure;
        }
        return null;
    }

    public DDMStructure fetchStructureByUuidAndGroupId(String uuid, long groupId, boolean includeAncestorStructures) {
        DDMStructure structure = this.ddmStructurePersistence.fetchByUUID_G(uuid, groupId);
        if (structure != null) {
            return structure;
        }
        if (!includeAncestorStructures) {
            return null;
        }
        for (long ancestorSiteGroupId : PortalUtil.getAncestorSiteGroupIds((long)groupId)) {
            structure = this.ddmStructurePersistence.fetchByUUID_G(uuid, ancestorSiteGroupId);
            if (structure == null) continue;
            return structure;
        }
        return null;
    }

    public List<DDMStructure> getChildrenStructures(long parentStructureId) {
        return this.ddmStructurePersistence.findByParentStructureId(parentStructureId);
    }

    public List<DDMStructure> getClassStructures(long companyId, long classNameId) {
        return this.ddmStructurePersistence.findByC_C(companyId, classNameId);
    }

    public List<DDMStructure> getClassStructures(long companyId, long classNameId, int start, int end) {
        return this.ddmStructurePersistence.findByC_C(companyId, classNameId, start, end);
    }

    public List<DDMStructure> getClassStructures(long companyId, long classNameId, OrderByComparator<DDMStructure> orderByComparator) {
        return this.ddmStructurePersistence.findByC_C(companyId, classNameId, -1, -1, orderByComparator);
    }

    public DDMStructure getStructure(long structureId) throws PortalException {
        return this.ddmStructurePersistence.findByPrimaryKey(structureId);
    }

    public DDMStructure getStructure(long groupId, long classNameId, String structureKey) throws PortalException {
        structureKey = this.getStructureKey(structureKey);
        return this.ddmStructurePersistence.findByG_C_S(groupId, classNameId, structureKey);
    }

    public DDMStructure getStructure(long groupId, long classNameId, String structureKey, boolean includeAncestorStructures) throws PortalException {
        DDMStructure structure = this.ddmStructurePersistence.fetchByG_C_S(groupId, classNameId, structureKey = this.getStructureKey(structureKey));
        if (structure != null) {
            return structure;
        }
        if (!includeAncestorStructures) {
            throw new NoSuchStructureException("No DDMStructure exists with the structure key " + structureKey);
        }
        for (long curGroupId : PortalUtil.getAncestorSiteGroupIds((long)groupId)) {
            structure = this.ddmStructurePersistence.fetchByG_C_S(curGroupId, classNameId, structureKey);
            if (structure == null) continue;
            return structure;
        }
        throw new NoSuchStructureException("No DDMStructure exists with the structure key " + structureKey + " in the ancestor groups");
    }

    public List<DDMStructure> getStructure(long groupId, String name, String description) {
        return this.ddmStructurePersistence.findByG_N_D(groupId, name, description);
    }

    @Transactional(enabled=false)
    public DDMForm getStructureDDMForm(DDMStructure structure) throws PortalException {
        return this.deserializeJSONDDMForm(structure.getDefinition());
    }

    public List<DDMStructure> getStructures() {
        return this.ddmStructurePersistence.findAll();
    }

    public List<DDMStructure> getStructures(long groupId) {
        return this.ddmStructurePersistence.findByGroupId(groupId);
    }

    public List<DDMStructure> getStructures(long groupId, int start, int end) {
        return this.ddmStructurePersistence.findByGroupId(groupId, start, end);
    }

    public List<DDMStructure> getStructures(long groupId, long classNameId) {
        return this.ddmStructurePersistence.findByG_C(groupId, classNameId);
    }

    public List<DDMStructure> getStructures(long groupId, long classNameId, int start, int end) {
        return this.ddmStructurePersistence.findByG_C(groupId, classNameId, start, end);
    }

    public List<DDMStructure> getStructures(long groupId, long classNameId, int start, int end, OrderByComparator<DDMStructure> orderByComparator) {
        return this.ddmStructurePersistence.findByG_C(groupId, classNameId, start, end, orderByComparator);
    }

    public List<DDMStructure> getStructures(long companyId, long[] groupIds, long classNameId, int start, int end, OrderByComparator<DDMStructure> orderByComparator) {
        return this.ddmStructureFinder.filterFindByC_G_C_S(companyId, groupIds, classNameId, -1, start, end, orderByComparator);
    }

    public List<DDMStructure> getStructures(long groupId, String name, String description) {
        return this.ddmStructurePersistence.findByG_N_D(groupId, name, description);
    }

    public List<DDMStructure> getStructures(long[] groupIds) {
        return this.ddmStructurePersistence.findByGroupId(groupIds);
    }

    public List<DDMStructure> getStructures(long[] groupIds, long classNameId) {
        return this.ddmStructurePersistence.findByG_C(groupIds, classNameId);
    }

    public List<DDMStructure> getStructures(long[] groupIds, long classNameId, int start, int end) {
        return this.ddmStructurePersistence.findByG_C(groupIds, classNameId, start, end);
    }

    public List<DDMStructure> getStructures(long[] groupIds, long classNameId, OrderByComparator<DDMStructure> orderByComparator) {
        return this.ddmStructurePersistence.findByG_C(groupIds, classNameId, -1, -1, orderByComparator);
    }

    public List<DDMStructure> getStructures(long[] groupIds, long classNameId, String name, String description, int start, int end, OrderByComparator<DDMStructure> orderByComparator) {
        return this.ddmStructurePersistence.findByG_C_N_D(groupIds, classNameId, name, description, start, end, orderByComparator);
    }

    public int getStructuresCount(long groupId) {
        return this.ddmStructurePersistence.countByGroupId(groupId);
    }

    public int getStructuresCount(long groupId, long classNameId) {
        return this.ddmStructurePersistence.countByG_C(groupId, classNameId);
    }

    public int getStructuresCount(long[] groupIds, long classNameId) {
        return this.ddmStructurePersistence.countByG_C(groupIds, classNameId);
    }

    public String prepareLocalizedDefinitionForImport(DDMStructure structure, Locale defaultImportLocale) {
        DDMForm ddmForm = this.ddm.updateDDMFormDefaultLocale(structure.getDDMForm(), defaultImportLocale);
        return this.serializeJSONDDMForm(ddmForm);
    }

    public void revertStructure(long userId, long structureId, String version, ServiceContext serviceContext) throws PortalException {
        DDMStructureVersion structureVersion = this.ddmStructureVersionLocalService.getStructureVersion(structureId, version);
        if (!structureVersion.isApproved()) {
            throw new InvalidStructureVersionException("Unable to revert from an unapproved file version");
        }
        DDMStructure structure = structureVersion.getStructure();
        serviceContext.setAttribute("majorVersion", (Serializable)Boolean.TRUE);
        serviceContext.setAttribute("status", (Serializable)Integer.valueOf(0));
        serviceContext.setCommand("revert");
        this.ddmStructureLocalService.updateStructure(userId, structure.getGroupId(), structureVersion.getParentStructureId(), structure.getClassNameId(), structure.getStructureKey(), structureVersion.getNameMap(), structureVersion.getDescriptionMap(), structureVersion.getDDMForm(), structureVersion.getDDMFormLayout(), serviceContext);
    }

    public List<DDMStructure> search(long companyId, long[] groupIds, long classNameId, long classPK, String keywords, int start, int end, OrderByComparator<DDMStructure> orderByComparator) throws PortalException {
        SearchContext searchContext = this.ddmSearchHelper.buildStructureSearchContext(companyId, groupIds, classNameId, classPK, keywords, keywords, "", null, -1, start, end, orderByComparator);
        return this.ddmSearchHelper.doSearch(searchContext, DDMStructure.class, arg_0 -> ((DDMStructurePersistence)this.ddmStructurePersistence).findByPrimaryKey(arg_0));
    }

    public List<DDMStructure> search(long companyId, long[] groupIds, long classNameId, String keywords, int status, int start, int end, OrderByComparator<DDMStructure> orderByComparator) {
        SearchContext searchContext = this.ddmSearchHelper.buildStructureSearchContext(companyId, groupIds, classNameId, null, keywords, keywords, "", null, status, start, end, orderByComparator);
        return this.ddmSearchHelper.doSearch(searchContext, DDMStructure.class, arg_0 -> ((DDMStructurePersistence)this.ddmStructurePersistence).findByPrimaryKey(arg_0));
    }

    public List<DDMStructure> search(long companyId, long[] groupIds, long classNameId, String name, String description, String storageType, int type, int status, boolean andOperator, int start, int end, OrderByComparator<DDMStructure> orderByComparator) {
        SearchContext searchContext = this.ddmSearchHelper.buildStructureSearchContext(companyId, groupIds, classNameId, null, name, description, storageType, type, status, start, end, orderByComparator);
        return this.ddmSearchHelper.doSearch(searchContext, DDMStructure.class, arg_0 -> ((DDMStructurePersistence)this.ddmStructurePersistence).findByPrimaryKey(arg_0));
    }

    public int searchCount(long companyId, long[] groupIds, long classNameId, long classPK, String keywords) throws PortalException {
        SearchContext searchContext = this.ddmSearchHelper.buildStructureSearchContext(companyId, groupIds, classNameId, classPK, keywords, keywords, "", null, -1, -1, -1, null);
        return this.ddmSearchHelper.doSearchCount(searchContext, DDMStructure.class);
    }

    public int searchCount(long companyId, long[] groupIds, long classNameId, String keywords, int status) {
        SearchContext searchContext = this.ddmSearchHelper.buildStructureSearchContext(companyId, groupIds, classNameId, null, keywords, keywords, "", null, status, -1, -1, null);
        return this.ddmSearchHelper.doSearchCount(searchContext, DDMStructure.class);
    }

    public int searchCount(long companyId, long[] groupIds, long classNameId, String name, String description, String storageType, int type, int status, boolean andOperator) {
        SearchContext searchContext = this.ddmSearchHelper.buildStructureSearchContext(companyId, groupIds, classNameId, null, name, description, storageType, type, status, -1, -1, null);
        return this.ddmSearchHelper.doSearchCount(searchContext, DDMStructure.class);
    }

    @Indexable(type=IndexableType.REINDEX)
    public DDMStructure updateStructure(long userId, long structureId, DDMForm ddmForm, DDMFormLayout ddmFormLayout, ServiceContext serviceContext) throws PortalException {
        DDMStructure structure = this.ddmStructurePersistence.findByPrimaryKey(structureId);
        return this.doUpdateStructure(userId, structure.getParentStructureId(), structure.getNameMap(), structure.getDescriptionMap(), ddmForm, ddmFormLayout, serviceContext, structure);
    }

    @Indexable(type=IndexableType.REINDEX)
    public DDMStructure updateStructure(long userId, long groupId, long parentStructureId, long classNameId, String structureKey, Map<Locale, String> nameMap, Map<Locale, String> descriptionMap, DDMForm ddmForm, DDMFormLayout ddmFormLayout, ServiceContext serviceContext) throws PortalException {
        structureKey = this.getStructureKey(structureKey);
        DDMStructure structure = this.ddmStructurePersistence.findByG_C_S(groupId, classNameId, structureKey);
        return this.doUpdateStructure(userId, parentStructureId, nameMap, descriptionMap, ddmForm, ddmFormLayout, serviceContext, structure);
    }

    @Indexable(type=IndexableType.REINDEX)
    public DDMStructure updateStructure(long userId, long structureId, long parentStructureId, Map<Locale, String> nameMap, Map<Locale, String> descriptionMap, DDMForm ddmForm, DDMFormLayout ddmFormLayout, ServiceContext serviceContext) throws PortalException {
        DDMStructure structure = this.ddmStructurePersistence.findByPrimaryKey(structureId);
        return this.doUpdateStructure(userId, parentStructureId, nameMap, descriptionMap, ddmForm, ddmFormLayout, serviceContext, structure);
    }

    public DDMStructure updateStructure(long userId, long structureId, long parentStructureId, Map<Locale, String> nameMap, Map<Locale, String> descriptionMap, String definition, ServiceContext serviceContext) throws PortalException {
        DDMStructure structure = this.ddmStructurePersistence.findByPrimaryKey(structureId);
        User user = this.userLocalService.getUser(userId);
        structure.setUserId(userId);
        structure.setParentStructureId(parentStructureId);
        DDMStructureVersion latestStructureVersion = this.ddmStructureVersionLocalService.getLatestStructureVersion(structure.getStructureId());
        boolean majorVersion = GetterUtil.getBoolean((Object)serviceContext.getAttribute("majorVersion"));
        String version = this.getNextVersion(latestStructureVersion.getVersion(), majorVersion);
        structure.setVersion(version);
        structure.setNameMap(nameMap);
        structure.setVersionUserId(user.getUserId());
        structure.setVersionUserName(user.getFullName());
        structure.setModifiedDate(new Date());
        structure.setDescriptionMap(descriptionMap);
        structure.setDefinition(definition);
        DDMStructureVersion structureVersion = this.addStructureVersion(user, structure, version, serviceContext);
        if (!structureVersion.isApproved()) {
            return structure;
        }
        this.ddmStructurePersistence.update((BaseModel)structure);
        this.reindexStructure(structure, serviceContext);
        return structure;
    }

    @Deprecated
    public DDMStructure updateStructure(long groupId, long parentStructureId, long classNameId, String structureKey, Map<Locale, String> nameMap, Map<Locale, String> descriptionMap, String definition, ServiceContext serviceContext) throws PortalException {
        DDMStructure structure = this.ddmStructurePersistence.findByG_C_S(groupId, classNameId, structureKey);
        long userId = PortalUtil.getValidUserId((long)structure.getCompanyId(), (long)serviceContext.getUserId());
        this.ddmXML.validateXML(definition);
        DDMForm ddmForm = this.deserializeXSDDDMForm(definition);
        DDMFormLayout ddmFormLayout = this.ddm.getDefaultDDMFormLayout(ddmForm);
        structureKey = this.getStructureKey(structureKey);
        return this.doUpdateStructure(userId, parentStructureId, nameMap, descriptionMap, ddmForm, ddmFormLayout, serviceContext, structure);
    }

    @Deprecated
    public DDMStructure updateStructure(long structureId, long parentStructureId, Map<Locale, String> nameMap, Map<Locale, String> descriptionMap, String definition, ServiceContext serviceContext) throws PortalException {
        DDMStructure structure = this.ddmStructurePersistence.findByPrimaryKey(structureId);
        long userId = PortalUtil.getValidUserId((long)structure.getCompanyId(), (long)serviceContext.getUserId());
        this.ddmXML.validateXML(definition);
        DDMForm ddmForm = this.deserializeXSDDDMForm(definition);
        DDMFormLayout ddmFormLayout = this.ddm.getDefaultDDMFormLayout(ddmForm);
        return this.doUpdateStructure(userId, parentStructureId, nameMap, descriptionMap, ddmForm, ddmFormLayout, serviceContext, structure);
    }

    @Deprecated
    public DDMStructure updateXSD(long structureId, String definition, ServiceContext serviceContext) throws PortalException {
        DDMStructure structure = this.ddmStructurePersistence.findByPrimaryKey(structureId);
        long userId = PortalUtil.getValidUserId((long)structure.getCompanyId(), (long)serviceContext.getUserId());
        this.ddmXML.validateXML(definition);
        DDMForm ddmForm = this.deserializeXSDDDMForm(definition);
        DDMFormLayout ddmFormLayout = this.ddm.getDefaultDDMFormLayout(ddmForm);
        return this.doUpdateStructure(userId, structure.getParentStructureId(), structure.getNameMap(), structure.getDescriptionMap(), ddmForm, ddmFormLayout, serviceContext, structure);
    }

    protected void addDataProviderInstanceLinks(long groupId, long structureId, DDMForm ddmForm) {
        Set<Long> dataProviderInstanceIds = this.getDataProviderInstanceIds(groupId, ddmForm);
        for (Long dataProviderInstanceId : dataProviderInstanceIds) {
            this.ddmDataProviderInstanceLinkLocalService.addDataProviderInstanceLink(dataProviderInstanceId.longValue(), structureId);
        }
    }

    protected DDMStructureVersion addStructureVersion(User user, DDMStructure structure, String version, ServiceContext serviceContext) {
        long structureVersionId = this.counterLocalService.increment();
        DDMStructureVersion structureVersion = this.ddmStructureVersionPersistence.create(structureVersionId);
        structureVersion.setGroupId(structure.getGroupId());
        structureVersion.setCompanyId(structure.getCompanyId());
        structureVersion.setUserId(user.getUserId());
        structureVersion.setUserName(user.getFullName());
        structureVersion.setCreateDate(structure.getModifiedDate());
        structureVersion.setStructureId(structure.getStructureId());
        structureVersion.setVersion(version);
        structureVersion.setParentStructureId(structure.getParentStructureId());
        structureVersion.setName(structure.getName());
        structureVersion.setDescription(structure.getDescription());
        structureVersion.setDefinition(structure.getDefinition());
        structureVersion.setStorageType(structure.getStorageType());
        structureVersion.setType(structure.getType());
        int status = GetterUtil.getInteger((Object)serviceContext.getAttribute("status"), (int)0);
        structureVersion.setStatus(status);
        structureVersion.setStatusByUserId(user.getUserId());
        structureVersion.setStatusByUserName(user.getFullName());
        structureVersion.setStatusDate(structure.getModifiedDate());
        this.ddmStructureVersionPersistence.update((BaseModel)structureVersion);
        return structureVersion;
    }

    protected Set<Long> deleteStructures(List<DDMStructure> structures) throws PortalException {
        if (ListUtil.isEmpty(structures)) {
            return Collections.emptySet();
        }
        HashSet<Long> deletedStructureIds = new HashSet<Long>();
        for (DDMStructure structure : structures) {
            if (deletedStructureIds.contains(structure.getStructureId())) continue;
            if (!GroupThreadLocal.isDeleteInProcess()) {
                List childDDMStructures = this.ddmStructurePersistence.findByParentStructureId(structure.getStructureId());
                deletedStructureIds.addAll(this.deleteStructures(childDDMStructures));
            }
            this.ddmStructureLocalService.deleteStructure(structure);
            deletedStructureIds.add(structure.getStructureId());
        }
        return deletedStructureIds;
    }

    protected DDMForm deserializeDDMForm(String content, DDMFormDeserializer ddmFormDeserializer) {
        DDMFormDeserializerDeserializeRequest.Builder builder = DDMFormDeserializerDeserializeRequest.Builder.newBuilder((String)content);
        DDMFormDeserializerDeserializeResponse ddmFormDeserializerDeserializeResponse = ddmFormDeserializer.deserialize(builder.build());
        return ddmFormDeserializerDeserializeResponse.getDDMForm();
    }

    protected DDMForm deserializeJSONDDMForm(String content) {
        DDMFormDeserializer ddmFormDeserializer = this.ddmFormDeserializerTracker.getDDMFormDeserializer("json");
        return this.deserializeDDMForm(content, ddmFormDeserializer);
    }

    protected DDMForm deserializeXSDDDMForm(String content) {
        DDMFormDeserializer ddmFormDeserializer = this.ddmFormDeserializerTracker.getDDMFormDeserializer("xsd");
        return this.deserializeDDMForm(content, ddmFormDeserializer);
    }

    protected DDMStructure doUpdateStructure(long userId, long parentStructureId, Map<Locale, String> nameMap, Map<Locale, String> descriptionMap, DDMForm ddmForm, DDMFormLayout ddmFormLayout, ServiceContext serviceContext, DDMStructure structure) throws PortalException {
        User user = this.userLocalService.getUser(userId);
        DDMForm parentDDMForm = this.getParentDDMForm(parentStructureId);
        this.validateParentStructure(structure.getStructureId(), parentStructureId);
        this.validate(nameMap, parentDDMForm, ddmForm);
        structure.setUserId(userId);
        structure.setParentStructureId(parentStructureId);
        DDMStructureVersion latestStructureVersion = this.ddmStructureVersionLocalService.getLatestStructureVersion(structure.getStructureId());
        boolean majorVersion = GetterUtil.getBoolean((Object)serviceContext.getAttribute("majorVersion"));
        String version = this.getNextVersion(latestStructureVersion.getVersion(), majorVersion);
        structure.setVersion(version);
        structure.setNameMap(nameMap, ddmForm.getDefaultLocale());
        structure.setVersionUserId(user.getUserId());
        structure.setVersionUserName(user.getFullName());
        structure.setDescriptionMap(descriptionMap, ddmForm.getDefaultLocale());
        structure.setDefinition(this.serializeJSONDDMForm(ddmForm));
        DDMStructureVersion structureVersion = this.addStructureVersion(user, structure, version, serviceContext);
        serviceContext.getUuid();
        this.ddmStructureLayoutLocalService.addStructureLayout(structureVersion.getUserId(), structureVersion.getGroupId(), structureVersion.getStructureVersionId(), ddmFormLayout, serviceContext);
        if (!structureVersion.isApproved()) {
            return structure;
        }
        this.ddmStructurePersistence.update((BaseModel)structure);
        this.syncStructureTemplatesFields(structure);
        this.updateDataProviderInstanceLinks(structure.getGroupId(), structure.getStructureId(), ddmForm);
        this.reindexStructure(structure, serviceContext);
        return structure;
    }

    protected Set<Long> getDataProviderInstanceIds(long groupId, DDMForm ddmForm) {
        HashSet<Long> dataProviderInstanceIds = new HashSet<Long>();
        Map ddmFormFieldsMap = ddmForm.getDDMFormFieldsMap(true);
        for (DDMFormField ddmFormField : ddmFormFieldsMap.values()) {
            long[] ddmDataProviderInstanceIds;
            for (long ddmDataProviderInstanceId : ddmDataProviderInstanceIds = this.getDDMDataProviderInstanceIds(ddmFormField.getProperty("ddmDataProviderInstanceId"))) {
                if (ddmDataProviderInstanceId <= 0L) continue;
                dataProviderInstanceIds.add(ddmDataProviderInstanceId);
            }
        }
        for (DDMFormRule ddmFormRule : ddmForm.getDDMFormRules()) {
            Set<Long> ddmFormDataProviderInstanceIds = this.getDataProviderInstanceIds(groupId, ddmFormRule);
            dataProviderInstanceIds.addAll(ddmFormDataProviderInstanceIds);
        }
        return dataProviderInstanceIds;
    }

    protected Set<Long> getDataProviderInstanceIds(long groupId, DDMFormRule ddmFormRule) {
        List actions = ddmFormRule.getActions();
        if (ListUtil.isEmpty((List)actions)) {
            return Collections.emptySet();
        }
        HashSet<Long> dataProviderInstanceIds = new HashSet<Long>(actions.size());
        for (String action : actions) {
            Matcher matcher = _callFunctionPattern.matcher(action);
            while (matcher.find()) {
                String dataProviderUuid = matcher.group(1);
                DDMDataProviderInstance dataProviderInstance = this.ddmDataProviderInstanceLocalService.fetchDDMDataProviderInstanceByUuidAndGroupId(dataProviderUuid, groupId);
                if (dataProviderInstance == null) continue;
                dataProviderInstanceIds.add(dataProviderInstance.getDataProviderInstanceId());
            }
        }
        return dataProviderInstanceIds;
    }

    protected long[] getDDMDataProviderInstanceIds(JSONArray jsonArray) {
        long[] ddmDataProviderInstanceIds = new long[jsonArray.length()];
        for (int i = 0; i < jsonArray.length(); ++i) {
            ddmDataProviderInstanceIds[i] = jsonArray.getLong(i);
        }
        return ddmDataProviderInstanceIds;
    }

    protected long[] getDDMDataProviderInstanceIds(Object ddmDataProviderInstanceId) {
        long ddmDataProviderInstanceIdLong;
        if (ddmDataProviderInstanceId instanceof JSONArray) {
            JSONArray jsonArray = (JSONArray)ddmDataProviderInstanceId;
            return this.getDDMDataProviderInstanceIds(jsonArray);
        }
        if (ddmDataProviderInstanceId instanceof String) {
            try {
                JSONArray jsonArray = this.jsonFactory.createJSONArray((String)ddmDataProviderInstanceId);
                return this.getDDMDataProviderInstanceIds(jsonArray);
            }
            catch (Exception jsonArray) {
                // empty catch block
            }
        }
        if ((ddmDataProviderInstanceIdLong = GetterUtil.getLong((Object)ddmDataProviderInstanceId)) > 0L) {
            return new long[]{ddmDataProviderInstanceIdLong};
        }
        return GetterUtil.DEFAULT_LONG_VALUES;
    }

    protected Set<String> getDDMFormFieldsNames(DDMForm ddmForm) {
        Map ddmFormFieldsMap = ddmForm.getDDMFormFieldsMap(true);
        if (MapUtil.isEmpty((Map)ddmFormFieldsMap)) {
            return Collections.emptySet();
        }
        HashSet<String> ddmFormFieldsNames = new HashSet<String>(ddmFormFieldsMap.size());
        for (String ddmFormFieldName : ddmFormFieldsMap.keySet()) {
            ddmFormFieldsNames.add(StringUtil.toLowerCase((String)ddmFormFieldName));
        }
        return ddmFormFieldsNames;
    }

    protected String getNextVersion(String version, boolean majorVersion) {
        int[] versionParts = StringUtil.split((String)version, (String)".", (int)0);
        if (majorVersion) {
            versionParts[0] = versionParts[0] + 1;
            versionParts[1] = 0;
        } else {
            versionParts[1] = versionParts[1] + 1;
        }
        return versionParts[0] + "." + versionParts[1];
    }

    protected DDMForm getParentDDMForm(long parentStructureId) {
        DDMStructure parentStructure = this.ddmStructurePersistence.fetchByPrimaryKey(parentStructureId);
        if (parentStructure == null) {
            return null;
        }
        return parentStructure.getFullHierarchyDDMForm();
    }

    protected String getStructureKey(String structureKey) {
        if (structureKey != null) {
            structureKey = structureKey.trim();
            return StringUtil.toUpperCase((String)structureKey);
        }
        return "";
    }

    protected List<DDMTemplate> getStructureTemplates(DDMStructure structure, String type) {
        long classNameId = this.classNameLocalService.getClassNameId(DDMStructure.class);
        return this.ddmTemplateLocalService.getTemplates(structure.getGroupId(), classNameId, structure.getStructureId(), type);
    }

    protected void reindexStructure(DDMStructure structure, ServiceContext serviceContext) throws PortalException {
        if (!serviceContext.isIndexingEnabled()) {
            return;
        }
        DDMStructureIndexer ddmStructureIndexer = this.ddmStructureIndexerTracker.getDDMStructureIndexer(structure.getClassName());
        if (ddmStructureIndexer == null) {
            return;
        }
        String backgroundTaskName = DDMStructureIndexerBackgroundTaskExecutor.getBackgroundTaskName(structure.getStructureId());
        HashMap<String, Long> taskContextMap = new HashMap<String, Long>();
        taskContextMap.put("structureId", structure.getStructureId());
        this.backgroundTaskmanager.addBackgroundTask(structure.getUserId(), structure.getGroupId(), backgroundTaskName, DDMStructureIndexerBackgroundTaskExecutor.class.getName(), taskContextMap, serviceContext);
    }

    protected String serializeJSONDDMForm(DDMForm ddmForm) {
        DDMFormSerializer ddmFormSerializer = this.ddmFormSerializerTracker.getDDMFormSerializer("json");
        DDMFormSerializerSerializeRequest.Builder builder = DDMFormSerializerSerializeRequest.Builder.newBuilder((DDMForm)ddmForm);
        DDMFormSerializerSerializeResponse ddmFormSerializerSerializeResponse = ddmFormSerializer.serialize(builder.build());
        return ddmFormSerializerSerializeResponse.getContent();
    }

    protected void syncStructureTemplatesFields(final DDMStructure structure) {
        TransactionCommitCallbackUtil.registerCallback((Callable)new Callable<Void>(){

            @Override
            public Void call() throws Exception {
                DDMFormSerializer ddmFormSerializer = DDMStructureLocalServiceImpl.this.ddmFormSerializerTracker.getDDMFormSerializer("json");
                DDMFormDeserializer ddmFormDeserializer = DDMStructureLocalServiceImpl.this.ddmFormDeserializerTracker.getDDMFormDeserializer("json");
                DDMFormTemplateSynchonizer ddmFormTemplateSynchonizer = new DDMFormTemplateSynchonizer(structure.getDDMForm(), ddmFormDeserializer, ddmFormSerializer, DDMStructureLocalServiceImpl.this.ddmTemplateLocalService);
                List<DDMTemplate> templates = DDMStructureLocalServiceImpl.this.getStructureTemplates(structure, "form");
                ddmFormTemplateSynchonizer.setDDMFormTemplates(templates);
                ddmFormTemplateSynchonizer.synchronize();
                return null;
            }
        });
    }

    protected void updateDataProviderInstanceLinks(long groupId, long structureId, DDMForm ddmForm) {
        Set<Long> dataProviderInstanceIds = this.getDataProviderInstanceIds(groupId, ddmForm);
        List dataProviderInstanceLinks = this.ddmDataProviderInstanceLinkLocalService.getDataProviderInstanceLinks(structureId);
        for (DDMDataProviderInstanceLink dataProviderInstanceLink : dataProviderInstanceLinks) {
            long dataProviderInstanceId = dataProviderInstanceLink.getDataProviderInstanceId();
            if (dataProviderInstanceIds.remove(dataProviderInstanceId)) continue;
            this.ddmDataProviderInstanceLinkLocalService.deleteDataProviderInstanceLink(dataProviderInstanceLink);
        }
        for (Long dataProviderInstanceId : dataProviderInstanceIds) {
            this.ddmDataProviderInstanceLinkLocalService.addDataProviderInstanceLink(dataProviderInstanceId.longValue(), structureId);
        }
    }

    protected void validate(DDMForm ddmForm) throws PortalException {
        this.ddmFormValidator.validate(ddmForm);
    }

    protected void validate(DDMForm parentDDMForm, DDMForm ddmForm) throws PortalException {
        Set commonDDMFormFieldNames = SetUtil.intersect(this.getDDMFormFieldsNames(parentDDMForm), this.getDDMFormFieldsNames(ddmForm));
        if (!commonDDMFormFieldNames.isEmpty()) {
            throw new StructureDuplicateElementException("Duplicate DDM form field names: " + StringUtil.merge((Collection)commonDDMFormFieldNames));
        }
    }

    protected void validate(long groupId, long parentStructureId, long classNameId, String structureKey, Map<Locale, String> nameMap, DDMForm ddmForm) throws PortalException {
        DDMStructure structure = this.ddmStructurePersistence.fetchByG_C_S(groupId, classNameId, structureKey = this.getStructureKey(structureKey));
        if (structure != null) {
            StructureDuplicateStructureKeyException sdske = new StructureDuplicateStructureKeyException();
            sdske.setStructureKey(structure.getStructureKey());
            throw sdske;
        }
        DDMForm parentDDMForm = this.getParentDDMForm(parentStructureId);
        this.validate(nameMap, parentDDMForm, ddmForm);
    }

    protected void validate(Map<Locale, String> nameMap, DDMForm parentDDMForm, DDMForm ddmForm) throws PortalException {
        try {
            if (!ExportImportThreadLocal.isImportInProcess()) {
                this.validate(nameMap, ddmForm.getDefaultLocale());
            }
            this.validate(ddmForm);
            if (parentDDMForm != null) {
                this.validate(parentDDMForm, ddmForm);
            }
        }
        catch (DDMFormValidationException ddmfve) {
            throw ddmfve;
        }
        catch (LocaleException le) {
            throw le;
        }
        catch (StructureDuplicateElementException sdee) {
            throw sdee;
        }
        catch (StructureNameException sne) {
            throw sne;
        }
        catch (StructureDefinitionException sde) {
            throw sde;
        }
        catch (Exception e) {
            throw new StructureDefinitionException((Throwable)e);
        }
    }

    protected void validate(Map<Locale, String> nameMap, Locale contentDefaultLocale) throws PortalException {
        String name = nameMap.get(contentDefaultLocale);
        if (Validator.isNull((String)name)) {
            throw new StructureNameException("Name is null for locale " + contentDefaultLocale.getDisplayName());
        }
        if (!LanguageUtil.isAvailableLocale((Locale)contentDefaultLocale)) {
            Long companyId = CompanyThreadLocal.getCompanyId();
            LocaleException le = new LocaleException(3, StringBundler.concat((Object[])new Object[]{"The locale ", contentDefaultLocale, " is not available in company ", companyId}));
            le.setSourceAvailableLocales(Collections.singleton(contentDefaultLocale));
            le.setTargetAvailableLocales((Collection)LanguageUtil.getAvailableLocales());
            throw le;
        }
    }

    protected void validateParentStructure(long structureId, long parentStructureId) throws PortalException {
        while (parentStructureId != 0L) {
            DDMStructure parentStructure = this.ddmStructurePersistence.fetchByPrimaryKey(parentStructureId);
            if (structureId == parentStructure.getStructureId()) {
                throw new InvalidParentStructureException();
            }
            parentStructureId = parentStructure.getParentStructureId();
        }
    }
}

