/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.dynamic.data.mapping.internal.util;

import com.liferay.dynamic.data.mapping.io.DDMFormDeserializer;
import com.liferay.dynamic.data.mapping.io.DDMFormDeserializerDeserializeRequest;
import com.liferay.dynamic.data.mapping.io.DDMFormDeserializerDeserializeResponse;
import com.liferay.dynamic.data.mapping.io.DDMFormDeserializerTracker;
import com.liferay.dynamic.data.mapping.io.DDMFormLayoutDeserializer;
import com.liferay.dynamic.data.mapping.io.DDMFormLayoutDeserializerDeserializeRequest;
import com.liferay.dynamic.data.mapping.io.DDMFormLayoutDeserializerDeserializeResponse;
import com.liferay.dynamic.data.mapping.io.DDMFormLayoutDeserializerTracker;
import com.liferay.dynamic.data.mapping.model.DDMForm;
import com.liferay.dynamic.data.mapping.model.DDMFormLayout;
import com.liferay.dynamic.data.mapping.model.DDMStructure;
import com.liferay.dynamic.data.mapping.service.DDMStructureLocalService;
import com.liferay.dynamic.data.mapping.service.DDMTemplateLocalService;
import com.liferay.dynamic.data.mapping.storage.StorageType;
import com.liferay.dynamic.data.mapping.util.DDM;
import com.liferay.dynamic.data.mapping.util.DDMXML;
import com.liferay.dynamic.data.mapping.util.DefaultDDMStructureHelper;
import com.liferay.portal.kernel.language.LanguageUtil;
import com.liferay.portal.kernel.service.ServiceContext;
import com.liferay.portal.kernel.upgrade.util.UpgradeProcessUtil;
import com.liferay.portal.kernel.util.FileUtil;
import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.kernel.util.Portal;
import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.portal.kernel.xml.Document;
import com.liferay.portal.kernel.xml.Element;
import com.liferay.portal.kernel.xml.UnsecureSAXReaderUtil;
import java.io.Serializable;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component(immediate=true, service={DefaultDDMStructureHelper.class})
public class DefaultDDMStructureHelperImpl
implements DefaultDDMStructureHelper {
    private DDM _ddm;
    private DDMFormDeserializerTracker _ddmFormDeserializerTracker;
    private DDMFormLayoutDeserializerTracker _ddmFormLayoutDeserializerTracker;
    private DDMStructureLocalService _ddmStructureLocalService;
    private DDMTemplateLocalService _ddmTemplateLocalService;
    private DDMXML _ddmXML;
    @Reference
    private Portal _portal;

    public void addDDMStructures(long userId, long groupId, long classNameId, ClassLoader classLoader, String fileName, ServiceContext serviceContext) throws Exception {
        Locale locale = this._portal.getSiteDefaultLocale(groupId);
        List<Element> structureElements = this.getDDMStructures(classLoader, fileName, locale);
        for (Element structureElement : structureElements) {
            String name;
            String ddmStructureKey;
            DDMStructure ddmStructure;
            boolean dynamicStructure = GetterUtil.getBoolean((String)structureElement.elementText("dynamic-structure"));
            if (dynamicStructure || (ddmStructure = this._ddmStructureLocalService.fetchStructure(groupId, classNameId, ddmStructureKey = (name = structureElement.elementText("name")))) != null || name.equals("image-gallery-image") && !UpgradeProcessUtil.isCreateIGImageDocumentType()) continue;
            String description = structureElement.elementText("description");
            HashMap<Locale, String> nameMap = new HashMap<Locale, String>();
            HashMap<Locale, String> descriptionMap = new HashMap<Locale, String>();
            for (Locale curLocale : LanguageUtil.getAvailableLocales((long)groupId)) {
                nameMap.put(curLocale, LanguageUtil.get((Locale)curLocale, (String)name));
                descriptionMap.put(curLocale, LanguageUtil.get((Locale)curLocale, (String)description));
            }
            DDMForm ddmForm = this.getDDMForm(structureElement, locale);
            DDMFormLayout ddmFormLayout = this.getDDMFormLayout(structureElement, ddmForm);
            serviceContext.setAttribute("status", (Serializable)Integer.valueOf(0));
            ddmStructure = this._ddmStructureLocalService.addStructure(userId, groupId, 0L, classNameId, ddmStructureKey, nameMap, descriptionMap, ddmForm, ddmFormLayout, StorageType.JSON.toString(), 0, serviceContext);
            Element templateElement = structureElement.element("template");
            if (templateElement == null) continue;
            String templateFileName = templateElement.elementText("file-name");
            String script = StringUtil.read((ClassLoader)classLoader, (String)(FileUtil.getPath((String)fileName) + "/" + templateFileName));
            boolean cacheable = GetterUtil.getBoolean((String)templateElement.elementText("cacheable"));
            this._ddmTemplateLocalService.addTemplate(userId, groupId, this._portal.getClassNameId(DDMStructure.class), ddmStructure.getStructureId(), ddmStructure.getClassNameId(), name, nameMap, null, "display", "create", "ftl", script, cacheable, false, "", null, serviceContext);
        }
    }

    public String getDynamicDDMStructureDefinition(ClassLoader classLoader, String fileName, String dynamicDDMStructureName, Locale locale) throws Exception {
        List<Element> structureElements = this.getDDMStructures(classLoader, fileName, locale);
        for (Element structureElement : structureElements) {
            String name;
            boolean dynamicStructure = GetterUtil.getBoolean((String)structureElement.elementText("dynamic-structure"));
            if (!dynamicStructure || !(name = structureElement.elementText("name")).equals(dynamicDDMStructureName)) continue;
            Element structureElementRootElement = structureElement.element("root");
            return structureElementRootElement.asXML();
        }
        return null;
    }

    protected DDMForm deserialize(String content, String type) {
        DDMFormDeserializer ddmFormDeserializer = this._ddmFormDeserializerTracker.getDDMFormDeserializer(type);
        DDMFormDeserializerDeserializeRequest.Builder builder = DDMFormDeserializerDeserializeRequest.Builder.newBuilder((String)content);
        DDMFormDeserializerDeserializeResponse ddmFormDeserializerDeserializeResponse = ddmFormDeserializer.deserialize(builder.build());
        return ddmFormDeserializerDeserializeResponse.getDDMForm();
    }

    protected DDMForm getDDMForm(Element structureElement, Locale locale) {
        Element structureElementDefinitionElement = structureElement.element("definition");
        if (structureElementDefinitionElement != null) {
            return this.deserialize(structureElementDefinitionElement.getTextTrim(), "json");
        }
        Element structureElementRootElement = structureElement.element("root");
        String definition = structureElementRootElement.asXML();
        DDMForm ddmForm = this.deserialize(definition, "xsd");
        return this._ddm.updateDDMFormDefaultLocale(ddmForm, locale);
    }

    protected DDMFormLayout getDDMFormLayout(Element structureElement, DDMForm ddmForm) {
        Element structureElementLayoutElement = structureElement.element("layout");
        if (structureElementLayoutElement != null) {
            DDMFormLayoutDeserializer ddmFormLayoutDeserializer = this._ddmFormLayoutDeserializerTracker.getDDMFormLayoutDeserializer("json");
            DDMFormLayoutDeserializerDeserializeRequest.Builder builder = DDMFormLayoutDeserializerDeserializeRequest.Builder.newBuilder((String)structureElementLayoutElement.getTextTrim());
            DDMFormLayoutDeserializerDeserializeResponse ddmFormLayoutDeserializerDeserializeResponse = ddmFormLayoutDeserializer.deserialize(builder.build());
            return ddmFormLayoutDeserializerDeserializeResponse.getDDMFormLayout();
        }
        return this._ddm.getDefaultDDMFormLayout(ddmForm);
    }

    protected List<Element> getDDMStructures(ClassLoader classLoader, String fileName, Locale locale) throws Exception {
        String xml = StringUtil.read((ClassLoader)classLoader, (String)fileName);
        xml = StringUtil.replace((String)xml, (String)"[$LOCALE_DEFAULT$]", (String)locale.toString());
        Document document = UnsecureSAXReaderUtil.read((String)xml);
        Element rootElement = document.getRootElement();
        return rootElement.elements("structure");
    }

    @Reference(unbind="-")
    protected void setDDM(DDM ddm) {
        this._ddm = ddm;
    }

    @Reference(unbind="-")
    protected void setDDMFormDeserializerTracker(DDMFormDeserializerTracker ddmFormDeserializerTracker) {
        this._ddmFormDeserializerTracker = ddmFormDeserializerTracker;
    }

    @Reference(unbind="-")
    protected void setDDMFormLayoutDeserializerTracker(DDMFormLayoutDeserializerTracker ddmFormLayoutDeserializerTracker) {
        this._ddmFormLayoutDeserializerTracker = ddmFormLayoutDeserializerTracker;
    }

    @Reference(unbind="-")
    protected void setDDMStructureLocalService(DDMStructureLocalService ddmStructureLocalService) {
        this._ddmStructureLocalService = ddmStructureLocalService;
    }

    @Reference(unbind="-")
    protected void setDDMTemplateLocalService(DDMTemplateLocalService ddmTemplateLocalService) {
        this._ddmTemplateLocalService = ddmTemplateLocalService;
    }

    @Reference(unbind="-")
    protected void setDDMXML(DDMXML ddmXML) {
        this._ddmXML = ddmXML;
    }
}

