/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.dynamic.data.mapping.internal.search.spi.model.index.contributor;

import com.liferay.dynamic.data.mapping.model.DDMStructure;
import com.liferay.dynamic.data.mapping.model.DDMStructureVersion;
import com.liferay.dynamic.data.mapping.service.DDMStructureVersionLocalService;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.search.Document;
import com.liferay.portal.kernel.util.LocaleUtil;
import com.liferay.portal.kernel.util.LocalizationUtil;
import com.liferay.portal.search.spi.model.index.contributor.ModelDocumentContributor;
import java.util.Locale;
import java.util.Map;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component(immediate=true, property={"indexer.class.name=com.liferay.dynamic.data.mapping.model.DDMStructure"}, service={ModelDocumentContributor.class})
public class DDMStructureModelDocumentContributor
implements ModelDocumentContributor<DDMStructure> {
    @Reference
    protected DDMStructureVersionLocalService ddmStructureVersionLocalService;
    private static final Log _log = LogFactoryUtil.getLog(DDMStructureModelDocumentContributor.class);

    public void contribute(Document document, DDMStructure ddmStructure) {
        String[] nameLanguageIds;
        String[] descriptionLanguageIds;
        block4: {
            document.addKeyword("classNameId", ddmStructure.getClassNameId());
            try {
                DDMStructureVersion structureVersion = this.ddmStructureVersionLocalService.getStructureVersion(ddmStructure.getStructureId(), ddmStructure.getVersion());
                document.addKeyword("status", structureVersion.getStatus());
                document.addKeyword("version", structureVersion.getVersion());
            }
            catch (PortalException pe) {
                if (!_log.isDebugEnabled()) break block4;
                _log.debug((Object)pe, (Throwable)pe);
            }
        }
        document.addKeyword("structureKey", ddmStructure.getStructureKey());
        document.addKeyword("storageType", ddmStructure.getStorageType());
        document.addKeyword("type", ddmStructure.getType());
        Locale defaultLocale = LocaleUtil.getSiteDefault();
        String defaultLanguageId = LocaleUtil.toLanguageId((Locale)defaultLocale);
        for (String descriptionLanguageId : descriptionLanguageIds = this.getLanguageIds(defaultLanguageId, ddmStructure.getDescription())) {
            document.addText(LocalizationUtil.getLocalizedName((String)"description", (String)descriptionLanguageId), ddmStructure.getDescription(descriptionLanguageId));
        }
        for (String nameLanguageId : nameLanguageIds = this.getLanguageIds(defaultLanguageId, ddmStructure.getName())) {
            document.addText(LocalizationUtil.getLocalizedName((String)"name", (String)nameLanguageId), ddmStructure.getName(nameLanguageId));
        }
        document.addLocalizedKeyword("localized_name", LocalizationUtil.populateLocalizationMap((Map)ddmStructure.getNameMap(), (String)ddmStructure.getDefaultLanguageId(), (long)ddmStructure.getGroupId()), true, true);
    }

    protected String[] getLanguageIds(String defaultLanguageId, String content) {
        String[] languageIds = LocalizationUtil.getAvailableLanguageIds((String)content);
        if (languageIds.length == 0) {
            languageIds = new String[]{defaultLanguageId};
        }
        return languageIds;
    }
}

