/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.dynamic.data.mapping.internal.exportimport.data.handler;

import com.liferay.dynamic.data.mapping.exportimport.staged.model.repository.DDMFormInstanceRecordStagedModelRepository;
import com.liferay.dynamic.data.mapping.io.DDMFormValuesDeserializer;
import com.liferay.dynamic.data.mapping.io.DDMFormValuesDeserializerDeserializeRequest;
import com.liferay.dynamic.data.mapping.io.DDMFormValuesDeserializerDeserializeResponse;
import com.liferay.dynamic.data.mapping.io.DDMFormValuesDeserializerTracker;
import com.liferay.dynamic.data.mapping.io.DDMFormValuesSerializer;
import com.liferay.dynamic.data.mapping.io.DDMFormValuesSerializerSerializeRequest;
import com.liferay.dynamic.data.mapping.io.DDMFormValuesSerializerSerializeResponse;
import com.liferay.dynamic.data.mapping.io.DDMFormValuesSerializerTracker;
import com.liferay.dynamic.data.mapping.model.DDMForm;
import com.liferay.dynamic.data.mapping.model.DDMFormInstance;
import com.liferay.dynamic.data.mapping.model.DDMFormInstanceRecord;
import com.liferay.dynamic.data.mapping.model.DDMStructure;
import com.liferay.dynamic.data.mapping.service.DDMFormInstanceLocalService;
import com.liferay.dynamic.data.mapping.storage.DDMFormValues;
import com.liferay.exportimport.content.processor.ExportImportContentProcessor;
import com.liferay.exportimport.data.handler.base.BaseStagedModelDataHandler;
import com.liferay.exportimport.kernel.lar.ExportImportPathUtil;
import com.liferay.exportimport.kernel.lar.PortletDataContext;
import com.liferay.exportimport.kernel.lar.PortletDataException;
import com.liferay.exportimport.kernel.lar.StagedModelDataHandler;
import com.liferay.exportimport.kernel.lar.StagedModelDataHandlerUtil;
import com.liferay.exportimport.staged.model.repository.StagedModelRepository;
import com.liferay.portal.kernel.model.ClassedModel;
import com.liferay.portal.kernel.model.StagedModel;
import com.liferay.portal.kernel.util.ArrayUtil;
import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.kernel.util.MapUtil;
import com.liferay.portal.kernel.xml.Element;
import java.io.Serializable;
import java.util.Map;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component(immediate=true, service={StagedModelDataHandler.class})
public class DDMFormInstanceRecordStagedModelDataHandler
extends BaseStagedModelDataHandler<DDMFormInstanceRecord> {
    public static final String[] CLASS_NAMES = new String[]{DDMFormInstanceRecord.class.getName()};
    @Reference(service=DDMFormInstanceLocalService.class)
    private DDMFormInstanceLocalService _ddmFormInstanceLocalService;
    @Reference(service=DDMFormInstanceRecordStagedModelRepository.class, target="(model.class.name=com.liferay.dynamic.data.mapping.model.DDMFormInstanceRecord)")
    private DDMFormInstanceRecordStagedModelRepository _ddmFormInstanceRecordStagedModelRepository;
    @Reference(service=DDMFormValuesDeserializerTracker.class)
    private DDMFormValuesDeserializerTracker _ddmFormValuesDeserializerTracker;
    @Reference(service=ExportImportContentProcessor.class, target="(model.class.name=com.liferay.dynamic.data.mapping.storage.DDMFormValues)")
    private ExportImportContentProcessor<DDMFormValues> _ddmFormValuesExportImportContentProcessor;
    @Reference(service=DDMFormValuesSerializerTracker.class)
    private DDMFormValuesSerializerTracker _ddmFormValuesSerializerTracker;

    public String[] getClassNames() {
        return CLASS_NAMES;
    }

    public String getDisplayName(DDMFormInstanceRecord record) {
        return record.getUuid();
    }

    protected DDMFormValues deserialize(String content, DDMForm ddmForm) {
        DDMFormValuesDeserializer ddmFormValuesDeserializer = this._ddmFormValuesDeserializerTracker.getDDMFormValuesDeserializer("json");
        DDMFormValuesDeserializerDeserializeRequest.Builder builder = DDMFormValuesDeserializerDeserializeRequest.Builder.newBuilder((String)content, (DDMForm)ddmForm);
        DDMFormValuesDeserializerDeserializeResponse ddmFormValuesDeserializerDeserializeResponse = ddmFormValuesDeserializer.deserialize(builder.build());
        return ddmFormValuesDeserializerDeserializeResponse.getDDMFormValues();
    }

    protected void doExportStagedModel(PortletDataContext portletDataContext, DDMFormInstanceRecord record) throws Exception {
        StagedModelDataHandlerUtil.exportReferenceStagedModel((PortletDataContext)portletDataContext, (StagedModel)record, (StagedModel)record.getFormInstance(), (String)"strong");
        Element recordElement = portletDataContext.getExportDataElement((ClassedModel)record);
        this.exportDDMFormValues(portletDataContext, record, recordElement);
        portletDataContext.addClassedModel(recordElement, ExportImportPathUtil.getModelPath((StagedModel)record), (ClassedModel)record);
    }

    protected void doImportMissingReference(PortletDataContext portletDataContext, String uuid, long groupId, long recordId) throws Exception {
        DDMFormInstanceRecord existingRecord = (DDMFormInstanceRecord)this.fetchMissingReference(uuid, groupId);
        Map recordIds = portletDataContext.getNewPrimaryKeysMap(DDMFormInstanceRecord.class);
        recordIds.put(recordId, existingRecord.getFormInstanceRecordId());
    }

    protected void doImportStagedModel(PortletDataContext portletDataContext, DDMFormInstanceRecord record) throws Exception {
        Map recordSetIds = portletDataContext.getNewPrimaryKeysMap(DDMFormInstance.class);
        long ddmFormInstanceId = MapUtil.getLong((Map)recordSetIds, (long)record.getFormInstanceId(), (long)record.getFormInstanceId());
        Element recordElement = portletDataContext.getImportDataElement((StagedModel)record);
        DDMFormValues ddmFormValues = this.getImportDDMFormValues(portletDataContext, recordElement, ddmFormInstanceId);
        DDMFormInstanceRecord importedRecord = (DDMFormInstanceRecord)record.clone();
        importedRecord.setGroupId(portletDataContext.getScopeGroupId());
        importedRecord.setFormInstanceId(ddmFormInstanceId);
        DDMFormInstanceRecord existingRecord = this._ddmFormInstanceRecordStagedModelRepository.fetchStagedModelByUuidAndGroupId(record.getUuid(), portletDataContext.getScopeGroupId());
        if (existingRecord == null || !portletDataContext.isDataStrategyMirror()) {
            importedRecord = this._ddmFormInstanceRecordStagedModelRepository.addStagedModel(portletDataContext, importedRecord, ddmFormValues);
        } else {
            importedRecord.setFormInstanceRecordId(existingRecord.getFormInstanceRecordId());
            importedRecord = this._ddmFormInstanceRecordStagedModelRepository.updateStagedModel(portletDataContext, importedRecord, ddmFormValues);
        }
        portletDataContext.importClassedModel((ClassedModel)record, (ClassedModel)importedRecord);
    }

    protected void exportDDMFormValues(PortletDataContext portletDataContext, DDMFormInstanceRecord ddmFormInstanceRecord, Element recordElement) throws Exception {
        String ddmFormValuesPath = ExportImportPathUtil.getModelPath((StagedModel)ddmFormInstanceRecord, (String)"ddm-form-values.json");
        recordElement.addAttribute("ddm-form-values-path", ddmFormValuesPath);
        DDMFormValues ddmFormValues = ddmFormInstanceRecord.getDDMFormValues();
        ddmFormValues = (DDMFormValues)this._ddmFormValuesExportImportContentProcessor.replaceExportContentReferences(portletDataContext, (StagedModel)ddmFormInstanceRecord, (Serializable)ddmFormValues, true, false);
        portletDataContext.addZipEntry(ddmFormValuesPath, this.serialize(ddmFormValues));
    }

    protected DDMFormValues getImportDDMFormValues(PortletDataContext portletDataContext, Element recordElement, long ddmFormInstanceId) throws Exception {
        DDMFormInstance recordSet = this._ddmFormInstanceLocalService.getFormInstance(ddmFormInstanceId);
        DDMStructure ddmStructure = recordSet.getStructure();
        String ddmFormValuesPath = recordElement.attributeValue("ddm-form-values-path");
        String serializedDDMFormValues = portletDataContext.getZipEntryAsString(ddmFormValuesPath);
        DDMFormValues ddmFormValues = this.deserialize(serializedDDMFormValues, ddmStructure.getDDMForm());
        return (DDMFormValues)this._ddmFormValuesExportImportContentProcessor.replaceImportContentReferences(portletDataContext, (StagedModel)ddmStructure, (Serializable)ddmFormValues);
    }

    protected StagedModelRepository<DDMFormInstanceRecord> getStagedModelRepository() {
        return this._ddmFormInstanceRecordStagedModelRepository;
    }

    protected String serialize(DDMFormValues ddmFormValues) {
        DDMFormValuesSerializer ddmFormValuesSerializer = this._ddmFormValuesSerializerTracker.getDDMFormValuesSerializer("json");
        DDMFormValuesSerializerSerializeRequest.Builder builder = DDMFormValuesSerializerSerializeRequest.Builder.newBuilder((DDMFormValues)ddmFormValues);
        DDMFormValuesSerializerSerializeResponse ddmFormValuesSerializerSerializeResponse = ddmFormValuesSerializer.serialize(builder.build());
        return ddmFormValuesSerializerSerializeResponse.getContent();
    }

    protected void validateExport(PortletDataContext portletDataContext, DDMFormInstanceRecord record) throws PortletDataException {
        int status = -1;
        try {
            status = record.getStatus();
        }
        catch (Exception e) {
            throw new PortletDataException((Throwable)e);
        }
        if (!portletDataContext.isInitialPublication() && !ArrayUtil.contains((int[])this.getExportableStatuses(), (int)status)) {
            PortletDataException pde = new PortletDataException(9);
            pde.setStagedModelDisplayName(record.getUuid());
            pde.setStagedModelClassName(record.getModelClassName());
            pde.setStagedModelClassPK(GetterUtil.getString((Object)record.getFormInstanceRecordId()));
            throw pde;
        }
    }
}

