/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.dynamic.data.mapping.service.persistence.impl;

import com.liferay.dynamic.data.mapping.exception.NoSuchTemplateLinkException;
import com.liferay.dynamic.data.mapping.model.DDMTemplateLink;
import com.liferay.dynamic.data.mapping.model.impl.DDMTemplateLinkImpl;
import com.liferay.dynamic.data.mapping.model.impl.DDMTemplateLinkModelImpl;
import com.liferay.dynamic.data.mapping.service.persistence.DDMTemplateLinkPersistence;
import com.liferay.dynamic.data.mapping.service.persistence.impl.constants.DDMPersistenceConstants;
import com.liferay.petra.string.StringBundler;
import com.liferay.portal.kernel.configuration.Configuration;
import com.liferay.portal.kernel.dao.orm.Dialect;
import com.liferay.portal.kernel.dao.orm.EntityCache;
import com.liferay.portal.kernel.dao.orm.FinderCache;
import com.liferay.portal.kernel.dao.orm.FinderPath;
import com.liferay.portal.kernel.dao.orm.Query;
import com.liferay.portal.kernel.dao.orm.QueryPos;
import com.liferay.portal.kernel.dao.orm.QueryUtil;
import com.liferay.portal.kernel.dao.orm.Session;
import com.liferay.portal.kernel.dao.orm.SessionFactory;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.model.BaseModel;
import com.liferay.portal.kernel.security.auth.CompanyThreadLocal;
import com.liferay.portal.kernel.service.persistence.impl.BasePersistenceImpl;
import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.kernel.util.OrderByComparator;
import com.liferay.portal.kernel.util.ProxyUtil;
import java.io.Serializable;
import java.lang.reflect.InvocationHandler;
import java.util.List;
import java.util.Map;
import javax.sql.DataSource;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Deactivate;
import org.osgi.service.component.annotations.Reference;

@Component(service={DDMTemplateLinkPersistence.class})
public class DDMTemplateLinkPersistenceImpl
extends BasePersistenceImpl<DDMTemplateLink>
implements DDMTemplateLinkPersistence {
    public static final String FINDER_CLASS_NAME_ENTITY = DDMTemplateLinkImpl.class.getName();
    public static final String FINDER_CLASS_NAME_LIST_WITH_PAGINATION = FINDER_CLASS_NAME_ENTITY + ".List1";
    public static final String FINDER_CLASS_NAME_LIST_WITHOUT_PAGINATION = FINDER_CLASS_NAME_ENTITY + ".List2";
    private FinderPath _finderPathWithPaginationFindAll;
    private FinderPath _finderPathWithoutPaginationFindAll;
    private FinderPath _finderPathCountAll;
    private FinderPath _finderPathWithPaginationFindByClassNameId;
    private FinderPath _finderPathWithoutPaginationFindByClassNameId;
    private FinderPath _finderPathCountByClassNameId;
    private static final String _FINDER_COLUMN_CLASSNAMEID_CLASSNAMEID_2 = "ddmTemplateLink.classNameId = ?";
    private FinderPath _finderPathWithPaginationFindByTemplateId;
    private FinderPath _finderPathWithoutPaginationFindByTemplateId;
    private FinderPath _finderPathCountByTemplateId;
    private static final String _FINDER_COLUMN_TEMPLATEID_TEMPLATEID_2 = "ddmTemplateLink.templateId = ?";
    private FinderPath _finderPathFetchByC_C;
    private FinderPath _finderPathCountByC_C;
    private static final String _FINDER_COLUMN_C_C_CLASSNAMEID_2 = "ddmTemplateLink.classNameId = ? AND ";
    private static final String _FINDER_COLUMN_C_C_CLASSPK_2 = "ddmTemplateLink.classPK = ?";
    private boolean _columnBitmaskEnabled;
    @Reference
    protected EntityCache entityCache;
    @Reference
    protected FinderCache finderCache;
    private static final String _SQL_SELECT_DDMTEMPLATELINK = "SELECT ddmTemplateLink FROM DDMTemplateLink ddmTemplateLink";
    private static final String _SQL_SELECT_DDMTEMPLATELINK_WHERE = "SELECT ddmTemplateLink FROM DDMTemplateLink ddmTemplateLink WHERE ";
    private static final String _SQL_COUNT_DDMTEMPLATELINK = "SELECT COUNT(ddmTemplateLink) FROM DDMTemplateLink ddmTemplateLink";
    private static final String _SQL_COUNT_DDMTEMPLATELINK_WHERE = "SELECT COUNT(ddmTemplateLink) FROM DDMTemplateLink ddmTemplateLink WHERE ";
    private static final String _ORDER_BY_ENTITY_ALIAS = "ddmTemplateLink.";
    private static final String _NO_SUCH_ENTITY_WITH_PRIMARY_KEY = "No DDMTemplateLink exists with the primary key ";
    private static final String _NO_SUCH_ENTITY_WITH_KEY = "No DDMTemplateLink exists with the key {";
    private static final Log _log = LogFactoryUtil.getLog(DDMTemplateLinkPersistenceImpl.class);

    public List<DDMTemplateLink> findByClassNameId(long classNameId) {
        return this.findByClassNameId(classNameId, -1, -1, null);
    }

    public List<DDMTemplateLink> findByClassNameId(long classNameId, int start, int end) {
        return this.findByClassNameId(classNameId, start, end, null);
    }

    public List<DDMTemplateLink> findByClassNameId(long classNameId, int start, int end, OrderByComparator<DDMTemplateLink> orderByComparator) {
        return this.findByClassNameId(classNameId, start, end, orderByComparator, true);
    }

    public List<DDMTemplateLink> findByClassNameId(long classNameId, int start, int end, OrderByComparator<DDMTemplateLink> orderByComparator, boolean useFinderCache) {
        FinderPath finderPath = null;
        Object[] finderArgs = null;
        if (start == -1 && end == -1 && orderByComparator == null) {
            if (useFinderCache) {
                finderPath = this._finderPathWithoutPaginationFindByClassNameId;
                finderArgs = new Object[]{classNameId};
            }
        } else if (useFinderCache) {
            finderPath = this._finderPathWithPaginationFindByClassNameId;
            finderArgs = new Object[]{classNameId, start, end, orderByComparator};
        }
        List list = null;
        if (useFinderCache && (list = (List)this.finderCache.getResult(finderPath, finderArgs, (BasePersistenceImpl)this)) != null && !list.isEmpty()) {
            for (DDMTemplateLink ddmTemplateLink : list) {
                if (classNameId == ddmTemplateLink.getClassNameId()) continue;
                list = null;
                break;
            }
        }
        if (list == null) {
            StringBundler query = null;
            query = orderByComparator != null ? new StringBundler(3 + orderByComparator.getOrderByFields().length * 2) : new StringBundler(3);
            query.append(_SQL_SELECT_DDMTEMPLATELINK_WHERE);
            query.append(_FINDER_COLUMN_CLASSNAMEID_CLASSNAMEID_2);
            if (orderByComparator != null) {
                this.appendOrderByComparator(query, _ORDER_BY_ENTITY_ALIAS, orderByComparator);
            } else {
                query.append(" ORDER BY ddmTemplateLink.templateLinkId ASC");
            }
            String sql = query.toString();
            Session session = null;
            try {
                session = this.openSession();
                Query q = session.createQuery(sql);
                QueryPos qPos = QueryPos.getInstance((Query)q);
                qPos.add(classNameId);
                list = QueryUtil.list((Query)q, (Dialect)this.getDialect(), (int)start, (int)end);
                this.cacheResult(list);
                if (useFinderCache) {
                    this.finderCache.putResult(finderPath, finderArgs, (Object)list);
                }
            }
            catch (Exception e) {
                if (useFinderCache) {
                    this.finderCache.removeResult(finderPath, finderArgs);
                }
                throw this.processException(e);
            }
            finally {
                this.closeSession(session);
            }
        }
        return list;
    }

    public DDMTemplateLink findByClassNameId_First(long classNameId, OrderByComparator<DDMTemplateLink> orderByComparator) throws NoSuchTemplateLinkException {
        DDMTemplateLink ddmTemplateLink = this.fetchByClassNameId_First(classNameId, orderByComparator);
        if (ddmTemplateLink != null) {
            return ddmTemplateLink;
        }
        StringBundler msg = new StringBundler(4);
        msg.append(_NO_SUCH_ENTITY_WITH_KEY);
        msg.append("classNameId=");
        msg.append(classNameId);
        msg.append("}");
        throw new NoSuchTemplateLinkException(msg.toString());
    }

    public DDMTemplateLink fetchByClassNameId_First(long classNameId, OrderByComparator<DDMTemplateLink> orderByComparator) {
        List<DDMTemplateLink> list = this.findByClassNameId(classNameId, 0, 1, orderByComparator);
        if (!list.isEmpty()) {
            return list.get(0);
        }
        return null;
    }

    public DDMTemplateLink findByClassNameId_Last(long classNameId, OrderByComparator<DDMTemplateLink> orderByComparator) throws NoSuchTemplateLinkException {
        DDMTemplateLink ddmTemplateLink = this.fetchByClassNameId_Last(classNameId, orderByComparator);
        if (ddmTemplateLink != null) {
            return ddmTemplateLink;
        }
        StringBundler msg = new StringBundler(4);
        msg.append(_NO_SUCH_ENTITY_WITH_KEY);
        msg.append("classNameId=");
        msg.append(classNameId);
        msg.append("}");
        throw new NoSuchTemplateLinkException(msg.toString());
    }

    public DDMTemplateLink fetchByClassNameId_Last(long classNameId, OrderByComparator<DDMTemplateLink> orderByComparator) {
        int count = this.countByClassNameId(classNameId);
        if (count == 0) {
            return null;
        }
        List<DDMTemplateLink> list = this.findByClassNameId(classNameId, count - 1, count, orderByComparator);
        if (!list.isEmpty()) {
            return list.get(0);
        }
        return null;
    }

    public DDMTemplateLink[] findByClassNameId_PrevAndNext(long templateLinkId, long classNameId, OrderByComparator<DDMTemplateLink> orderByComparator) throws NoSuchTemplateLinkException {
        DDMTemplateLink ddmTemplateLink = this.findByPrimaryKey(templateLinkId);
        Session session = null;
        try {
            session = this.openSession();
            DDMTemplateLink[] array = new DDMTemplateLinkImpl[]{this.getByClassNameId_PrevAndNext(session, ddmTemplateLink, classNameId, orderByComparator, true), ddmTemplateLink, this.getByClassNameId_PrevAndNext(session, ddmTemplateLink, classNameId, orderByComparator, false)};
            DDMTemplateLink[] dDMTemplateLinkArray = array;
            return dDMTemplateLinkArray;
        }
        catch (Exception e) {
            throw this.processException(e);
        }
        finally {
            this.closeSession(session);
        }
    }

    protected DDMTemplateLink getByClassNameId_PrevAndNext(Session session, DDMTemplateLink ddmTemplateLink, long classNameId, OrderByComparator<DDMTemplateLink> orderByComparator, boolean previous) {
        List list;
        StringBundler query = null;
        query = orderByComparator != null ? new StringBundler(4 + orderByComparator.getOrderByConditionFields().length * 3 + orderByComparator.getOrderByFields().length * 3) : new StringBundler(3);
        query.append(_SQL_SELECT_DDMTEMPLATELINK_WHERE);
        query.append(_FINDER_COLUMN_CLASSNAMEID_CLASSNAMEID_2);
        if (orderByComparator != null) {
            String[] orderByConditionFields = orderByComparator.getOrderByConditionFields();
            if (orderByConditionFields.length > 0) {
                query.append(" AND ");
            }
            for (int i = 0; i < orderByConditionFields.length; ++i) {
                query.append(_ORDER_BY_ENTITY_ALIAS);
                query.append(orderByConditionFields[i]);
                if (i + 1 < orderByConditionFields.length) {
                    if (orderByComparator.isAscending() ^ previous) {
                        query.append(" >= ? AND ");
                        continue;
                    }
                    query.append(" <= ? AND ");
                    continue;
                }
                if (orderByComparator.isAscending() ^ previous) {
                    query.append(" >= ? ");
                    continue;
                }
                query.append(" <= ? ");
            }
            query.append(" ORDER BY ");
            String[] orderByFields = orderByComparator.getOrderByFields();
            for (int i = 0; i < orderByFields.length; ++i) {
                query.append(_ORDER_BY_ENTITY_ALIAS);
                query.append(orderByFields[i]);
                if (i + 1 < orderByFields.length) {
                    if (orderByComparator.isAscending() ^ previous) {
                        query.append(" ASC, ");
                        continue;
                    }
                    query.append(" DESC, ");
                    continue;
                }
                if (orderByComparator.isAscending() ^ previous) {
                    query.append(" ASC");
                    continue;
                }
                query.append(" DESC");
            }
        } else {
            query.append(" ORDER BY ddmTemplateLink.templateLinkId ASC");
        }
        String sql = query.toString();
        Query q = session.createQuery(sql);
        q.setFirstResult(0);
        q.setMaxResults(2);
        QueryPos qPos = QueryPos.getInstance((Query)q);
        qPos.add(classNameId);
        if (orderByComparator != null) {
            for (Object orderByConditionValue : orderByComparator.getOrderByConditionValues((Object)ddmTemplateLink)) {
                qPos.add(orderByConditionValue);
            }
        }
        if ((list = q.list()).size() == 2) {
            return (DDMTemplateLink)list.get(1);
        }
        return null;
    }

    public void removeByClassNameId(long classNameId) {
        for (DDMTemplateLink ddmTemplateLink : this.findByClassNameId(classNameId, -1, -1, null)) {
            this.remove((BaseModel)ddmTemplateLink);
        }
    }

    public int countByClassNameId(long classNameId) {
        FinderPath finderPath = this._finderPathCountByClassNameId;
        Object[] finderArgs = new Object[]{classNameId};
        Long count = (Long)this.finderCache.getResult(finderPath, finderArgs, (BasePersistenceImpl)this);
        if (count == null) {
            StringBundler query = new StringBundler(2);
            query.append(_SQL_COUNT_DDMTEMPLATELINK_WHERE);
            query.append(_FINDER_COLUMN_CLASSNAMEID_CLASSNAMEID_2);
            String sql = query.toString();
            Session session = null;
            try {
                session = this.openSession();
                Query q = session.createQuery(sql);
                QueryPos qPos = QueryPos.getInstance((Query)q);
                qPos.add(classNameId);
                count = (Long)q.uniqueResult();
                this.finderCache.putResult(finderPath, finderArgs, (Object)count);
            }
            catch (Exception e) {
                this.finderCache.removeResult(finderPath, finderArgs);
                throw this.processException(e);
            }
            finally {
                this.closeSession(session);
            }
        }
        return count.intValue();
    }

    public List<DDMTemplateLink> findByTemplateId(long templateId) {
        return this.findByTemplateId(templateId, -1, -1, null);
    }

    public List<DDMTemplateLink> findByTemplateId(long templateId, int start, int end) {
        return this.findByTemplateId(templateId, start, end, null);
    }

    public List<DDMTemplateLink> findByTemplateId(long templateId, int start, int end, OrderByComparator<DDMTemplateLink> orderByComparator) {
        return this.findByTemplateId(templateId, start, end, orderByComparator, true);
    }

    public List<DDMTemplateLink> findByTemplateId(long templateId, int start, int end, OrderByComparator<DDMTemplateLink> orderByComparator, boolean useFinderCache) {
        FinderPath finderPath = null;
        Object[] finderArgs = null;
        if (start == -1 && end == -1 && orderByComparator == null) {
            if (useFinderCache) {
                finderPath = this._finderPathWithoutPaginationFindByTemplateId;
                finderArgs = new Object[]{templateId};
            }
        } else if (useFinderCache) {
            finderPath = this._finderPathWithPaginationFindByTemplateId;
            finderArgs = new Object[]{templateId, start, end, orderByComparator};
        }
        List list = null;
        if (useFinderCache && (list = (List)this.finderCache.getResult(finderPath, finderArgs, (BasePersistenceImpl)this)) != null && !list.isEmpty()) {
            for (DDMTemplateLink ddmTemplateLink : list) {
                if (templateId == ddmTemplateLink.getTemplateId()) continue;
                list = null;
                break;
            }
        }
        if (list == null) {
            StringBundler query = null;
            query = orderByComparator != null ? new StringBundler(3 + orderByComparator.getOrderByFields().length * 2) : new StringBundler(3);
            query.append(_SQL_SELECT_DDMTEMPLATELINK_WHERE);
            query.append(_FINDER_COLUMN_TEMPLATEID_TEMPLATEID_2);
            if (orderByComparator != null) {
                this.appendOrderByComparator(query, _ORDER_BY_ENTITY_ALIAS, orderByComparator);
            } else {
                query.append(" ORDER BY ddmTemplateLink.templateLinkId ASC");
            }
            String sql = query.toString();
            Session session = null;
            try {
                session = this.openSession();
                Query q = session.createQuery(sql);
                QueryPos qPos = QueryPos.getInstance((Query)q);
                qPos.add(templateId);
                list = QueryUtil.list((Query)q, (Dialect)this.getDialect(), (int)start, (int)end);
                this.cacheResult(list);
                if (useFinderCache) {
                    this.finderCache.putResult(finderPath, finderArgs, (Object)list);
                }
            }
            catch (Exception e) {
                if (useFinderCache) {
                    this.finderCache.removeResult(finderPath, finderArgs);
                }
                throw this.processException(e);
            }
            finally {
                this.closeSession(session);
            }
        }
        return list;
    }

    public DDMTemplateLink findByTemplateId_First(long templateId, OrderByComparator<DDMTemplateLink> orderByComparator) throws NoSuchTemplateLinkException {
        DDMTemplateLink ddmTemplateLink = this.fetchByTemplateId_First(templateId, orderByComparator);
        if (ddmTemplateLink != null) {
            return ddmTemplateLink;
        }
        StringBundler msg = new StringBundler(4);
        msg.append(_NO_SUCH_ENTITY_WITH_KEY);
        msg.append("templateId=");
        msg.append(templateId);
        msg.append("}");
        throw new NoSuchTemplateLinkException(msg.toString());
    }

    public DDMTemplateLink fetchByTemplateId_First(long templateId, OrderByComparator<DDMTemplateLink> orderByComparator) {
        List<DDMTemplateLink> list = this.findByTemplateId(templateId, 0, 1, orderByComparator);
        if (!list.isEmpty()) {
            return list.get(0);
        }
        return null;
    }

    public DDMTemplateLink findByTemplateId_Last(long templateId, OrderByComparator<DDMTemplateLink> orderByComparator) throws NoSuchTemplateLinkException {
        DDMTemplateLink ddmTemplateLink = this.fetchByTemplateId_Last(templateId, orderByComparator);
        if (ddmTemplateLink != null) {
            return ddmTemplateLink;
        }
        StringBundler msg = new StringBundler(4);
        msg.append(_NO_SUCH_ENTITY_WITH_KEY);
        msg.append("templateId=");
        msg.append(templateId);
        msg.append("}");
        throw new NoSuchTemplateLinkException(msg.toString());
    }

    public DDMTemplateLink fetchByTemplateId_Last(long templateId, OrderByComparator<DDMTemplateLink> orderByComparator) {
        int count = this.countByTemplateId(templateId);
        if (count == 0) {
            return null;
        }
        List<DDMTemplateLink> list = this.findByTemplateId(templateId, count - 1, count, orderByComparator);
        if (!list.isEmpty()) {
            return list.get(0);
        }
        return null;
    }

    public DDMTemplateLink[] findByTemplateId_PrevAndNext(long templateLinkId, long templateId, OrderByComparator<DDMTemplateLink> orderByComparator) throws NoSuchTemplateLinkException {
        DDMTemplateLink ddmTemplateLink = this.findByPrimaryKey(templateLinkId);
        Session session = null;
        try {
            session = this.openSession();
            DDMTemplateLink[] array = new DDMTemplateLinkImpl[]{this.getByTemplateId_PrevAndNext(session, ddmTemplateLink, templateId, orderByComparator, true), ddmTemplateLink, this.getByTemplateId_PrevAndNext(session, ddmTemplateLink, templateId, orderByComparator, false)};
            DDMTemplateLink[] dDMTemplateLinkArray = array;
            return dDMTemplateLinkArray;
        }
        catch (Exception e) {
            throw this.processException(e);
        }
        finally {
            this.closeSession(session);
        }
    }

    protected DDMTemplateLink getByTemplateId_PrevAndNext(Session session, DDMTemplateLink ddmTemplateLink, long templateId, OrderByComparator<DDMTemplateLink> orderByComparator, boolean previous) {
        List list;
        StringBundler query = null;
        query = orderByComparator != null ? new StringBundler(4 + orderByComparator.getOrderByConditionFields().length * 3 + orderByComparator.getOrderByFields().length * 3) : new StringBundler(3);
        query.append(_SQL_SELECT_DDMTEMPLATELINK_WHERE);
        query.append(_FINDER_COLUMN_TEMPLATEID_TEMPLATEID_2);
        if (orderByComparator != null) {
            String[] orderByConditionFields = orderByComparator.getOrderByConditionFields();
            if (orderByConditionFields.length > 0) {
                query.append(" AND ");
            }
            for (int i = 0; i < orderByConditionFields.length; ++i) {
                query.append(_ORDER_BY_ENTITY_ALIAS);
                query.append(orderByConditionFields[i]);
                if (i + 1 < orderByConditionFields.length) {
                    if (orderByComparator.isAscending() ^ previous) {
                        query.append(" >= ? AND ");
                        continue;
                    }
                    query.append(" <= ? AND ");
                    continue;
                }
                if (orderByComparator.isAscending() ^ previous) {
                    query.append(" >= ? ");
                    continue;
                }
                query.append(" <= ? ");
            }
            query.append(" ORDER BY ");
            String[] orderByFields = orderByComparator.getOrderByFields();
            for (int i = 0; i < orderByFields.length; ++i) {
                query.append(_ORDER_BY_ENTITY_ALIAS);
                query.append(orderByFields[i]);
                if (i + 1 < orderByFields.length) {
                    if (orderByComparator.isAscending() ^ previous) {
                        query.append(" ASC, ");
                        continue;
                    }
                    query.append(" DESC, ");
                    continue;
                }
                if (orderByComparator.isAscending() ^ previous) {
                    query.append(" ASC");
                    continue;
                }
                query.append(" DESC");
            }
        } else {
            query.append(" ORDER BY ddmTemplateLink.templateLinkId ASC");
        }
        String sql = query.toString();
        Query q = session.createQuery(sql);
        q.setFirstResult(0);
        q.setMaxResults(2);
        QueryPos qPos = QueryPos.getInstance((Query)q);
        qPos.add(templateId);
        if (orderByComparator != null) {
            for (Object orderByConditionValue : orderByComparator.getOrderByConditionValues((Object)ddmTemplateLink)) {
                qPos.add(orderByConditionValue);
            }
        }
        if ((list = q.list()).size() == 2) {
            return (DDMTemplateLink)list.get(1);
        }
        return null;
    }

    public void removeByTemplateId(long templateId) {
        for (DDMTemplateLink ddmTemplateLink : this.findByTemplateId(templateId, -1, -1, null)) {
            this.remove((BaseModel)ddmTemplateLink);
        }
    }

    public int countByTemplateId(long templateId) {
        FinderPath finderPath = this._finderPathCountByTemplateId;
        Object[] finderArgs = new Object[]{templateId};
        Long count = (Long)this.finderCache.getResult(finderPath, finderArgs, (BasePersistenceImpl)this);
        if (count == null) {
            StringBundler query = new StringBundler(2);
            query.append(_SQL_COUNT_DDMTEMPLATELINK_WHERE);
            query.append(_FINDER_COLUMN_TEMPLATEID_TEMPLATEID_2);
            String sql = query.toString();
            Session session = null;
            try {
                session = this.openSession();
                Query q = session.createQuery(sql);
                QueryPos qPos = QueryPos.getInstance((Query)q);
                qPos.add(templateId);
                count = (Long)q.uniqueResult();
                this.finderCache.putResult(finderPath, finderArgs, (Object)count);
            }
            catch (Exception e) {
                this.finderCache.removeResult(finderPath, finderArgs);
                throw this.processException(e);
            }
            finally {
                this.closeSession(session);
            }
        }
        return count.intValue();
    }

    public DDMTemplateLink findByC_C(long classNameId, long classPK) throws NoSuchTemplateLinkException {
        DDMTemplateLink ddmTemplateLink = this.fetchByC_C(classNameId, classPK);
        if (ddmTemplateLink == null) {
            StringBundler msg = new StringBundler(6);
            msg.append(_NO_SUCH_ENTITY_WITH_KEY);
            msg.append("classNameId=");
            msg.append(classNameId);
            msg.append(", classPK=");
            msg.append(classPK);
            msg.append("}");
            if (_log.isDebugEnabled()) {
                _log.debug((Object)msg.toString());
            }
            throw new NoSuchTemplateLinkException(msg.toString());
        }
        return ddmTemplateLink;
    }

    public DDMTemplateLink fetchByC_C(long classNameId, long classPK) {
        return this.fetchByC_C(classNameId, classPK, true);
    }

    public DDMTemplateLink fetchByC_C(long classNameId, long classPK, boolean useFinderCache) {
        DDMTemplateLink ddmTemplateLink;
        Object[] finderArgs = null;
        if (useFinderCache) {
            finderArgs = new Object[]{classNameId, classPK};
        }
        Object result = null;
        if (useFinderCache) {
            result = this.finderCache.getResult(this._finderPathFetchByC_C, finderArgs, (BasePersistenceImpl)this);
        }
        if (result instanceof DDMTemplateLink && (classNameId != (ddmTemplateLink = (DDMTemplateLink)result).getClassNameId() || classPK != ddmTemplateLink.getClassPK())) {
            result = null;
        }
        if (result == null) {
            StringBundler query = new StringBundler(4);
            query.append(_SQL_SELECT_DDMTEMPLATELINK_WHERE);
            query.append(_FINDER_COLUMN_C_C_CLASSNAMEID_2);
            query.append(_FINDER_COLUMN_C_C_CLASSPK_2);
            String sql = query.toString();
            Session session = null;
            try {
                session = this.openSession();
                Query q = session.createQuery(sql);
                QueryPos qPos = QueryPos.getInstance((Query)q);
                qPos.add(classNameId);
                qPos.add(classPK);
                List list = q.list();
                if (list.isEmpty()) {
                    if (useFinderCache) {
                        this.finderCache.putResult(this._finderPathFetchByC_C, finderArgs, (Object)list);
                    }
                } else {
                    DDMTemplateLink ddmTemplateLink2 = (DDMTemplateLink)list.get(0);
                    result = ddmTemplateLink2;
                    this.cacheResult(ddmTemplateLink2);
                }
            }
            catch (Exception e) {
                if (useFinderCache) {
                    this.finderCache.removeResult(this._finderPathFetchByC_C, finderArgs);
                }
                throw this.processException(e);
            }
            finally {
                this.closeSession(session);
            }
        }
        if (result instanceof List) {
            return null;
        }
        return (DDMTemplateLink)result;
    }

    public DDMTemplateLink removeByC_C(long classNameId, long classPK) throws NoSuchTemplateLinkException {
        DDMTemplateLink ddmTemplateLink = this.findByC_C(classNameId, classPK);
        return (DDMTemplateLink)this.remove((BaseModel)ddmTemplateLink);
    }

    public int countByC_C(long classNameId, long classPK) {
        FinderPath finderPath = this._finderPathCountByC_C;
        Object[] finderArgs = new Object[]{classNameId, classPK};
        Long count = (Long)this.finderCache.getResult(finderPath, finderArgs, (BasePersistenceImpl)this);
        if (count == null) {
            StringBundler query = new StringBundler(3);
            query.append(_SQL_COUNT_DDMTEMPLATELINK_WHERE);
            query.append(_FINDER_COLUMN_C_C_CLASSNAMEID_2);
            query.append(_FINDER_COLUMN_C_C_CLASSPK_2);
            String sql = query.toString();
            Session session = null;
            try {
                session = this.openSession();
                Query q = session.createQuery(sql);
                QueryPos qPos = QueryPos.getInstance((Query)q);
                qPos.add(classNameId);
                qPos.add(classPK);
                count = (Long)q.uniqueResult();
                this.finderCache.putResult(finderPath, finderArgs, (Object)count);
            }
            catch (Exception e) {
                this.finderCache.removeResult(finderPath, finderArgs);
                throw this.processException(e);
            }
            finally {
                this.closeSession(session);
            }
        }
        return count.intValue();
    }

    public DDMTemplateLinkPersistenceImpl() {
        this.setModelClass(DDMTemplateLink.class);
        this.setModelImplClass(DDMTemplateLinkImpl.class);
        this.setModelPKClass(Long.TYPE);
    }

    public void cacheResult(DDMTemplateLink ddmTemplateLink) {
        this.entityCache.putResult(this.entityCacheEnabled, DDMTemplateLinkImpl.class, (Serializable)Long.valueOf(ddmTemplateLink.getPrimaryKey()), (Serializable)ddmTemplateLink);
        this.finderCache.putResult(this._finderPathFetchByC_C, new Object[]{ddmTemplateLink.getClassNameId(), ddmTemplateLink.getClassPK()}, (Object)ddmTemplateLink);
        ddmTemplateLink.resetOriginalValues();
    }

    public void cacheResult(List<DDMTemplateLink> ddmTemplateLinks) {
        for (DDMTemplateLink ddmTemplateLink : ddmTemplateLinks) {
            if (this.entityCache.getResult(this.entityCacheEnabled, DDMTemplateLinkImpl.class, (Serializable)Long.valueOf(ddmTemplateLink.getPrimaryKey())) == null) {
                this.cacheResult(ddmTemplateLink);
                continue;
            }
            ddmTemplateLink.resetOriginalValues();
        }
    }

    public void clearCache() {
        this.entityCache.clearCache(DDMTemplateLinkImpl.class);
        this.finderCache.clearCache(FINDER_CLASS_NAME_ENTITY);
        this.finderCache.clearCache(FINDER_CLASS_NAME_LIST_WITH_PAGINATION);
        this.finderCache.clearCache(FINDER_CLASS_NAME_LIST_WITHOUT_PAGINATION);
    }

    public void clearCache(DDMTemplateLink ddmTemplateLink) {
        this.entityCache.removeResult(this.entityCacheEnabled, DDMTemplateLinkImpl.class, (Serializable)Long.valueOf(ddmTemplateLink.getPrimaryKey()));
        this.finderCache.clearCache(FINDER_CLASS_NAME_LIST_WITH_PAGINATION);
        this.finderCache.clearCache(FINDER_CLASS_NAME_LIST_WITHOUT_PAGINATION);
        this.clearUniqueFindersCache((DDMTemplateLinkModelImpl)ddmTemplateLink, true);
    }

    public void clearCache(List<DDMTemplateLink> ddmTemplateLinks) {
        this.finderCache.clearCache(FINDER_CLASS_NAME_LIST_WITH_PAGINATION);
        this.finderCache.clearCache(FINDER_CLASS_NAME_LIST_WITHOUT_PAGINATION);
        for (DDMTemplateLink ddmTemplateLink : ddmTemplateLinks) {
            this.entityCache.removeResult(this.entityCacheEnabled, DDMTemplateLinkImpl.class, (Serializable)Long.valueOf(ddmTemplateLink.getPrimaryKey()));
            this.clearUniqueFindersCache((DDMTemplateLinkModelImpl)ddmTemplateLink, true);
        }
    }

    protected void cacheUniqueFindersCache(DDMTemplateLinkModelImpl ddmTemplateLinkModelImpl) {
        Object[] args = new Object[]{ddmTemplateLinkModelImpl.getClassNameId(), ddmTemplateLinkModelImpl.getClassPK()};
        this.finderCache.putResult(this._finderPathCountByC_C, args, (Object)1L, false);
        this.finderCache.putResult(this._finderPathFetchByC_C, args, (Object)ddmTemplateLinkModelImpl, false);
    }

    protected void clearUniqueFindersCache(DDMTemplateLinkModelImpl ddmTemplateLinkModelImpl, boolean clearCurrent) {
        Object[] args;
        if (clearCurrent) {
            args = new Object[]{ddmTemplateLinkModelImpl.getClassNameId(), ddmTemplateLinkModelImpl.getClassPK()};
            this.finderCache.removeResult(this._finderPathCountByC_C, args);
            this.finderCache.removeResult(this._finderPathFetchByC_C, args);
        }
        if ((ddmTemplateLinkModelImpl.getColumnBitmask() & this._finderPathFetchByC_C.getColumnBitmask()) != 0L) {
            args = new Object[]{ddmTemplateLinkModelImpl.getOriginalClassNameId(), ddmTemplateLinkModelImpl.getOriginalClassPK()};
            this.finderCache.removeResult(this._finderPathCountByC_C, args);
            this.finderCache.removeResult(this._finderPathFetchByC_C, args);
        }
    }

    public DDMTemplateLink create(long templateLinkId) {
        DDMTemplateLinkImpl ddmTemplateLink = new DDMTemplateLinkImpl();
        ddmTemplateLink.setNew(true);
        ddmTemplateLink.setPrimaryKey(templateLinkId);
        ddmTemplateLink.setCompanyId(CompanyThreadLocal.getCompanyId());
        return ddmTemplateLink;
    }

    public DDMTemplateLink remove(long templateLinkId) throws NoSuchTemplateLinkException {
        return this.remove(Long.valueOf(templateLinkId));
    }

    public DDMTemplateLink remove(Serializable primaryKey) throws NoSuchTemplateLinkException {
        Session session = null;
        try {
            session = this.openSession();
            DDMTemplateLink ddmTemplateLink = (DDMTemplateLink)session.get(DDMTemplateLinkImpl.class, primaryKey);
            if (ddmTemplateLink == null) {
                if (_log.isDebugEnabled()) {
                    _log.debug((Object)(_NO_SUCH_ENTITY_WITH_PRIMARY_KEY + primaryKey));
                }
                throw new NoSuchTemplateLinkException(_NO_SUCH_ENTITY_WITH_PRIMARY_KEY + primaryKey);
            }
            DDMTemplateLink dDMTemplateLink = (DDMTemplateLink)this.remove((BaseModel)ddmTemplateLink);
            return dDMTemplateLink;
        }
        catch (NoSuchTemplateLinkException nsee) {
            throw nsee;
        }
        catch (Exception e) {
            throw this.processException(e);
        }
        finally {
            this.closeSession(session);
        }
    }

    protected DDMTemplateLink removeImpl(DDMTemplateLink ddmTemplateLink) {
        Session session = null;
        try {
            session = this.openSession();
            if (!session.contains((Object)ddmTemplateLink)) {
                ddmTemplateLink = (DDMTemplateLink)session.get(DDMTemplateLinkImpl.class, ddmTemplateLink.getPrimaryKeyObj());
            }
            if (ddmTemplateLink != null) {
                session.delete((Object)ddmTemplateLink);
            }
        }
        catch (Exception e) {
            throw this.processException(e);
        }
        finally {
            this.closeSession(session);
        }
        if (ddmTemplateLink != null) {
            this.clearCache(ddmTemplateLink);
        }
        return ddmTemplateLink;
    }

    public DDMTemplateLink updateImpl(DDMTemplateLink ddmTemplateLink) {
        boolean isNew = ddmTemplateLink.isNew();
        if (!(ddmTemplateLink instanceof DDMTemplateLinkModelImpl)) {
            InvocationHandler invocationHandler = null;
            if (ProxyUtil.isProxyClass(ddmTemplateLink.getClass())) {
                invocationHandler = ProxyUtil.getInvocationHandler((Object)ddmTemplateLink);
                throw new IllegalArgumentException("Implement ModelWrapper in ddmTemplateLink proxy " + invocationHandler.getClass());
            }
            throw new IllegalArgumentException("Implement ModelWrapper in custom DDMTemplateLink implementation " + ddmTemplateLink.getClass());
        }
        DDMTemplateLinkModelImpl ddmTemplateLinkModelImpl = (DDMTemplateLinkModelImpl)ddmTemplateLink;
        Session session = null;
        try {
            session = this.openSession();
            if (ddmTemplateLink.isNew()) {
                session.save((Object)ddmTemplateLink);
                ddmTemplateLink.setNew(false);
            } else {
                ddmTemplateLink = (DDMTemplateLink)session.merge((Object)ddmTemplateLink);
            }
        }
        catch (Exception e) {
            throw this.processException(e);
        }
        finally {
            this.closeSession(session);
        }
        this.finderCache.clearCache(FINDER_CLASS_NAME_LIST_WITH_PAGINATION);
        if (!this._columnBitmaskEnabled) {
            this.finderCache.clearCache(FINDER_CLASS_NAME_LIST_WITHOUT_PAGINATION);
        } else if (isNew) {
            Object[] args = new Object[]{ddmTemplateLinkModelImpl.getClassNameId()};
            this.finderCache.removeResult(this._finderPathCountByClassNameId, args);
            this.finderCache.removeResult(this._finderPathWithoutPaginationFindByClassNameId, args);
            args = new Object[]{ddmTemplateLinkModelImpl.getTemplateId()};
            this.finderCache.removeResult(this._finderPathCountByTemplateId, args);
            this.finderCache.removeResult(this._finderPathWithoutPaginationFindByTemplateId, args);
            this.finderCache.removeResult(this._finderPathCountAll, FINDER_ARGS_EMPTY);
            this.finderCache.removeResult(this._finderPathWithoutPaginationFindAll, FINDER_ARGS_EMPTY);
        } else {
            Object[] args;
            if ((ddmTemplateLinkModelImpl.getColumnBitmask() & this._finderPathWithoutPaginationFindByClassNameId.getColumnBitmask()) != 0L) {
                args = new Object[]{ddmTemplateLinkModelImpl.getOriginalClassNameId()};
                this.finderCache.removeResult(this._finderPathCountByClassNameId, args);
                this.finderCache.removeResult(this._finderPathWithoutPaginationFindByClassNameId, args);
                args = new Object[]{ddmTemplateLinkModelImpl.getClassNameId()};
                this.finderCache.removeResult(this._finderPathCountByClassNameId, args);
                this.finderCache.removeResult(this._finderPathWithoutPaginationFindByClassNameId, args);
            }
            if ((ddmTemplateLinkModelImpl.getColumnBitmask() & this._finderPathWithoutPaginationFindByTemplateId.getColumnBitmask()) != 0L) {
                args = new Object[]{ddmTemplateLinkModelImpl.getOriginalTemplateId()};
                this.finderCache.removeResult(this._finderPathCountByTemplateId, args);
                this.finderCache.removeResult(this._finderPathWithoutPaginationFindByTemplateId, args);
                args = new Object[]{ddmTemplateLinkModelImpl.getTemplateId()};
                this.finderCache.removeResult(this._finderPathCountByTemplateId, args);
                this.finderCache.removeResult(this._finderPathWithoutPaginationFindByTemplateId, args);
            }
        }
        this.entityCache.putResult(this.entityCacheEnabled, DDMTemplateLinkImpl.class, (Serializable)Long.valueOf(ddmTemplateLink.getPrimaryKey()), (Serializable)ddmTemplateLink, false);
        this.clearUniqueFindersCache(ddmTemplateLinkModelImpl, false);
        this.cacheUniqueFindersCache(ddmTemplateLinkModelImpl);
        ddmTemplateLink.resetOriginalValues();
        return ddmTemplateLink;
    }

    public DDMTemplateLink findByPrimaryKey(Serializable primaryKey) throws NoSuchTemplateLinkException {
        DDMTemplateLink ddmTemplateLink = (DDMTemplateLink)this.fetchByPrimaryKey(primaryKey);
        if (ddmTemplateLink == null) {
            if (_log.isDebugEnabled()) {
                _log.debug((Object)(_NO_SUCH_ENTITY_WITH_PRIMARY_KEY + primaryKey));
            }
            throw new NoSuchTemplateLinkException(_NO_SUCH_ENTITY_WITH_PRIMARY_KEY + primaryKey);
        }
        return ddmTemplateLink;
    }

    public DDMTemplateLink findByPrimaryKey(long templateLinkId) throws NoSuchTemplateLinkException {
        return this.findByPrimaryKey(Long.valueOf(templateLinkId));
    }

    public DDMTemplateLink fetchByPrimaryKey(long templateLinkId) {
        return (DDMTemplateLink)this.fetchByPrimaryKey(Long.valueOf(templateLinkId));
    }

    public List<DDMTemplateLink> findAll() {
        return this.findAll(-1, -1, null);
    }

    public List<DDMTemplateLink> findAll(int start, int end) {
        return this.findAll(start, end, null);
    }

    public List<DDMTemplateLink> findAll(int start, int end, OrderByComparator<DDMTemplateLink> orderByComparator) {
        return this.findAll(start, end, orderByComparator, true);
    }

    public List<DDMTemplateLink> findAll(int start, int end, OrderByComparator<DDMTemplateLink> orderByComparator, boolean useFinderCache) {
        FinderPath finderPath = null;
        Object[] finderArgs = null;
        if (start == -1 && end == -1 && orderByComparator == null) {
            if (useFinderCache) {
                finderPath = this._finderPathWithoutPaginationFindAll;
                finderArgs = FINDER_ARGS_EMPTY;
            }
        } else if (useFinderCache) {
            finderPath = this._finderPathWithPaginationFindAll;
            finderArgs = new Object[]{start, end, orderByComparator};
        }
        List list = null;
        if (useFinderCache) {
            list = (List)this.finderCache.getResult(finderPath, finderArgs, (BasePersistenceImpl)this);
        }
        if (list == null) {
            StringBundler query = null;
            String sql = null;
            if (orderByComparator != null) {
                query = new StringBundler(2 + orderByComparator.getOrderByFields().length * 2);
                query.append(_SQL_SELECT_DDMTEMPLATELINK);
                this.appendOrderByComparator(query, _ORDER_BY_ENTITY_ALIAS, orderByComparator);
                sql = query.toString();
            } else {
                sql = _SQL_SELECT_DDMTEMPLATELINK;
                sql = sql.concat(" ORDER BY ddmTemplateLink.templateLinkId ASC");
            }
            Session session = null;
            try {
                session = this.openSession();
                Query q = session.createQuery(sql);
                list = QueryUtil.list((Query)q, (Dialect)this.getDialect(), (int)start, (int)end);
                this.cacheResult(list);
                if (useFinderCache) {
                    this.finderCache.putResult(finderPath, finderArgs, (Object)list);
                }
            }
            catch (Exception e) {
                if (useFinderCache) {
                    this.finderCache.removeResult(finderPath, finderArgs);
                }
                throw this.processException(e);
            }
            finally {
                this.closeSession(session);
            }
        }
        return list;
    }

    public void removeAll() {
        for (DDMTemplateLink ddmTemplateLink : this.findAll()) {
            this.remove((BaseModel)ddmTemplateLink);
        }
    }

    public int countAll() {
        Long count = (Long)this.finderCache.getResult(this._finderPathCountAll, FINDER_ARGS_EMPTY, (BasePersistenceImpl)this);
        if (count == null) {
            Session session = null;
            try {
                session = this.openSession();
                Query q = session.createQuery(_SQL_COUNT_DDMTEMPLATELINK);
                count = (Long)q.uniqueResult();
                this.finderCache.putResult(this._finderPathCountAll, FINDER_ARGS_EMPTY, (Object)count);
            }
            catch (Exception e) {
                this.finderCache.removeResult(this._finderPathCountAll, FINDER_ARGS_EMPTY);
                throw this.processException(e);
            }
            finally {
                this.closeSession(session);
            }
        }
        return count.intValue();
    }

    protected EntityCache getEntityCache() {
        return this.entityCache;
    }

    protected String getPKDBName() {
        return "templateLinkId";
    }

    protected String getSelectSQL() {
        return _SQL_SELECT_DDMTEMPLATELINK;
    }

    protected Map<String, Integer> getTableColumnsMap() {
        return DDMTemplateLinkModelImpl.TABLE_COLUMNS_MAP;
    }

    @Activate
    public void activate() {
        DDMTemplateLinkModelImpl.setEntityCacheEnabled(this.entityCacheEnabled);
        DDMTemplateLinkModelImpl.setFinderCacheEnabled(this.finderCacheEnabled);
        this._finderPathWithPaginationFindAll = new FinderPath(this.entityCacheEnabled, this.finderCacheEnabled, DDMTemplateLinkImpl.class, FINDER_CLASS_NAME_LIST_WITH_PAGINATION, "findAll", new String[0]);
        this._finderPathWithoutPaginationFindAll = new FinderPath(this.entityCacheEnabled, this.finderCacheEnabled, DDMTemplateLinkImpl.class, FINDER_CLASS_NAME_LIST_WITHOUT_PAGINATION, "findAll", new String[0]);
        this._finderPathCountAll = new FinderPath(this.entityCacheEnabled, this.finderCacheEnabled, Long.class, FINDER_CLASS_NAME_LIST_WITHOUT_PAGINATION, "countAll", new String[0]);
        this._finderPathWithPaginationFindByClassNameId = new FinderPath(this.entityCacheEnabled, this.finderCacheEnabled, DDMTemplateLinkImpl.class, FINDER_CLASS_NAME_LIST_WITH_PAGINATION, "findByClassNameId", new String[]{Long.class.getName(), Integer.class.getName(), Integer.class.getName(), OrderByComparator.class.getName()});
        this._finderPathWithoutPaginationFindByClassNameId = new FinderPath(this.entityCacheEnabled, this.finderCacheEnabled, DDMTemplateLinkImpl.class, FINDER_CLASS_NAME_LIST_WITHOUT_PAGINATION, "findByClassNameId", new String[]{Long.class.getName()}, 1L);
        this._finderPathCountByClassNameId = new FinderPath(this.entityCacheEnabled, this.finderCacheEnabled, Long.class, FINDER_CLASS_NAME_LIST_WITHOUT_PAGINATION, "countByClassNameId", new String[]{Long.class.getName()});
        this._finderPathWithPaginationFindByTemplateId = new FinderPath(this.entityCacheEnabled, this.finderCacheEnabled, DDMTemplateLinkImpl.class, FINDER_CLASS_NAME_LIST_WITH_PAGINATION, "findByTemplateId", new String[]{Long.class.getName(), Integer.class.getName(), Integer.class.getName(), OrderByComparator.class.getName()});
        this._finderPathWithoutPaginationFindByTemplateId = new FinderPath(this.entityCacheEnabled, this.finderCacheEnabled, DDMTemplateLinkImpl.class, FINDER_CLASS_NAME_LIST_WITHOUT_PAGINATION, "findByTemplateId", new String[]{Long.class.getName()}, 4L);
        this._finderPathCountByTemplateId = new FinderPath(this.entityCacheEnabled, this.finderCacheEnabled, Long.class, FINDER_CLASS_NAME_LIST_WITHOUT_PAGINATION, "countByTemplateId", new String[]{Long.class.getName()});
        this._finderPathFetchByC_C = new FinderPath(this.entityCacheEnabled, this.finderCacheEnabled, DDMTemplateLinkImpl.class, FINDER_CLASS_NAME_ENTITY, "fetchByC_C", new String[]{Long.class.getName(), Long.class.getName()}, 3L);
        this._finderPathCountByC_C = new FinderPath(this.entityCacheEnabled, this.finderCacheEnabled, Long.class, FINDER_CLASS_NAME_LIST_WITHOUT_PAGINATION, "countByC_C", new String[]{Long.class.getName(), Long.class.getName()});
    }

    @Deactivate
    public void deactivate() {
        this.entityCache.removeCache(DDMTemplateLinkImpl.class.getName());
        this.finderCache.removeCache(FINDER_CLASS_NAME_ENTITY);
        this.finderCache.removeCache(FINDER_CLASS_NAME_LIST_WITH_PAGINATION);
        this.finderCache.removeCache(FINDER_CLASS_NAME_LIST_WITHOUT_PAGINATION);
    }

    @Reference(target="(&(origin.bundle.symbolic.name=com.liferay.dynamic.data.mapping.service)(name=service))", unbind="-")
    public void setConfiguration(Configuration configuration) {
        super.setConfiguration(configuration);
        this._columnBitmaskEnabled = GetterUtil.getBoolean((String)configuration.get("value.object.column.bitmask.enabled.com.liferay.dynamic.data.mapping.model.DDMTemplateLink"), (boolean)true);
    }

    @Reference(target="(origin.bundle.symbolic.name=com.liferay.dynamic.data.mapping.service)", unbind="-")
    public void setDataSource(DataSource dataSource) {
        super.setDataSource(dataSource);
    }

    @Reference(target="(origin.bundle.symbolic.name=com.liferay.dynamic.data.mapping.service)", unbind="-")
    public void setSessionFactory(SessionFactory sessionFactory) {
        super.setSessionFactory(sessionFactory);
    }

    static {
        try {
            Class.forName(DDMPersistenceConstants.class.getName());
        }
        catch (ClassNotFoundException cnfe) {
            throw new ExceptionInInitializerError(cnfe);
        }
    }
}

