/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.dynamic.data.mapping.service.impl;

import com.liferay.dynamic.data.mapping.exception.ContentException;
import com.liferay.dynamic.data.mapping.exception.ContentNameException;
import com.liferay.dynamic.data.mapping.model.DDMContent;
import com.liferay.dynamic.data.mapping.service.base.DDMContentLocalServiceBaseImpl;
import com.liferay.portal.aop.AopService;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.model.BaseModel;
import com.liferay.portal.kernel.model.User;
import com.liferay.portal.kernel.service.ServiceContext;
import com.liferay.portal.kernel.util.Validator;
import java.util.List;
import org.osgi.service.component.annotations.Component;

@Component(property={"model.class.name=com.liferay.dynamic.data.mapping.model.DDMContent"}, service={AopService.class})
public class DDMContentLocalServiceImpl
extends DDMContentLocalServiceBaseImpl {
    public DDMContent addContent(long userId, long groupId, String name, String description, String data, ServiceContext serviceContext) throws PortalException {
        User user = this.userLocalService.getUser(userId);
        this.validate(0L, name, data);
        long contentId = this.counterLocalService.increment();
        DDMContent content = this.ddmContentPersistence.create(contentId);
        content.setUuid(serviceContext.getUuid());
        content.setGroupId(serviceContext.getScopeGroupId());
        content.setCompanyId(user.getCompanyId());
        content.setUserId(user.getUserId());
        content.setUserName(user.getFullName());
        content.setName(name);
        content.setDescription(description);
        content.setData(data);
        this.ddmContentPersistence.update((BaseModel)content);
        return content;
    }

    public void deleteContent(DDMContent content) {
        this.ddmContentPersistence.remove((BaseModel)content);
    }

    public void deleteContents(long groupId) {
        List contents = this.ddmContentPersistence.findByGroupId(groupId);
        for (DDMContent content : contents) {
            this.deleteContent(content);
        }
    }

    public DDMContent getContent(long contentId) throws PortalException {
        return this.ddmContentPersistence.findByPrimaryKey(contentId);
    }

    public List<DDMContent> getContents() {
        return this.ddmContentPersistence.findAll();
    }

    public List<DDMContent> getContents(long groupId) {
        return this.ddmContentPersistence.findByGroupId(groupId);
    }

    public List<DDMContent> getContents(long groupId, int start, int end) {
        return this.ddmContentPersistence.findByGroupId(groupId, start, end);
    }

    public int getContentsCount(long groupId) {
        return this.ddmContentPersistence.countByGroupId(groupId);
    }

    public DDMContent updateContent(long contentId, String name, String description, String data, ServiceContext serviceContext) throws PortalException {
        this.validate(contentId, name, data);
        DDMContent content = this.ddmContentPersistence.findByPrimaryKey(contentId);
        content.setName(name);
        content.setDescription(description);
        content.setData(data);
        this.ddmContentPersistence.update((BaseModel)content);
        return content;
    }

    protected void validate(long contentId, String name, String data) throws PortalException {
        if (Validator.isNull((String)name)) {
            throw new ContentNameException("Content " + contentId + " has a null name");
        }
        if (Validator.isNull((String)data)) {
            throw new ContentException("Content " + contentId + " has null data");
        }
    }
}

